/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;

public final class Heartbeat {
    private final int sessionTimeoutMs;
    private final int heartbeatIntervalMs;
    private final int maxPollIntervalMs;
    private final long retryBackoffMs;
    private final Time time;
    private final Timer heartbeatTimer;
    private final Timer sessionTimer;
    private final Timer pollTimer;
    private volatile long lastHeartbeatSend;

    public Heartbeat(Time time, int sessionTimeoutMs, int heartbeatIntervalMs, int maxPollIntervalMs, long retryBackoffMs) {
        if (heartbeatIntervalMs >= sessionTimeoutMs) {
            throw new IllegalArgumentException("Heartbeat must be set lower than the session timeout");
        }
        this.time = time;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.maxPollIntervalMs = maxPollIntervalMs;
        this.retryBackoffMs = retryBackoffMs;
        this.heartbeatTimer = time.timer(heartbeatIntervalMs);
        this.sessionTimer = time.timer(sessionTimeoutMs);
        this.pollTimer = time.timer(maxPollIntervalMs);
    }

    private void update(long now) {
        this.heartbeatTimer.update(now);
        this.sessionTimer.update(now);
        this.pollTimer.update(now);
    }

    public void poll(long now) {
        this.update(now);
        this.pollTimer.reset(this.maxPollIntervalMs);
    }

    public void sentHeartbeat(long now) {
        this.lastHeartbeatSend = now;
        this.update(now);
        this.heartbeatTimer.reset(this.heartbeatIntervalMs);
    }

    public void failHeartbeat() {
        this.update(this.time.milliseconds());
        this.heartbeatTimer.reset(this.retryBackoffMs);
    }

    public void receiveHeartbeat() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.sessionTimeoutMs);
    }

    public boolean shouldHeartbeat(long now) {
        this.update(now);
        return this.heartbeatTimer.isExpired();
    }

    public long lastHeartbeatSend() {
        return this.lastHeartbeatSend;
    }

    public long timeToNextHeartbeat(long now) {
        this.update(now);
        return this.heartbeatTimer.remainingMs();
    }

    public boolean sessionTimeoutExpired(long now) {
        this.update(now);
        return this.sessionTimer.isExpired();
    }

    public void resetTimeouts() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.sessionTimeoutMs);
        this.pollTimer.reset(this.maxPollIntervalMs);
        this.heartbeatTimer.reset(this.heartbeatIntervalMs);
    }

    public void resetSessionTimeout() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.sessionTimeoutMs);
    }

    public boolean pollTimeoutExpired(long now) {
        this.update(now);
        return this.pollTimer.isExpired();
    }

    public long lastPollTime() {
        return this.pollTimer.currentTimeMs();
    }
}

