/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp.packet.chunks;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.red5.io.sctp.IAssociationControl;
import org.red5.io.sctp.IServerChannelControl;
import org.red5.io.sctp.SctpException;
import org.red5.io.sctp.packet.SctpPacket;
import org.red5.io.sctp.packet.chunks.Chunk;
import org.red5.io.sctp.packet.chunks.ChunkType;
import org.red5.io.sctp.packet.chunks.InitAck;
import org.red5.io.sctp.packet.chunks.StateCookie;

public class Init
extends Chunk {
    private static final int MANDATORY_FIELD_SIZE = 16;
    private int initiateTag;
    private int advertisedReceiverWindowCredit;
    private int numberOfOutboundStreams;
    private int numberOfInboundStreams;
    private int initialTSN;

    public Init(int initialTSN, int initiateTag) {
        super(ChunkType.INIT, (byte)0);
        super.setLength(this.getSize());
        this.initialTSN = initialTSN;
        this.initiateTag = initiateTag;
        this.advertisedReceiverWindowCredit = 1024;
        this.numberOfInboundStreams = 1;
        this.numberOfOutboundStreams = 1;
    }

    public Init(byte[] data, int offset, int length) throws SctpException {
        super(data, offset, length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset + 4, data.length - (offset + 4));
        this.setLength(20);
        this.initiateTag = byteBuffer.getInt();
        this.advertisedReceiverWindowCredit = byteBuffer.getInt();
        this.numberOfOutboundStreams = byteBuffer.getShort();
        this.numberOfInboundStreams = byteBuffer.getShort();
        this.initialTSN = byteBuffer.getInt();
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(20);
        byte[] data = super.getBytes();
        byteBuffer.put(data);
        byteBuffer.putInt(this.initiateTag);
        byteBuffer.putInt(this.advertisedReceiverWindowCredit);
        byteBuffer.putShort((short)this.numberOfOutboundStreams);
        byteBuffer.putShort((short)this.numberOfInboundStreams);
        byteBuffer.putInt(this.initialTSN);
        byteBuffer.clear();
        byte[] result = new byte[byteBuffer.capacity()];
        byteBuffer.get(result, 0, result.length);
        return result;
    }

    public int getInitiateTag() {
        return this.initiateTag;
    }

    public int getAdvertisedReceiverWindowCredit() {
        return this.advertisedReceiverWindowCredit;
    }

    public int getNumberOfOutboundStreams() {
        return this.numberOfOutboundStreams;
    }

    public int getNumberOfInboundStreams() {
        return this.numberOfInboundStreams;
    }

    public int getInitialTSN() {
        return this.initialTSN;
    }

    @Override
    public int getSize() {
        return 16 + super.getSize();
    }

    @Override
    public void apply(InetSocketAddress address, IServerChannelControl server) throws SctpException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        IAssociationControl association = server.getPendingChannel(address);
        if (association != null) {
            throw new SctpException("init chunk : association already exist in pending pool");
        }
        StateCookie stateCookie = new StateCookie(this.getInitiateTag(), this.getInitialTSN(), this.getAdvertisedReceiverWindowCredit(), this.getNumberOfOutboundStreams(), this.getNumberOfInboundStreams());
        int verificationTag = server.getRandom().nextInt();
        int initialTSN = server.getRandom().nextInt();
        InitAck initAck = new InitAck(verificationTag, initialTSN, stateCookie, server.getMac());
        SctpPacket packet = new SctpPacket(server.getPort(), address.getPort(), this.getInitiateTag(), initAck);
        server.send(packet, address);
    }

    @Override
    public void apply(IAssociationControl association) throws SctpException {
        throw new SctpException("init chunk : association already exist in pending pool");
    }
}

