/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp.packet.chunks;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.red5.io.sctp.IAssociationControl;
import org.red5.io.sctp.IServerChannelControl;
import org.red5.io.sctp.SctpException;
import org.red5.io.sctp.packet.SctpPacket;
import org.red5.io.sctp.packet.chunks.Chunk;
import org.red5.io.sctp.packet.chunks.ChunkType;
import org.red5.io.sctp.packet.chunks.CookieAck;
import org.red5.io.sctp.packet.chunks.StateCookie;

public class CookieEcho
extends Chunk {
    private byte[] cookie;

    public CookieEcho(byte[] data, int offset, int length) throws SctpException {
        super(data, offset, length);
        this.cookie = new byte[length - super.getSize()];
        System.arraycopy(data, offset, this.cookie, 0, this.cookie.length);
    }

    public CookieEcho(byte[] cookie) {
        super(ChunkType.COOKIE_ECHO, (byte)0);
        this.cookie = cookie;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(super.getSize() + this.cookie.length);
        byte[] data = super.getBytes();
        byteBuffer.put(data);
        byteBuffer.put(this.cookie);
        byteBuffer.clear();
        byte[] result = new byte[byteBuffer.capacity()];
        byteBuffer.get(result, 0, result.length);
        return result;
    }

    @Override
    public void apply(IAssociationControl channel) throws SctpException, IOException {
    }

    @Override
    public void apply(InetSocketAddress address, IServerChannelControl server) throws SctpException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        StateCookie stateCookie = new StateCookie(this.cookie, 0, this.cookie.length);
        if (stateCookie.isValid(server.getMac())) {
            server.addPendingChannel(address, stateCookie.getInitialTSN(), stateCookie.getVerificationTag());
            IAssociationControl channel = server.getPendingChannel(address);
            CookieAck cookieAck = new CookieAck();
            SctpPacket packet = new SctpPacket((short)server.getPort(), (short)address.getPort(), stateCookie.getVerificationTag(), cookieAck);
            channel.setState(IAssociationControl.State.ESTABLISHED);
        }
    }
}

