/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mp3.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.tika.io.TailStream;
import org.apache.tika.parser.mp3.AudioFrame;

public class MP3Stream
extends PushbackInputStream {
    private static final int[] BIT_RATE_MPEG1_L1 = new int[]{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000};
    private static final int[] BIT_RATE_MPEG1_L2 = new int[]{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000};
    private static final int[] BIT_RATE_MPEG1_L3 = new int[]{0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000};
    private static final int[] BIT_RATE_MPEG2_L1 = new int[]{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000};
    private static final int[] BIT_RATE_MPEG2_L2 = new int[]{0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000};
    private static final int[] SAMPLE_RATE_MPEG1 = new int[]{44100, 48000, 32000};
    private static final int[] SAMPLE_RATE_MPEG2 = new int[]{22050, 24000, 16000};
    private static final int[] SAMPLE_RATE_MPEG2_5 = new int[]{11025, 12000, 8000};
    private static final int[][] SAMPLE_RATE = MP3Stream.createSampleRateTable();
    private static final int SAMPLE_COUNT_L1 = 384;
    private static final int SAMPLE_COUNT_L2 = 1152;
    private static final int HEADER_SIZE = 4;
    private AudioFrame currentHeader;
    private byte[] header = new byte[3];
    private boolean endOfStream;

    public MP3Stream(InputStream in) {
        super((InputStream)new TailStream(in, 10368), 8);
    }

    public boolean eos() {
        return this.endOfStream;
    }

    public AudioFrame nextFrame() throws IOException {
        AudioFrame frame = null;
        while (!this.endOfStream && frame == null) {
            this.findFrameSyncByte();
            if (this.endOfStream) continue;
            HeaderBitField headerField = this.createHeaderField();
            if (this.endOfStream) continue;
            frame = MP3Stream.createHeader(headerField);
            if (frame == null) {
                this.pushBack(headerField);
                continue;
            }
            System.arraycopy(headerField.toArray(), 0, this.header, 0, 3);
        }
        this.currentHeader = frame;
        return frame;
    }

    public boolean skipFrame() throws IOException {
        if (this.currentHeader != null) {
            MP3Stream.skipStream(this.in, this.currentHeader.getLength() - 4);
            this.currentHeader = null;
            return true;
        }
        return false;
    }

    private void findFrameSyncByte() throws IOException {
        boolean found = false;
        while (!found && !this.endOfStream) {
            if (this.nextByte() != 255) continue;
            found = true;
        }
    }

    private HeaderBitField createHeaderField() throws IOException {
        HeaderBitField field = new HeaderBitField();
        field.add(this.nextByte());
        field.add(this.nextByte());
        field.add(this.nextByte());
        return field;
    }

    private static AudioFrame createHeader(HeaderBitField bits) {
        if (bits.get(21, 23) != 7) {
            return null;
        }
        int mpegVer = bits.get(19, 20);
        int layer = bits.get(17, 18);
        int bitRateCode = bits.get(12, 15);
        int sampleRateCode = bits.get(10, 11);
        int padding = bits.get(9);
        if (mpegVer == 1 || layer == 0 || bitRateCode == 0 || bitRateCode == 15 || sampleRateCode == 3) {
            return null;
        }
        int bitRate = MP3Stream.calculateBitRate(mpegVer, layer, bitRateCode);
        int sampleRate = MP3Stream.calculateSampleRate(mpegVer, sampleRateCode);
        int length = MP3Stream.calculateFrameLength(layer, bitRate, sampleRate, padding);
        float duration = MP3Stream.calculateDuration(layer, sampleRate);
        int channels = MP3Stream.calculateChannels(bits.get(6, 7));
        return new AudioFrame(mpegVer, layer, bitRate, sampleRate, channels, length, duration);
    }

    private int nextByte() throws IOException {
        int result = 0;
        if (!this.endOfStream && (result = this.read()) == -1) {
            this.endOfStream = true;
        }
        return this.endOfStream ? 0 : result;
    }

    private void pushBack(HeaderBitField field) throws IOException {
        this.unread(field.toArray());
    }

    private static void skipStream(InputStream in, long count) throws IOException {
        long size = count;
        long skipped = 0L;
        while (size > 0L && skipped >= 0L) {
            skipped = in.skip(size);
            if (skipped == -1L) continue;
            size -= skipped;
        }
    }

    private static int calculateBitRate(int mpegVer, int layer, int code) {
        int[] arr = null;
        if (mpegVer == 3) {
            switch (layer) {
                case 3: {
                    arr = BIT_RATE_MPEG1_L1;
                    break;
                }
                case 2: {
                    arr = BIT_RATE_MPEG1_L2;
                    break;
                }
                case 1: {
                    arr = BIT_RATE_MPEG1_L3;
                }
            }
        } else {
            arr = layer == 3 ? BIT_RATE_MPEG2_L1 : BIT_RATE_MPEG2_L2;
        }
        return arr[code];
    }

    private static int calculateSampleRate(int mpegVer, int code) {
        return SAMPLE_RATE[mpegVer][code];
    }

    private static int calculateFrameLength(int layer, int bitRate, int sampleRate, int padding) {
        if (layer == 3) {
            return (12 * bitRate / sampleRate + padding) * 4;
        }
        return 144 * bitRate / sampleRate + padding;
    }

    private static float calculateDuration(int layer, int sampleRate) {
        int sampleCount = layer == 3 ? 384 : 1152;
        return 1000.0f / (float)sampleRate * (float)sampleCount;
    }

    private static int calculateChannels(int chan) {
        return chan < 3 ? 2 : 1;
    }

    private static int[][] createSampleRateTable() {
        int[][] arr = new int[4][];
        arr[3] = SAMPLE_RATE_MPEG1;
        arr[2] = SAMPLE_RATE_MPEG2;
        arr[0] = SAMPLE_RATE_MPEG2_5;
        return arr;
    }

    private static class HeaderBitField {
        private int value;

        private HeaderBitField() {
        }

        public void add(int b) {
            this.value <<= 8;
            this.value |= b;
        }

        public int get(int from, int to) {
            int shiftVal = this.value >> from;
            int mask = (1 << to - from + 1) - 1;
            return shiftVal & mask;
        }

        public int get(int bit) {
            return this.get(bit, bit);
        }

        public byte[] toArray() {
            byte[] result = new byte[]{(byte)this.get(16, 23), (byte)this.get(8, 15), (byte)this.get(0, 7)};
            return result;
        }
    }
}

