/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;
import org.red5.io.matroska.dtd.TagFactory;

public class ParserUtils {
    public static final int BIT_IN_BYTE = 8;

    public static long parseInteger(InputStream inputStream, int size) throws IOException {
        byte[] buffer = new byte[size];
        int numberOfReadsBytes = inputStream.read(buffer, 0, size);
        assert (numberOfReadsBytes == size);
        long value = (long)buffer[0] & 0xFFL;
        for (int i = 1; i < size; ++i) {
            value = value << 8 | (long)buffer[i] & 0xFFL;
        }
        return value;
    }

    public static String parseString(InputStream inputStream, int size) throws IOException {
        if (0 == size) {
            return "";
        }
        byte[] buffer = new byte[size];
        int numberOfReadsBytes = inputStream.read(buffer, 0, size);
        assert (numberOfReadsBytes == size);
        return new String(buffer, "UTF-8");
    }

    public static double parseFloat(InputStream inputStream, int size) throws IOException {
        byte[] buffer = new byte[size];
        int numberOfReadsBytes = inputStream.read(buffer, 0, size);
        assert (numberOfReadsBytes == size);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer).order(ByteOrder.BIG_ENDIAN);
        if (8 == size) {
            return byteBuffer.getDouble();
        }
        return byteBuffer.getFloat();
    }

    public static ArrayList<Tag> parseMasterElement(InputStream inputStream, int size) throws IOException, ConverterException {
        byte[] bufferForSubElements = new byte[size];
        int readOfBytes = inputStream.read(bufferForSubElements, 0, size);
        assert (readOfBytes == size);
        ArrayList<Tag> subElements = new ArrayList<Tag>();
        ByteArrayInputStream inputStreamForSubElements = new ByteArrayInputStream(bufferForSubElements);
        while (0 != inputStreamForSubElements.available()) {
            subElements.add(ParserUtils.parseTag(inputStreamForSubElements));
        }
        return subElements;
    }

    public static byte[] parseBinary(InputStream inputStream, int size) throws IOException {
        byte[] value = new byte[size];
        for (int i = value.length; i != 0; i -= inputStream.read(value, value.length - i, i)) {
        }
        return value;
    }

    public static VINT readVINT(InputStream inputStream) throws IOException {
        byte[] vint;
        int fb = inputStream.read();
        int read = 0;
        assert (fb > 0);
        int len = fb >> 4;
        long mask = 0xFFFFFFFL;
        if (len >= 8) {
            read = 0;
            mask = 127L;
            vint = new byte[1];
        } else if (len >= 4) {
            mask = 16383L;
            vint = new byte[2];
            read = inputStream.read(vint, 1, 1);
            assert (read == 1);
        } else if (len >= 2) {
            mask = 0x1FFFFFL;
            vint = new byte[3];
            read = inputStream.read(vint, 1, 2);
            assert (read == 2);
        } else if (len >= 1) {
            vint = new byte[4];
            read = inputStream.read(vint, 1, 3);
            assert (read == 3);
        } else {
            mask = 0xFFFFFFFFFFFFFFL;
            vint = new byte[8];
            read = inputStream.read(vint, 1, 7);
            assert (read == 7);
        }
        vint[0] = (byte)fb;
        long binaryV = 0L;
        for (int i = 0; i < vint.length; ++i) {
            binaryV += (long)(0xFF & vint[i]);
            if (i == vint.length - 1) continue;
            binaryV <<= 8;
        }
        return new VINT(binaryV, (byte)(read + 1), mask & binaryV);
    }

    public static Tag parseTag(InputStream inputStream) throws IOException, ConverterException {
        VINT id = ParserUtils.readVINT(inputStream);
        VINT size = ParserUtils.readVINT(inputStream);
        return TagFactory.createTag(id, size, inputStream);
    }

    public static byte[] getBytes(long val, long size) {
        byte[] res = new byte[(int)size];
        long bv = val;
        for (int i = (int)size - 1; i >= 0; --i) {
            res[i] = (byte)(bv & 0xFFL);
            bv >>= 8;
        }
        return res;
    }

    public static void skip(long size, InputStream input) throws IOException {
        while (size > 0L) {
            size -= input.skip(size);
        }
    }
}

