/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AbstractVideo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.VideoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SorensonVideo
extends AbstractVideo {
    private Logger log = LoggerFactory.getLogger(SorensonVideo.class);
    static final String CODEC_NAME = "SorensonVideo";
    private byte[] blockData;
    private int dataCount;
    private int blockSize;
    private final CopyOnWriteArrayList<IVideoStreamCodec.FrameData> interframes = new CopyOnWriteArrayList();
    private final AtomicInteger numInterframes = new AtomicInteger(0);

    public SorensonVideo() {
        this.reset();
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canDropFrames() {
        return true;
    }

    @Override
    public void reset() {
        this.blockData = null;
        this.blockSize = 0;
        this.dataCount = 0;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        if (data.limit() > 0) {
            byte first = data.get();
            data.rewind();
            return (first & 0xF) == VideoCodec.H263.getId();
        }
        return false;
    }

    @Override
    public boolean addData(IoBuffer data) {
        if (data.limit() == 0) {
            return true;
        }
        if (!this.canHandleData(data)) {
            return false;
        }
        byte first = data.get();
        data.rewind();
        int frameType = (first & 0xF0) >> 4;
        if (frameType != 1) {
            try {
                int lastInterframe = this.numInterframes.getAndIncrement();
                if (frameType != 3) {
                    this.log.trace("Buffering interframe #{}", (Object)lastInterframe);
                    if (lastInterframe < this.interframes.size()) {
                        this.interframes.get(lastInterframe).setData(data);
                    } else {
                        this.interframes.add(new IVideoStreamCodec.FrameData(data));
                    }
                } else {
                    this.numInterframes.set(lastInterframe);
                }
            }
            catch (Throwable e) {
                this.log.error("Failed to buffer interframe", e);
            }
            data.rewind();
            return true;
        }
        this.numInterframes.set(0);
        this.interframes.clear();
        this.dataCount = data.limit();
        if (this.blockSize < this.dataCount) {
            this.blockSize = this.dataCount;
            this.blockData = new byte[this.blockSize];
        }
        data.get(this.blockData, 0, this.dataCount);
        data.rewind();
        return true;
    }

    @Override
    public IoBuffer getKeyframe() {
        if (this.dataCount > 0) {
            IoBuffer result = IoBuffer.allocate((int)this.dataCount);
            result.put(this.blockData, 0, this.dataCount);
            result.rewind();
            return result;
        }
        return null;
    }

    @Override
    public int getNumInterframes() {
        return this.numInterframes.get();
    }

    @Override
    public IVideoStreamCodec.FrameData getInterframe(int index) {
        if (index < this.numInterframes.get()) {
            return this.interframes.get(index);
        }
        return null;
    }

    @Override
    public IVideoStreamCodec.FrameData[] getKeyframes() {
        IVideoStreamCodec.FrameData[] frameDataArray;
        if (this.dataCount > 0) {
            IVideoStreamCodec.FrameData[] frameDataArray2 = new IVideoStreamCodec.FrameData[1];
            frameDataArray = frameDataArray2;
            frameDataArray2[0] = new IVideoStreamCodec.FrameData(this.getKeyframe());
        } else {
            frameDataArray = new IVideoStreamCodec.FrameData[]{};
        }
        return frameDataArray;
    }
}

