/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerInteger;

public class SerializerIntegerPacked
extends SerializerInteger {
    @Override
    public void serialize(DataOutput2 out, Integer value) throws IOException {
        out.packInt(value);
    }

    @Override
    public Integer deserialize(DataInput2 in, int available) throws IOException {
        return new Integer(in.unpackInt());
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        for (int o : (int[])vals) {
            out.packIntBigger(o);
        }
    }

    public int[] valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        int[] ret2 = new int[size2];
        in.unpackIntArray(ret2, 0, size2);
        return ret2;
    }

    @Override
    public int fixedSize() {
        return -1;
    }

    @Override
    public int valueArrayBinarySearch(Integer key, DataInput2 input, int keysLen, Comparator comparator) throws IOException {
        if (comparator != this) {
            return super.valueArrayBinarySearch(key, input, keysLen, comparator);
        }
        int key2 = key;
        for (int pos = 0; pos < keysLen; ++pos) {
            int from = input.unpackInt();
            if (key2 > from) continue;
            input.unpackLongSkip(keysLen - pos - 1);
            return key2 == from ? pos : -(pos + 1);
        }
        return -(keysLen + 1);
    }

    @Override
    public Integer valueArrayBinaryGet(DataInput2 input, int keysLen, int pos) throws IOException {
        input.unpackLongSkip(pos);
        return input.unpackInt();
    }
}

