/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.StoreDirectAbstract;
import org.mapdb.StoreDirectJava;
import org.mapdb.StoreTx;
import org.mapdb.StoreWAL;
import org.mapdb.Utils;
import org.mapdb.WriteAheadLog;
import org.mapdb.volume.ReadOnlyVolume;
import org.mapdb.volume.SingleByteArrayVol;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 z2\u00020\u00012\u00020\u0002:\u0001zBg\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\u0006\u0010\u0011\u001a\u00020\n\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014J\b\u0010B\u001a\u00020\bH\u0014J\b\u0010C\u001a\u00020\bH\u0014J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020EH\u0016J\b\u0010G\u001a\u00020EH\u0016J=\u0010H\u001a\u00020\n\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\b\u0010K\u001a\u0004\u0018\u0001HI2\b\u0010L\u001a\u0004\u0018\u0001HI2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010OJ$\u0010P\u001a\u00020E\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016J\b\u0010Q\u001a\u00020\nH\u0016J\u0010\u0010R\u001a\u00020E2\u0006\u0010S\u001a\u00020\bH\u0014J+\u0010T\u001a\u0004\u0018\u0001HI\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010UJ\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00040WH\u0016J\b\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\b2\u0006\u0010J\u001a\u00020\bH\u0014J\u0018\u0010[\u001a\u00020E2\u0006\u0010\\\u001a\u00020\b2\u0006\u0010J\u001a\u00020\bH\u0004J\u0018\u0010]\u001a\u00020&2\u0006\u0010\\\u001a\u00020\b2\u0006\u0010J\u001a\u00020\bH\u0004J \u0010^\u001a\u00020\b2\u0006\u0010_\u001a\u00020&2\u0006\u0010`\u001a\u00020\f2\u0006\u0010J\u001a\u00020\bH\u0004J\u0018\u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020\b2\u0006\u0010c\u001a\u00020\bH\u0004J\u0010\u0010d\u001a\u00020&2\u0006\u0010e\u001a\u00020\bH\u0002J0\u0010f\u001a\u00020E2\u0006\u0010g\u001a\u00020\b2\u0006\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020\b2\u0006\u0010j\u001a\u00020\b2\u0006\u0010k\u001a\u00020\nH\u0004J \u0010l\u001a\u00020E2\u0006\u0010g\u001a\u00020\b2\u0006\u0010i\u001a\u00020\b2\u0006\u0010k\u001a\u00020\nH\u0014J\u0018\u0010m\u001a\u00020\b2\u0006\u0010g\u001a\u00020\b2\u0006\u0010k\u001a\u00020\nH\u0014J\b\u0010n\u001a\u00020\bH\u0016J+\u0010o\u001a\u00020\b\"\u0004\b\u0000\u0010I2\b\u0010p\u001a\u0004\u0018\u0001HI2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010qJ\b\u0010r\u001a\u00020EH\u0016J\u0018\u0010s\u001a\u00020E2\u0006\u0010J\u001a\u00020\b2\u0006\u0010i\u001a\u00020\bH\u0014J3\u0010t\u001a\u00020E\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\b\u0010p\u001a\u0004\u0018\u0001HI2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010uJ\u001a\u0010v\u001a\u00020E2\u0006\u0010J\u001a\u00020\b2\b\u0010w\u001a\u0004\u0018\u00010xH\u0002J\b\u0010y\u001a\u00020EH\u0016R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b#\u0010 R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u000209X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010;R\u0014\u0010>\u001a\u00020?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010A\u00a8\u0006{"}, d2={"Lorg/mapdb/StoreWAL;", "Lorg/mapdb/StoreDirectAbstract;", "Lorg/mapdb/StoreTx;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "fileLockWait", "", "isThreadSafe", "", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDeleteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "(Ljava/lang/String;Lorg/mapdb/volume/VolumeFactory;JZIJJZZZZZ)V", "allocatedPages", "Lorg/eclipse/collections/impl/list/mutable/primitive/LongArrayList;", "getAllocatedPages", "()Lorg/eclipse/collections/impl/list/mutable/primitive/LongArrayList;", "cacheIndexLinks", "Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "getCacheIndexLinks", "()Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "cacheIndexVals", "", "getCacheIndexVals", "()[Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "[Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "cacheRecords", "getCacheRecords", "cacheStacks", "Lorg/eclipse/collections/impl/map/mutable/primitive/LongObjectHashMap;", "", "getCacheStacks", "()Lorg/eclipse/collections/impl/map/mutable/primitive/LongObjectHashMap;", "headBytes", "getHeadBytes", "()[B", "headVol", "Lorg/mapdb/volume/SingleByteArrayVol;", "getHeadVol", "()Lorg/mapdb/volume/SingleByteArrayVol;", "indexPagesBackup", "", "getIndexPagesBackup", "()[J", "setIndexPagesBackup", "([J)V", "isReadOnly", "()Z", "realVolume", "Lorg/mapdb/volume/Volume;", "getRealVolume", "()Lorg/mapdb/volume/Volume;", "volume", "getVolume", "wal", "Lorg/mapdb/WriteAheadLog;", "getWal", "()Lorg/mapdb/WriteAheadLog;", "allocateNewIndexPage", "allocateNewPage", "close", "", "commit", "compact", "compareAndSwap", "R", "recid", "expectedOldRecord", "newRecord", "serializer", "Lorg/mapdb/Serializer;", "(JLjava/lang/Object;Ljava/lang/Object;Lorg/mapdb/Serializer;)Z", "delete", "fileLoad", "freeSizeIncrement", "increment", "get", "(JLorg/mapdb/Serializer;)Ljava/lang/Object;", "getAllFiles", "", "getAllRecids", "Lkotlin/collections/LongIterator;", "getIndexVal", "linkedRecordDelete", "indexValue", "linkedRecordGet", "linkedRecordPut", "output", "size", "longStackFindEnd", "pageOffset", "pos", "longStackLoadChunk", "chunkOffset", "longStackNewChunk", "masterLinkOffset", "prevPageOffset", "value", "valueSize", "recursive", "longStackPut", "longStackTake", "preallocate", "put", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)J", "rollback", "setIndexVal", "update", "(JLjava/lang/Object;Lorg/mapdb/Serializer;)V", "updateProtected", "di", "Lorg/mapdb/DataOutput2;", "verify", "Companion", "mapdb"})
public final class StoreWAL
extends StoreDirectAbstract
implements StoreTx {
    @NotNull
    private final Volume realVolume;
    @NotNull
    private final Volume volume;
    @NotNull
    private final byte[] headBytes;
    @NotNull
    private final SingleByteArrayVol headVol;
    @NotNull
    private final LongObjectHashMap<byte[]> cacheStacks;
    @NotNull
    private final LongLongHashMap[] cacheIndexVals;
    @NotNull
    private final LongLongHashMap cacheIndexLinks;
    @NotNull
    private final LongLongHashMap[] cacheRecords;
    @NotNull
    private final WriteAheadLog wal;
    @NotNull
    private long[] indexPagesBackup;
    @NotNull
    private final LongArrayList allocatedPages;
    private final boolean isReadOnly = false;
    private static final long TOMB1 = -1L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final Volume getRealVolume() {
        return this.realVolume;
    }

    @Override
    @NotNull
    protected Volume getVolume() {
        return this.volume;
    }

    @NotNull
    protected final byte[] getHeadBytes() {
        return this.headBytes;
    }

    @Override
    @NotNull
    protected SingleByteArrayVol getHeadVol() {
        return this.headVol;
    }

    @NotNull
    protected final LongObjectHashMap<byte[]> getCacheStacks() {
        return this.cacheStacks;
    }

    @NotNull
    protected final LongLongHashMap[] getCacheIndexVals() {
        return this.cacheIndexVals;
    }

    @NotNull
    protected final LongLongHashMap getCacheIndexLinks() {
        return this.cacheIndexLinks;
    }

    @NotNull
    protected final LongLongHashMap[] getCacheRecords() {
        return this.cacheRecords;
    }

    @NotNull
    protected final WriteAheadLog getWal() {
        return this.wal;
    }

    @NotNull
    protected final long[] getIndexPagesBackup() {
        return this.indexPagesBackup;
    }

    protected final void setIndexPagesBackup(@NotNull long[] lArray) {
        Intrinsics.checkParameterIsNotNull((Object)lArray, (String)"<set-?>");
        this.indexPagesBackup = lArray;
    }

    @NotNull
    protected final LongArrayList getAllocatedPages() {
        return this.allocatedPages;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    protected long getIndexVal(long recid2) {
        int segment = this.recidToSegment(recid2);
        Utils.INSTANCE.assertReadLock(this.getLocks()[segment]);
        long indexOffset = this.recidToOffset(recid2);
        long ret2 = this.cacheIndexVals[segment].get(indexOffset);
        if (ret2 == 0L) {
            ret2 = this.getVolume().getLong(indexOffset);
        }
        if (ret2 == 0L) {
            throw (Throwable)new DBException.GetVoid(recid2);
        }
        return DataIO.parity1Get(ret2);
    }

    @Override
    protected void setIndexVal(long recid2, long value) {
        int segment = this.recidToSegment(recid2);
        Utils.INSTANCE.assertReadLock(this.getLocks()[segment]);
        long indexOffset = this.recidToOffset(recid2);
        this.cacheIndexVals[segment].put(indexOffset, DataIO.parity1Set(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> boolean compareAndSwap(long recid2, @Nullable R expectedOldRecord, @Nullable R newRecord, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            R old = this.get(recid2, serializer);
            if (old == null && expectedOldRecord != null) {
                boolean bl = false;
                return bl;
            }
            if (old != null && expectedOldRecord == null) {
                boolean bl = false;
                return bl;
            }
            if (old != expectedOldRecord) {
                R r = old;
                if (r == null) {
                    Intrinsics.throwNpe();
                }
                R r2 = expectedOldRecord;
                if (r2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!serializer.equals(r, r2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            DataOutput2 di = this.serialize(newRecord, serializer);
            this.updateProtected(recid2, di);
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void delete(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        int segment = this.recidToSegment(recid2);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[segment];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            long oldIndexVal = this.getIndexVal(recid2);
            long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
            if (oldSize == 65534L) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            if (oldSize != 65535L) {
                Lock lock$iv2;
                Utils utils2 = Utils.INSTANCE;
                Lock lock = lock$iv2 = this.getStructuralLock();
                if (lock != null) {
                    lock.lock();
                }
                try {
                    if (this.indexValFlagLinked(oldIndexVal)) {
                        this.linkedRecordDelete(oldIndexVal, recid2);
                    } else if (oldSize > (long)5) {
                        long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                        long sizeUp = DataIO.roundUp(oldSize, 16L);
                        this.releaseData(sizeUp, oldOffset, false);
                        this.cacheRecords[segment].remove(StoreDirectJava.indexValToOffset(oldIndexVal));
                    }
                    this.releaseRecid(recid2);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Lock lock2 = lock$iv2;
                    if (lock2 != null) {
                        lock2.unlock();
                    }
                }
            }
            this.setIndexVal(recid2, this.indexValCompose(65534L, 0L, 0, 0, 1));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long l;
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        Object lock$iv = this.getStructuralLock();
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            l = this.allocateRecid();
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long recid2 = l;
        Utils this_$iv = Utils.INSTANCE;
        lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 1, 1));
            long l2 = recid2;
            return l2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @NotNull
    protected final byte[] linkedRecordGet(long indexValue, long recid2) {
        if (!this.indexValFlagLinked(indexValue)) {
            throw (Throwable)((Object)new AssertionError((Object)"not linked record"));
        }
        int segment = this.recidToSegment(recid2);
        LongLongHashMap cacheRec = this.cacheRecords[segment];
        byte[] b = new byte[131072];
        int bpos = 0;
        long pointer = indexValue;
        while (true) {
            long walId;
            boolean isLinked;
            int nextPointerSize = (isLinked = this.indexValFlagLinked(pointer)) ? 8 : 0;
            int size2 = (int)StoreDirectJava.indexValToSize(pointer) - nextPointerSize;
            long offset = StoreDirectJava.indexValToOffset(pointer);
            if (bpos + size2 >= b.length) {
                Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(b, b.length * 2), (String)"Arrays.copyOf(b,b.size*2)");
            }
            if ((walId = cacheRec.get(offset)) != 0L) {
                byte[] ba = this.wal.walGetRecord(walId, recid2);
                System.arraycopy(ba, nextPointerSize, b, bpos, size2);
                bpos += size2;
                if (!isLinked) break;
                pointer = DataIO.parity3Get(DataIO.getLong(ba, 0));
                continue;
            }
            this.getVolume().getData(offset + (long)nextPointerSize, b, bpos, size2);
            bpos += size2;
            if (!isLinked) break;
            pointer = DataIO.parity3Get(this.getVolume().getLong(offset));
        }
        byte[] byArray = Arrays.copyOf(b, bpos);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(b,bpos)");
        return byArray;
    }

    protected final void linkedRecordDelete(long indexValue, long recid2) {
        if (!this.indexValFlagLinked(indexValue)) {
            throw (Throwable)((Object)new AssertionError((Object)"not linked record"));
        }
        int segment = this.recidToSegment(recid2);
        LongLongHashMap cacheRec = this.cacheRecords[segment];
        long pointer = indexValue;
        while (pointer != 0L) {
            long l;
            boolean isLinked = this.indexValFlagLinked(pointer);
            long size2 = StoreDirectJava.indexValToSize(pointer);
            long offset = StoreDirectJava.indexValToOffset(pointer);
            if (isLinked) {
                long walId = cacheRec.get(offset);
                if (walId == 0L) {
                    l = DataIO.parity3Get(this.getVolume().getLong(offset));
                } else {
                    byte[] ba = this.wal.walGetRecord(walId, recid2);
                    l = DataIO.parity3Get(DataIO.getLong(ba, 0));
                }
            } else {
                l = 0L;
            }
            pointer = l;
            long sizeUp = DataIO.roundUp(size2, 16L);
            this.releaseData(sizeUp, offset, false);
            cacheRec.remove(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long linkedRecordPut(@NotNull byte[] output, int size2, long recid2) {
        long l;
        Lock lock$iv;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        int segment = this.recidToSegment(recid2);
        LongLongHashMap cacheRec = this.cacheRecords[segment];
        long remSize = size2;
        long chunkSize = Math.min(65520L, remSize);
        Utils utils = Utils.INSTANCE;
        Lock lock = lock$iv = this.getStructuralLock();
        if (lock != null) {
            lock.lock();
        }
        try {
            l = this.allocateData(DataIO.roundUp((int)chunkSize, 16), false);
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long chunkOffset = l;
        long walId = this.wal.walPutRecord(recid2, output, (int)(remSize - chunkSize), (int)chunkSize);
        cacheRec.put(chunkOffset, walId);
        remSize -= chunkSize;
        long isLinked = 0L;
        while (remSize > 0L) {
            long l2;
            Lock lock$iv2;
            long prevLink = DataIO.parity3Set((chunkSize + isLinked << 48) + chunkOffset + isLinked);
            isLinked = 8L;
            chunkSize = Math.min(65512L, remSize);
            Utils utils2 = Utils.INSTANCE;
            Lock lock3 = lock$iv2 = this.getStructuralLock();
            if (lock3 != null) {
                lock3.lock();
            }
            try {
                l2 = this.allocateData((int)DataIO.roundUp(chunkSize + (long)8, 16L), false);
            }
            finally {
                Lock lock4 = lock$iv2;
                if (lock4 != null) {
                    lock4.unlock();
                }
            }
            chunkOffset = l2;
            byte[] ba = new byte[(int)chunkSize + 8];
            DataIO.putLong(ba, 0, prevLink);
            System.arraycopy(output, (int)(remSize -= chunkSize), ba, 8, (int)chunkSize);
            walId = this.wal.walPutRecord(recid2, ba, 0, ba.length);
            cacheRec.put(chunkOffset, walId);
        }
        if (remSize != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        return (chunkSize + (long)8 << 48) + chunkOffset + isLinked + 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> long put(@Nullable R record, @NotNull Serializer<R> serializer) {
        long l;
        Lock lock$iv;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        DataOutput2 di = this.serialize(record, serializer);
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        Lock lock = lock$iv = this.getStructuralLock();
        if (lock != null) {
            lock.lock();
        }
        try {
            l = this.allocateRecid();
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long recid2 = l;
        long indexOffset = this.recidToOffset(recid2);
        int segment = this.recidToSegment(recid2);
        Utils utils2 = Utils.INSTANCE;
        ReadWriteLock lock$iv2 = this.getLocks()[segment];
        if (lock$iv2 != null) {
            lock$iv2.writeLock().lock();
        }
        try {
            if (di != null) {
                if (di.pos == 0) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 1;
                    long indexVal = this.indexValCompose(0L, 0L, n2, n, n3);
                    this.setIndexVal(recid2, indexVal);
                } else if (di.pos < 6) {
                    long offset = DataIO.getLong(di.buf, 0) >>> (7 - di.pos) * 8;
                    int n = 0;
                    int n4 = 0;
                    int n5 = 1;
                    long indexVal = this.indexValCompose(di.pos, offset, n4, n, n5);
                    this.setIndexVal(recid2, indexVal);
                } else if ((long)di.pos > 65520L) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)di.buf, (String)"di.buf");
                    long indexVal = this.linkedRecordPut(di.buf, di.pos, recid2);
                    this.setIndexVal(recid2, indexVal);
                } else {
                    long l2;
                    Lock lock$iv3;
                    Utils utils3 = Utils.INSTANCE;
                    Lock lock3 = lock$iv3 = this.getStructuralLock();
                    if (lock3 != null) {
                        lock3.lock();
                    }
                    try {
                        l2 = this.allocateData(DataIO.roundUp(di.pos, 16), false);
                    }
                    finally {
                        Lock lock4 = lock$iv3;
                        if (lock4 != null) {
                            lock4.unlock();
                        }
                    }
                    long volOffset = l2;
                    long walId = this.wal.walPutRecord(recid2, di.buf, 0, di.pos);
                    this.cacheRecords[segment].put(volOffset, walId);
                    int n = 0;
                    int n6 = 0;
                    int n7 = 1;
                    long indexVal = this.indexValCompose(di.pos, volOffset, n6, n, n7);
                    this.setIndexVal(recid2, indexVal);
                }
            } else {
                int n = 0;
                int n8 = 0;
                int n9 = 1;
                long indexVal = this.indexValCompose(65535L, 0L, n8, n, n9);
                this.cacheIndexVals[segment].put(indexOffset, indexVal);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv2 != null) {
                lock$iv2.writeLock().unlock();
            }
        }
        return recid2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void update(long recid2, @Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        DataOutput2 di = this.serialize(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.updateProtected(recid2, di);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateProtected(long recid2, DataOutput2 di) {
        long l;
        long newUpSize;
        Utils.INSTANCE.assertWriteLock(this.getLocks()[this.recidToSegment(recid2)]);
        long oldIndexVal = this.getIndexVal(recid2);
        boolean oldLinked = this.indexValFlagLinked(oldIndexVal);
        long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
        if (oldSize == 65534L) {
            throw (Throwable)new DBException.GetVoid(recid2);
        }
        updateProtected.1 roundSixDown$ = updateProtected.1.INSTANCE;
        long l2 = newUpSize = di == null ? -16L : DataIO.roundUp(roundSixDown$.invoke(di.pos), 16L);
        if (oldLinked || newUpSize != DataIO.roundUp(roundSixDown$.invoke(oldSize), 16L) && oldSize != 65535L && oldSize > 5L) {
            Lock lock$iv;
            Utils utils = Utils.INSTANCE;
            Lock lock = lock$iv = this.getStructuralLock();
            if (lock != null) {
                lock.lock();
            }
            try {
                if (oldLinked) {
                    this.linkedRecordDelete(oldIndexVal, recid2);
                } else {
                    long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                    long sizeUp = DataIO.roundUp(oldSize, 16L);
                    this.releaseData(sizeUp, oldOffset, false);
                    this.cacheRecords[this.recidToSegment(recid2)].remove(oldOffset);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Lock lock2 = lock$iv;
                if (lock2 != null) {
                    lock2.unlock();
                }
            }
        }
        if (di == null) {
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
            return;
        }
        if ((long)di.pos > 65520L) {
            Intrinsics.checkExpressionValueIsNotNull((Object)di.buf, (String)"di.buf");
            long newIndexVal = this.linkedRecordPut(di.buf, di.pos, recid2);
            this.setIndexVal(recid2, newIndexVal);
            return;
        }
        int size2 = di.pos;
        if (size2 != 0 && size2 < 6) {
            l = DataIO.getLong(di.buf, 0) >>> (7 - size2) * 8;
        } else if (!oldLinked && newUpSize == DataIO.roundUp(oldSize, 16L) && oldSize >= (long)6) {
            l = StoreDirectJava.indexValToOffset(oldIndexVal);
        } else if (size2 == 0) {
            l = 0L;
        } else {
            Lock lock$iv;
            Utils utils = Utils.INSTANCE;
            Lock lock = lock$iv = this.getStructuralLock();
            if (lock != null) {
                lock.lock();
            }
            try {
                long l3 = this.allocateData(DataIO.roundUp(size2, 16), false);
                l = l3;
            }
            finally {
                Lock lock3 = lock$iv;
                if (lock3 != null) {
                    lock3.unlock();
                }
            }
        }
        long offset = l;
        if (size2 > 5) {
            long walId = this.wal.walPutRecord(recid2, di.buf, 0, size2);
            this.cacheRecords[this.recidToSegment(recid2)].put(offset, walId);
        }
        this.setIndexVal(recid2, this.indexValCompose(size2, offset, 0, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <R> R get(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        int segment = this.recidToSegment(recid2);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[segment];
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            DataInput2 di;
            long indexVal = this.getIndexVal(recid2);
            long size2 = StoreDirectJava.indexValToSize(indexVal);
            if (size2 == 65535L) {
                R r = null;
                return r;
            }
            if (size2 == 65534L) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            if (this.indexValFlagLinked(indexVal)) {
                byte[] ba = this.linkedRecordGet(indexVal, recid2);
                R r = this.deserialize(serializer, new DataInput2.ByteArray(ba), ba.length);
                return r;
            }
            long volOffset = StoreDirectJava.indexValToOffset(indexVal);
            if (size2 < (long)6) {
                if (size2 > (long)5) {
                    throw (Throwable)new DBException.DataCorruption("wrong size record header");
                }
                R r = serializer.deserializeFromLong(volOffset >>> 8, (int)size2);
                return r;
            }
            long walId = this.cacheRecords[segment].get(volOffset);
            DataInput2 dataInput2 = di = walId != 0L ? (DataInput2)new DataInput2.ByteArray(this.wal.walGetRecord(walId, recid2)) : this.getVolume().getDataInput(volOffset, (int)size2);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataInput2, (String)"di");
            R r = this.deserialize(serializer, dataInput2, size2);
            return r;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LongIterator getAllRecids() {
        LongArrayList ret2;
        block8: {
            ret2 = new LongArrayList();
            Utils.INSTANCE.lockReadAll(this.getLocks());
            try {
                long maxRecid = this.getMaxRecid();
                long l = 1L;
                long l2 = maxRecid;
                if (l > l2) break block8;
                while (true) {
                    void recid2;
                    try {
                        long indexVal = this.getIndexVal((long)recid2);
                        if (!this.indexValFlagUnused(indexVal)) {
                            ret2.add((long)recid2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (recid2 != l2) {
                        ++recid2;
                        continue;
                    }
                    break;
                }
            }
            finally {
                Utils.INSTANCE.unlockReadAll(this.getLocks());
            }
        }
        return ArrayIteratorsKt.iterator((long[])ret2.toArray());
    }

    @Override
    public void verify() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            if (!this.getClosed().compareAndSet(false, true)) {
                return;
            }
            this.getVolume().close();
            if (this.getFileDeleteAfterClose() && this.getFile() != null) {
                new File(this.getFile()).delete();
                this.wal.destroyWalFiles();
            }
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            LongLongHashMap it;
            LongLongHashMap element$iv;
            int n;
            this.realVolume.getData(0L, this.headBytes, 0, this.headBytes.length);
            this.cacheIndexLinks.clear();
            LongLongHashMap[] $receiver$iv = this.cacheIndexVals;
            int n2 = $receiver$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $receiver$iv[n];
                it.clear();
                it.compact();
            }
            $receiver$iv = this.cacheRecords;
            n2 = $receiver$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $receiver$iv[n];
                it.clear();
                it.compact();
            }
            this.cacheStacks.clear();
            this.cacheStacks.compact();
            this.getIndexPages().clear();
            for (long page : this.indexPagesBackup) {
                this.getIndexPages().add(page);
            }
            this.wal.rollback();
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            DataIO.putInt(this.headBytes, 20, this.calculateHeaderChecksum());
            this.wal.walPutByteArray(0L, this.headBytes, 0, this.headBytes.length);
            this.wal.commit();
            this.realVolume.putData(0L, this.headBytes, 0, this.headBytes.length);
            this.realVolume.ensureAvailable(this.getFileTail$mapdb());
            for (LongLongHashMap indexVals : this.cacheIndexVals) {
                indexVals.forEachKeyValue(new LongLongProcedure(this){
                    final /* synthetic */ StoreWAL this$0;

                    public final void value(long indexOffset, long indexVal) {
                        this.this$0.getRealVolume().putLong(indexOffset, indexVal);
                    }
                    {
                        this.this$0 = storeWAL;
                    }
                });
                indexVals.clear();
                indexVals.compact();
            }
            this.cacheIndexLinks.forEachKeyValue(new LongLongProcedure(this){
                final /* synthetic */ StoreWAL this$0;

                public final void value(long indexOffset, long indexVal) {
                    this.this$0.getRealVolume().putLong(indexOffset, indexVal);
                }
                {
                    this.this$0 = storeWAL;
                }
            });
            this.cacheIndexLinks.clear();
            this.cacheStacks.forEachKeyValue((LongObjectProcedure)new LongObjectProcedure<byte[]>(this){
                final /* synthetic */ StoreWAL this$0;

                public final void value(long offset, byte[] bytes) {
                    this.this$0.getRealVolume().putData(offset, bytes, 0, bytes.length);
                }
                {
                    this.this$0 = storeWAL;
                }
            });
            this.cacheStacks.clear();
            this.cacheStacks.compact();
            for (LongLongHashMap records : this.cacheRecords) {
                records.forEachKeyValue(new LongLongProcedure(this){
                    final /* synthetic */ StoreWAL this$0;

                    public final void value(long offset, long walId) {
                        byte[] bytes = this.this$0.getWal().walGetRecord(walId, 0L);
                        this.this$0.getRealVolume().putData(offset, bytes, 0, bytes.length);
                    }
                    {
                        this.this$0 = storeWAL;
                    }
                });
                records.clear();
                records.compact();
            }
            long[] lArray = this.getIndexPages().toArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)lArray, (String)"indexPages.toArray()");
            this.indexPagesBackup = lArray;
            this.realVolume.sync();
            this.wal.destroyWalFiles();
            this.wal.close();
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    @Override
    public void compact() {
    }

    @Override
    protected long allocateNewPage() {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        long eof = this.getFileTail$mapdb();
        long newEof = eof + 0x100000L;
        this.allocatedPages.add(eof);
        this.setFileTail$mapdb(newEof);
        return eof;
    }

    @Override
    protected long allocateNewIndexPage() {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        long indexPage = this.allocateNewPage();
        MutableLongList mutableLongList = this.getIndexPages();
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableLongList, (String)"indexPages");
        long pagePointerOffset = mutableLongList.isEmpty() ? 32864L : this.getIndexPages().get(this.getIndexPages().size() - 1) + (long)8;
        this.wal.walPutLong(pagePointerOffset, DataIO.parity16Set(indexPage));
        this.cacheIndexLinks.put(pagePointerOffset, DataIO.parity16Set(indexPage));
        this.getIndexPages().add(indexPage);
        this.wal.walPutLong(indexPage + (long)8, DataIO.parity16Set(0L));
        this.cacheIndexLinks.put(indexPage + (long)8, DataIO.parity16Set(0L));
        return indexPage;
    }

    @Override
    protected void freeSizeIncrement(long increment) {
    }

    @Override
    protected void longStackPut(long masterLinkOffset, long value, boolean recursive) {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw (Throwable)new DBException.DataCorruption("wrong master link");
        }
        if (value >> 48 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        DataIO.parity1Get(value);
        long valueSize = DataIO.packLongSize(value);
        long masterLinkVal = DataIO.parity4Get(this.getHeadVol().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            this.longStackNewChunk(masterLinkOffset, 0L, value, valueSize, true);
            return;
        }
        long currSize = masterLinkVal >>> 48;
        long chunkOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        byte[] ba = this.longStackLoadChunk(chunkOffset);
        if (currSize + valueSize > (long)ba.length) {
            this.longStackNewChunk(masterLinkOffset, chunkOffset, value, valueSize, true);
            return;
        }
        DataIO.packLong(ba, (int)currSize, value);
        long newMasterLinkValue = (currSize + valueSize << 48) + chunkOffset;
        this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    private final byte[] longStackLoadChunk(long chunkOffset) {
        byte[] ba = (byte[])this.cacheStacks.get(chunkOffset);
        if (ba == null) {
            long prevLinkVal = DataIO.parity4Get(this.getVolume().getLong(chunkOffset));
            int pageSize = (int)(prevLinkVal >>> 48);
            ba = new byte[pageSize];
            this.getVolume().getData(chunkOffset, ba, 0, pageSize);
            this.cacheStacks.put(chunkOffset, (Object)ba);
        }
        if ((long)ba.length > 256L) {
            throw (Throwable)((Object)new AssertionError());
        }
        return ba;
    }

    /*
     * WARNING - void declaration
     */
    protected final void longStackNewChunk(long masterLinkOffset, long prevPageOffset, long value, long valueSize, boolean recursive) {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw (Throwable)new DBException.DataCorruption("wrong master link");
        }
        long newChunkSize = -1L;
        if (!recursive) {
            LongProgression longProgression = RangesKt.step((LongProgression)RangesKt.downTo((long)256L, (long)16L), (long)16L);
            long l = longProgression.getFirst();
            long l2 = longProgression.getLast();
            long l3 = longProgression.getStep();
            long l4 = l;
            long l5 = l2;
            if (l3 > 0L ? l4 <= l5 : l4 >= l5) {
                while (true) {
                    long indexVal;
                    void size2;
                    long masterLinkOffset2;
                    if (masterLinkOffset != (masterLinkOffset2 = this.longStackMasterLinkOffset((long)size2)) && (indexVal = DataIO.parity4Get(this.getHeadVol().getLong(masterLinkOffset2))) != 0L) {
                        newChunkSize = size2;
                        break;
                    }
                    if (size2 == l2) break;
                    size2 += l3;
                }
            }
        }
        long dataTail = this.getDataTail();
        long remainderSize = DataIO.roundUp(dataTail, 0x100000L) - dataTail;
        if (newChunkSize == -1L) {
            long dataTail2 = dataTail;
            if (dataTail2 == 0L) {
                newChunkSize = 160L;
            } else {
                long l = newChunkSize = remainderSize > 256L || remainderSize < 16L ? 160L : remainderSize;
            }
        }
        if (newChunkSize % (long)16 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        long newChunkOffset = this.allocateData((int)newChunkSize, true);
        byte[] ba = new byte[(int)newChunkSize];
        this.cacheStacks.put(newChunkOffset, (Object)ba);
        DataIO.putLong(ba, 0, DataIO.parity4Set((newChunkSize << 48) + prevPageOffset));
        DataIO.packLong(ba, 8, value);
        long newSize = (long)8 + valueSize;
        long newMasterLinkValue = (newSize << 48) + newChunkOffset;
        this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long longStackTake(long masterLinkOffset, boolean recursive) {
        long l;
        int pos;
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw (Throwable)new DBException.DataCorruption("wrong master link");
        }
        long masterLinkVal = DataIO.parity4Get(this.getHeadVol().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            return 0L;
        }
        long offset = masterLinkVal & 0xFFFFFFFFFFF0L;
        byte[] ba = this.longStackLoadChunk(offset);
        for (pos = (int)Math.max((masterLinkVal >>> 48) - 1L, 8L); pos > 8 && (ba[pos - 1] & 0x80) == 0; --pos) {
        }
        if ((long)pos < 8L) {
            throw (Throwable)new DBException.DataCorruption("position too small");
        }
        if (DataIO.getLong(ba, 0) >>> 48 <= (long)pos) {
            throw (Throwable)new DBException.DataCorruption("position beyond chunk " + masterLinkOffset);
        }
        long ret2 = DataIO.unpackLong(ba, pos);
        int n = pos;
        int n2 = pos + DataIO.packLongSize(ret2);
        while (n < n2) {
            void i;
            ba[i] = 0;
            ++i;
        }
        if ((long)pos > 8L) {
            this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set(((long)pos << 48) + offset));
            if (ret2 >> 48 != 0L) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (ret2 != 0L) {
                DataIO.parity1Get(ret2);
            }
            return ret2;
        }
        long prevChunkValue = DataIO.parity4Get(DataIO.getLong(ba, 0));
        DataIO.putLong(ba, 0, 0L);
        long currentSize = prevChunkValue >>> 48;
        long prevChunkOffset = prevChunkValue & 0xFFFFFFFFFFF0L;
        if (prevChunkOffset != 0L) {
            byte[] baPrev = this.longStackLoadChunk(prevChunkOffset);
            long pos2 = DataIO.parity4Get(DataIO.getLong(baPrev, 0)) >>> 48;
            l = this.longStackFindEnd(prevChunkOffset, pos2);
        } else {
            l = 0L;
        }
        long masterLinkPos = l;
        this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set((masterLinkPos << 48) + prevChunkOffset));
        this.releaseData(currentSize, offset, true);
        if (ret2 >> 48 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (ret2 != 0L) {
            DataIO.parity1Get(ret2);
        }
        return ret2;
    }

    protected final long longStackFindEnd(long pageOffset, long pos) {
        int pos2;
        byte[] ba = this.longStackLoadChunk(pageOffset);
        for (pos2 = (int)pos; pos2 > 8 && ba[pos2 - 1] == (byte)0; --pos2) {
        }
        return pos2;
    }

    @Override
    public boolean fileLoad() {
        return this.getVolume().fileLoad();
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        if (this.getFile() == null) {
            List<String> list = Arrays.asList(new String[0]);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList<String>()");
            return list;
        }
        ArrayList ret2 = CollectionsKt.arrayListOf((Object[])new String[]{this.getFile()});
        Collection collection = ret2;
        Iterable<String> iterable = this.wal.getAllFiles();
        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"wal.getAllFiles()");
        CollectionsKt.addAll((Collection)collection, iterable);
        return CollectionsKt.toList((Iterable)ret2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public StoreWAL(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDeleteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
        Lock lock$iv;
        LongLongHashMap longLongHashMap;
        LongLongHashMap[] longLongHashMapArray;
        int n;
        int i$iv;
        int size$iv;
        Intrinsics.checkParameterIsNotNull((Object)volumeFactory, (String)"volumeFactory");
        super(file, volumeFactory, isThreadSafe, concShift, fileDeleteAfterClose, checksum, checksumHeader, checksumHeaderBypass);
        Object object = ((Function0)new Function0<Volume>(volumeFactory, file, fileLockWait, allocateIncrement, allocateStartSize){
            final /* synthetic */ VolumeFactory $volumeFactory;
            final /* synthetic */ String $file;
            final /* synthetic */ long $fileLockWait;
            final /* synthetic */ long $allocateIncrement;
            final /* synthetic */ long $allocateStartSize;

            public final Volume invoke() {
                Volume volume2 = this.$volumeFactory.makeVolume(this.$file, false, this.$fileLockWait, Math.max(20, DataIO.shift((int)this.$allocateIncrement)), DataIO.roundUp(this.$allocateStartSize, 0x100000L), false);
                Intrinsics.checkExpressionValueIsNotNull((Object)volume2, (String)"volumeFactory.makeVolume\u2026          false\n        )");
                return volume2;
            }
            {
                this.$volumeFactory = volumeFactory;
                this.$file = string;
                this.$fileLockWait = l;
                this.$allocateIncrement = l2;
                this.$allocateStartSize = l3;
                super(0);
            }
        }).invoke();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"{\n        volumeFactory.\u2026  false\n        )\n    }()");
        this.realVolume = (Volume)object;
        this.volume = new ReadOnlyVolume(this.realVolume);
        this.headBytes = new byte[(int)32864L];
        this.headVol = new SingleByteArrayVol(this.headBytes);
        this.cacheStacks = new LongObjectHashMap();
        int n2 = this.getSegmentCount();
        StoreWAL storeWAL = this;
        LongLongHashMap[] result$iv = new LongLongHashMap[size$iv];
        int n3 = 0;
        int n4 = result$iv.length;
        while (n3 < n4) {
            void var20_20 = i$iv;
            n = i$iv++;
            longLongHashMapArray = result$iv;
            longLongHashMapArray[n] = longLongHashMap = new LongLongHashMap();
        }
        longLongHashMapArray = result$iv;
        storeWAL.cacheIndexVals = longLongHashMapArray;
        this.cacheIndexLinks = new LongLongHashMap();
        size$iv = this.getSegmentCount();
        storeWAL = this;
        result$iv = new LongLongHashMap[size$iv];
        i$iv = 0;
        n4 = result$iv.length;
        while (i$iv < n4) {
            int it = i$iv;
            n = i$iv++;
            longLongHashMapArray = result$iv;
            longLongHashMapArray[n] = longLongHashMap = new LongLongHashMap();
        }
        longLongHashMapArray = result$iv;
        storeWAL.cacheRecords = longLongHashMapArray;
        this.wal = new WriteAheadLog(file, volumeFactory, 0L, fileDeleteAfterOpen);
        this.indexPagesBackup = new long[0];
        this.allocatedPages = new LongArrayList();
        if (checksum) {
            throw (Throwable)new DBException.WrongConfiguration("StoreWAL does not support checksum yet");
        }
        Utils size$iv2 = Utils.INSTANCE;
        Lock lock = lock$iv = this.getStructuralLock();
        if (lock != null) {
            lock.lock();
        }
        try {
            if (!this.getVolumeExistsAtStart()) {
                this.realVolume.ensureAvailable(0x100000L);
                this.getHeadVol().putLong(0L, this.fileHeaderCompose());
                this.getHeadVol().putLong(8L, 1L);
                this.setDataTail(0L);
                this.setMaxRecid(0L);
                this.setFileTail$mapdb(0x100000L);
                LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)64L, (long)32864L)), (long)8L);
                long i$iv2 = longProgression.getFirst();
                long l = longProgression.getLast();
                long l2 = longProgression.getStep();
                long l3 = i$iv2;
                long l4 = l;
                if (l2 > 0L ? l3 <= l4 : l3 >= l4) {
                    while (true) {
                        void offset;
                        this.getHeadVol().putLong((long)offset, DataIO.parity4Set(0L));
                        if (offset == l) break;
                        offset += l2;
                    }
                }
                this.getHeadVol().putInt(16L, this.storeHeaderCompose());
                DataIO.putInt(this.headBytes, 20, this.calculateHeaderChecksum());
                this.realVolume.putLong(32864L, DataIO.parity16Set(0L));
                this.realVolume.putData(0L, this.headBytes, 0, this.headBytes.length);
                this.realVolume.sync();
            } else {
                if (this.getVolume().length() <= 0L) {
                    throw (Throwable)new DBException.DataCorruption("File is empty");
                }
                this.getVolume().getData(0L, this.headBytes, 0, this.headBytes.length);
                this.fileHeaderCheck();
                MutableLongList mutableLongList = this.getIndexPages();
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableLongList, (String)"indexPages");
                this.loadIndexPages(mutableLongList);
                long[] lArray = this.getIndexPages().toArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)lArray, (String)"indexPages.toArray()");
                this.indexPagesBackup = lArray;
            }
            if (file != null && fileDeleteAfterOpen) {
                new File(file).delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
    }

    static {
        TOMB1 = -1L;
    }

    @JvmStatic
    @NotNull
    public static final StoreWAL make(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDelteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
        return Companion.make(file, volumeFactory, fileLockWait, isThreadSafe, concShift, allocateIncrement, allocateStartSize, fileDeleteAfterClose, fileDelteAfterOpen, checksum, checksumHeader, checksumHeaderBypass);
    }

    protected static final long getTOMB1() {
        Companion companion = Companion;
        return TOMB1;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0082\u0001\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u0010H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/mapdb/StoreWAL$Companion;", "", "()V", "TOMB1", "", "TOMB1$annotations", "getTOMB1", "()J", "make", "Lorg/mapdb/StoreWAL;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "fileLockWait", "isThreadSafe", "", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDelteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "mapdb"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final StoreWAL make(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDelteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
            Intrinsics.checkParameterIsNotNull((Object)volumeFactory, (String)"volumeFactory");
            return new StoreWAL(file, volumeFactory, fileLockWait, isThreadSafe, concShift, allocateIncrement, allocateStartSize, fileDeleteAfterClose, fileDelteAfterOpen, checksum, checksumHeader, checksumHeaderBypass);
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ StoreWAL make$default(Companion companion, String string, VolumeFactory volumeFactory, long l, boolean bl, int n, long l2, long l3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                VolumeFactory volumeFactory2;
                if (string == null) {
                    VolumeFactory volumeFactory3 = CC.DEFAULT_MEMORY_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)volumeFactory3, (String)"CC.DEFAULT_MEMORY_VOLUME_FACTORY");
                } else {
                    VolumeFactory volumeFactory4 = CC.DEFAULT_FILE_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)volumeFactory4, (String)"CC.DEFAULT_FILE_VOLUME_FACTORY");
                }
                volumeFactory = volumeFactory2;
            }
            if ((n2 & 4) != 0) {
                l = 0L;
            }
            if ((n2 & 8) != 0) {
                bl = true;
            }
            if ((n2 & 0x10) != 0) {
                n = 3;
            }
            if ((n2 & 0x20) != 0) {
                l2 = 0x100000L;
            }
            if ((n2 & 0x40) != 0) {
                l3 = 0L;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = false;
            }
            if ((n2 & 0x100) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x200) != 0) {
                bl4 = false;
            }
            if ((n2 & 0x400) != 0) {
                bl5 = true;
            }
            if ((n2 & 0x800) != 0) {
                bl6 = false;
            }
            return companion.make(string, volumeFactory, l, bl, n, l2, l3, bl2, bl3, bl4, bl5, bl6);
        }

        @JvmStatic
        protected static /* synthetic */ void TOMB1$annotations() {
        }

        protected final long getTOMB1() {
            return TOMB1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

