/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientSessionOptions;
import com.mongodb.DB;
import com.mongodb.DBObjectCodec;
import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.ChangeStreamIterableImpl;
import com.mongodb.client.internal.Crypts;
import com.mongodb.client.internal.ListDatabasesIterableImpl;
import com.mongodb.client.internal.MongoClientDelegate;
import com.mongodb.client.internal.MongoDatabaseImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.internal.SimpleMongoClient;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.SocketStreamFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.event.ClusterListener;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.SingleServerBinding;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.DefaultClusterFactory;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.internal.thread.DaemonThreadFactory;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.CodecRegistryHelper;

public class MongoClient
implements Closeable {
    private final ConcurrentMap<String, DB> dbCache = new ConcurrentHashMap<String, DB>();
    private final MongoClientOptions options;
    private final MongoCredential credential;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();
    private final ConcurrentLinkedQueue<ServerCursorAndNamespace> orphanedCursors = new ConcurrentLinkedQueue();
    private final ExecutorService cursorCleaningService;
    private final MongoClientDelegate delegate;

    public static CodecRegistry getDefaultCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }

    public MongoClient() {
        this(new ServerAddress());
    }

    public MongoClient(String host) {
        this(ServerAddressHelper.createServerAddress((String)host));
    }

    public MongoClient(String host, MongoClientOptions options) {
        this(ServerAddressHelper.createServerAddress((String)host), options);
    }

    public MongoClient(String host, int port) {
        this(ServerAddressHelper.createServerAddress((String)host, (int)port));
    }

    public MongoClient(ServerAddress addr) {
        this(addr, MongoClientOptions.builder().build());
    }

    public MongoClient(ServerAddress addr, MongoClientOptions options) {
        this(MongoClient.createCluster(addr, null, options, null), options, null);
    }

    public MongoClient(ServerAddress addr, MongoCredential credential, MongoClientOptions options) {
        this(MongoClient.createCluster(addr, credential, options, null), options, credential);
    }

    public MongoClient(List<ServerAddress> seeds) {
        this(seeds, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, MongoClientOptions options) {
        this(MongoClient.createCluster(seeds, null, options, null), options, null);
    }

    public MongoClient(List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options) {
        this(MongoClient.createCluster(seeds, credential, options, null), options, credential);
    }

    public MongoClient(MongoClientURI uri) {
        this(MongoClient.createCluster(uri, null), uri.getOptions(), uri.getCredentials());
    }

    public MongoClient(MongoClientURI uri, MongoDriverInformation mongoDriverInformation) {
        this(MongoClient.createCluster(uri, mongoDriverInformation), uri.getOptions(), uri.getCredentials());
    }

    public MongoClient(ServerAddress addr, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        this(MongoClient.createCluster(addr, credential, options, mongoDriverInformation), options, credential);
    }

    public MongoClient(List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        this(MongoClient.createCluster(seeds, credential, options, mongoDriverInformation), options, credential);
    }

    MongoClient(Cluster cluster, MongoClientOptions options, @Nullable MongoCredential credential) {
        this.options = options;
        this.credential = credential;
        AutoEncryptionSettings autoEncryptionSettings = options.getAutoEncryptionSettings();
        this.delegate = new MongoClientDelegate(cluster, CodecRegistryHelper.createRegistry((CodecRegistry)options.getCodecRegistry(), (UuidRepresentation)options.getUuidRepresentation()), (Object)this, autoEncryptionSettings == null ? null : Crypts.createCrypt((SimpleMongoClient)this.asSimpleMongoClient(), (AutoEncryptionSettings)autoEncryptionSettings));
        this.cursorCleaningService = options.isCursorFinalizerEnabled() ? this.createCursorCleaningService() : null;
    }

    public MongoClientOptions getMongoClientOptions() {
        return this.options;
    }

    @Nullable
    public MongoCredential getCredential() {
        return this.credential;
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(Boolean.valueOf(true)).map((Function)new Function<BsonDocument, String>(){

            public String apply(BsonDocument result) {
                return result.getString((Object)"name").getValue();
            }
        });
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl(clientSession, clazz, this.delegate.getCodecRegistry(), ReadPreference.primary(), this.createOperationExecutor(), this.getMongoClientOptions().getRetryReads());
    }

    public MongoDatabase getDatabase(String databaseName) {
        MongoClientOptions clientOptions = this.getMongoClientOptions();
        return new MongoDatabaseImpl(databaseName, this.delegate.getCodecRegistry(), clientOptions.getReadPreference(), clientOptions.getWriteConcern(), clientOptions.getRetryWrites(), clientOptions.getRetryReads(), clientOptions.getReadConcern(), clientOptions.getUuidRepresentation(), this.createOperationExecutor());
    }

    public ClientSession startSession() {
        return this.startSession(ClientSessionOptions.builder().build());
    }

    public ClientSession startSession(ClientSessionOptions options) {
        ClientSession clientSession = this.createClientSession((ClientSessionOptions)Assertions.notNull((String)"options", (Object)options));
        if (clientSession == null) {
            throw new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected");
        }
        return clientSession;
    }

    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    public WriteConcern getWriteConcern() {
        return this.options.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.options.getReadConcern();
    }

    public ReadPreference getReadPreference() {
        return this.options.getReadPreference();
    }

    @Deprecated
    public DB getDB(String dbName) {
        DB db = (DB)this.dbCache.get(dbName);
        if (db != null) {
            return db;
        }
        db = new DB(this, dbName, this.createOperationExecutor());
        DB temp = this.dbCache.putIfAbsent(dbName, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public void dropDatabase(String dbName) {
        this.getDB(dbName).dropDatabase();
    }

    @Override
    public void close() {
        this.delegate.close();
        if (this.cursorCleaningService != null) {
            this.cursorCleaningService.shutdownNow();
        }
    }

    public String toString() {
        return "MongoClient{options=" + this.options + '}';
    }

    private static Cluster createCluster(MongoClientURI mongoURI, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClient.createCluster(MongoClient.getClusterSettings(ClusterSettings.builder().applyConnectionString(mongoURI.getProxied()), mongoURI.getOptions()), mongoURI.getCredentials(), mongoURI.getOptions(), mongoDriverInformation);
    }

    private static Cluster createCluster(List<ServerAddress> seedList, @Nullable MongoCredential credential, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClient.createCluster(MongoClient.getClusterSettings(seedList, options, ClusterConnectionMode.MULTIPLE), credential, options, mongoDriverInformation);
    }

    private static Cluster createCluster(ServerAddress serverAddress, @Nullable MongoCredential credential, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClient.createCluster(MongoClient.getClusterSettings(Collections.singletonList(serverAddress), options, MongoClient.getSingleServerClusterMode(options)), credential, options, mongoDriverInformation);
    }

    private static Cluster createCluster(ClusterSettings clusterSettings, @Nullable MongoCredential credential, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        return new DefaultClusterFactory().createCluster(clusterSettings, options.getServerSettings(), options.getConnectionPoolSettings(), (StreamFactory)new SocketStreamFactory(options.getSocketSettings(), options.getSslSettings()), (StreamFactory)new SocketStreamFactory(options.getHeartbeatSocketSettings(), options.getSslSettings()), credential, EventListenerHelper.getCommandListener(options.getCommandListeners()), options.getApplicationName(), MongoClient.wrapMongoDriverInformation(mongoDriverInformation), options.getCompressorList());
    }

    private static MongoDriverInformation wrapMongoDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        return (mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation)).driverName("legacy").build();
    }

    private static ClusterSettings getClusterSettings(ClusterSettings.Builder builder, MongoClientOptions options) {
        builder.requiredReplicaSetName(options.getRequiredReplicaSetName()).serverSelectionTimeout((long)options.getServerSelectionTimeout(), TimeUnit.MILLISECONDS).localThreshold((long)options.getLocalThreshold(), TimeUnit.MILLISECONDS).serverSelector(options.getServerSelector());
        for (ClusterListener clusterListener : options.getClusterListeners()) {
            builder.addClusterListener(clusterListener);
        }
        return builder.build();
    }

    private static ClusterSettings getClusterSettings(List<ServerAddress> seedList, MongoClientOptions options, ClusterConnectionMode clusterConnectionMode) {
        return MongoClient.getClusterSettings(ClusterSettings.builder().hosts(new ArrayList<ServerAddress>(seedList)).mode(clusterConnectionMode), options);
    }

    MongoClientDelegate getDelegate() {
        return this.delegate;
    }

    Cluster getCluster() {
        return this.delegate.getCluster();
    }

    CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    ServerSessionPool getServerSessionPool() {
        return this.delegate.getServerSessionPool();
    }

    BufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    void addOrphanedCursor(ServerCursor serverCursor, MongoNamespace namespace) {
        this.orphanedCursors.add(new ServerCursorAndNamespace(serverCursor, namespace));
    }

    OperationExecutor createOperationExecutor() {
        return this.delegate.getOperationExecutor();
    }

    @Nullable
    private ClientSession createClientSession(ClientSessionOptions clientSessionOptions) {
        return this.delegate.createClientSession(clientSessionOptions, this.options.getReadConcern(), this.options.getWriteConcern(), this.options.getReadPreference());
    }

    private ExecutorService createCursorCleaningService() {
        ScheduledExecutorService newTimer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("CleanCursors"));
        newTimer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MongoClient.this.cleanCursors();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        return newTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCursors() {
        ServerCursorAndNamespace cur;
        while ((cur = this.orphanedCursors.poll()) != null) {
            SingleServerBinding binding = new SingleServerBinding(this.delegate.getCluster(), cur.serverCursor.getAddress());
            try {
                ConnectionSource source = binding.getReadConnectionSource();
                try {
                    Connection connection = source.getConnection();
                    try {
                        connection.killCursor(cur.namespace, Collections.singletonList(cur.serverCursor.getId()));
                    }
                    finally {
                        connection.release();
                    }
                }
                finally {
                    source.release();
                }
            }
            finally {
                binding.release();
            }
        }
    }

    private static ClusterConnectionMode getSingleServerClusterMode(MongoClientOptions options) {
        if (options.getRequiredReplicaSetName() == null) {
            return ClusterConnectionMode.SINGLE;
        }
        return ClusterConnectionMode.MULTIPLE;
    }

    private SimpleMongoClient asSimpleMongoClient() {
        return new SimpleMongoClient(){

            public MongoDatabase getDatabase(String databaseName) {
                return MongoClient.this.getDatabase(databaseName);
            }

            public void close() {
                MongoClient.this.close();
            }
        };
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        MongoClientOptions clientOptions = this.getMongoClientOptions();
        return new ChangeStreamIterableImpl(clientSession, "admin", this.delegate.getCodecRegistry(), clientOptions.getReadPreference(), clientOptions.getReadConcern(), this.createOperationExecutor(), pipeline, resultClass, ChangeStreamLevel.CLIENT, clientOptions.getRetryReads());
    }

    static DBObjectCodec getCommandCodec() {
        return new DBObjectCodec(MongoClient.getDefaultCodecRegistry());
    }

    private static class ServerCursorAndNamespace {
        private final ServerCursor serverCursor;
        private final MongoNamespace namespace;

        ServerCursorAndNamespace(ServerCursor serverCursor, MongoNamespace namespace) {
            this.serverCursor = serverCursor;
            this.namespace = namespace;
        }
    }
}

