/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.filter.utils.FilterConfiguration;
import io.antmedia.plugin.FiltersManager;
import io.antmedia.plugin.MCUManager;
import io.antmedia.rest.model.Result;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
@Path(value="/v2/filters")
public class FilterRestService {
    @Context
    protected ServletContext servletContext;

    @ApiOperation(value="Creates or update the filter. If the filterId of the FilterConfiguration is already available, it just updates the configuration. Otherwise it creates the filter", notes="", response=Result.class)
    @POST
    @Path(value="/create")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result create(@ApiParam(value="Filter object with the updates") FilterConfiguration filterConfiguration) {
        ApplicationContext appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        AntMediaApplicationAdapter adaptor = (AntMediaApplicationAdapter)appCtx.getBean("web.handler");
        FiltersManager filtersManager = (FiltersManager)appCtx.getBean("filters.manager");
        return new Result(filtersManager.createFilter(filterConfiguration, adaptor));
    }

    @ApiOperation(value="Returns the list of filters effective in the application", notes="", response=Result.class)
    @GET
    @Path(value="/list/{offset}/{size}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<FilterConfiguration> getFilters(@ApiParam(value="This is the offset of the list, it is useful for pagination. If you want to use sort mechanism, we recommend using Mongo DB.", required=true) @PathParam(value="offset") int offset, @ApiParam(value="Number of items that will be fetched. If there is not enough item in the datastore, returned list size may less then this value", required=true) @PathParam(value="size") int size) {
        ApplicationContext appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        FiltersManager filtersManager = (FiltersManager)appCtx.getBean("filters.manager");
        return filtersManager.getfilters();
    }

    @ApiOperation(value="Delete the filter according to the filterId", notes="", response=Result.class)
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result delete(@ApiParam(value="Filter id for deleting filter") @PathParam(value="id") String id) {
        ApplicationContext appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        AntMediaApplicationAdapter adaptor = (AntMediaApplicationAdapter)appCtx.getBean("web.handler");
        FiltersManager filtersManager = (FiltersManager)appCtx.getBean("filters.manager");
        return new Result(filtersManager.delete(id, adaptor));
    }

    @ApiOperation(value="Set the plugin type of the MCU function. This type is in application specific not room specific", notes="", response=Result.class)
    @PUT
    @Path(value="/{id}/mcu-plugin-type")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result setPluginType(@ApiParam(value="Change the plugin type for a flter: synchronous | asynchronous (default) | lastpoint") @QueryParam(value="type") String type) {
        ApplicationContext appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        MCUManager mcuManager = (MCUManager)appCtx.getBean("filters.mcu");
        mcuManager.setPluginType(type);
        return new Result(true);
    }

    @ApiOperation(value="Set a filter specific to the MCU room. When this method is used, it always uses this filter. If you want to change to the default behaviour, you need to reset the MCU filter", notes="", response=Result.class)
    @PUT
    @Path(value="/mcu-filter")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result setCustomMCUFilter(@ApiParam(value="Filter object with the updates") FilterConfiguration filterConfiguration) {
        Result result = this.create(filterConfiguration);
        if (result.isSuccess()) {
            ApplicationContext appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            MCUManager mcuManager = (MCUManager)appCtx.getBean("filters.mcu");
            mcuManager.customFilterAdded(filterConfiguration.getFilterId());
        }
        return result;
    }

    @ApiOperation(value="Reset the default MCU filter", notes="", response=Result.class)
    @DELETE
    @Path(value="/mcu-filter/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result resetMCUFilter(@ApiParam(value="Filter object with the updates") @PathParam(value="id") String filterId) {
        ApplicationContext appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        MCUManager mcuManager = (MCUManager)appCtx.getBean("filters.mcu");
        return new Result(mcuManager.customFilterRemoved(filterId));
    }
}

