/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.plugin;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.filter.utils.FilterConfiguration;
import io.antmedia.filter.utils.MCUFilterTextGenerator;
import io.antmedia.plugin.FiltersManager;
import io.antmedia.plugin.api.IStreamListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="filters.mcu")
public class MCUManager
implements ApplicationContextAware,
IStreamListener {
    public static final String BEAN_NAME = "filters.mcu";
    private Queue<String> conferenceRoomsUpdated = new ConcurrentLinkedQueue<String>();
    public static final long CONFERENCE_INFO_POLL_PERIOD_MS = 5000L;
    private long roomUpdateTimer = -1L;
    private ApplicationContext applicationContext;
    private AntMediaApplicationAdapter appAdaptor;
    private FiltersManager filtersManager;
    private String pluginType = "asynchronous";
    private static Logger logger = LoggerFactory.getLogger(MCUManager.class);
    private Queue<String> roomsHasCustomFilters = new ConcurrentLinkedQueue<String>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        AntMediaApplicationAdapter app = this.getApplication();
        app.addStreamListener((IStreamListener)this);
        this.roomUpdateTimer = this.getApplication().getVertx().setPeriodic(5000L, t -> {
            Iterator iterator = this.conferenceRoomsUpdated.iterator();
            while (iterator.hasNext()) {
                this.updateRoomFilter((String)iterator.next());
                iterator.remove();
            }
        });
    }

    public void customFilterAdded(String roomId) {
        if (!this.roomsHasCustomFilters.contains(roomId)) {
            this.roomsHasCustomFilters.add(roomId);
        }
    }

    public boolean customFilterRemoved(String roomId) {
        this.roomsHasCustomFilters.remove(roomId);
        return this.updateRoomFilter(roomId);
    }

    public AntMediaApplicationAdapter getApplication() {
        if (this.appAdaptor == null) {
            this.appAdaptor = (AntMediaApplicationAdapter)this.applicationContext.getBean("web.handler");
        }
        return this.appAdaptor;
    }

    public FiltersManager getFiltersManager() {
        if (this.filtersManager == null) {
            this.filtersManager = (FiltersManager)this.applicationContext.getBean("filters.manager");
        }
        return this.filtersManager;
    }

    private synchronized boolean updateRoomFilter(String roomId) {
        DataStore datastore = this.getApplication().getDataStore();
        ConferenceRoom room = datastore.getConferenceRoom(roomId);
        boolean result = false;
        if (room == null) {
            result = this.getFiltersManager().delete(roomId, this.getApplication());
        } else if (!this.roomsHasCustomFilters.contains(roomId)) {
            try {
                ArrayList<String> streams = new ArrayList<String>();
                streams.addAll(room.getRoomStreamList());
                for (String streamId : room.getRoomStreamList()) {
                    Broadcast broadcast = datastore.get(streamId);
                    if (broadcast != null && broadcast.getStatus().equals("broadcasting")) continue;
                    streams.remove(streamId);
                }
                if (!streams.isEmpty()) {
                    FilterConfiguration filterConfiguration = new FilterConfiguration();
                    filterConfiguration.setFilterId(roomId);
                    filterConfiguration.setInputStreams(streams);
                    ArrayList<String> outputStreams = new ArrayList<String>();
                    outputStreams.add(roomId);
                    filterConfiguration.setOutputStreams(outputStreams);
                    filterConfiguration.setVideoFilter(MCUFilterTextGenerator.createVideoFilter(streams.size()));
                    filterConfiguration.setAudioFilter(MCUFilterTextGenerator.createAudioFilter(streams.size()));
                    filterConfiguration.setVideoEnabled(!room.getMode().equals("amcu"));
                    filterConfiguration.setAudioEnabled(true);
                    filterConfiguration.setType(this.pluginType);
                    result = this.getFiltersManager().createFilter(filterConfiguration, this.getApplication());
                } else {
                    result = this.getFiltersManager().delete(roomId, this.getApplication());
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    private void roomHasChange(String roomId) {
        DataStore datastore = this.getApplication().getDataStore();
        ConferenceRoom room = datastore.getConferenceRoom(roomId);
        if ((room == null || room.getMode().equals("mcu") || room.getMode().equals("amcu")) && !this.conferenceRoomsUpdated.contains(roomId)) {
            this.conferenceRoomsUpdated.add(roomId);
        }
    }

    public void joinedTheRoom(String roomId, String streamId) {
        this.triggerUpdate(roomId);
    }

    private void triggerUpdate(String roomId) {
        this.roomHasChange(roomId);
        this.getApplication().getVertx().setTimer(5000L, id -> this.roomHasChange(roomId));
    }

    public void leftTheRoom(String roomId, String streamId) {
        this.triggerUpdate(roomId);
    }

    public void streamStarted(String streamId) {
    }

    public void streamFinished(String streamId) {
    }

    public void setPluginType(String type) {
        this.pluginType = type;
    }
}

