/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.plugin;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.filter.FilterAdaptor;
import io.antmedia.filter.utils.FilterConfiguration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="filters.manager")
public class FiltersManager {
    public static final String BEAN_NAME = "filters.manager";
    private Map<String, FilterAdaptor> filterList = new LinkedHashMap<String, FilterAdaptor>();

    public boolean createFilter(FilterConfiguration filterConfiguration, AntMediaApplicationAdapter appAdaptor) {
        boolean decodeStreams = appAdaptor.getAppSettings().getEncoderSettings().isEmpty();
        String filter = filterConfiguration.getFilterId();
        FilterAdaptor filterAdaptor = this.filterList.get(filter);
        if (filterAdaptor == null) {
            filterAdaptor = new FilterAdaptor(decodeStreams);
            this.filterList.put(filter, filterAdaptor);
        }
        return filterAdaptor.createFilter(filterConfiguration, appAdaptor);
    }

    public List<FilterConfiguration> getfilters() {
        ArrayList<FilterConfiguration> filters = new ArrayList<FilterConfiguration>();
        for (FilterAdaptor filterAdaptor : this.filterList.values()) {
            filters.add(filterAdaptor.getCurrentFilterConfiguration());
        }
        return filters;
    }

    public boolean delete(String id, AntMediaApplicationAdapter app) {
        FilterAdaptor filterAdaptor = this.filterList.get(id);
        if (filterAdaptor != null) {
            this.filterList.remove(id);
            return filterAdaptor.close(app);
        }
        return false;
    }
}

