/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCUFilterTextGenerator {
    private static Logger logger = LoggerFactory.getLogger(MCUFilterTextGenerator.class);

    public static String createAudioFilter(int streamCount) {
        if (streamCount == 1) {
            return "[in0]acopy[out0]";
        }
        Object filter = "";
        for (int i = 0; i < streamCount; ++i) {
            filter = (String)filter + "[in" + i + "]";
        }
        filter = (String)filter + "amix=inputs=" + streamCount + "[out0]";
        return filter;
    }

    public static String createVideoFilter(int streamCount) {
        int i;
        int width = 360;
        int height = 240;
        String color = "black";
        int margin = 3;
        if (streamCount == 1) {
            return "[in0]scale=" + width + ":" + height + ":force_original_aspect_ratio=decrease,pad=720:480:(ow-iw)/2:(oh-ih)/2:color=" + color + "[out0]";
        }
        Object filter = "";
        int columns = (int)Math.ceil(Math.sqrt(streamCount));
        int rows = (int)Math.ceil((double)streamCount / (double)columns);
        int lastRowColumns = streamCount - (rows - 1) * columns;
        width = Math.min(360, 720 / columns);
        height = 240 * width / 360;
        for (int i2 = 0; i2 < streamCount; ++i2) {
            filter = (String)filter + "[in" + i2 + "]scale=" + (width - 2 * margin) + ":" + (height - 2 * margin) + ":force_original_aspect_ratio=decrease";
            filter = (String)filter + ",pad=" + width + ":" + height + ":" + margin + ":" + margin + ":color=" + color;
            filter = (String)filter + "[s" + i2 + "];";
        }
        int total = 0;
        int iterateRowsCount = lastRowColumns == 1 ? rows - 1 : rows;
        for (i = 0; i < iterateRowsCount; ++i) {
            int j = 0;
            for (j = 0; j < columns && total < streamCount; ++total, ++j) {
                filter = (String)filter + "[s" + total + "]";
            }
            Object outLabel = rows == 1 ? ",pad=720:480:(ow-iw)/2:(oh-ih)/2[out0]" : "[l" + i + "];";
            filter = (String)filter + "hstack=inputs=" + j + (String)outLabel;
        }
        if (rows > 1) {
            if (lastRowColumns < columns) {
                String lastLowLabel = lastRowColumns == 1 ? "[s" + total + "]" : "[l" + (rows - 1) + "]";
                filter = (String)filter + lastLowLabel + "pad=" + width * columns + ":" + height + ":" + width * (columns - lastRowColumns) / 2 + "[l" + (rows - 1) + "];";
            }
            for (i = 0; i < rows; ++i) {
                filter = (String)filter + "[l" + i + "]";
            }
            filter = (String)filter + "vstack=inputs=" + rows + ",pad=720:480:(ow-iw)/2:(oh-ih)/2[out0]";
        }
        logger.info("generated filter:{}", filter);
        return filter;
    }
}

