/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter.utils;

import io.antmedia.filter.utils.Filter;
import io.antmedia.filter.utils.IFilteredFrameListener;
import java.util.Map;
import org.bytedeco.ffmpeg.avfilter.AVFilterContext;
import org.bytedeco.ffmpeg.avfilter.AVFilterGraph;
import org.bytedeco.ffmpeg.avfilter.AVFilterInOut;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.global.avfilter;
import org.bytedeco.ffmpeg.global.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterGraph {
    private static final Logger logger = LoggerFactory.getLogger(FilterGraph.class);
    AVFilterInOut listOfOutputs;
    AVFilterInOut listOfInputs;
    Map<String, Filter> sourceFiltersMap;
    Map<String, Filter> sinkFiltersMap;
    AVFilterGraph filterGraph = new AVFilterGraph();
    AVFrame filterOutputFrame = new AVFrame();
    private Object lock = new Object();
    private boolean initiated = false;
    private IFilteredFrameListener listener;
    private int count;
    private long currentPts = 0L;

    public FilterGraph(String filterDescription, Map<String, Filter> sourceFiltersMap, Map<String, Filter> sinkFiltersMap) {
        this.sourceFiltersMap = sourceFiltersMap;
        this.sinkFiltersMap = sinkFiltersMap;
        this.filterOutputFrame = avutil.av_frame_alloc();
        this.filterGraph = avfilter.avfilter_graph_alloc();
        Filter prev = null;
        for (Filter source : sourceFiltersMap.values()) {
            source.initFilterContex(this.filterGraph);
            if (prev == null) {
                this.listOfOutputs = source.getFilterInOut();
            } else {
                prev.getFilterInOut().next(source.getFilterInOut());
            }
            prev = source;
        }
        prev = null;
        for (Filter sink : this.sinkFiltersMap.values()) {
            sink.initFilterContex(this.filterGraph);
            if (prev == null) {
                this.listOfInputs = sink.getFilterInOut();
            } else {
                prev.getFilterInOut().next(sink.getFilterInOut());
            }
            prev = sink;
        }
        if (avfilter.avfilter_graph_parse((AVFilterGraph)this.filterGraph, (String)filterDescription, (AVFilterInOut)this.listOfInputs, (AVFilterInOut)this.listOfOutputs, null) < 0) {
            logger.error("error avfilter_graph_parse");
            return;
        }
        if (avfilter.avfilter_graph_config((AVFilterGraph)this.filterGraph, null) < 0) {
            logger.error("error avfilter_graph_config");
            return;
        }
        this.setInitiated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(String streamId, AVFrame frame) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isInitiated()) {
                return;
            }
            Filter sourceFilter = this.sourceFiltersMap.get(streamId);
            if (sourceFilter == null) {
                return;
            }
            if (sourceFilter.isFirstFrame) {
                sourceFilter.offset = this.currentPts - frame.pts();
                sourceFilter.isFirstFrame = false;
            }
            long allignedPts = frame.pts() + sourceFilter.offset;
            frame.pts(allignedPts);
            this.currentPts = Math.max(allignedPts, this.currentPts);
            int ret = avfilter.av_buffersrc_add_frame((AVFilterContext)this.sourceFiltersMap.get((Object)streamId).filterContext, (AVFrame)frame);
            if (ret < 0) {
                logger.error("Error while feeding the filtergraph " + ret);
                return;
            }
            for (String outStreamId : this.sinkFiltersMap.keySet()) {
                while ((ret = avfilter.av_buffersink_get_frame((AVFilterContext)this.sinkFiltersMap.get((Object)outStreamId).filterContext, (AVFrame)this.filterOutputFrame)) >= 0) {
                    this.listener.onFilteredFrame(outStreamId, this.filterOutputFrame);
                    avutil.av_frame_unref((AVFrame)this.filterOutputFrame);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AVFrame doFilterSync(String streamId, AVFrame frame) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isInitiated()) {
                return null;
            }
            Filter sourceFilter = this.sourceFiltersMap.get(streamId);
            if (sourceFilter == null) {
                return null;
            }
            if (sourceFilter.isFirstFrame) {
                sourceFilter.offset = this.currentPts - frame.pts();
                sourceFilter.isFirstFrame = false;
            }
            long allignedPts = frame.pts() + sourceFilter.offset;
            frame.pts(allignedPts);
            this.currentPts = Math.max(allignedPts, this.currentPts);
            int ret = avfilter.av_buffersrc_add_frame((AVFilterContext)this.sourceFiltersMap.get((Object)streamId).filterContext, (AVFrame)frame);
            if (ret < 0) {
                logger.error("Error while feeding the filtergraph " + ret);
                return null;
            }
            for (String outStreamId : this.sinkFiltersMap.keySet()) {
                ret = avfilter.av_buffersink_get_frame((AVFilterContext)this.sinkFiltersMap.get((Object)outStreamId).filterContext, (AVFrame)this.filterOutputFrame);
                if (ret < 0) continue;
                if (streamId.equals(outStreamId)) {
                    return this.filterOutputFrame;
                }
                return null;
            }
        }
        return null;
    }

    public void setListener(IFilteredFrameListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.setInitiated(false);
            avfilter.avfilter_graph_free((AVFilterGraph)this.filterGraph);
            this.filterGraph = null;
            avutil.av_frame_free((AVFrame)this.filterOutputFrame);
            this.filterOutputFrame = null;
            this.sourceFiltersMap.clear();
            this.sinkFiltersMap.clear();
        }
    }

    public long getCurrentPts() {
        return this.currentPts;
    }

    public void setCurrentPts(long currentPts) {
        this.currentPts = currentPts;
    }

    public boolean isInitiated() {
        return this.initiated;
    }

    public void setInitiated(boolean initiated) {
        this.initiated = initiated;
    }
}

