/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter.utils;

import java.util.ArrayList;
import org.bytedeco.ffmpeg.avfilter.AVFilter;
import org.bytedeco.ffmpeg.avfilter.AVFilterContext;
import org.bytedeco.ffmpeg.avfilter.AVFilterGraph;
import org.bytedeco.ffmpeg.avfilter.AVFilterInOut;
import org.bytedeco.ffmpeg.global.avfilter;
import org.bytedeco.javacpp.BytePointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filter {
    private static final Logger logger = LoggerFactory.getLogger(Filter.class);
    AVFilterContext filterContext = new AVFilterContext();
    AVFilterInOut filterInOut;
    AVFilter filterBuffer;
    String label;
    private String filterArgs;
    private String filterName;
    private BytePointer labelPointer;
    public long offset = 0L;
    public boolean isFirstFrame = true;
    public static ArrayList<BytePointer> labels = new ArrayList();

    public Filter(String filterName, String filterArgs, String label) {
        this.filterName = filterName;
        this.label = label;
        this.filterArgs = filterArgs;
        this.labelPointer = new BytePointer(label);
        labels.add(this.labelPointer);
    }

    public void initFilterContex(AVFilterGraph filterGraph) {
        this.filterBuffer = avfilter.avfilter_get_by_name((String)this.filterName);
        int ret = avfilter.avfilter_graph_create_filter((AVFilterContext)this.filterContext, (AVFilter)this.filterBuffer, (String)this.label, (String)this.filterArgs, null, (AVFilterGraph)filterGraph);
        if (ret < 0) {
            logger.error("Cannot create buffer source");
        }
    }

    public AVFilterInOut getFilterInOut() {
        if (this.filterInOut == null) {
            this.filterInOut = avfilter.avfilter_inout_alloc();
            this.filterInOut.name(this.labelPointer);
            this.filterInOut.filter_ctx(this.filterContext);
            this.filterInOut.pad_idx(0);
            this.filterInOut.next(null);
        }
        return this.filterInOut;
    }
}

