/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.SystemUtils;
import io.antmedia.plugin.api.StreamParametersInfo;
import io.antmedia.statistic.GPUUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.presets.avcodec;
import org.bytedeco.javacpp.BytePointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoDecoder {
    static Logger logger = LoggerFactory.getLogger(VideoDecoder.class);
    private AVCodecContext videoContext;
    private String streamId;
    private AVFrame decodedFrame;
    private AVRational videoEncoderTimebase;
    private StreamParametersInfo streamParameters;
    private boolean initialized = false;

    public VideoDecoder(String streamId, StreamParametersInfo streamParameters) {
        this.streamId = streamId;
        this.streamParameters = streamParameters;
        this.videoEncoderTimebase = new AVRational();
        this.videoEncoderTimebase.num(1);
        this.videoEncoderTimebase.den(20);
        this.decodedFrame = avutil.av_frame_alloc();
        if (this.decodedFrame == null) {
            throw new IllegalArgumentException("av_frame_alloc() error: Could not allocate raw picture frame.");
        }
        String encoderName = null;
        AVCodec codec = null;
        if (GPUUtils.getInstance().getDeviceCount() > 0 && streamParameters.codecParameters.codec_id() == 27) {
            if (SystemUtils.OS_TYPE == 1 || SystemUtils.OS_TYPE == 2) {
                encoderName = "h264_cuvid";
            } else if (SystemUtils.OS_TYPE == 0) {
                // empty if block
            }
        }
        boolean result = false;
        if (encoderName != null) {
            codec = org.bytedeco.ffmpeg.global.avcodec.avcodec_find_decoder_by_name(encoderName);
            result = this.openDecoder(codec, streamParameters.codecParameters);
        }
        if (!result) {
            if (codec != null) {
                codec.close();
                codec = null;
            }
            codec = org.bytedeco.ffmpeg.global.avcodec.avcodec_find_decoder((int)streamParameters.codecParameters.codec_id());
            result = this.openDecoder(codec, streamParameters.codecParameters);
        }
        BytePointer name = codec.name();
        logger.info("video decoder name: {} video context timebase:{}/{} wxh:{}x{}", new Object[]{name.getString(), this.videoContext.time_base().num(), this.videoContext.time_base().den(), this.videoContext.width(), this.videoContext.height()});
        codec.close();
        this.initialized = result;
        if (!this.initialized) {
            this.release();
        }
    }

    public boolean openDecoder(AVCodec codec, AVCodecParameters par) {
        this.videoContext = org.bytedeco.ffmpeg.global.avcodec.avcodec_alloc_context3((AVCodec)codec);
        if (this.videoContext == null) {
            logger.warn("cannot allocate video context : {} ", (Object)codec.name().getString());
            return false;
        }
        if (org.bytedeco.ffmpeg.global.avcodec.avcodec_parameters_to_context((AVCodecContext)this.videoContext, (AVCodecParameters)par) < 0) {
            logger.warn("cannot copy context parameters: {} ", (Object)codec.name().getString());
            org.bytedeco.ffmpeg.global.avcodec.avcodec_free_context((AVCodecContext)this.videoContext);
            return false;
        }
        this.videoContext.thread_count(6);
        int ret = org.bytedeco.ffmpeg.global.avcodec.avcodec_open2((AVCodecContext)this.videoContext, (AVCodec)codec, (AVDictionary)null);
        if (ret < 0) {
            if (logger.isErrorEnabled()) {
                byte[] data = new byte[2048];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.error(" Opening decoder error: {}", (Object)new String(data, 0, data.length));
            }
            org.bytedeco.ffmpeg.global.avcodec.avcodec_free_context((AVCodecContext)this.videoContext);
            return false;
        }
        return true;
    }

    public AVFrame decodeVideoPacket(AVPacket pkt) {
        org.bytedeco.ffmpeg.global.avcodec.av_packet_rescale_ts((AVPacket)pkt, (AVRational)this.videoEncoderTimebase, (AVRational)this.streamParameters.timeBase);
        int ret = org.bytedeco.ffmpeg.global.avcodec.avcodec_send_packet((AVCodecContext)this.videoContext, (AVPacket)pkt);
        if (ret < 0) {
            logger.error("Cannot send video packet for decoding for stream: {}", (Object)this.streamId);
        }
        if ((ret = org.bytedeco.ffmpeg.global.avcodec.avcodec_receive_frame((AVCodecContext)this.videoContext, (AVFrame)this.decodedFrame)) == org.bytedeco.ffmpeg.presets.avutil.AVERROR_EAGAIN() || ret == avutil.AVERROR_EOF()) {
            return null;
        }
        if (ret < 0) {
            byte[] data = new byte[2048];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            logger.error("Decode video frame error: {}", (Object)new String(data, 0, data.length));
            return null;
        }
        return this.decodedFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<avcodec> clazz = avcodec.class;
        synchronized (avcodec.class) {
            this.releaseUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void releaseUnsafe() {
        if (this.decodedFrame != null) {
            avutil.av_frame_free((AVFrame)this.decodedFrame);
            this.decodedFrame.close();
            this.decodedFrame = null;
        }
        if (this.videoContext != null) {
            org.bytedeco.ffmpeg.global.avcodec.avcodec_free_context((AVCodecContext)this.videoContext);
            this.videoContext.close();
            this.videoContext = null;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

