/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.filter.VideoDecoder;
import io.antmedia.filter.utils.Filter;
import io.antmedia.filter.utils.FilterConfiguration;
import io.antmedia.filter.utils.FilterGraph;
import io.antmedia.plugin.api.IFrameListener;
import io.antmedia.plugin.api.IPacketListener;
import io.antmedia.plugin.api.StreamParametersInfo;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.global.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterAdaptor
implements IFrameListener,
IPacketListener {
    private FilterGraph videoFilterGraph = null;
    private FilterGraph audioFilterGraph = null;
    List<String> currentInStreams = new ArrayList<String>();
    Map<String, IFrameListener> currentOutStreams = new LinkedHashMap<String, IFrameListener>();
    private Map<String, StreamParametersInfo> videoStreamParamsMap = new LinkedHashMap<String, StreamParametersInfo>();
    private Map<String, StreamParametersInfo> audioStreamParamsMap = new LinkedHashMap<String, StreamParametersInfo>();
    private FilterConfiguration filterConfiguration;
    private Vertx vertx;
    private static final Logger logger = LoggerFactory.getLogger(FilterAdaptor.class);
    private Map<String, VideoDecoder> videoDecodersMap = new LinkedHashMap<String, VideoDecoder>();
    private static final int WIDTH = 720;
    private static final int HEIGHT = 480;
    private boolean selfDecodeStreams = true;

    public FilterAdaptor(boolean selfDecodeVideo) {
        this.selfDecodeStreams = selfDecodeVideo;
    }

    public AVFrame onAudioFrame(String streamId, AVFrame audioFrame) {
        if (this.audioFilterGraph == null || !this.audioFilterGraph.isInitiated()) {
            return audioFrame;
        }
        AVFrame filterOutputFrame = null;
        if (this.filterConfiguration.getType().equals("asynchronous")) {
            AVFrame filterInputframe = avutil.av_frame_clone((AVFrame)audioFrame);
            this.audioFilterGraph.doFilter(streamId, filterInputframe);
            filterOutputFrame = audioFrame;
            avutil.av_frame_free((AVFrame)filterInputframe);
        } else if (this.filterConfiguration.getType().equals("lastpoint")) {
            AVFrame filterInputframe = audioFrame;
            this.audioFilterGraph.doFilter(streamId, filterInputframe);
            filterOutputFrame = null;
        } else if (this.filterConfiguration.getType().equals("synchronous")) {
            AVFrame filterInputframe = audioFrame;
            filterOutputFrame = this.audioFilterGraph.doFilterSync(streamId, filterInputframe);
        }
        return filterOutputFrame;
    }

    public AVFrame onVideoFrame(String streamId, AVFrame videoFrame) {
        AVFrame filterInputframe;
        if (this.videoFilterGraph == null || !this.videoFilterGraph.isInitiated()) {
            return videoFrame;
        }
        AVFrame filterOutputFrame = null;
        if (this.filterConfiguration.getType().equals("asynchronous")) {
            AVFrame filterInputframe2 = avutil.av_frame_clone((AVFrame)videoFrame);
            this.videoFilterGraph.doFilter(streamId, filterInputframe2);
            filterOutputFrame = videoFrame;
            avutil.av_frame_free((AVFrame)filterInputframe2);
        } else if (this.filterConfiguration.getType().equals("lastpoint")) {
            AVFrame filterInputframe3 = videoFrame;
            filterOutputFrame = null;
            this.videoFilterGraph.doFilter(streamId, filterInputframe3);
        } else if (this.filterConfiguration.getType().equals("synchronous") && (filterOutputFrame = this.videoFilterGraph.doFilterSync(streamId, filterInputframe = videoFrame)).width() == 0) {
            filterOutputFrame = null;
        }
        return filterOutputFrame;
    }

    public void writeTrailer(String streamId) {
    }

    public synchronized void setVideoStreamInfo(String streamId, StreamParametersInfo videoStreamInfo) {
        VideoDecoder decoder;
        this.videoStreamParamsMap.put(streamId, videoStreamInfo);
        if (this.selfDecodeStreams && (decoder = new VideoDecoder(streamId, videoStreamInfo)).isInitialized()) {
            this.videoDecodersMap.put(streamId, decoder);
        }
    }

    public void setAudioStreamInfo(String streamId, StreamParametersInfo audioStreamInfo) {
        this.audioStreamParamsMap.put(streamId, audioStreamInfo);
    }

    public void start() {
    }

    public boolean update() {
        LinkedHashMap<String, Filter> videoSourceFiltersMap = new LinkedHashMap<String, Filter>();
        LinkedHashMap<String, Filter> videoSinkFiltersMap = new LinkedHashMap<String, Filter>();
        LinkedHashMap<String, Filter> audioSourceFiltersMap = new LinkedHashMap<String, Filter>();
        LinkedHashMap<String, Filter> audioSinkFiltersMap = new LinkedHashMap<String, Filter>();
        int i = 0;
        for (String string : this.currentInStreams) {
            StreamParametersInfo videoStreamParams = this.videoStreamParamsMap.get(string);
            Object videoFilterArgs = "video_size=" + videoStreamParams.codecParameters.width() + "x" + videoStreamParams.codecParameters.height() + ":pix_fmt=" + videoStreamParams.codecParameters.format() + ":time_base=" + videoStreamParams.timeBase.num() + "/" + videoStreamParams.timeBase.den() + ":pixel_aspect=1/1";
            if (!videoStreamParams.enabled) {
                videoFilterArgs = "video_size=360x360:pix_fmt=0:time_base=1/20:pixel_aspect=1/1";
            }
            videoSourceFiltersMap.put(string, new Filter("buffer", (String)videoFilterArgs, "in" + i));
            StreamParametersInfo audioStreamParams = this.audioStreamParamsMap.get(string);
            String audioFilterArgs = "channel_layout=" + audioStreamParams.codecParameters.channel_layout() + ":sample_fmt=" + audioStreamParams.codecParameters.format() + ":time_base=1/" + audioStreamParams.timeBase.num() + "/" + audioStreamParams.timeBase.den() + ":sample_rate=" + audioStreamParams.codecParameters.sample_rate();
            audioSourceFiltersMap.put(string, new Filter("abuffer", audioFilterArgs, "in" + i));
            ++i;
        }
        FilterGraph prevVideoFilterGraph = this.videoFilterGraph;
        i = 0;
        for (String streamId3 : this.currentOutStreams.keySet()) {
            videoSinkFiltersMap.put(streamId3, new Filter("buffersink", null, "out" + i));
            audioSinkFiltersMap.put(streamId3, new Filter("abuffersink", null, "out" + i));
        }
        long l = 0L;
        if (this.videoFilterGraph != null) {
            l = this.videoFilterGraph.getCurrentPts();
        }
        this.videoFilterGraph = new FilterGraph(this.filterConfiguration.getVideoFilter(), videoSourceFiltersMap, videoSinkFiltersMap);
        if (!this.videoFilterGraph.isInitiated()) {
            logger.error("Video filter graph can not be initiated: {}", (Object)this.filterConfiguration.getVideoFilter());
            return false;
        }
        this.videoFilterGraph.setCurrentPts(l);
        this.videoFilterGraph.setListener((streamId, frame) -> {
            IFrameListener frameListener;
            if (frame != null && this.currentOutStreams.containsKey(streamId) && (frameListener = this.currentOutStreams.get(streamId)) != null) {
                frameListener.onVideoFrame(streamId, frame);
            }
        });
        if (prevVideoFilterGraph != null) {
            prevVideoFilterGraph.close();
        }
        FilterGraph prevAudioFilterGraph = this.audioFilterGraph;
        long currentAudioPts = 0L;
        if (this.audioFilterGraph != null) {
            currentAudioPts = this.audioFilterGraph.getCurrentPts();
        }
        this.audioFilterGraph = new FilterGraph(this.filterConfiguration.getAudioFilter(), audioSourceFiltersMap, audioSinkFiltersMap);
        if (!this.audioFilterGraph.isInitiated()) {
            logger.error("Audio filter graph can not be initiated:{}", (Object)this.filterConfiguration.getAudioFilter());
            return false;
        }
        this.audioFilterGraph.setCurrentPts(currentAudioPts);
        this.audioFilterGraph.setListener((streamId, frame) -> {
            IFrameListener frameListener;
            if (frame != null && this.currentOutStreams.containsKey(streamId) && (frameListener = this.currentOutStreams.get(streamId)) != null) {
                frameListener.onAudioFrame(streamId, frame);
            }
        });
        if (prevAudioFilterGraph != null) {
            prevAudioFilterGraph.close();
        }
        return true;
    }

    public synchronized boolean createFilter(FilterConfiguration filterConfiguration, AntMediaApplicationAdapter app) {
        boolean noChange;
        if (this.vertx == null) {
            this.vertx = app.getVertx();
        }
        this.filterConfiguration = filterConfiguration;
        for (String streamId : filterConfiguration.getOutputStreams()) {
            if (this.currentOutStreams.containsKey(streamId)) continue;
            if (filterConfiguration.getInputStreams().contains(streamId)) {
                this.currentOutStreams.put(streamId, null);
                continue;
            }
            IFrameListener broadcast = app.createCustomBroadcast(streamId);
            this.startBroadcast(streamId, broadcast, filterConfiguration.isVideoEnabled(), filterConfiguration.isAudioEnabled());
            this.currentOutStreams.put(streamId, broadcast);
        }
        List<String> inserted = filterConfiguration.getInputStreams();
        ArrayList<String> removed = new ArrayList<String>();
        for (String streamId : this.currentInStreams) {
            if (filterConfiguration.getInputStreams().contains(streamId)) {
                inserted.remove(streamId);
                continue;
            }
            removed.add(streamId);
        }
        boolean bl = noChange = inserted.isEmpty() && removed.isEmpty();
        if (!noChange) {
            for (String streamId : removed) {
                app.removeFrameListener(streamId, (IFrameListener)this);
                this.currentInStreams.remove(streamId);
            }
            for (String streamId : inserted) {
                if (this.selfDecodeStreams) {
                    app.addPacketListener(streamId, (IPacketListener)this);
                } else {
                    app.addFrameListener(streamId, (IFrameListener)this);
                }
                this.currentInStreams.add(streamId);
            }
            filterConfiguration.setInputStreams(this.currentInStreams);
        }
        return this.update();
    }

    private void startBroadcast(String streamId, IFrameListener broadcast, boolean videoEnabled, boolean audioEnabled) {
        AVCodecParameters videoCodecParameters = new AVCodecParameters();
        videoCodecParameters.width(720);
        videoCodecParameters.height(480);
        videoCodecParameters.codec_id(27);
        videoCodecParameters.codec_type(0);
        videoCodecParameters.format(0);
        videoCodecParameters.codec_tag(0);
        AVCodecParameters audioCodecParameters = new AVCodecParameters();
        audioCodecParameters.codec_id(86018);
        audioCodecParameters.codec_type(1);
        audioCodecParameters.format(8);
        audioCodecParameters.sample_rate(44100);
        audioCodecParameters.channels(1);
        audioCodecParameters.channel_layout(4L);
        audioCodecParameters.codec_tag(0);
        StreamParametersInfo videoStreamParametersInfo = new StreamParametersInfo();
        StreamParametersInfo audioStreamParametersInfo = new StreamParametersInfo();
        videoStreamParametersInfo.codecParameters = videoCodecParameters;
        videoStreamParametersInfo.enabled = videoEnabled;
        audioStreamParametersInfo.codecParameters = audioCodecParameters;
        audioStreamParametersInfo.enabled = audioEnabled;
        if (videoEnabled) {
            broadcast.setVideoStreamInfo(streamId, videoStreamParametersInfo);
        }
        broadcast.setAudioStreamInfo(streamId, audioStreamParametersInfo);
        broadcast.start();
    }

    public FilterConfiguration getCurrentFilterConfiguration() {
        return this.filterConfiguration;
    }

    public boolean close(AntMediaApplicationAdapter app) {
        for (String streamId : this.currentInStreams) {
            app.removeFrameListener(streamId, (IFrameListener)this);
            app.removePacketListener(streamId, (IPacketListener)this);
        }
        for (String streamId : this.filterConfiguration.getOutputStreams()) {
            app.stopCustomBroadcast(streamId);
        }
        this.videoFilterGraph.close();
        this.audioFilterGraph.close();
        return true;
    }

    public AVPacket onVideoPacket(String streamId, AVPacket packet) {
        if (this.selfDecodeStreams) {
            if (this.videoDecodersMap.containsKey(streamId)) {
                AVFrame frame = this.videoDecodersMap.get(streamId).decodeVideoPacket(packet);
                if (frame != null) {
                    this.onVideoFrame(streamId, frame);
                }
            } else {
                logger.warn("Decoder is not initialized for {}", (Object)streamId);
            }
        }
        return packet;
    }

    public AVPacket onAudioPacket(String streamId, AVPacket packet) {
        return packet;
    }
}

