/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.dsmiley.httpproxy;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Formatter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.util.EntityUtils;

public class ProxyServlet
extends HttpServlet {
    public static final String P_LOG = "log";
    public static final String P_FORWARDEDFOR = "forwardip";
    public static final String P_PRESERVEHOST = "preserveHost";
    public static final String P_PRESERVECOOKIES = "preserveCookies";
    public static final String P_HANDLEREDIRECTS = "http.protocol.handle-redirects";
    public static final String P_CONNECTTIMEOUT = "http.socket.timeout";
    public static final String P_READTIMEOUT = "http.read.timeout";
    public static final String P_CONNECTIONREQUESTTIMEOUT = "http.connectionrequest.timeout";
    public static final String P_MAXCONNECTIONS = "http.maxConnections";
    public static final String P_USESYSTEMPROPERTIES = "useSystemProperties";
    protected static final String P_TARGET_URI = "targetUri";
    protected static final String ATTR_TARGET_URI;
    protected static final String ATTR_TARGET_HOST;
    protected boolean doLog = false;
    protected boolean doForwardIP = true;
    protected boolean doSendUrlFragment = true;
    protected boolean doPreserveHost = false;
    protected boolean doPreserveCookies = false;
    protected boolean doHandleRedirects = false;
    protected boolean useSystemProperties = true;
    protected int connectTimeout = -1;
    protected int readTimeout = -1;
    protected int connectionRequestTimeout = -1;
    protected int maxConnections = -1;
    protected String targetUri;
    protected URI targetUriObj;
    protected HttpHost targetHost;
    private HttpClient proxyClient;
    protected static final HeaderGroup hopByHopHeaders;
    protected static final BitSet asciiQueryChars;

    public String getServletInfo() {
        return "A proxy servlet by David Smiley, dsmiley@apache.org";
    }

    protected String getTargetUri(HttpServletRequest servletRequest) {
        return (String)servletRequest.getAttribute(ATTR_TARGET_URI);
    }

    protected HttpHost getTargetHost(HttpServletRequest servletRequest) {
        return (HttpHost)servletRequest.getAttribute(ATTR_TARGET_HOST);
    }

    protected String getConfigParam(String key) {
        return this.getServletConfig().getInitParameter(key);
    }

    public void init() throws ServletException {
        String useSystemPropertiesString;
        String maxConnections;
        String connectionRequestTimeout;
        String readTimeoutString;
        String connectTimeoutString;
        String handleRedirectsString;
        String preserveCookiesString;
        String preserveHostString;
        String doForwardIPString;
        String doLogStr = this.getConfigParam(P_LOG);
        if (doLogStr != null) {
            this.doLog = Boolean.parseBoolean(doLogStr);
        }
        if ((doForwardIPString = this.getConfigParam(P_FORWARDEDFOR)) != null) {
            this.doForwardIP = Boolean.parseBoolean(doForwardIPString);
        }
        if ((preserveHostString = this.getConfigParam(P_PRESERVEHOST)) != null) {
            this.doPreserveHost = Boolean.parseBoolean(preserveHostString);
        }
        if ((preserveCookiesString = this.getConfigParam(P_PRESERVECOOKIES)) != null) {
            this.doPreserveCookies = Boolean.parseBoolean(preserveCookiesString);
        }
        if ((handleRedirectsString = this.getConfigParam(P_HANDLEREDIRECTS)) != null) {
            this.doHandleRedirects = Boolean.parseBoolean(handleRedirectsString);
        }
        if ((connectTimeoutString = this.getConfigParam(P_CONNECTTIMEOUT)) != null) {
            this.connectTimeout = Integer.parseInt(connectTimeoutString);
        }
        if ((readTimeoutString = this.getConfigParam(P_READTIMEOUT)) != null) {
            this.readTimeout = Integer.parseInt(readTimeoutString);
        }
        if ((connectionRequestTimeout = this.getConfigParam(P_CONNECTIONREQUESTTIMEOUT)) != null) {
            this.connectionRequestTimeout = Integer.parseInt(connectionRequestTimeout);
        }
        if ((maxConnections = this.getConfigParam(P_MAXCONNECTIONS)) != null) {
            this.maxConnections = Integer.parseInt(maxConnections);
        }
        if ((useSystemPropertiesString = this.getConfigParam(P_USESYSTEMPROPERTIES)) != null) {
            this.useSystemProperties = Boolean.parseBoolean(useSystemPropertiesString);
        }
        this.initTarget();
        this.proxyClient = this.createHttpClient();
    }

    protected RequestConfig buildRequestConfig() {
        return RequestConfig.custom().setRedirectsEnabled(this.doHandleRedirects).setCookieSpec("ignoreCookies").setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).build();
    }

    protected SocketConfig buildSocketConfig() {
        if (this.readTimeout < 1) {
            return null;
        }
        return SocketConfig.custom().setSoTimeout(this.readTimeout).build();
    }

    protected void initTarget() throws ServletException {
        this.targetUri = this.getConfigParam(P_TARGET_URI);
        if (this.targetUri == null) {
            throw new ServletException("targetUri is required.");
        }
        try {
            this.targetUriObj = new URI(this.targetUri);
        }
        catch (Exception e) {
            throw new ServletException("Trying to process targetUri init parameter: " + e, (Throwable)e);
        }
        this.targetHost = URIUtils.extractHost((URI)this.targetUriObj);
    }

    protected HttpClient createHttpClient() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(this.buildRequestConfig()).setDefaultSocketConfig(this.buildSocketConfig());
        clientBuilder.setMaxConnTotal(this.maxConnections);
        if (this.useSystemProperties) {
            clientBuilder = clientBuilder.useSystemProperties();
        }
        return clientBuilder.build();
    }

    protected HttpClient getProxyClient() {
        return this.proxyClient;
    }

    public void destroy() {
        if (this.proxyClient instanceof Closeable) {
            try {
                ((Closeable)this.proxyClient).close();
            }
            catch (IOException e) {
                this.log("While destroying servlet, shutting down HttpClient: " + e, e);
            }
        } else if (this.proxyClient != null) {
            this.proxyClient.getConnectionManager().shutdown();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (servletRequest.getAttribute(ATTR_TARGET_URI) == null) {
            servletRequest.setAttribute(ATTR_TARGET_URI, (Object)this.targetUri);
        }
        if (servletRequest.getAttribute(ATTR_TARGET_HOST) == null) {
            servletRequest.setAttribute(ATTR_TARGET_HOST, (Object)this.targetHost);
        }
        String method = servletRequest.getMethod();
        String proxyRequestUri = this.rewriteUrlFromRequest(servletRequest);
        Object proxyRequest = servletRequest.getHeader("Content-Length") != null || servletRequest.getHeader("Transfer-Encoding") != null ? this.newProxyRequestWithEntity(method, proxyRequestUri, servletRequest) : new BasicHttpRequest(method, proxyRequestUri);
        this.copyRequestHeaders(servletRequest, (HttpRequest)proxyRequest);
        this.setXForwardedForHeader(servletRequest, (HttpRequest)proxyRequest);
        HttpResponse proxyResponse = null;
        try {
            proxyResponse = this.doExecute(servletRequest, servletResponse, (HttpRequest)proxyRequest);
            int statusCode = proxyResponse.getStatusLine().getStatusCode();
            servletResponse.setStatus(statusCode, proxyResponse.getStatusLine().getReasonPhrase());
            this.copyResponseHeaders(proxyResponse, servletRequest, servletResponse);
            if (statusCode == 304) {
                servletResponse.setIntHeader("Content-Length", 0);
            } else {
                this.copyResponseEntity(proxyResponse, servletResponse, (HttpRequest)proxyRequest, servletRequest);
            }
        }
        catch (Exception e) {
            this.handleRequestException((HttpRequest)proxyRequest, e);
        }
        finally {
            if (proxyResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)proxyResponse.getEntity());
            }
        }
    }

    protected void handleRequestException(HttpRequest proxyRequest, Exception e) throws ServletException, IOException {
        if (proxyRequest instanceof AbortableHttpRequest) {
            AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)proxyRequest;
            abortableHttpRequest.abort();
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof ServletException) {
            throw (ServletException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new RuntimeException(e);
    }

    protected HttpResponse doExecute(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpRequest proxyRequest) throws IOException {
        if (this.doLog) {
            this.log("proxy " + servletRequest.getMethod() + " uri: " + servletRequest.getRequestURI() + " -- " + proxyRequest.getRequestLine().getUri());
        }
        return this.proxyClient.execute(this.getTargetHost(servletRequest), proxyRequest);
    }

    protected HttpRequest newProxyRequestWithEntity(String method, String proxyRequestUri, HttpServletRequest servletRequest) throws IOException {
        BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, proxyRequestUri);
        eProxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)servletRequest.getInputStream(), this.getContentLength(servletRequest)));
        return eProxyRequest;
    }

    private long getContentLength(HttpServletRequest request) {
        String contentLengthHeader = request.getHeader("Content-Length");
        if (contentLengthHeader != null) {
            return Long.parseLong(contentLengthHeader);
        }
        return -1L;
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
        }
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            this.copyRequestHeader(servletRequest, proxyRequest, headerName);
        }
    }

    protected void copyRequestHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest, String headerName) {
        if (headerName.equalsIgnoreCase("Content-Length")) {
            return;
        }
        if (hopByHopHeaders.containsHeader(headerName)) {
            return;
        }
        Enumeration headers = servletRequest.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String headerValue = (String)headers.nextElement();
            if (!this.doPreserveHost && headerName.equalsIgnoreCase("Host")) {
                HttpHost host = this.getTargetHost(servletRequest);
                headerValue = host.getHostName();
                if (host.getPort() != -1) {
                    headerValue = headerValue + ":" + host.getPort();
                }
            } else if (!this.doPreserveCookies && headerName.equalsIgnoreCase("Cookie")) {
                headerValue = this.getRealCookie(headerValue);
            }
            proxyRequest.addHeader(headerName, headerValue);
        }
    }

    private void setXForwardedForHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        if (this.doForwardIP) {
            String forHeaderName = "X-Forwarded-For";
            String forHeader = servletRequest.getRemoteAddr();
            String existingForHeader = servletRequest.getHeader(forHeaderName);
            if (existingForHeader != null) {
                forHeader = existingForHeader + ", " + forHeader;
            }
            proxyRequest.setHeader(forHeaderName, forHeader);
            String protoHeaderName = "X-Forwarded-Proto";
            String protoHeader = servletRequest.getScheme();
            proxyRequest.setHeader(protoHeaderName, protoHeader);
        }
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            this.copyResponseHeader(servletRequest, servletResponse, header);
        }
    }

    protected void copyResponseHeader(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Header header) {
        String headerName = header.getName();
        if (hopByHopHeaders.containsHeader(headerName)) {
            return;
        }
        String headerValue = header.getValue();
        if (headerName.equalsIgnoreCase("Set-Cookie") || headerName.equalsIgnoreCase("Set-Cookie2")) {
            this.copyProxyCookie(servletRequest, servletResponse, headerValue);
        } else if (headerName.equalsIgnoreCase("Location")) {
            servletResponse.addHeader(headerName, this.rewriteUrlFromResponse(servletRequest, headerValue));
        } else {
            servletResponse.addHeader(headerName, headerValue);
        }
    }

    protected void copyProxyCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String headerValue) {
        String path = servletRequest.getContextPath();
        if ((path = path + servletRequest.getServletPath()).isEmpty()) {
            path = "/";
        }
        for (HttpCookie cookie : HttpCookie.parse(headerValue)) {
            String proxyCookieName = this.doPreserveCookies ? cookie.getName() : this.getCookieNamePrefix(cookie.getName()) + cookie.getName();
            Cookie servletCookie = new Cookie(proxyCookieName, cookie.getValue());
            servletCookie.setComment(cookie.getComment());
            servletCookie.setMaxAge((int)cookie.getMaxAge());
            servletCookie.setPath(path);
            servletCookie.setSecure(cookie.getSecure());
            servletCookie.setVersion(cookie.getVersion());
            servletCookie.setHttpOnly(cookie.isHttpOnly());
            servletResponse.addCookie(servletCookie);
        }
    }

    protected String getRealCookie(String cookieValue) {
        String[] cookies;
        StringBuilder escapedCookie = new StringBuilder();
        for (String cookie : cookies = cookieValue.split("[;,]")) {
            String cookieName;
            String[] cookieSplit = cookie.split("=");
            if (cookieSplit.length != 2 || !(cookieName = cookieSplit[0].trim()).startsWith(this.getCookieNamePrefix(cookieName))) continue;
            cookieName = cookieName.substring(this.getCookieNamePrefix(cookieName).length());
            if (escapedCookie.length() > 0) {
                escapedCookie.append("; ");
            }
            escapedCookie.append(cookieName).append("=").append(cookieSplit[1].trim());
        }
        return escapedCookie.toString();
    }

    protected String getCookieNamePrefix(String name) {
        return "!Proxy!" + this.getServletConfig().getServletName();
    }

    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse, HttpRequest proxyRequest, HttpServletRequest servletRequest) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            entity.writeTo((OutputStream)servletOutputStream);
        }
    }

    protected String rewriteUrlFromRequest(HttpServletRequest servletRequest) {
        int fragIdx;
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri(servletRequest));
        String pathInfo = this.rewritePathInfoFromRequest(servletRequest);
        if (pathInfo != null) {
            uri.append(ProxyServlet.encodeUriQuery(pathInfo, true));
        }
        String queryString = servletRequest.getQueryString();
        String fragment = null;
        if (queryString != null && (fragIdx = queryString.indexOf(35)) >= 0) {
            fragment = queryString.substring(fragIdx + 1);
            queryString = queryString.substring(0, fragIdx);
        }
        if ((queryString = this.rewriteQueryStringFromRequest(servletRequest, queryString)) != null && queryString.length() > 0) {
            uri.append('?');
            uri.append(ProxyServlet.encodeUriQuery(queryString, false));
        }
        if (this.doSendUrlFragment && fragment != null) {
            uri.append('#');
            uri.append(ProxyServlet.encodeUriQuery(fragment, false));
        }
        return uri.toString();
    }

    protected String rewriteQueryStringFromRequest(HttpServletRequest servletRequest, String queryString) {
        return queryString;
    }

    protected String rewritePathInfoFromRequest(HttpServletRequest servletRequest) {
        return servletRequest.getPathInfo();
    }

    protected String rewriteUrlFromResponse(HttpServletRequest servletRequest, String theUrl) {
        String targetUri = this.getTargetUri(servletRequest);
        if (theUrl.startsWith(targetUri)) {
            StringBuffer curUrl = servletRequest.getRequestURL();
            int pos = curUrl.indexOf("://");
            if (pos >= 0 && (pos = curUrl.indexOf("/", pos + 3)) >= 0) {
                curUrl.setLength(pos);
            }
            curUrl.append(servletRequest.getContextPath());
            curUrl.append(servletRequest.getServletPath());
            curUrl.append(theUrl, targetUri.length(), theUrl.length());
            return curUrl.toString();
        }
        return theUrl;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    protected static CharSequence encodeUriQuery(CharSequence in, boolean encodePercent) {
        CharSequence outBuf = null;
        Formatter formatter = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (asciiQueryChars.get(c) && (!encodePercent || c != '%')) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf == null) {
                outBuf = new StringBuilder(in.length() + 15);
                ((StringBuilder)outBuf).append(in, 0, i);
                formatter = new Formatter((Appendable)((Object)outBuf));
            }
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        String[] headers;
        ATTR_TARGET_URI = ProxyServlet.class.getSimpleName() + ".targetUri";
        ATTR_TARGET_HOST = ProxyServlet.class.getSimpleName() + ".targetHost";
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        char[] c_unreserved = "_-!.~'()*".toCharArray();
        char[] c_punct = ",;:$&+=".toCharArray();
        char[] c_reserved = "?/[]@".toCharArray();
        asciiQueryChars = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (char c2 : c_unreserved) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_punct) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_reserved) {
            asciiQueryChars.set(c2);
        }
        asciiQueryChars.set(37);
    }
}

