/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.InvalidPublicKeyException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class Jwk {
    private static final String PUBLIC_KEY_ALGORITHM = "RSA";
    private final String id;
    private final String type;
    private final String algorithm;
    private final String usage;
    private final List<String> operations;
    private final String certificateUrl;
    private final List<String> certificateChain;
    private final String certificateThumbprint;
    private final Map<String, Object> additionalAttributes;

    public Jwk(String id, String type, String algorithm, String usage, List<String> operations, String certificateUrl, List<String> certificateChain, String certificateThumbprint, Map<String, Object> additionalAttributes) {
        this.id = id;
        this.type = type;
        this.algorithm = algorithm;
        this.usage = usage;
        this.operations = operations;
        this.certificateUrl = certificateUrl;
        this.certificateChain = certificateChain;
        this.certificateThumbprint = certificateThumbprint;
        this.additionalAttributes = additionalAttributes;
    }

    @Deprecated
    public Jwk(String id, String type, String algorithm, String usage, String operations, String certificateUrl, List<String> certificateChain, String certificateThumbprint, Map<String, Object> additionalAttributes) {
        this(id, type, algorithm, usage, Collections.singletonList(operations), certificateUrl, certificateChain, certificateThumbprint, additionalAttributes);
    }

    public static Jwk fromValues(Map<String, Object> map) {
        HashMap values = Maps.newHashMap(map);
        String kid = (String)values.remove("kid");
        String kty = (String)values.remove("kty");
        String alg = (String)values.remove("alg");
        String use = (String)values.remove("use");
        Object keyOps = values.remove("key_ops");
        String x5u = (String)values.remove("x5u");
        List x5c = (List)values.remove("x5c");
        String x5t = (String)values.remove("x5t");
        if (kty == null) {
            throw new IllegalArgumentException("Attributes " + map + " are not from a valid jwk");
        }
        if (keyOps instanceof String) {
            return new Jwk(kid, kty, alg, use, (String)keyOps, x5u, (List<String>)x5c, x5t, (Map<String, Object>)values);
        }
        return new Jwk(kid, kty, alg, use, (List)keyOps, x5u, (List<String>)x5c, x5t, (Map<String, Object>)values);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getOperations() {
        if (this.operations == null || this.operations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String delimiter = ",";
        for (String operation : this.operations) {
            sb.append(operation);
            sb.append(delimiter);
        }
        String ops = sb.toString();
        return ops.substring(0, ops.length() - delimiter.length());
    }

    public List<String> getOperationsAsList() {
        return this.operations;
    }

    public String getCertificateUrl() {
        return this.certificateUrl;
    }

    public List<String> getCertificateChain() {
        return this.certificateChain;
    }

    public String getCertificateThumbprint() {
        return this.certificateThumbprint;
    }

    public Map<String, Object> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public PublicKey getPublicKey() throws InvalidPublicKeyException {
        if (!PUBLIC_KEY_ALGORITHM.equalsIgnoreCase(this.type)) {
            throw new InvalidPublicKeyException("The key is not of type RSA", null);
        }
        try {
            KeyFactory kf = KeyFactory.getInstance(PUBLIC_KEY_ALGORITHM);
            BigInteger modulus = new BigInteger(1, Base64.decodeBase64((String)this.stringValue("n")));
            BigInteger exponent = new BigInteger(1, Base64.decodeBase64((String)this.stringValue("e")));
            return kf.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidPublicKeyException("Invalid public key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidPublicKeyException("Invalid algorithm to generate key", e);
        }
    }

    private String stringValue(String key) {
        return (String)this.additionalAttributes.get(key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("kid", (Object)this.id).add("kyt", (Object)this.type).add("alg", (Object)this.algorithm).add("use", (Object)this.usage).add("extras", this.additionalAttributes).toString();
    }
}

