/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WSProxySession
implements Session {
    private Map<String, Object> userParams = new HashMap<String, Object>();
    private RemoteEndpoint.Basic proxy;
    private String remoteHost;
    public String streamId;
    private int httpPort = 5080;
    private static Logger logger = LoggerFactory.getLogger(WSProxySession.class);

    public WSProxySession(ApplicationContext appContext, String remoteNodeIp, String streamId, int httpPort) {
        this.remoteHost = remoteNodeIp;
        this.streamId = streamId;
        this.httpPort = httpPort;
        this.proxy = new ProxyBasic();
    }

    public String getRemoteUrl() {
        return "http://" + this.getRemoteHost() + ":" + this.httpPort + "/WebRTCAppEE/rest/v2/acm/signalling";
    }

    public WebSocketContainer getContainer() {
        return null;
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
    }

    public Set<MessageHandler> getMessageHandlers() {
        return null;
    }

    public void removeMessageHandler(MessageHandler handler) {
    }

    public String getProtocolVersion() {
        return null;
    }

    public String getNegotiatedSubprotocol() {
        return null;
    }

    public List<Extension> getNegotiatedExtensions() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public long getMaxIdleTimeout() {
        return 0L;
    }

    public void setMaxIdleTimeout(long milliseconds) {
    }

    public void setMaxBinaryMessageBufferSize(int length) {
    }

    public int getMaxBinaryMessageBufferSize() {
        return 0;
    }

    public void setMaxTextMessageBufferSize(int length) {
    }

    public int getMaxTextMessageBufferSize() {
        return 0;
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        return null;
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        return this.proxy;
    }

    public String getId() {
        return "noid";
    }

    public void close() throws IOException {
    }

    public void close(CloseReason closeReason) throws IOException {
    }

    public URI getRequestURI() {
        return null;
    }

    public Map<String, List<String>> getRequestParameterMap() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public Map<String, String> getPathParameters() {
        return null;
    }

    public Map<String, Object> getUserProperties() {
        return this.userParams;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public Set<Session> getOpenSessions() {
        return null;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    class ProxyBasic
    implements RemoteEndpoint.Basic {
        ProxyBasic() {
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        }

        public void sendText(String text) throws IOException {
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpPost httppost = new HttpPost(WSProxySession.this.getRemoteUrl());
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("Content-Type", "application/x-www-form-urlencoded;"));
                nameValuePairs.add(new BasicNameValuePair("streamId", WSProxySession.this.streamId));
                nameValuePairs.add(new BasicNameValuePair("message", text));
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                    if (response.getStatusLine().getStatusCode() != 204) {
                        logger.error("Peer signalling message can't be sent to node {} Status Code: {}", (Object)WSProxySession.this.getRemoteHost(), (Object)response.getStatusLine().getStatusCode());
                    }
                }
            }
        }

        public void sendBinary(ByteBuffer data) throws IOException {
        }

        public void sendText(String partialMessage, boolean isLast) throws IOException {
        }

        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        }

        public OutputStream getSendStream() throws IOException {
            return null;
        }

        public Writer getSendWriter() throws IOException {
            return null;
        }

        public void sendObject(Object data) throws IOException, EncodeException {
        }
    }
}

