/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.enterprise.webrtc.WebRTCApplication;
import io.antmedia.rest.WSProxySession;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Contact;
import io.swagger.annotations.ExternalDocs;
import io.swagger.annotations.Info;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Api(value="ACM")
@SwaggerDefinition(info=@Info(description="AMS Asynchronous Cluster Messaging REST API Reference", version="v2.0", title="AMS Asynchronous Cluster Messaging REST API Reference", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="http://www.apache.org")), consumes={"application/json"}, produces={"application/json"}, schemes={SwaggerDefinition.Scheme.HTTP, SwaggerDefinition.Scheme.HTTPS}, externalDocs=@ExternalDocs(value="External Docs", url="https://antmedia.io"), basePath="/v2")
@Component
@Path(value="/v2/acm")
public class ACMRestServiceV2 {
    @Context
    protected ServletContext servletContext;
    private ApplicationContext appCtx;
    private WebRTCApplication applicationAdaptor;
    private static Logger logger = LoggerFactory.getLogger(ACMRestServiceV2.class);
    public static int HTTP_PORT = 5080;

    @ApiOperation(value="Signalling messages come from a peer connected to caller node to forward the peer connected to this node")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/signalling")
    @Produces(value={"application/json"})
    public void signallingMsgReceived(@ApiParam(value="Stream Id", required=true) @FormParam(value="streamId") String streamId, @ApiParam(value="Message to forward.", required=true) @FormParam(value="message") String message, @Context HttpServletRequest requestContext) {
        this.applicationAdaptor = (WebRTCApplication)((Object)this.getAppContext().getBean("web.handler"));
        WSProxySession proxySession = null;
        Session realSession = null;
        Map<String, List<Session>> signallingConnections = this.applicationAdaptor.getSignallingConnections();
        List<Session> peers = signallingConnections.get(streamId);
        for (Session session : peers) {
            if (session instanceof WSProxySession) {
                proxySession = (WSProxySession)session;
                continue;
            }
            realSession = session;
        }
        if (proxySession == null) {
            proxySession = new WSProxySession(this.getAppContext(), requestContext.getRemoteHost(), streamId, HTTP_PORT);
            peers.add(proxySession);
        }
        try {
            realSession.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @ApiOperation(value="Peer connected to other node is leaved")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/peerleaved")
    @Produces(value={"application/json"})
    public void peerLeaved(@ApiParam(value="Stream Id", required=true) @FormParam(value="streamId") String streamId, @Context HttpServletRequest requestContext) {
        this.applicationAdaptor = (WebRTCApplication)((Object)this.getAppContext().getBean("web.handler"));
        Map<String, List<Session>> signallingConnections = this.applicationAdaptor.getSignallingConnections();
        List<Session> peers = signallingConnections.get(streamId);
        Session proxySession = null;
        for (Session session : peers) {
            if (!(session instanceof WSProxySession)) continue;
            proxySession = session;
        }
        peers.remove(proxySession);
        DataStore datastore = ((DataStoreFactory)this.getAppContext().getBean("dataStoreFactory")).getDataStore();
        P2PConnection conn = datastore.getP2PConnection(streamId);
        if (conn == null) {
            datastore.createP2PConnection(new P2PConnection(streamId, requestContext.getLocalAddr()));
        } else if (!conn.getOriginNode().contentEquals(requestContext.getLocalAddr())) {
            datastore.deleteP2PConnection(streamId);
            datastore.createP2PConnection(new P2PConnection(streamId, requestContext.getLocalAddr()));
        }
    }

    @Nullable
    protected ApplicationContext getAppContext() {
        if (this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public static void sendPeerLeavedMessage(String streamId, String remoteHost, int httpPort) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(ACMRestServiceV2.getRemoteUrl(remoteHost, httpPort));
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("Content-Type", "application/x-www-form-urlencoded;"));
            nameValuePairs.add(new BasicNameValuePair("streamId", streamId));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                if (response.getStatusLine().getStatusCode() != 204) {
                    logger.error("Peer signalling message can't be sent to node {} Status Code: {}", (Object)remoteHost, (Object)response.getStatusLine().getStatusCode());
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static String getRemoteUrl(String remoteHost, int httpPort) {
        return "http://" + remoteHost + ":" + httpPort + "/WebRTCAppEE/rest/v2/acm/peerleaved";
    }

    public static void setHttpPort(int httpPort) {
        HTTP_PORT = httpPort;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

