/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc.codec;

import io.antmedia.AppSettings;
import io.antmedia.enterprise.webrtc.codec.VirtualVideoEncoder;
import io.antmedia.webrtc.VideoCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.H264Utils;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;

public class VirtualVideoEncoderFactory
implements VideoEncoderFactory {
    protected static Logger logger = LoggerFactory.getLogger(VirtualVideoEncoderFactory.class);
    private LinkedHashMap<String, VirtualVideoEncoder> virtualVideoEncoders = new LinkedHashMap();
    int returnIndex = 0;
    private AppSettings appSettings;
    private List<VideoCodec> videoCodecList;

    public VirtualVideoEncoderFactory(String streamId, List<String> subTracks, AppSettings appSettings) {
        this.appSettings = appSettings;
        this.createNewEncoder(streamId);
        for (String trackId : subTracks) {
            this.createNewEncoder(trackId);
        }
    }

    public void createNewEncoder(String trackId) {
        this.virtualVideoEncoders.put("ARDAMSv" + trackId, new VirtualVideoEncoder());
    }

    public VirtualVideoEncoderFactory(String streamId, List<String> subTracks, List<VideoCodec> videoCodecList) {
        this(streamId, subTracks, (AppSettings)null);
        this.videoCodecList = videoCodecList;
    }

    public VirtualVideoEncoder getEncoder(String trackId) {
        return this.virtualVideoEncoders.get("ARDAMSv" + trackId);
    }

    public VideoEncoder createEncoder(VideoCodecInfo input) {
        logger.info("createEncoder: {} for factory: {}", (Object)input.name, (Object)this.hashCode());
        for (String key : input.params.keySet()) {
            logger.info("encoder input key: {}  value: {} ", (Object)key, input.params.get(key));
        }
        String trackId = (String)input.params.get("track");
        return this.virtualVideoEncoders.get(trackId);
    }

    public VideoCodecInfo[] getSupportedCodecs() {
        List<VideoCodecInfo> enabledCodecList = this.videoCodecList != null ? VirtualVideoEncoderFactory.getCodecListFromStreamInfo(this.videoCodecList) : VirtualVideoEncoderFactory.getEnabledCodecList(this.appSettings);
        return enabledCodecList.toArray(new VideoCodecInfo[enabledCodecList.size()]);
    }

    public static List<VideoCodecInfo> getEnabledCodecList(AppSettings appSettings) {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        if (appSettings.isH264Enabled()) {
            logger.info("Adding H264 Encoder to the supported codecs");
            supportedCodecInfos.add(new VideoCodecInfo(VideoCodecType.H264.name(), H264Utils.getDefaultH264Params((boolean)false)));
        }
        if (appSettings.isVp8Enabled()) {
            logger.info("Adding VP8 Encoder to the supported codecs");
            supportedCodecInfos.add(new VideoCodecInfo(VideoCodecType.VP8.name(), new HashMap()));
        }
        if (appSettings.isH265Enabled()) {
            logger.info("Adding H265 Encoder to the supported codecs");
            supportedCodecInfos.add(new VideoCodecInfo(VideoCodecType.H265.name(), new HashMap()));
        }
        return supportedCodecInfos;
    }

    public static List<VideoCodecInfo> getCodecListFromStreamInfo(List<VideoCodec> videoCodecList) {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        boolean noVideo = false;
        for (VideoCodec videoCodec : videoCodecList) {
            VideoCodecInfo videoCodecInfo = null;
            if (videoCodec == VideoCodec.H264) {
                videoCodecInfo = new VideoCodecInfo(VideoCodecType.H264.name(), H264Utils.getDefaultH264Params((boolean)false));
            } else if (videoCodec == VideoCodec.VP8) {
                videoCodecInfo = new VideoCodecInfo(VideoCodecType.VP8.name(), new HashMap());
            } else if (videoCodec == VideoCodec.H265) {
                videoCodecInfo = new VideoCodecInfo(VideoCodecType.H265.name(), new HashMap());
            } else if (videoCodec == VideoCodec.NOVIDEO) {
                noVideo = true;
            }
            if (videoCodecInfo == null) continue;
            supportedCodecInfos.add(videoCodecInfo);
        }
        if (supportedCodecInfos.isEmpty() && noVideo) {
            VideoCodecInfo videoCodecInfo = new VideoCodecInfo(VideoCodecType.H264.name(), H264Utils.getDefaultH264Params((boolean)false));
            supportedCodecInfos.add(videoCodecInfo);
        }
        return supportedCodecInfos;
    }
}

