/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc.codec;

import io.antmedia.enterprise.webrtc.WebRTCClient;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.CalledByNative;
import org.webrtc.EncodedImage;
import org.webrtc.NaluIndex;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoFrame;

public class VirtualVideoEncoder
implements VideoEncoder {
    protected static Logger logger = LoggerFactory.getLogger(VirtualVideoEncoder.class);
    private static final int MAX_VIDEO_FRAMERATE = 60;
    private int adjustedBitrate = 10000000;
    private WebRTCClient.IVideoPacketSender sendVideo;
    private int time2Log;
    private Queue<Short> packetLossMeasurements = new LinkedList<Short>();
    private Queue<Long> rttMeasurements = new LinkedList<Long>();
    private VideoEncoder.CodecSpecificInfo codecInfo = new VideoEncoder.CodecSpecificInfo();
    private int windowSize = 5;
    private int packetLossAverage;
    private int rttMeasurementsAverage;
    private int time2LogChannel = 0;
    private long frameId;
    private long captureTimeMs;

    public VirtualVideoEncoder() {
        this.setSendVideo((encodedFrameBuffer, isKeyFrame, timestampNs, frameRotation, naluIndices, trackIndex) -> logger.info("Callback is not set in encoder for {}", (Object)this.hashCode()));
    }

    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, final VideoEncoder.Callback encodeCallback) {
        logger.info("initEncode: {} x {}. @ {}kbps {}fps automaticResizeOn: {} adjusted bitrate: {} for client:", new Object[]{settings.width, settings.height, settings.startBitrate, settings.maxFramerate, settings.automaticResizeOn, this.adjustedBitrate, this.hashCode()});
        this.setSendVideo(new WebRTCClient.IVideoPacketSender(){

            @Override
            public void sendVideo(ByteBuffer encodedFrameBuffer, boolean isKeyFrame, long timestampNs, int frameRotation, List<NaluIndex> naluIndices, String trackId) {
                encodedFrameBuffer.rewind();
                EncodedImage encodedImage = EncodedImage.builder().setCompleteFrame(true).setFrameType(isKeyFrame ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta).setRotation(frameRotation).setBuffer(encodedFrameBuffer).setNaluIndices(naluIndices).setEncodedHeight(1).setEncodedWidth(1).createEncodedImage();
                int encodedFrameSize = encodedImage.buffer.limit();
                encodedImage.setCaptureTimeNs(timestampNs);
                encodeCallback.onEncodedFrame(encodedImage, VirtualVideoEncoder.this.codecInfo, naluIndices);
                encodedImage.release();
            }
        });
        return VideoCodecStatus.OK;
    }

    public VideoCodecStatus release() {
        this.setSendVideo(new WebRTCClient.IVideoPacketSender(){

            @Override
            public void sendVideo(ByteBuffer encodedFrameBuffer, boolean isKeyFrame, long timestampNs, int frameRotation, List<NaluIndex> naluIndices, String trackId) {
                logger.info("Callback is  reset in encoder for {}", (Object)this.hashCode());
            }
        });
        return VideoCodecStatus.OK;
    }

    public VideoCodecStatus encode(VideoFrame videoFrame, VideoEncoder.EncodeInfo info) {
        if (info != null) {
            logger.debug("encode video frame type: {}", (Object)info.frameTypes[0]);
        }
        return VideoCodecStatus.OK;
    }

    public int getAdjustedBitrate() {
        return this.adjustedBitrate;
    }

    public VideoCodecStatus setChannelParameters(short packetLoss, long roundTripTimeMs) {
        this.packetLossMeasurements.add(packetLoss);
        if (this.packetLossMeasurements.size() > this.windowSize) {
            this.packetLossMeasurements.poll();
        }
        int total = 0;
        Iterator iterator = this.packetLossMeasurements.iterator();
        while (iterator.hasNext()) {
            short msrmnt = (Short)iterator.next();
            total += msrmnt;
        }
        this.packetLossAverage = total / this.packetLossMeasurements.size();
        this.rttMeasurements.add(roundTripTimeMs);
        if (this.rttMeasurements.size() > this.windowSize) {
            this.rttMeasurements.poll();
        }
        total = 0;
        iterator = this.rttMeasurements.iterator();
        while (iterator.hasNext()) {
            long msrmnt = (Long)iterator.next();
            total = (int)((long)total + msrmnt);
        }
        this.rttMeasurementsAverage = total / this.rttMeasurements.size();
        if (this.time2LogChannel > 50) {
            logger.info("Channel parameters. packetloss:{}  roundTripTimeMs:{}", (Object)packetLoss, (Object)roundTripTimeMs);
            this.time2LogChannel = 0;
        }
        ++this.time2LogChannel;
        return VideoCodecStatus.OK;
    }

    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int framerate) {
        if (framerate > 60) {
            framerate = 60;
        }
        if (this.time2Log > 50) {
            logger.info("setRateAllocation bitrate: {} framerate: {} adjusted bitrate:{} for client: {}", new Object[]{bitrateAllocation.getSum(), framerate, this.adjustedBitrate, this.hashCode()});
            this.time2Log = 0;
        }
        ++this.time2Log;
        this.adjustedBitrate = bitrateAllocation.getSum();
        return VideoCodecStatus.OK;
    }

    public VideoEncoder.ScalingSettings getScalingSettings() {
        logger.debug("getScalingSettings for {}", (Object)this);
        return VideoEncoder.ScalingSettings.OFF;
    }

    public String getImplementationName() {
        return this.getClass().getSimpleName();
    }

    public void setEncodedFrameBuffer(ByteBuffer encodedFrameBuffer, boolean isKeyFrame, long timestampNs, int frameRotation, List<NaluIndex> naluIndices, String trackId) {
        this.sendVideo.sendVideo(encodedFrameBuffer, isKeyFrame, timestampNs, frameRotation, naluIndices, trackId);
    }

    public int getPacketLossAverage() {
        return this.packetLossAverage;
    }

    public int getRttMeasurementsAverage() {
        return this.rttMeasurementsAverage;
    }

    public WebRTCClient.IVideoPacketSender getSendVideo() {
        return this.sendVideo;
    }

    public void setSendVideo(WebRTCClient.IVideoPacketSender sendVideo) {
        this.sendVideo = sendVideo;
    }

    @CalledByNative
    public void notifyFrameId(int frameid, long captureTimeNs) {
        logger.info("frame id: {} capture TimeNs: {}", (Object)Integer.toUnsignedLong(frameid), (Object)captureTimeNs);
        this.frameId = Integer.toUnsignedLong(frameid);
        this.captureTimeMs = captureTimeNs / 1000000L;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public long getCaptureTimeMs() {
        return this.captureTimeMs;
    }
}

