/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.StreamIdValidator;
import io.antmedia.cluster.IStreamInfo;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import io.antmedia.enterprise.adaptive.WebRTCEncoderAdaptor;
import io.antmedia.enterprise.adaptive.WebRTCVideoForwarder;
import io.antmedia.enterprise.cluster.webrtc.EdgeClient;
import io.antmedia.enterprise.cluster.webrtc.OriginServer;
import io.antmedia.enterprise.cluster.webrtc.OriginServerStatusListener;
import io.antmedia.enterprise.security.TokenService;
import io.antmedia.enterprise.webrtc.SubtrackPoller;
import io.antmedia.enterprise.webrtc.WebRTCAdaptor;
import io.antmedia.enterprise.webrtc.WebRTCApplication;
import io.antmedia.enterprise.webrtc.WebRTCClient;
import io.antmedia.enterprise.webrtc.WebRTCPlayStreamInfoListener;
import io.antmedia.enterprise.webrtc.WebRTCPublishStreamInfoListener;
import io.antmedia.enterprise.webrtc.codec.VirtualVideoEncoderFactory;
import io.antmedia.licence.ILicenceService;
import io.antmedia.rest.ACMRestServiceV2;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.WSProxySession;
import io.antmedia.security.AcceptOnlyStreamsWithWebhook;
import io.antmedia.security.ITokenService;
import io.antmedia.settings.ServerSettings;
import io.antmedia.statistic.IStatsCollector;
import io.antmedia.websocket.WebSocketCommunityHandler;
import io.vertx.core.Vertx;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.websocket.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;
import org.webrtc.VideoCodecInfo;

public class WebSocketEnterpriseHandler
extends WebSocketCommunityHandler {
    public static final String USER_STREAM_ID = "USER_STREAM_ID";
    public static final String USER_ROOM_ID = "USER_ROOM_ID";
    private static Logger logger = LoggerFactory.getLogger(WebSocketEnterpriseHandler.class);
    private JSONParser jsonParser = new JSONParser();
    private WebRTCApplication applicationAdaptor;
    private AppSettings appSettings;
    private DataStore datastore;
    private Vertx vertx;
    public TokenService tokenService;
    private IStatsCollector statsCollector;
    private WebRTCAdaptor webRTCAdaptor;
    private ServerSettings serverSettings;
    private Vertx webRTCVertx;
    private ILicenceService licenceService;

    public WebSocketEnterpriseHandler(ApplicationContext appContext, Session session) {
        super(appContext, session);
        this.applicationAdaptor = (WebRTCApplication)((Object)appContext.getBean("web.handler"));
        this.appSettings = (AppSettings)this.getAppContext().getBean("app.settings");
        DataStoreFactory dataStoreFactory = (DataStoreFactory)this.getAppContext().getBean("dataStoreFactory");
        this.setDatastore(dataStoreFactory.getDataStore());
        this.tokenService = (TokenService)appContext.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
        this.setStatsCollector((IStatsCollector)appContext.getBean("statsCollector"));
        this.setVertx((Vertx)appContext.getBean("vertxCore"));
        this.setWebRTCAdaptor((WebRTCAdaptor)appContext.getBean("webrtc.adaptor"));
        this.serverSettings = (ServerSettings)appContext.getBean("ant.media.server.settings");
        this.webRTCVertx = (Vertx)appContext.getBean("webRTCVertx");
        this.licenceService = (ILicenceService)appContext.getBean(ILicenceService.BeanName.LICENCE_SERVICE.toString());
    }

    public void onClose(Session session) {
        String roomId = (String)session.getUserProperties().get(USER_ROOM_ID);
        this.processStopEverything(session, roomId, false);
        this.signallingDisconnected(session);
    }

    public void onError(Session session, Throwable throwable) {
        String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)throwable);
        if (logger.isErrorEnabled()) {
            logger.error("Error: {}", (Object)(rootCauseMessage.contains("Broken") || rootCauseMessage.contains("EOFException") ? rootCauseMessage : ExceptionUtils.getStackTrace((Throwable)throwable)));
        }
    }

    public void onMessage(Session session, String message) {
        if (message == null) {
            logger.error("Received message null for session id: {}", (Object)session.getId());
            return;
        }
        if (this.applicationAdaptor.isServerShuttingDown()) {
            this.sendServerWillCloaseMessage(session);
            return;
        }
        if (!this.getDatastore().isAvailable()) {
            this.sendDataStoreNotAvailable(session);
            return;
        }
        try {
            logger.debug("Received message: {} session id: {}", (Object)message, (Object)session.getId());
            JSONObject jsonObject = (JSONObject)this.jsonParser.parse(message);
            String cmd = (String)jsonObject.get((Object)"command");
            if (cmd == null) {
                logger.error("Received message does not contain any command for session id: {}, message:{}", (Object)session.getId(), (Object)message);
                return;
            }
            String streamId = (String)jsonObject.get((Object)"streamId");
            if (!(streamId != null && !streamId.isEmpty() || cmd.equals("joinRoom") || cmd.equals("leaveFromRoom") || cmd.equals("ping"))) {
                this.sendNoStreamIdSpecifiedError(session);
                return;
            }
            if (!StreamIdValidator.isStreamIdValid((String)streamId)) {
                this.sendInvalidStreamNameError(session);
                return;
            }
            if (cmd.equals("join")) {
                boolean multiPeer = false;
                if (jsonObject.containsKey((Object)"multiPeer")) {
                    multiPeer = (Boolean)jsonObject.get((Object)"multiPeer");
                }
                String mode = "both";
                if (jsonObject.containsKey((Object)"mode")) {
                    mode = (String)jsonObject.get((Object)"mode");
                }
                this.processSignallingJoin(streamId, multiPeer, mode);
            } else if (cmd.equals("ping")) {
                this.sendPongMessage(session);
            } else if (cmd.equals("toggleAudio")) {
                String trackId = null;
                if (jsonObject.containsKey((Object)"trackId")) {
                    trackId = (String)jsonObject.get((Object)"trackId");
                }
                boolean enabled = true;
                if (jsonObject.containsKey((Object)"enabled")) {
                    enabled = (Boolean)jsonObject.get((Object)"enabled");
                    logger.info("received track id :{} , enabled : {}", (Object)trackId, (Object)enabled);
                }
                this.setAudioStatus(streamId, trackId, enabled);
            } else if (cmd.equals("toggleVideo")) {
                String trackId = null;
                if (jsonObject.containsKey((Object)"trackId")) {
                    trackId = (String)jsonObject.get((Object)"trackId");
                }
                boolean enabled = true;
                if (jsonObject.containsKey((Object)"enabled")) {
                    enabled = (Boolean)jsonObject.get((Object)"enabled");
                    logger.info("received track id :{} , enabled : {}", (Object)trackId, (Object)enabled);
                }
                this.setVideoStatus(streamId, trackId, enabled);
            } else if (cmd.equals("takeConfiguration")) {
                this.processTakeConfigurationCommand(jsonObject, session.getId(), streamId);
            } else if (cmd.equals("takeCandidate")) {
                this.processTakeCandidateCommand(jsonObject, session.getId(), streamId);
            } else if (cmd.equals("leave")) {
                this.processSignallingLeave(streamId);
            } else if (cmd.equals("stop")) {
                this.processStopCommand(streamId);
            } else if (cmd.equals("publish")) {
                if (this.licenceService.isLicenceSuspended()) {
                    this.sendLicenseSuspended(session);
                    return;
                }
                if (!this.getStatsCollector().enoughResource()) {
                    this.sendHighResourceUsage(session);
                    logger.warn("Sending high resource usage for publishing stream:{}. Stream is not accepted", (Object)streamId);
                    return;
                }
                String tokenId = null;
                String subscriberId = null;
                String subscriberCode = null;
                String streamName = null;
                String mainTrack = null;
                if (jsonObject.containsKey((Object)"token")) {
                    tokenId = (String)jsonObject.get((Object)"token");
                    logger.info("received token:{}", (Object)tokenId);
                }
                if (jsonObject.containsKey((Object)"subscriberId")) {
                    subscriberId = (String)jsonObject.get((Object)"subscriberId");
                    logger.info("received subscriber id :{}", (Object)subscriberId);
                }
                if (jsonObject.containsKey((Object)"subscriberCode")) {
                    subscriberCode = (String)jsonObject.get((Object)"subscriberCode");
                    logger.info("received subscriber code :{}", (Object)subscriberCode);
                }
                if (jsonObject.containsKey((Object)"streamName") && !((String)jsonObject.get((Object)"streamName")).isEmpty()) {
                    streamName = (String)jsonObject.get((Object)"streamName");
                    logger.info("received stream name:{}", (Object)streamName);
                }
                if (jsonObject.containsKey((Object)"mainTrack") && !((String)jsonObject.get((Object)"mainTrack")).isEmpty()) {
                    mainTrack = (String)jsonObject.get((Object)"mainTrack");
                    logger.info("received mainTrack:{}", (Object)mainTrack);
                }
                boolean enableVideo = jsonObject.containsKey((Object)"video") ? (Boolean)jsonObject.get((Object)"video") : true;
                boolean enableAudio = jsonObject.containsKey((Object)"audio") ? (Boolean)jsonObject.get((Object)"audio") : true;
                this.processPublishCommand(streamId, enableVideo, enableAudio, tokenId, subscriberId, subscriberCode, streamName, mainTrack);
            } else if (cmd.equals("getRoomInfo")) {
                String roomId = null;
                if (jsonObject.get((Object)"room") != null) {
                    roomId = (String)jsonObject.get((Object)"room");
                    this.processGetRoomInfoCommand(roomId, streamId);
                } else {
                    this.sendNoRoomSpecifiedError(session);
                }
            } else if (cmd.equals("getStreamInfo")) {
                this.processGetStreamInfoCommand(streamId);
            } else if (cmd.equals("forceStreamQuality")) {
                long streamResolution = (Long)jsonObject.get((Object)"streamHeight");
                this.processSetStreamResolutionCommand(streamId, (int)streamResolution);
            } else if (cmd.equals("play")) {
                if (!this.getStatsCollector().enoughResource()) {
                    this.sendHighResourceUsage(session);
                    logger.warn("Sending high resource usage for playing stream:{}. Playing request is not accepted", (Object)streamId);
                    return;
                }
                if (this.isWebRTCClientExist(session.getId(), streamId)) {
                    logger.info("WebRTC Client already exists for stream id: {} and session id:{}", (Object)streamId, (Object)session.getId());
                    this.sendAlreadyPlaying(session, streamId);
                    return;
                }
                Broadcast broadcast = this.getDatastore().get(streamId);
                if (broadcast != null && broadcast.getWebRTCViewerLimit() != -1 && broadcast.getWebRTCViewerCount() >= broadcast.getWebRTCViewerLimit()) {
                    this.sendViewerLimitReached(session);
                    return;
                }
                int webRTCViewersCount = this.getDatastore().getTotalWebRTCViewersCount();
                if (this.appSettings.getWebRTCViewerLimit() != -1 && webRTCViewersCount >= this.appSettings.getWebRTCViewerLimit()) {
                    this.sendViewerLimitReached(session);
                    return;
                }
                String tokenId = null;
                String subscriberId = null;
                String subscriberCode = null;
                String viewerInfo = "";
                if (jsonObject.containsKey((Object)"token")) {
                    tokenId = (String)jsonObject.get((Object)"token");
                }
                if (jsonObject.containsKey((Object)"subscriberId")) {
                    subscriberId = (String)jsonObject.get((Object)"subscriberId");
                    logger.info("received subscriber id :{}", (Object)subscriberId);
                }
                if (jsonObject.containsKey((Object)"subscriberCode")) {
                    subscriberCode = (String)jsonObject.get((Object)"subscriberCode");
                    logger.info("received subscriber code :{}", (Object)subscriberCode);
                }
                ArrayList<String> enabledTracks = new ArrayList<String>();
                if (jsonObject.containsKey((Object)"trackList")) {
                    JSONArray jArray = (JSONArray)jsonObject.get((Object)"trackList");
                    for (int i = 0; i < jArray.size(); ++i) {
                        enabledTracks.add((String)jArray.get(i));
                    }
                }
                if (jsonObject.containsKey((Object)"viewerInfo")) {
                    viewerInfo = (String)jsonObject.get((Object)"viewerInfo");
                    logger.info("viewer info :{}", (Object)viewerInfo);
                }
                this.processPlayCommand(streamId, tokenId, this.appSettings.isPlayTokenControlEnabled(), (String)jsonObject.get((Object)"room"), enabledTracks, this.appSettings.isTimeTokenSubscriberOnly(), subscriberId, subscriberCode, viewerInfo);
            } else if (cmd.equals("joinRoom")) {
                String mode = "legacy";
                if (jsonObject.containsKey((Object)"mode")) {
                    mode = (String)jsonObject.get((Object)"mode");
                }
                logger.info("Conference mode: {}", (Object)mode);
                if (this.appSettings.isAcceptOnlyRoomsInDataStore()) {
                    ConferenceRoom dbRoom = this.getDatastore().getConferenceRoom((String)jsonObject.get((Object)"room"));
                    if (dbRoom == null) {
                        this.sendNoAllowUnRegisteredStream(session);
                    } else {
                        this.processJoinRoomCommand((String)jsonObject.get((Object)"room"), streamId, false, mode);
                    }
                } else {
                    this.processJoinRoomCommand((String)jsonObject.get((Object)"room"), streamId, true, mode);
                }
            } else if (cmd.equals("leaveFromRoom")) {
                this.processStopEverything(session, (String)jsonObject.get((Object)"room"), true);
            } else if (cmd.equals("enableTrack")) {
                String trackId = (String)jsonObject.get((Object)"trackId");
                boolean enabled = (Boolean)jsonObject.get((Object)"enabled");
                this.processEnableTrackCommand(streamId, trackId, enabled);
            } else if (cmd.equals("getTrackList")) {
                String tokenId = null;
                if (jsonObject.containsKey((Object)"token")) {
                    tokenId = (String)jsonObject.get((Object)"token");
                }
                this.processGetTrackListCommand(streamId, tokenId);
            } else if (cmd.equals("peerMessageCommand")) {
                this.processPeerMessageCommand(streamId, message);
            } else {
                logger.info("Unprocessed message: {} ", (Object)message);
            }
        }
        catch (ParseException e) {
            logger.info("Received message: {} session id: {}", (Object)message, (Object)session.getId());
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void setVideoStatus(String streamId, String trackId, boolean enabled) {
        logger.info("setVideoStatus called with streamId = " + streamId + " trackId = " + trackId + " enabled = " + enabled);
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
        Queue<WebRTCClient> webRTCClientList = webRTCClientsMap.get(this.session.getId());
        if (webRTCClientList != null) {
            for (WebRTCClient webRTCClient : webRTCClientList) {
                List<String> tracks;
                if (!webRTCClient.getStreamId().equals(streamId) || (tracks = webRTCClient.getSubTracks()) == null) continue;
                for (String track : tracks) {
                    if (!trackId.equals(track)) continue;
                    webRTCClient.setVideoTrack(trackId, enabled);
                    logger.info("Setting video track enabled to {} for streamId: {}", (Object)enabled, (Object)trackId);
                }
            }
        }
    }

    public void setAudioStatus(String streamId, String trackId, boolean enabled) {
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
        Queue<WebRTCClient> webRTCClientList = webRTCClientsMap.get(this.session.getId());
        if (webRTCClientList != null) {
            for (WebRTCClient webRTCClient : webRTCClientList) {
                List<String> tracks;
                if (!webRTCClient.getStreamId().equals(streamId) || (tracks = webRTCClient.getSubTracks()) == null) continue;
                for (String track : tracks) {
                    if (!trackId.equals(track)) continue;
                    webRTCClient.setAudioTrack(trackId, enabled);
                    logger.info("Setting audio track enabled to {} for streamId: {}", (Object)enabled, (Object)trackId);
                }
            }
        }
    }

    private void sendLicenseSuspended(Session session) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"error");
        jsonObject.put((Object)"definition", (Object)"license_suspended_please_renew_license");
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public boolean isValidStreamDate(Broadcast broadcast) {
        long now;
        return broadcast == null || broadcast.getPlannedStartDate() == 0L || broadcast.getPlannedEndDate() == 0L || (now = Instant.now().getEpochSecond()) >= broadcast.getPlannedStartDate() && now <= broadcast.getPlannedEndDate();
    }

    private boolean isP2PCommand(String cmd, String streamId) {
        boolean isP2PCmd = cmd.equals("join") || cmd.equals("leave");
        isP2PCmd = isP2PCmd || this.getApplicationAdaptor().getSignallingConnections().containsKey(streamId);
        return isP2PCmd;
    }

    public boolean processJoinRoomCommand(String room, String streamId, boolean isZombi, String mode) {
        String newStreamId = null;
        if (room == null || room.isEmpty()) {
            logger.warn("Sending no room specified error. Stream: {} room:{} ", (Object)streamId, (Object)room);
            this.sendNoRoomSpecifiedError(this.session);
            return false;
        }
        newStreamId = streamId == null || streamId.isEmpty() || streamId.equals("null") ? RandomStringUtils.randomAlphabetic((int)16) : streamId;
        ConferenceRoom dbRoom = this.getDatastore().getConferenceRoom(room);
        HashMap<String, String> streamDetailsMap = null;
        ArrayList<String> roomStreamList = null;
        if (dbRoom != null) {
            if (dbRoom.getStartDate() != 0L && dbRoom.getEndDate() != 0L && !this.checkConferenceDate(dbRoom)) {
                return false;
            }
            roomStreamList = dbRoom.getRoomStreamList();
            if (!roomStreamList.contains(newStreamId)) {
                roomStreamList.add(newStreamId);
                dbRoom.setRoomStreamList(roomStreamList);
                this.getDatastore().editConferenceRoom(room, dbRoom);
            }
            streamDetailsMap = new HashMap<String, String>();
            for (String tmpStreamId : roomStreamList) {
                Broadcast broadcast = this.getDatastore().get(tmpStreamId);
                if (broadcast == null || !"broadcasting".equals(broadcast.getStatus())) continue;
                streamDetailsMap.put(tmpStreamId, broadcast.getName());
            }
            streamDetailsMap.remove(newStreamId);
        } else {
            dbRoom = new ConferenceRoom();
            dbRoom.setZombi(isZombi);
            dbRoom.setMode(mode);
            roomStreamList = new ArrayList<String>();
            roomStreamList.add(newStreamId);
            dbRoom.setRoomStreamList(roomStreamList);
            dbRoom.setRoomId(room);
            this.getDatastore().createConferenceRoom(dbRoom);
        }
        this.applicationAdaptor.joinedTheRoom(dbRoom.getRoomId(), newStreamId);
        this.session.getUserProperties().put(USER_STREAM_ID, newStreamId);
        this.session.getUserProperties().put(USER_ROOM_ID, room);
        this.sendJoinedRoomMessage(room, newStreamId, streamDetailsMap);
        return true;
    }

    public boolean checkConferenceDate(ConferenceRoom dbRoom) {
        long now = Instant.now().getEpochSecond();
        if (now < dbRoom.getStartDate() || now > dbRoom.getEndDate()) {
            this.sendRoomTimeError(this.session);
            return false;
        }
        return true;
    }

    private void sendLeavedFromRoomMessage(Session session, String roomName) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"notification");
        jsonResponse.put((Object)"definition", (Object)"leavedFromRoom");
        jsonResponse.put((Object)"ATTR_ROOM_NAME", (Object)roomName);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    private void sendNoRoomSpecifiedError(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"no_room_specified");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    private void sendRoomTimeError(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"room_not_active_or_expired");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public final void sendDataStoreNotAvailable(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"data_store_not_available");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendStreamTimeError(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"stream_not_active_or_expired");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    private void sendUnauthorizedError(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"unauthorized_access");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void processPlayCommand(String streamId, String tokenId, boolean playTokenControlEnabled, String roomId, List<String> enabledTracks, boolean subscriberOnly, String subscriberId, String subscriberCodeText, String viewerInfo) {
        if ((subscriberOnly || this.appSettings.isEnableTimeTokenForPlay()) && !this.tokenService.checkTimeBasedSubscriber(subscriberId, streamId, this.session.getId(), subscriberCodeText, false)) {
            this.sendUnauthorizedError(this.session);
            return;
        }
        if (playTokenControlEnabled) {
            Token token = new Token();
            token.setTokenId(tokenId);
            token.setStreamId(streamId);
            token.setType("play");
            Token dbToken = this.getDatastore().getToken(tokenId);
            if (dbToken != null && dbToken.getRoomId() != null && !dbToken.getRoomId().isEmpty() && roomId != null && dbToken.getRoomId().equals(roomId)) {
                token.setRoomId(roomId);
                ConferenceRoom conferenceRoom = this.getDatastore().getConferenceRoom(roomId);
                if (conferenceRoom == null) {
                    this.sendUnauthorizedError(this.session);
                    return;
                }
                List streamIdList = conferenceRoom.getRoomStreamList();
                if (!streamIdList.contains(streamId) || this.getDatastore().validateToken(token) == null) {
                    this.sendUnauthorizedError(this.session);
                    return;
                }
            } else if (this.getDatastore().validateToken(token) == null) {
                this.sendUnauthorizedError(this.session);
                return;
            }
        }
        if (this.appSettings.isHashControlPlayEnabled() && !this.tokenService.checkHash(tokenId, streamId, this.session.getId(), "play")) {
            this.sendUnauthorizedError(this.session);
            return;
        }
        if (this.appSettings.isPlayJwtControlEnabled() && !this.tokenService.checkJwtToken(tokenId, streamId, "play")) {
            this.sendUnauthorizedError(this.session);
            return;
        }
        this.play(streamId, enabledTracks, subscriberId, viewerInfo);
    }

    public boolean isWebRTCClientExist(String sessionId, String streamId) {
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
        Queue<WebRTCClient> list = webRTCClientsMap.get(sessionId);
        return list != null && list.stream().anyMatch(webRTCClient -> webRTCClient.getStreamId().equals(streamId));
    }

    public void play(String streamId, List<String> enabledTracks, String subscriberId, String viewerInfo) {
        boolean streamExists = this.getWebRTCAdaptor().streamExists(streamId);
        logger.debug("Stream {} exists -> {}", (Object)streamId, (Object)streamExists);
        boolean isMainTrack = false;
        Broadcast broadcast = this.getDatastore().get(streamId);
        if (broadcast == null) {
            this.sendNotFoundJSON(streamId, this.session);
            return;
        }
        isMainTrack = !broadcast.getSubTrackStreamIds().isEmpty();
        if (streamExists || isMainTrack && !this.isClusterMode()) {
            logger.info("Play");
            WebRTCClient webRTCClient = this.initWebRTCClient(streamId, this.getWebRTCAdaptor(), subscriberId, viewerInfo, broadcast, enabledTracks);
            this.putWebRTCClientMap(this.session.getId(), webRTCClient);
            logger.info("Starting webrtc stream viewer local for stream id: {} viewer hashcode:{} user-agent: {}", new Object[]{streamId, webRTCClient.hashCode(), this.userAgent});
            webRTCClient.start();
        } else if (this.isClusterMode()) {
            List streamInfoList = this.getDatastore().getStreamInfoList(streamId);
            if (streamInfoList != null && !streamInfoList.isEmpty() || isMainTrack) {
                this.startWebRTCStreamInCluster(streamId, streamInfoList, subscriberId, viewerInfo, broadcast, enabledTracks);
            } else {
                this.sendNotFoundJSON(streamId, this.session);
            }
        } else {
            this.sendNotFoundJSON(streamId, this.session);
        }
    }

    public boolean isClusterMode() {
        return this.getAppContext().containsBean("tomcat.cluster");
    }

    public WebRTCClient initWebRTCClient(String streamId, WebRTCAdaptor webRTCAdaptor, String subscriberId, String clientInfo, Broadcast broadcast, List<String> enabledTracks) {
        WebRTCClient webRTCClient = new WebRTCClient(streamId, this.getVertx(), new ArrayList<String>(), this.serverSettings.getWebRTCLogLevel(), this.getDatastore());
        webRTCClient.setClientInfo(clientInfo);
        for (String trackId : broadcast.getSubTrackStreamIds()) {
            webRTCClient.enableTrack(trackId, true);
        }
        for (String trackId : enabledTracks) {
            if (trackId.startsWith("!")) {
                webRTCClient.enableTrack(trackId.replaceFirst("!", ""), false);
                continue;
            }
            webRTCClient.enableTrack(trackId, true);
        }
        String stunServerURI = this.appSettings.getStunServerURI();
        if (stunServerURI != null && !stunServerURI.isEmpty()) {
            webRTCClient.setStunServerUri(this.appSettings.getStunServerURI());
        }
        webRTCClient.setWebRTCAdaptor(webRTCAdaptor);
        webRTCClient.setPortRange(this.getAppSettings().getWebRTCPortRangeMin(), this.getAppSettings().getWebRTCPortRangeMax());
        webRTCClient.setDisableIpv6(this.getAppSettings().isDisableIPv6Candidates());
        webRTCClient.setPortAllocatorFlags(this.getAppSettings().getPortAllocatorFlags());
        WebRTCPlayStreamInfoListener infoStreamer = new WebRTCPlayStreamInfoListener(this.applicationAdaptor.getDataStore(), this, this.serverSettings);
        if ((this.getAppSettings().isTimeTokenSubscriberOnly() || this.getAppSettings().isEnableTimeTokenForPublish() || this.getAppSettings().isEnableTimeTokenForPlay()) && subscriberId != null) {
            infoStreamer.setSubscriberId(subscriberId);
        }
        webRTCClient.setStreamInfoListener(infoStreamer);
        webRTCClient.setReplaceCandidateAddressWithServerAddress(this.appSettings.isReplaceCandidateAddrWithServerAddr());
        webRTCClient.setServerAddress(this.serverSettings.getServerName());
        webRTCClient.setAppSettings(this.appSettings);
        webRTCClient.setDataChannelRouter(this.applicationAdaptor.getDataChannelRouter());
        webRTCClient.setWebRTCVertx(this.webRTCVertx);
        WebRTCViewerInfo info = new WebRTCViewerInfo();
        Object viewerId = subscriberId;
        if (subscriberId == null || subscriberId.isEmpty()) {
            viewerId = "generated_" + RandomStringUtils.randomAlphanumeric((int)10);
        }
        info.setViewerId((String)viewerId);
        info.setEdgeAddress(this.serverSettings.getHostAddress());
        info.setStreamId(streamId);
        webRTCClient.setViewerInfo(info);
        webRTCClient.setSubtrackPoller(this.applicationAdaptor.getSubtrackPoller());
        if (!broadcast.getSubTrackStreamIds().isEmpty()) {
            SubtrackPoller.SubtrackPollerListener clusterListener = this.createSubtrackPoller(webRTCClient);
            this.applicationAdaptor.getSubtrackPoller().register(streamId, clusterListener);
            webRTCClient.setSubtrackPollerListener(clusterListener);
        }
        return webRTCClient;
    }

    private void startWebRTCStreamInCluster(String streamId, List<StreamInfo> streamInfoList, String subscriberId, String viewerInfo, Broadcast broadcast, List<String> enabledTracks) {
        try {
            WebRTCClient webRTCClient = this.initWebRTCClient(streamId, this.webRTCAdaptor, subscriberId, viewerInfo, broadcast, enabledTracks);
            this.putWebRTCClientMap(this.session.getId(), webRTCClient);
            if (!broadcast.getSubTrackStreamIds().isEmpty()) {
                for (String trackId : broadcast.getSubTrackStreamIds()) {
                    List trackStreamInfoList;
                    if (this.getWebRTCAdaptor().streamExists(trackId) || (trackStreamInfoList = this.getDatastore().getStreamInfoList(trackId)) == null || trackStreamInfoList.isEmpty()) continue;
                    this.initEdgeClient(trackId, this.webRTCAdaptor, trackStreamInfoList);
                }
            } else {
                this.initEdgeClient(streamId, this.webRTCAdaptor, streamInfoList);
            }
            webRTCClient.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public SubtrackPoller.SubtrackPollerListener createSubtrackPoller(final WebRTCClient webRTCClient) {
        SubtrackPoller.SubtrackPollerListener listener = new SubtrackPoller.SubtrackPollerListener(){

            @Override
            public void onSubTracks(List<String> subTrackStreamIds) {
                for (String trackId : subTrackStreamIds) {
                    List trackStreamInfoList;
                    if (webRTCClient.getMapTrackEnable().containsKey(trackId)) continue;
                    if (!WebSocketEnterpriseHandler.this.webRTCAdaptor.streamExists(trackId) && WebSocketEnterpriseHandler.this.isClusterMode() && (trackStreamInfoList = WebSocketEnterpriseHandler.this.getDatastore().getStreamInfoList(trackId)) != null && !trackStreamInfoList.isEmpty()) {
                        WebSocketEnterpriseHandler.this.initEdgeClient(trackId, WebSocketEnterpriseHandler.this.webRTCAdaptor, trackStreamInfoList);
                    }
                    if (WebSocketEnterpriseHandler.this.webRTCAdaptor.getWebRTCMuxers(trackId) == null) continue;
                    WebSocketEnterpriseHandler.this.webRTCAdaptor.registerWebRTCClient(trackId, webRTCClient, webRTCClient.getCodec());
                    webRTCClient.addTrackOnTheFly(trackId);
                }
            }
        };
        return listener;
    }

    public synchronized List<EdgeClient> initEdgeClient(String streamId, WebRTCAdaptor webRTCAdaptor, List<StreamInfo> streamInfoList) {
        ArrayList<EdgeClient> edgeClientList = new ArrayList<EdgeClient>();
        if (webRTCAdaptor.streamExists(streamId)) {
            return edgeClientList;
        }
        boolean connectGlobalOrigin = false;
        boolean becomeLocalOrigin = true;
        String globalOriginGroup = this.findTheGlobalOriginGroup(streamInfoList);
        if (this.serverSettings.getNodeGroup().equals(globalOriginGroup)) {
            connectGlobalOrigin = true;
            becomeLocalOrigin = false;
        } else {
            connectGlobalOrigin = becomeLocalOrigin = this.shouldBecomeLocalOrigin(streamInfoList);
        }
        for (StreamInfo streamInfo : streamInfoList) {
            if ((!connectGlobalOrigin || !streamInfo.getNodeGroup().equals(globalOriginGroup)) && (connectGlobalOrigin || !streamInfo.getNodeGroup().equals(this.serverSettings.getNodeGroup()))) continue;
            EdgeClient edgeClient = new EdgeClient(streamInfo, this.getVertx(), this.webRTCVertx, this.getDatastore());
            edgeClient.setWebRTCAdaptor(webRTCAdaptor);
            edgeClient.createMuxer();
            edgeClient.setDataChannelRouter(this.applicationAdaptor.getDataChannelRouter());
            edgeClient.start((r, d) -> {});
            edgeClientList.add(edgeClient);
        }
        if (becomeLocalOrigin) {
            this.becomeLocalOrigin(streamId, webRTCAdaptor, streamInfoList, globalOriginGroup);
        }
        return edgeClientList;
    }

    private String findTheGlobalOriginGroup(List<StreamInfo> streamInfoList) {
        for (StreamInfo streamInfo : streamInfoList) {
            if (!streamInfo.isGlobalHost()) continue;
            return streamInfo.getNodeGroup();
        }
        return "default";
    }

    public boolean shouldBecomeLocalOrigin(List<StreamInfo> streamInfoList) {
        boolean becomeLocalOrigin = true;
        for (StreamInfo streamInfo : streamInfoList) {
            if (!streamInfo.getNodeGroup().equals(this.serverSettings.getNodeGroup())) continue;
            becomeLocalOrigin = false;
            break;
        }
        return becomeLocalOrigin;
    }

    public void becomeLocalOrigin(String streamId, WebRTCAdaptor webRTCAdaptor, List<StreamInfo> streamInfoList, String globalOriginGroup) {
        for (StreamInfo streamInfo : streamInfoList) {
            if (!streamInfo.getNodeGroup().equals(globalOriginGroup)) continue;
            StreamInfo si = new StreamInfo();
            si.setVideoEnabled(streamInfo.isVideoEnabled());
            si.setHeight(streamInfo.getVideoHeight());
            si.setWidth(streamInfo.getVideoWidth());
            si.setVideoBitrate(streamInfo.getVideoBitrate());
            si.setAudioEnabled(streamInfo.isAudioEnabled());
            si.setAudioBitrate(streamInfo.getAudioBitrate());
            si.setVideoRTimebase(streamInfo.getVideoRTimebase());
            si.setAudioRTimebase(streamInfo.getAudioRTimebase());
            si.setVideoCodec(streamInfo.getVideoCodec());
            si.setStreamId(streamId);
            si.setDataChannelEnabled(streamInfo.isDataChannelEnabled());
            si.setHost(this.serverSettings.getHostAddress());
            si.setNodeGroup(this.serverSettings.getNodeGroup());
            OriginServer originServer = new OriginServer(si.getStreamId(), this.vertx, si.isVideoEnabled(), si.isAudioEnabled());
            originServer.setStatusListener(new OriginServerStatusListener(webRTCAdaptor, this.getDatastore(), si, originServer));
            originServer.setDataChannelEnabled(si.isDataChannelEnabled());
            if (si.isDataChannelEnabled()) {
                originServer.setDataChannelRouter(this.getApplicationAdaptor().getDataChannelRouter());
            }
            originServer.start();
        }
    }

    public void putWebRTCClientMap(String sessionId, WebRTCClient webRTCClient) {
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
        Queue<WebRTCClient> list = webRTCClientsMap.get(sessionId);
        if (list == null) {
            list = new ConcurrentLinkedQueue<WebRTCClient>();
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!((WebRTCClient)iterator.next()).getStreamId().equals(webRTCClient.getStreamId())) continue;
                iterator.remove();
                break;
            }
        }
        list.add(webRTCClient);
        webRTCClientsMap.put(sessionId, list);
    }

    private void processGetStreamInfoCommand(String streamId) {
        List streamOptions = this.getWebRTCAdaptor().getStreamInfo(streamId);
        if (streamOptions == null && this.isClusterMode()) {
            List streamInfoList;
            streamOptions = streamInfoList = this.getDatastore().getStreamInfoList(streamId);
        }
        if (streamOptions != null && !streamOptions.isEmpty()) {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put((Object)"command", (Object)"streamInformation");
            jsonResponse.put((Object)"streamId", (Object)streamId);
            JSONArray jsonArray = new JSONArray();
            for (IStreamInfo iStreamInfo : streamOptions) {
                JSONObject streamJSON = new JSONObject();
                streamJSON.put((Object)"streamWidth", (Object)iStreamInfo.getVideoWidth());
                streamJSON.put((Object)"streamHeight", (Object)iStreamInfo.getVideoHeight());
                streamJSON.put((Object)"videoBitrate", (Object)iStreamInfo.getVideoBitrate());
                streamJSON.put((Object)"audioBitrate", (Object)iStreamInfo.getAudioBitrate());
                streamJSON.put((Object)"videoCodec", (Object)iStreamInfo.getVideoCodec().toString());
                jsonArray.add((Object)streamJSON);
            }
            jsonResponse.put((Object)"streamInfo", (Object)jsonArray);
            this.sendMessage(jsonResponse.toJSONString(), this.session);
        } else {
            this.sendNotFoundJSON(streamId, this.session);
        }
    }

    private void processSetStreamResolutionCommand(String streamId, int streamHeight) {
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
        Queue<WebRTCClient> webRTCClientList = webRTCClientsMap.get(this.session.getId());
        if (webRTCClientList != null) {
            for (WebRTCClient webRTCClient : webRTCClientList) {
                if (!webRTCClient.getStreamId().equals(streamId)) continue;
                webRTCClient.forceStreamQuality(streamHeight);
            }
        }
    }

    private void processGetRoomInfoCommand(String roomId, String streamId) {
        Map streamDetailsMap = RestServiceBase.getRoomInfoFromConference((String)roomId, (String)streamId, (DataStore)this.getDatastore());
        if (streamDetailsMap == null) {
            logger.warn("There is no room with id:{}", (Object)roomId);
            return;
        }
        this.sendRoomInformation(streamDetailsMap, roomId);
    }

    public boolean isAllowedToPublish(String subscriberId, String streamId, String subscriberCodeText, String tokenId) {
        if (this.appSettings.isEnableTimeTokenForPublish() && !this.tokenService.checkTimeBasedSubscriber(subscriberId, streamId, this.session.getId(), subscriberCodeText, true)) {
            return false;
        }
        if (this.appSettings.isPublishTokenControlEnabled()) {
            Token token = new Token();
            token.setTokenId(tokenId);
            token.setStreamId(streamId);
            token.setType("publish");
            if (this.getDatastore().validateToken(token) == null) {
                return false;
            }
        }
        if (this.appSettings.isHashControlPublishEnabled() && !this.tokenService.checkHash(tokenId, streamId, this.session.getId(), "publish")) {
            return false;
        }
        String webhookAuthURL = this.appSettings.getWebhookAuthenticateURL();
        if (webhookAuthURL != null && !webhookAuthURL.isEmpty()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("streamId", streamId);
            AcceptOnlyStreamsWithWebhook securityHandler = (AcceptOnlyStreamsWithWebhook)this.applicationAdaptor.getScope().getContext().getBean("acceptOnlyStreamsWithWebhook");
            boolean allowed = false;
            allowed = securityHandler.isPublishAllowed(this.applicationAdaptor.getScope(), this.applicationAdaptor.getScope().getName(), "mode", params);
            logger.info("Is publish allowed through Webhook Authentication: {}", (Object)allowed);
            return allowed;
        }
        return !this.appSettings.isPublishJwtControlEnabled() || this.tokenService.checkJwtToken(tokenId, streamId, "publish");
    }

    public void processPublishCommand(String streamId, boolean enableVideo, boolean enableAudio, String tokenId, String subscriberId, String subscriberCodeText, String streamName, String mainTrack) {
        String roomId = (String)this.session.getUserProperties().get(USER_ROOM_ID);
        if (this.applicationAdaptor.getPublisherListToBeStopped().containsKey(streamId)) {
            logger.info("There is a publisher in the cache to restore for stream: {}", (Object)streamId);
            WebRTCEncoderAdaptor encoderAdaptor = this.applicationAdaptor.getPublisherListToBeStopped().remove(streamId);
            encoderAdaptor.setRestored(true);
            this.applicationAdaptor.getPublisherAdaptorList().put(this.session.getId(), encoderAdaptor);
            encoderAdaptor.getInfoListener().setWebsocketHandler(this);
            encoderAdaptor.start();
            return;
        }
        List<VideoCodecInfo> enabledCodecList = VirtualVideoEncoderFactory.getEnabledCodecList(this.appSettings);
        if (enabledCodecList.isEmpty()) {
            this.sendNoCodecEnabled(streamId, this.session);
            return;
        }
        WebRTCEncoderAdaptor tmpAdaptor = this.applicationAdaptor.getPublisherAdaptorList().get(this.session.getId());
        if (tmpAdaptor != null) {
            this.sendAlreadyPublishing(streamId, this.session);
            return;
        }
        if (!this.isAllowedToPublish(subscriberId, streamId, subscriberCodeText, tokenId)) {
            this.sendUnauthorizedError(this.session);
            return;
        }
        Broadcast broadcast = this.getDatastore().get(streamId);
        if (broadcast != null) {
            String status = broadcast.getStatus();
            if ("broadcasting".equals(status) || "preparing".equals(status)) {
                logger.error("Sending stream id in use error for stream:{} session:{}", (Object)streamId, (Object)this.session.getId());
                this.sendStreamIdInUse(this.session);
                return;
            }
            if (!this.isValidStreamDate(broadcast) && roomId == null) {
                this.sendStreamTimeError(this.session);
                return;
            }
            broadcast.setStatus("preparing");
            broadcast.setName(streamName);
            broadcast.setMainTrackStreamId(mainTrack);
            this.getDatastore().updateBroadcastFields(streamId, broadcast);
        } else {
            if (this.appSettings.isAcceptOnlyStreamsInDataStore()) {
                this.sendNoAllowUnRegisteredStream(this.session);
                return;
            }
            Broadcast saveBroadcast = AntMediaApplicationAdapter.saveUndefinedBroadcast((String)streamId, (String)streamName, (AntMediaApplicationAdapter)this.getApplicationAdaptor(), (String)"preparing", (long)0L, null, (String)mainTrack);
            if (saveBroadcast == null) {
                logger.error("Not saved zombi stream {} is to data store", (Object)streamId);
            }
        }
        if (mainTrack != null) {
            Broadcast mainBroadcast = this.datastore.get(mainTrack);
            if (mainBroadcast == null) {
                if (this.appSettings.isAcceptOnlyStreamsInDataStore()) {
                    this.sendNoAllowUnRegisteredStream(this.session);
                } else {
                    mainBroadcast = new Broadcast();
                    try {
                        mainBroadcast.setStreamId(mainTrack);
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    mainBroadcast.setZombi(true);
                    mainBroadcast.setStatus("broadcasting");
                    mainBroadcast.getSubTrackStreamIds().add(streamId);
                    this.getDatastore().save(mainBroadcast);
                }
            } else {
                mainBroadcast.getSubTrackStreamIds().add(streamId);
                this.getDatastore().updateBroadcastFields(mainTrack, mainBroadcast);
            }
        }
        logger.debug("Enable audio {}  enable video {} for stream: {}, to session:{}", new Object[]{enableAudio, enableVideo, streamId, this.session.getId()});
        this.session.getUserProperties().put("ATTR_STREAM_NAME", streamId);
        WebRTCEncoderAdaptor encoderAdaptor = this.getNewWebRTCEncoderAdaptor();
        encoderAdaptor.setReplaceCandidateAddressWithServerAddress(this.appSettings.isReplaceCandidateAddrWithServerAddr());
        encoderAdaptor.setServerAddress(this.serverSettings.getServerName());
        encoderAdaptor.setVertx(this.getVertx());
        encoderAdaptor.setWebRTCAdaptor(this.getWebRTCAdaptor());
        encoderAdaptor.setDataStore(this.getDatastore());
        encoderAdaptor.setDataChannelRouter(this.applicationAdaptor.getDataChannelRouter());
        encoderAdaptor.setUserAgent(this.userAgent);
        if (broadcast != null) {
            encoderAdaptor.setRtmpEndpointList(broadcast.getEndPointList());
        }
        encoderAdaptor.setTrackEnable(enableVideo, enableAudio);
        this.applicationAdaptor.getPublisherAdaptorList().put(this.session.getId(), encoderAdaptor);
        encoderAdaptor.setWebRTCVertx(this.webRTCVertx);
        WebRTCPublishStreamInfoListener infoListener = new WebRTCPublishStreamInfoListener(this.getDatastore(), this.applicationAdaptor.getScope().getName(), this.appSettings, this, roomId, this.serverSettings);
        this.setListenerSubscriberId(subscriberId, infoListener);
        encoderAdaptor.setInfoListener(infoListener);
        encoderAdaptor.init(this.applicationAdaptor.getScope(), streamId, false);
        encoderAdaptor.start();
    }

    public void setListenerSubscriberId(String subscriberId, WebRTCPublishStreamInfoListener infoListener) {
        if (this.appSettings.isEnableTimeTokenForPublish() && subscriberId != null) {
            infoListener.setSubscriberId(subscriberId);
        }
    }

    private void sendNoCodecEnabled(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"no_codec_enabled_in_the_server");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public WebRTCEncoderAdaptor getNewWebRTCEncoderAdaptor() {
        List adaptiveResolutionList = this.appSettings.getEncoderSettings();
        if (adaptiveResolutionList == null || adaptiveResolutionList.isEmpty()) {
            return new WebRTCVideoForwarder(null, this.applicationAdaptor.getCluster(), this.appSettings, this.serverSettings.getWebRTCLogLevel());
        }
        return new WebRTCEncoderAdaptor(null, this.applicationAdaptor.getCluster(), this.serverSettings.getWebRTCLogLevel());
    }

    public void sendNoAllowUnRegisteredStream(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"not_allowed_unregistered_streams");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void signallingDisconnected(Session session) {
        Map<String, List<Session>> signallingConnections;
        List<Session> list;
        Boolean isSignallingConnection = (Boolean)session.getUserProperties().get("ATTR_SIGNALLING_CONNECTION");
        String streamId = (String)session.getUserProperties().get("ATTR_STREAM_NAME");
        if (isSignallingConnection != null && isSignallingConnection.booleanValue() && streamId != null && (list = (signallingConnections = this.applicationAdaptor.getSignallingConnections()).get(streamId)) != null) {
            Iterator<Session> iterator = list.iterator();
            while (iterator.hasNext()) {
                Session webSocketSession = iterator.next();
                if (webSocketSession.getId().equals(session.getId())) {
                    iterator.remove();
                    continue;
                }
                this.sendStopCommandJSON(streamId, webSocketSession);
            }
            if (list.isEmpty()) {
                logger.info("Removing {} from signalling connections", (Object)streamId);
                signallingConnections.remove(streamId);
            }
        }
    }

    public void processStopEverything(Session session, String roomId, boolean shutdownCompletely) {
        logger.debug("Stop command received in session {}", (Object)session.getId());
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
        Queue<WebRTCClient> webRTCClientList = webRTCClientsMap.get(session.getId());
        if (webRTCClientList != null) {
            for (WebRTCClient webRTCClient : webRTCClientList) {
                webRTCClient.stop();
            }
            if (webRTCClientList.isEmpty()) {
                webRTCClientsMap.remove(session.getId());
            }
        }
        this.stopPublisherOperations(null, shutdownCompletely);
        if (roomId != null) {
            RestServiceBase.removeStreamFromRoom((String)roomId, (String)((String)session.getUserProperties().get(USER_STREAM_ID)), (DataStore)this.getDatastore());
            this.applicationAdaptor.leftTheRoom(roomId, (String)session.getUserProperties().get(USER_STREAM_ID));
            this.sendLeavedFromRoomMessage(session, roomId);
            ConferenceRoom conferenceRoom = this.getDatastore().getConferenceRoom(roomId);
            if (conferenceRoom != null && conferenceRoom.getRoomStreamList().isEmpty() && conferenceRoom.isZombi()) {
                RestServiceBase.deleteConferenceRoom((String)roomId, (DataStore)this.getDatastore());
            }
        }
    }

    public void stopPublisherOperations(String streamId, boolean shutdownCompletely) {
        Map<String, WebRTCEncoderAdaptor> publisherAdaptorList = this.applicationAdaptor.getPublisherAdaptorList();
        WebRTCEncoderAdaptor webRTCEncoderAdaptor = publisherAdaptorList.get(this.session.getId());
        if (webRTCEncoderAdaptor != null && (streamId == null || streamId.equals(webRTCEncoderAdaptor.getStreamId()))) {
            webRTCEncoderAdaptor.stop(shutdownCompletely);
            logger.info("WebRTC Encoder adaptor stop stream Id {} for session {}", (Object)webRTCEncoderAdaptor.getStreamId(), (Object)this.session.getId());
            this.removePublisherFromSessionAdaptorList(this.session.getId());
        }
    }

    public void processStopCommand(String streamId) {
        logger.trace("Stop command received for {} in session {}", (Object)streamId, (Object)this.session.getId());
        this.stopWebRTCClients(this.session.getId(), streamId);
        this.removeWebRTCClientFromSessionMap(this.session.getId(), streamId);
        this.stopPublisherOperations(streamId, true);
    }

    public void stopWebRTCClients(String sessionId, String streamId) {
        Queue<WebRTCClient> webRTCClients = this.applicationAdaptor.getWebRTCClientsMap().get(sessionId);
        if (webRTCClients != null) {
            for (WebRTCClient webRTCClient : webRTCClients) {
                if (!webRTCClient.getStreamId().equals(streamId)) continue;
                webRTCClient.stop();
            }
        }
    }

    public void removeWebRTCClientFromSessionMap(String sessionId, String streamId) {
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
        Queue<WebRTCClient> webRTCClients = this.applicationAdaptor.getWebRTCClientsMap().get(sessionId);
        if (webRTCClients != null) {
            Iterator iterator = webRTCClients.iterator();
            while (iterator.hasNext()) {
                WebRTCClient webRTCClient = (WebRTCClient)iterator.next();
                if (!webRTCClient.getStreamId().equals(streamId)) continue;
                iterator.remove();
            }
            if (webRTCClients.isEmpty()) {
                webRTCClientsMap.remove(sessionId);
            }
        }
    }

    public void removePublisherFromSessionAdaptorList(String sessionId) {
        this.applicationAdaptor.getPublisherAdaptorList().remove(sessionId);
    }

    public void addPublisherToBeStopped(String streamId, WebRTCEncoderAdaptor encoderAdaptor) {
        this.applicationAdaptor.getPublisherListToBeStopped().put(streamId, encoderAdaptor);
    }

    public void removePublisherToBeStopped(String streamId) {
        this.applicationAdaptor.getPublisherListToBeStopped().remove(streamId);
    }

    public void processSignallingLeave(String streamId) {
        Map<String, List<Session>> signallingConnections = this.applicationAdaptor.getSignallingConnections();
        List<Session> webSocketConnections = signallingConnections.get(streamId);
        if (webSocketConnections != null) {
            Iterator<Session> iterator = webSocketConnections.iterator();
            while (iterator.hasNext()) {
                Session webSocketSession = iterator.next();
                this.sendStopCommandJSON(streamId, webSocketSession);
                if (!webSocketSession.getId().equals(this.session.getId())) continue;
                iterator.remove();
            }
            if (!webSocketConnections.isEmpty() && webSocketConnections.get(0) instanceof WSProxySession) {
                String remoteHost = ((WSProxySession)webSocketConnections.get(0)).getRemoteHost();
                webSocketConnections.clear();
                ACMRestServiceV2.sendPeerLeavedMessage(streamId, remoteHost, this.serverSettings.getDefaultHttpPort());
            }
            if (webSocketConnections.isEmpty()) {
                P2PConnection conn;
                signallingConnections.remove(streamId);
                if (this.isClusterMode() && (conn = this.getDatastore().getP2PConnection(streamId)) != null && conn.getOriginNode().contentEquals(this.serverSettings.getHostAddress())) {
                    this.getDatastore().deleteP2PConnection(streamId);
                }
            }
            JSONObject jsonResponseObject = new JSONObject();
            jsonResponseObject.put((Object)"command", (Object)"notification");
            jsonResponseObject.put((Object)"definition", (Object)"leaved");
            this.sendMessage(jsonResponseObject.toJSONString(), this.session);
        } else {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put((Object)"command", (Object)"error");
            jsonResponse.put((Object)"definition", (Object)"no_peer_associated_before");
            this.sendMessage(jsonResponse.toJSONString(), this.session);
        }
    }

    public void sendStopCommandJSON(String streamId, Session session) {
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put((Object)"command", (Object)"stop");
        jsonResponseObject.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponseObject.toJSONString(), session);
    }

    private void processTakeCandidateCommand(JSONObject jsonObject, String sessionId, String streamId) {
        Map<String, List<Session>> signallingConnections;
        List<Session> webSocketPeerConnections;
        Map<String, Queue<WebRTCClient>> webRTCClientsMap;
        Queue<WebRTCClient> webRTCClientList;
        String sdpMid = (String)jsonObject.get((Object)"id");
        String sdp = (String)jsonObject.get((Object)"candidate");
        long sdpMLineIndex = (Long)jsonObject.get((Object)"label");
        Map<String, WebRTCEncoderAdaptor> publisherAdaptorList = this.applicationAdaptor.getPublisherAdaptorList();
        WebRTCEncoderAdaptor webRTCEncoderAdaptor = publisherAdaptorList.get(sessionId);
        if (webRTCEncoderAdaptor != null) {
            IceCandidate iceCandidate = new IceCandidate(sdpMid, (int)sdpMLineIndex, sdp);
            webRTCEncoderAdaptor.addIceCandidate(iceCandidate);
        }
        if ((webRTCClientList = (webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap()).get(this.session.getId())) != null) {
            for (WebRTCClient webRTCClient : webRTCClientList) {
                if (!webRTCClient.getStreamId().equals(streamId)) continue;
                IceCandidate iceCandidate = new IceCandidate(sdpMid, (int)sdpMLineIndex, sdp);
                webRTCClient.addIceCandidate(iceCandidate);
                break;
            }
        }
        if ((webSocketPeerConnections = (signallingConnections = this.applicationAdaptor.getSignallingConnections()).get(streamId)) != null) {
            this.processSignallingTakeCandidate(streamId, webSocketPeerConnections, sdpMLineIndex, sdpMid, sdp);
        }
    }

    public void processTakeConfigurationCommand(JSONObject jsonObject, String sessionId, String streamId) {
        String typeString = (String)jsonObject.get((Object)"type");
        String sdpDescription = (String)jsonObject.get((Object)"sdp");
        SessionDescription.Type type = typeString.equals("offer") ? SessionDescription.Type.OFFER : SessionDescription.Type.ANSWER;
        if (type == SessionDescription.Type.OFFER) {
            logger.debug("received type: {} sdp: {}", (Object)type, (Object)sdpDescription);
            Map<String, WebRTCEncoderAdaptor> publisherAdaptorList = this.applicationAdaptor.getPublisherAdaptorList();
            WebRTCEncoderAdaptor webRTCEncoderAdaptor = publisherAdaptorList.get(sessionId);
            if (webRTCEncoderAdaptor != null) {
                SessionDescription sdp = new SessionDescription(type, sdpDescription);
                webRTCEncoderAdaptor.setRemoteDescription(sdp);
            } else {
                logger.warn("webRTCEncoder adaptor is not found in the session list for stream:{}", (Object)streamId);
            }
        } else {
            Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.applicationAdaptor.getWebRTCClientsMap();
            Queue<WebRTCClient> webRTCClientList = webRTCClientsMap.get(sessionId);
            if (webRTCClientList != null) {
                for (WebRTCClient webRTCClient : webRTCClientList) {
                    if (!webRTCClient.getStreamId().equals(streamId)) continue;
                    SessionDescription sdp = new SessionDescription(type, sdpDescription);
                    webRTCClient.setRemoteDescription(sdp);
                    break;
                }
            }
        }
        Map<String, List<Session>> signallingConnections = this.applicationAdaptor.getSignallingConnections();
        List<Session> webSocketPeerConnections = signallingConnections.get(streamId);
        if (webSocketPeerConnections != null) {
            this.processSignallingTakeConf(streamId, webSocketPeerConnections, typeString, sdpDescription);
        }
    }

    public boolean processSignallingTakeCandidate(String streamId, @Nonnull List<Session> webSocketPeerConnections, long sdpMLineIndex, String sdpMid, String sdp) {
        boolean result = false;
        if (webSocketPeerConnections.size() == 2) {
            for (Session webSocketSession : webSocketPeerConnections) {
                if (webSocketSession.getId().equals(this.session.getId())) continue;
                this.sendTakeCandidateMessage(sdpMLineIndex, sdpMid, sdp, streamId, webSocketSession);
                result = true;
            }
        } else {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put((Object)"command", (Object)"error");
            jsonResponse.put((Object)"definition", (Object)"no_peer_associated_before");
            this.sendMessage(jsonResponse.toJSONString(), this.session);
        }
        return result;
    }

    public void sendStartJSON(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"start");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendJoinedNotificationJSON(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"notification");
        jsonResponse.put((Object)"definition", (Object)"joined");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendNoSpaceForNewPeer(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"NoSpaceForNewPeer");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendTryWithNewId(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"connectWithNewId");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendStartNewP2PConnection(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"startNewP2PConnection");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public boolean processSignallingJoin(String streamId, boolean multiPeer, String mode) {
        boolean result = false;
        Map<String, List<Session>> signallingConnections = this.applicationAdaptor.getSignallingConnections();
        List<Session> webSocketConnections = signallingConnections.get(streamId);
        ACMRestServiceV2.setHttpPort(this.serverSettings.getDefaultHttpPort());
        String sessionMode = (String)this.session.getUserProperties().get("mode");
        if (webSocketConnections == null) {
            webSocketConnections = new ArrayList<Session>();
        } else if (webSocketConnections.contains(this.session) && !multiPeer && sessionMode != null && sessionMode.contentEquals("both")) {
            logger.info("WebRTC Peer already exists for stream id: {} and session id:{}", (Object)streamId, (Object)this.session.getId());
            this.sendAlreadyPublishing(streamId, this.session);
            return result;
        }
        if (webSocketConnections.size() < 2) {
            if (this.isClusterMode()) {
                P2PConnection p2pConn = this.getDatastore().getP2PConnection(streamId);
                if (p2pConn == null) {
                    P2PConnection conn = new P2PConnection(streamId, this.serverSettings.getHostAddress());
                    this.getDatastore().createP2PConnection(conn);
                } else if (!p2pConn.getOriginNode().contentEquals(this.serverSettings.getHostAddress())) {
                    WSProxySession proxySession = new WSProxySession(this.getAppContext(), p2pConn.getOriginNode(), streamId, this.serverSettings.getDefaultHttpPort());
                    proxySession.getUserProperties().put("ATTR_STREAM_NAME", streamId);
                    proxySession.getUserProperties().put("ATTR_SIGNALLING_CONNECTION", true);
                    webSocketConnections.add(proxySession);
                }
            }
            if (webSocketConnections.size() == 1 && multiPeer) {
                String newId = streamId + System.currentTimeMillis();
                Session masterSession = webSocketConnections.get(0);
                this.sendStartNewP2PConnection(newId, masterSession);
                this.sendTryWithNewId(newId, this.session);
                return true;
            }
            this.session.getUserProperties().put("ATTR_STREAM_NAME", streamId);
            this.session.getUserProperties().put("ATTR_SIGNALLING_CONNECTION", true);
            this.session.getUserProperties().put("mode", mode);
            webSocketConnections.add(this.session);
            signallingConnections.put(streamId, webSocketConnections);
            this.sendJoinedNotificationJSON(streamId, this.session);
            if (webSocketConnections.size() == 2) {
                for (Session session : webSocketConnections) {
                    sessionMode = (String)session.getUserProperties().get("mode");
                    if (sessionMode == null || sessionMode.contentEquals("play")) continue;
                    this.sendStartJSON(streamId, session);
                    break;
                }
            }
            result = true;
        } else {
            this.sendNoSpaceForNewPeer(streamId, this.session);
        }
        return result;
    }

    public boolean processSignallingTakeConf(String streamId, @Nonnull List<Session> webSocketSessions, String typeString, String sdpDescription) {
        boolean result = false;
        if (webSocketSessions.size() == 2) {
            for (Session sessionTmp : webSocketSessions) {
                if (sessionTmp.getId().equals(this.session.getId())) continue;
                this.sendSDPConfiguration(sdpDescription, typeString, streamId, sessionTmp);
                result = true;
            }
        } else {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put((Object)"command", (Object)"error");
            jsonResponse.put((Object)"definition", (Object)"no_peer_associated_before");
            this.sendMessage(jsonResponse.toJSONString(), this.session);
        }
        return result;
    }

    private void processEnableTrackCommand(String streamId, String trackId, boolean enabled) {
        Map<String, Queue<WebRTCClient>> webRTCClientsMap = this.getApplicationAdaptor().getWebRTCClientsMap();
        Queue<WebRTCClient> webRTCClientList = webRTCClientsMap.get(this.session.getId());
        if (webRTCClientList != null) {
            for (WebRTCClient webRTCClient : webRTCClientList) {
                if (!webRTCClient.getStreamId().equals(streamId)) continue;
                webRTCClient.enableTrack(trackId, true);
            }
        }
    }

    private void processGetTrackListCommand(String streamId, String tokenId) {
        List<String> subTracks = new ArrayList<String>();
        Broadcast broadcast = null;
        if (this.getDatastore() != null && (broadcast = this.getDatastore().get(streamId)) != null) {
            subTracks = broadcast.getSubTrackStreamIds();
        }
        this.sendTrackListMessage(streamId, subTracks, this.session);
    }

    public void sendTrackListMessage(String streamId, List<String> subTracks, Session session) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"trackList");
        jsonObject.put((Object)"streamId", (Object)streamId);
        jsonObject.put((Object)"trackList", subTracks);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public Session getSession() {
        return this.session;
    }

    private void processPeerMessageCommand(String streamId, String message) {
        Map<String, List<Session>> signallingConnections = this.applicationAdaptor.getSignallingConnections();
        List<Session> webSocketConnections = signallingConnections.get(streamId);
        for (Session session : webSocketConnections) {
            if (session == this.session) continue;
            this.sendMessage(message, session);
        }
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public void setApplicationAdaptor(WebRTCApplication applicationAdaptor) {
        this.applicationAdaptor = applicationAdaptor;
    }

    public void notifyHook(String url, String id, String action, String streamName, String category) {
        this.getVertx().setTimer(100L, handler -> this.applicationAdaptor.notifyHook(url, id, action, streamName, category, null, null));
    }

    public void sendHighResourceUsage(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"highResourceUsage");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendViewerLimitReached(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"viewerLimitReached");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendAlreadyPlaying(Session session, String streamId) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"already_playing");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendAlreadyPublishing(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"already_publishing");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public WebRTCApplication getApplicationAdaptor() {
        return this.applicationAdaptor;
    }

    public void sendEncoderNotOpenedError() {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"encoderNotOpened");
        this.sendMessage(jsonResponse.toJSONString(), this.session);
    }

    public void sendEncoderBlockedError() {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"encoderBlocked");
        this.sendMessage(jsonResponse.toJSONString(), this.session);
    }

    public void sendPublishTimeoutError(String streamId) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"publishTimeoutError");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), this.session);
    }

    public void sendPlayStartedMessage(String streamId, Session session) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"play_started");
        jsonObject.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public void sendPlayFinishedMessage(String streamId, Session session) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"play_finished");
        jsonObject.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public void sendServerWillCloaseMessage(Session session) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"server_will_stop");
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public void sendBitrateMeasurement(String streamId, int targetBitrate, int videoBitrate, int audioBitrate) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"bitrateMeasurement");
        jsonObject.put((Object)"streamId", (Object)streamId);
        jsonObject.put((Object)"targetBitrate", (Object)targetBitrate);
        jsonObject.put((Object)"videoBitrate", (Object)videoBitrate);
        jsonObject.put((Object)"audioBitrate", (Object)audioBitrate);
        this.sendMessage(jsonObject.toJSONString(), this.session);
    }

    public DataStore getDatastore() {
        return this.datastore;
    }

    public void setDatastore(DataStore datastore) {
        this.datastore = datastore;
    }

    public IStatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    public void setStatsCollector(IStatsCollector statsCollector) {
        this.statsCollector = statsCollector;
    }

    public WebRTCAdaptor getWebRTCAdaptor() {
        return this.webRTCAdaptor;
    }

    public void setWebRTCAdaptor(WebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setTokenService(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public ILicenceService getLicenceService() {
        return this.licenceService;
    }

    public void setLicenceService(ILicenceService licenceService) {
        this.licenceService = licenceService;
    }

    public void sendStreamingSessionRestoredNotification(String streamId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"session_restored");
        jsonObject.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonObject.toJSONString(), this.session);
    }
}

