/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.enterprise.adaptive.WebRTCEncoderAdaptor;
import io.antmedia.enterprise.webrtc.WebSocketEnterpriseHandler;
import io.antmedia.settings.ServerSettings;
import java.math.BigInteger;
import org.webrtc.IceCandidate;

public abstract class WebRTCStreamInfoListener {
    protected ServerSettings serverSettings;
    private WebSocketEnterpriseHandler websocketHandler;
    protected String subscriberId;
    protected DataStore dataStore;

    public abstract void requestAccepted(String var1);

    public abstract void streamingStarted(String var1);

    public abstract void streamingBeingStop(String var1, WebRTCEncoderAdaptor var2);

    public abstract void streamingStopped(String var1);

    public void iceCandidateReceived(IceCandidate candidate, String streamId) {
        String sdp = candidate.sdp;
        if (sdp != null && sdp.contains("tcp")) {
            sdp = sdp.replace(ServerSettings.getLocalHostAddress(), this.serverSettings.getHostAddress());
        }
        this.getWebsocketHandler().sendTakeCandidateMessage(candidate.sdpMLineIndex, candidate.sdpMid, sdp, streamId, this.getWebsocketHandler().getSession());
    }

    public void localDescriptionSet(String description, String type, String streamId) {
        this.getWebsocketHandler().sendSDPConfiguration(description, type, streamId, this.getWebsocketHandler().getSession());
    }

    public void localDescriptionFailure(String streamId) {
        this.getWebsocketHandler().sendLocalDescriptionSetFailure(this.getWebsocketHandler().getSession(), streamId);
    }

    public WebSocketEnterpriseHandler getWebsocketHandler() {
        return this.websocketHandler;
    }

    public void setWebsocketHandler(WebSocketEnterpriseHandler websocketHandler) {
        this.websocketHandler = websocketHandler;
    }

    public void serverWillClose() {
        this.websocketHandler.sendServerWillCloaseMessage(this.websocketHandler.getSession());
    }

    public abstract void encoderNotOpenedError(String var1);

    public abstract void encoderBlockedError(String var1, boolean var2);

    public abstract void publishTimeoutError(String var1);

    public void remoteDescriptionFailure(String streamId) {
        this.getWebsocketHandler().sendRemoteDescriptionSetFailure(this.getWebsocketHandler().getSession(), streamId);
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    public void avgBitrateMeasurement(String streamId, BigInteger videoBytesSentPerSecond, BigInteger audioBytesSentPerSecond) {
        if (this.subscriberId != null) {
            this.dataStore.updateSubscriberBitrateEvent(streamId, this.subscriberId, videoBytesSentPerSecond.longValue() * 8L, audioBytesSentPerSecond.longValue() * 8L);
        }
    }

    public void streamingSessionRestored(String streamId) {
        this.getWebsocketHandler().sendStreamingSessionRestoredNotification(streamId);
    }
}

