/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.ConnectionEvent;
import io.antmedia.enterprise.adaptive.WebRTCEncoderAdaptor;
import io.antmedia.enterprise.webrtc.WebRTCStreamInfoListener;
import io.antmedia.enterprise.webrtc.WebSocketEnterpriseHandler;
import io.antmedia.settings.ServerSettings;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.IceCandidate;

public class WebRTCPublishStreamInfoListener
extends WebRTCStreamInfoListener {
    private String scopeName;
    private AppSettings appSettings;
    private Logger logger = LoggerFactory.getLogger(WebRTCPublishStreamInfoListener.class);
    private String roomName;

    public WebRTCPublishStreamInfoListener(DataStore dataStore, String scopeName, AppSettings appSettings, WebSocketEnterpriseHandler websocketHandler, String roomName, ServerSettings serverSettings) {
        this.dataStore = dataStore;
        this.scopeName = scopeName;
        this.appSettings = appSettings;
        this.setWebsocketHandler(websocketHandler);
        this.roomName = roomName;
        this.serverSettings = serverSettings;
    }

    @Override
    public void streamingBeingStop(String streamId, WebRTCEncoderAdaptor encoderAdaptor) {
        this.getWebsocketHandler().addPublisherToBeStopped(streamId, encoderAdaptor);
    }

    @Override
    public void streamingStopped(String streamId) {
        this.getWebsocketHandler().removePublisherFromSessionAdaptorList(this.getWebsocketHandler().getSession().getId());
        this.getWebsocketHandler().removePublisherToBeStopped(streamId);
        this.getWebsocketHandler().sendPublishFinishedMessage(streamId, this.getWebsocketHandler().getSession());
        this.getWebsocketHandler().getApplicationAdaptor().closeBroadcast(streamId);
        this.dataStore.clearStreamInfoList(streamId);
        if (this.subscriberId != null) {
            ConnectionEvent event = new ConnectionEvent();
            event.setEventType("disconnected");
            Date curDate = new Date();
            event.setTimestamp(curDate.getTime());
            this.dataStore.addSubscriberConnectionEvent(streamId, this.subscriberId, event);
        }
    }

    @Override
    public void streamingStarted(String streamId) {
        this.logger.info("streaming started {}", (Object)streamId);
        this.getWebsocketHandler().getApplicationAdaptor().startPublish(streamId, System.currentTimeMillis(), "WebRTC");
        this.getWebsocketHandler().sendPublishStartedMessage(streamId, this.getWebsocketHandler().getSession(), this.roomName);
        if (this.subscriberId != null) {
            ConnectionEvent event = new ConnectionEvent();
            event.setEventType("connected");
            Date curDate = new Date();
            event.setTimestamp(curDate.getTime());
            this.dataStore.addSubscriberConnectionEvent(streamId, this.subscriberId, event);
        }
        this.logger.info("Sending publish started for {}", (Object)streamId);
    }

    @Override
    public void requestAccepted(String streamId) {
        this.getWebsocketHandler().sendStartMessage(streamId, this.getWebsocketHandler().getSession());
    }

    @Override
    public void encoderNotOpenedError(String streamId) {
        this.logger.error("Encoder not opened error for stream:{}", (Object)ExceptionUtils.getStackTrace((Throwable)new Exception()));
        this.getWebsocketHandler().sendEncoderNotOpenedError();
        this.getWebsocketHandler().getApplicationAdaptor().incrementEncoderNotOpenedError();
    }

    @Override
    public void iceCandidateReceived(IceCandidate candidate, String streamId) {
        String sdp = candidate.sdp;
        if (sdp.contains("tcp")) {
            sdp = sdp.replace(ServerSettings.getLocalHostAddress(), this.serverSettings.getHostAddress());
        }
        this.getWebsocketHandler().sendTakeCandidateMessage(candidate.sdpMLineIndex, candidate.sdpMid, sdp, streamId, this.getWebsocketHandler().getSession());
    }

    @Override
    public void encoderBlockedError(String streamId, boolean blocked) {
        this.logger.error("Encoder blocked error for stream:{} and blocked status:{}", (Object)streamId, (Object)blocked);
        this.getWebsocketHandler().sendEncoderBlockedError();
        this.getWebsocketHandler().getApplicationAdaptor().encoderBlocked(streamId, blocked);
    }

    @Override
    public void publishTimeoutError(String streamId) {
        this.logger.error("Publish timeout error for stream:{}", (Object)streamId);
        this.getWebsocketHandler().sendPublishTimeoutError(streamId);
        this.getWebsocketHandler().getApplicationAdaptor().publishTimeoutError(streamId);
    }
}

