/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.ConnectionEvent;
import io.antmedia.enterprise.adaptive.WebRTCEncoderAdaptor;
import io.antmedia.enterprise.webrtc.WebRTCStreamInfoListener;
import io.antmedia.enterprise.webrtc.WebSocketEnterpriseHandler;
import io.antmedia.settings.ServerSettings;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRTCPlayStreamInfoListener
extends WebRTCStreamInfoListener {
    private static Logger logger = LoggerFactory.getLogger(WebRTCPlayStreamInfoListener.class);
    private boolean streamingStarted = false;

    public WebRTCPlayStreamInfoListener(DataStore dataStore, WebSocketEnterpriseHandler websocketHandler, ServerSettings serverSettings) {
        this.dataStore = dataStore;
        this.setWebsocketHandler(websocketHandler);
        this.serverSettings = serverSettings;
    }

    @Override
    public void streamingStarted(String streamId) {
        this.getWebsocketHandler().sendPlayStartedMessage(streamId, this.getWebsocketHandler().getSession());
        this.streamingStarted = true;
        this.dataStore.updateWebRTCViewerCount(streamId, true);
        if (this.subscriberId != null) {
            ConnectionEvent event = new ConnectionEvent();
            event.setEventType("connected");
            Date curDate = new Date();
            event.setTimestamp(curDate.getTime());
            this.dataStore.addSubscriberConnectionEvent(streamId, this.subscriberId, event);
        }
        logger.info("A new viewer started streaming of {}", (Object)streamId);
    }

    @Override
    public void streamingBeingStop(String streamId, WebRTCEncoderAdaptor encoderAdaptor) {
    }

    @Override
    public void streamingStopped(String streamId) {
        this.getWebsocketHandler().removeWebRTCClientFromSessionMap(this.getWebsocketHandler().getSession().getId(), streamId);
        if (this.streamingStarted) {
            this.dataStore.updateWebRTCViewerCount(streamId, false);
            if (this.subscriberId != null) {
                ConnectionEvent event = new ConnectionEvent();
                event.setEventType("disconnected");
                Date curDate = new Date();
                event.setTimestamp(curDate.getTime());
                this.dataStore.addSubscriberConnectionEvent(streamId, this.subscriberId, event);
            }
            this.streamingStarted = false;
        }
        this.getWebsocketHandler().sendPlayFinishedMessage(streamId, this.getWebsocketHandler().getSession());
        logger.info("A viewer stopped streaming for {}", (Object)streamId);
    }

    @Override
    public void requestAccepted(String streamId) {
    }

    @Override
    public void encoderNotOpenedError(String streamId) {
    }

    @Override
    public void encoderBlockedError(String streamId, boolean blocked) {
    }

    @Override
    public void publishTimeoutError(String streamId) {
    }

    public void birateMeasurement(String streamId, int targetBitrate, int videoBitrate, int audioBitrate) {
        this.getWebsocketHandler().sendBitrateMeasurement(streamId, targetBitrate, videoBitrate, audioBitrate);
    }
}

