/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.VideoCodec;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVBitStreamFilter;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.NaluIndex;

public class WebRTCMuxer
extends Muxer
implements IWebRTCMuxer {
    private IWebRTCAdaptor webRTCAdaptor;
    private Queue<IWebRTCClient> webRTCClientList = new ConcurrentLinkedQueue<IWebRTCClient>();
    protected String streamId;
    private int width;
    private int height;
    private int videoBitrate;
    private int audioBitrate;
    protected int videoStreamIndex = -1;
    protected int audioStreamIndex = -1;
    private AtomicInteger clientCount = new AtomicInteger(0);
    private volatile boolean isPrepareIOCalled = false;
    private AVRational videoTimebase;
    private AVRational audioTimebase;
    protected static Logger logger = LoggerFactory.getLogger(WebRTCMuxer.class);
    private AVRational timeBaseForMS;
    private long totalSendVideoPacketCallInterval;
    private long lastSendVideoPacketCallTime;
    private long videoPacketCount;
    private long lastSendAudioPacketCallTime;
    private long totalSendAudioPacketCallInterval;
    private int audioPacketCount;
    private long totalVideoProcessingTime;
    private long totalAudioProcessingTime;
    private volatile boolean isStopped = false;
    private AVBSFContext bsfContext;
    private AVPacket tmpPacket;
    private AVRational outStreamTimebase;
    private byte[] extradata = null;
    private VideoCodec codec;
    private long absoluteStartTimeMs;
    private long absouteTotalLatencyUntilRTPPacketizingTimeMs = 0L;
    private long frameId;
    private long captureTimeMs;
    private MovingTimeAverage bitrateMeasurement = new MovingTimeAverage(10);

    public WebRTCMuxer(IWebRTCAdaptor webRTCAdaptor) {
        super(null);
        this.webRTCAdaptor = webRTCAdaptor;
        this.timeBaseForMS = new AVRational();
        this.timeBaseForMS.num(1);
        this.timeBaseForMS.den(1000);
    }

    public void init(IScope scope, String name, int resolutionHeight, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.height = resolutionHeight;
            this.streamId = name;
        }
    }

    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    public void registerToAdaptor() {
        this.webRTCAdaptor.registerMuxer(this.streamId, (IWebRTCMuxer)this);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public int getVideoHeight() {
        return this.height;
    }

    public int getVideoWidth() {
        return this.width;
    }

    public int getVideoBitrate() {
        if (this.videoBitrate == 0) {
            return (int)(this.bitrateMeasurement.getTimeAverage() * 8.0 * 1000.0);
        }
        return this.videoBitrate;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public void registerWebRTCClient(IWebRTCClient webRTCClient) {
        if (this.codec == null) {
            throw new IllegalStateException("Codec cannot be null in WebRTCMuxer. Set the codec parameter");
        }
        webRTCClient.setVideoResolution(this.width, this.height);
        webRTCClient.addWebRTCMuxer((IWebRTCMuxer)this);
        this.webRTCClientList.add(webRTCClient);
        int count = this.clientCount.incrementAndGet();
        logger.info("register webrtc client({}) to webrtc muxer({}p - codec:{}) for stream: {} current viewer count:{}", new Object[]{webRTCClient.hashCode(), this.height, this.codec, this.streamId, count});
    }

    public boolean unRegisterWebRTCClient(IWebRTCClient webRTCClient) {
        boolean result = this.webRTCClientList.remove(webRTCClient);
        if (result) {
            this.clientCount.decrementAndGet();
        }
        logger.info("unregister webrtc client({}) to webrtc muxer({}p - codec:{}) for stream: {} current viewer count:{} decremented:{}", new Object[]{webRTCClient.hashCode(), this.height, this.codec, this.streamId, this.clientCount.intValue(), result});
        return result;
    }

    private List<NaluIndex> findNaluIndices(ByteBuffer buffer) {
        int kNaluShortStartSequenceSize = 3;
        ArrayList<NaluIndex> naluSequence = new ArrayList<NaluIndex>();
        int size = 0;
        if (buffer.limit() >= kNaluShortStartSequenceSize) {
            int end = buffer.limit() - kNaluShortStartSequenceSize;
            int i = 0;
            while (i < end) {
                if (buffer.get(i + 2) > 1) {
                    i += 3;
                    continue;
                }
                if (buffer.get(i + 2) == 1 && buffer.get(i + 1) == 0 && buffer.get(i) == 0) {
                    NaluIndex index = new NaluIndex(i, i + 3, 0);
                    if (index.startOffset > 0 && buffer.get(index.startOffset - 1) == 0) {
                        --index.startOffset;
                    }
                    if ((size = naluSequence.size()) >= 1) {
                        ((NaluIndex)naluSequence.get((int)(size - 1))).payloadSize = index.startOffset - ((NaluIndex)naluSequence.get((int)(size - 1))).payloadStartOffset;
                    }
                    naluSequence.add(index);
                    i += 3;
                    continue;
                }
                ++i;
            }
        }
        if ((size = naluSequence.size()) >= 1) {
            ((NaluIndex)naluSequence.get((int)(size - 1))).payloadSize = buffer.limit() - ((NaluIndex)naluSequence.get((int)(size - 1))).payloadStartOffset;
        }
        naluSequence.removeIf(naluIndex -> naluIndex.payloadSize == 0);
        return naluSequence;
    }

    public void sendVideoPacket(ByteBuffer videoPacket, boolean isKeyFrame, long timestampMs, int frameRotation) {
        this.sendVideoPacketInternal(videoPacket, isKeyFrame, timestampMs, frameRotation, this.streamId);
    }

    public void sendTrackVideoPacket(ByteBuffer videoPacket, boolean isKeyFrame, long timestampMs, int frameRotation, String trackId) {
        this.sendVideoPacketInternal(videoPacket, isKeyFrame, timestampMs, frameRotation, trackId);
    }

    public void sendVideoPacketInternal(ByteBuffer videoPacket, boolean isKeyFrame, long timestampMs, int frameRotation, String trackId) {
        ArrayList naluIndices = null;
        if (this.codec == VideoCodec.H264 || this.codec == VideoCodec.H265) {
            naluIndices = this.findNaluIndices(videoPacket);
        }
        ArrayList finalNaluIndices = naluIndices == null ? new ArrayList() : naluIndices;
        long timestampNs = timestampMs * 1000000L;
        this.webRTCClientList.parallelStream().forEach(client -> client.sendVideoPacket(videoPacket, isKeyFrame, timestampNs, frameRotation, finalNaluIndices, trackId));
    }

    public void writeAudioBuffer(ByteBuffer originalBuffer, int i, long timestamp) {
        originalBuffer.rewind();
        ByteBuffer buffer = ByteBuffer.allocateDirect(originalBuffer.limit());
        buffer.put(originalBuffer);
        buffer.rewind();
        this.sendAudioPacket(buffer, timestamp);
    }

    public void sendAudioPacket(ByteBuffer audioPacket, long timestamp) {
        this.sendAudioPacketInternal(audioPacket, timestamp, this.streamId);
    }

    public void sendTrackAudioPacket(ByteBuffer audioPacket, long timestamp, String trackId) {
        this.sendAudioPacketInternal(audioPacket, timestamp, trackId);
    }

    public void sendAudioPacketInternal(ByteBuffer audioPacket, long timestamp, String trackId) {
        this.webRTCClientList.parallelStream().forEach(client -> client.sendAudioPacket(audioPacket, timestamp, trackId));
    }

    public boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        if (codecParameters.codec_type() == 0) {
            this.videoStreamIndex = streamIndex;
            this.width = codecParameters.width();
            this.height = codecParameters.height();
            this.videoBitrate = (int)codecParameters.bit_rate();
            this.videoTimebase = timebase;
            this.extradata = new byte[codecParameters.extradata_size()];
            if (this.extradata.length > 0) {
                BytePointer extraDataPointer = codecParameters.extradata();
                extraDataPointer.get(this.extradata).close();
                extraDataPointer.close();
                logger.info("extra data 0: {}  1: {}, 2:{}, 3:{}, 4:{}", new Object[]{this.extradata[0], this.extradata[1], this.extradata[2], this.extradata[3], this.extradata[4]});
            }
        } else if (codecParameters.codec_type() == 1) {
            this.audioStreamIndex = streamIndex;
            this.audioBitrate = (int)codecParameters.bit_rate();
            this.audioTimebase = timebase;
        } else {
            logger.warn("Codec type is not video or audio for stream:{}", (Object)this.streamId);
        }
        return true;
    }

    public boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVCodecParameters codecParameter = new AVCodecParameters();
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)codecParameter, (AVCodecContext)codecContext);
        if (ret < 0) {
            logger.error("Cannot get codec parameters for {}", (Object)this.streamId);
        }
        return this.addStream(codecParameter, codecContext.time_base(), streamIndex);
    }

    public synchronized boolean prepareIO() {
        if (!this.isPrepareIOCalled) {
            this.isPrepareIOCalled = true;
            this.registerToAdaptor();
        }
        return true;
    }

    public synchronized void writeTrailer() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        if (this.tmpPacket != null) {
            avcodec.av_packet_unref((AVPacket)this.tmpPacket);
            this.tmpPacket = null;
        }
        if (this.timeBaseForMS != null) {
            this.timeBaseForMS.close();
            this.timeBaseForMS = null;
        }
        if (this.bsfContext != null) {
            this.bsfContext.close();
            this.bsfContext = null;
        }
        if (this.videoTimebase != null) {
            this.videoTimebase.close();
            this.videoTimebase = null;
        }
        if (this.outStreamTimebase != null) {
            this.outStreamTimebase.close();
            this.outStreamTimebase = null;
        }
        this.webRTCAdaptor.unRegisterMuxer(this.streamId, (IWebRTCMuxer)this);
        if (this.videoPacketCount > 0L) {
            logger.info("Average write packet call interval for video {}ms average video packet processing time {}ms video packet count: {} for stream:{}", new Object[]{this.totalSendVideoPacketCallInterval / this.videoPacketCount, this.totalVideoProcessingTime / this.videoPacketCount, this.videoPacketCount, this.streamId});
        }
        if (this.audioPacketCount > 0) {
            logger.info("Average write packet call interval: {}ms average audio processing time: {}ms  audio packet count: {} for stream:{}", new Object[]{this.totalSendAudioPacketCallInterval / (long)this.audioPacketCount, this.totalAudioProcessingTime / (long)this.audioPacketCount, this.audioPacketCount, this.streamId});
        }
        this.webRTCClientList.parallelStream().forEach(iWebRTCClient -> {
            logger.info("WebRTC Client {} video frame average sent period: {}  audio frame average period: {} for stream:{} type:{}", new Object[]{iWebRTCClient.hashCode(), Float.valueOf(iWebRTCClient.getVideoFrameSentPeriod()), Float.valueOf(iWebRTCClient.getAudioFrameSentPeriod()), this.streamId, iWebRTCClient.getClass().getSimpleName()});
            iWebRTCClient.removeWebRTCMuxer((IWebRTCMuxer)this);
        });
    }

    public void writePacket(AVPacket avpacket, AVStream inStream) {
    }

    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContex) {
        long now = System.currentTimeMillis();
        if (pkt.stream_index() == this.videoStreamIndex) {
            ByteBuffer byteBuffer;
            boolean isKeyFrame = false;
            if ((pkt.flags() & 1) == 1) {
                isKeyFrame = true;
            }
            long dts = avutil.av_rescale_q((long)pkt.dts(), (AVRational)this.videoTimebase, (AVRational)this.timeBaseForMS);
            if (isKeyFrame) {
                byteBuffer = ByteBuffer.allocateDirect(this.extradata.length + pkt.size());
                byteBuffer.put(this.extradata);
                byteBuffer.put(pkt.data().position(0L).limit((long)pkt.size()).asByteBuffer());
            } else {
                byteBuffer = ByteBuffer.allocateDirect(pkt.size());
                byteBuffer.put(pkt.data().position(0L).limit((long)pkt.size()).asByteBuffer());
            }
            logger.trace("nal type:{} and key frame: {}", (Object)byteBuffer.get(4), (Object)isKeyFrame);
            this.sendVideoPacket(byteBuffer, isKeyFrame, dts, 0);
            this.totalSendVideoPacketCallInterval += this.lastSendVideoPacketCallTime != 0L ? now - this.lastSendVideoPacketCallTime : 0L;
            ++this.videoPacketCount;
            this.totalVideoProcessingTime += System.currentTimeMillis() - now;
            this.lastSendVideoPacketCallTime = now;
            this.absouteTotalLatencyUntilRTPPacketizingTimeMs += System.currentTimeMillis() - this.absoluteStartTimeMs - dts;
        } else if (pkt.stream_index() == this.audioStreamIndex) {
            long dts = avutil.av_rescale_q((long)pkt.dts(), (AVRational)this.audioTimebase, (AVRational)this.timeBaseForMS);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(pkt.size());
            byteBuffer.put(pkt.data().position(0L).limit((long)pkt.size()).asByteBuffer());
            this.sendAudioPacket(byteBuffer, dts);
            this.totalSendAudioPacketCallInterval += this.lastSendAudioPacketCallTime != 0L ? now - this.lastSendAudioPacketCallTime : 0L;
            ++this.audioPacketCount;
            this.totalAudioProcessingTime += System.currentTimeMillis() - now;
            this.lastSendAudioPacketCallTime = now;
        }
    }

    public boolean addVideoStream(int width, int height, AVRational videoTimebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        this.width = width;
        this.height = height;
        this.videoStreamIndex = streamIndex;
        this.videoTimebase = videoTimebase;
        if (isAVC) {
            this.tmpPacket = new AVPacket();
            avcodec.av_init_packet((AVPacket)this.tmpPacket);
            AVBitStreamFilter h264bsfc = avcodec.av_bsf_get_by_name((String)"h264_mp4toannexb");
            this.bsfContext = new AVBSFContext(null);
            int ret = avcodec.av_bsf_alloc((AVBitStreamFilter)h264bsfc, (AVBSFContext)this.bsfContext);
            if (ret < 0) {
                logger.info("cannot allocate bsf context for {}", (Object)this.file.getName());
                h264bsfc.close();
                return false;
            }
            ret = avcodec.avcodec_parameters_copy((AVCodecParameters)this.bsfContext.par_in(), (AVCodecParameters)codecpar);
            this.videoBitrate = (int)codecpar.bit_rate();
            if (ret < 0) {
                logger.info("cannot copy input codec parameters for {}", (Object)this.streamId);
                h264bsfc.close();
                return false;
            }
            this.bsfContext.time_base_in(videoTimebase);
            ret = avcodec.av_bsf_init((AVBSFContext)this.bsfContext);
            if (ret < 0) {
                if (logger.isWarnEnabled()) {
                    byte[] error = new byte[1024];
                    avutil.av_strerror((int)ret, (byte[])error, (long)error.length);
                    logger.warn("cannot init bit stream filter context for {} error: {}", (Object)this.streamId, (Object)new String(error, 0, error.length));
                }
                h264bsfc.close();
                return false;
            }
            this.videoTimebase = this.bsfContext.time_base_out();
            this.outStreamTimebase = new AVRational();
            this.outStreamTimebase.num(1);
            this.outStreamTimebase.den(1000);
            h264bsfc.close();
        } else if (codecpar != null) {
            this.extradata = new byte[codecpar.extradata_size()];
            if (this.extradata.length > 0) {
                BytePointer extraDataPointer = codecpar.extradata();
                extraDataPointer.get(this.extradata).close();
                extraDataPointer.close();
                logger.info("extra data 0: {}  extra data 1: {}, 2:{}, 3:{}, 4:{}", new Object[]{this.extradata[0], this.extradata[1], this.extradata[2], this.extradata[3], this.extradata[4]});
            }
        }
        return true;
    }

    public void writeVideoBuffer(ByteBuffer originalBuffer, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        ByteBuffer buffer;
        long now = System.currentTimeMillis();
        originalBuffer.rewind();
        if (isKeyFrame) {
            if (originalBuffer.limit() > 4) {
                byte nalType = (byte)(originalBuffer.get(4) & 0x1F);
                if (nalType != 7 && this.extradata != null) {
                    buffer = ByteBuffer.allocateDirect(this.extradata.length + originalBuffer.limit());
                    buffer.put(this.extradata);
                } else {
                    buffer = ByteBuffer.allocateDirect(originalBuffer.limit());
                }
            } else {
                buffer = ByteBuffer.allocateDirect(originalBuffer.limit());
            }
        } else {
            buffer = ByteBuffer.allocateDirect(originalBuffer.limit());
        }
        buffer.put(originalBuffer);
        buffer.rewind();
        if (this.bsfContext != null) {
            this.tmpPacket.data(new BytePointer(buffer));
            this.tmpPacket.size(buffer.limit());
            this.tmpPacket.pts(pts);
            this.tmpPacket.dts(dts);
            int ret = avcodec.av_bsf_send_packet((AVBSFContext)this.bsfContext, (AVPacket)this.tmpPacket);
            if (ret < 0) {
                logger.error("Cannot send packet to bitstream filter in stream: {}", (Object)this.streamId);
                return;
            }
            while (avcodec.av_bsf_receive_packet((AVBSFContext)this.bsfContext, (AVPacket)this.tmpPacket) == 0) {
                ByteBuffer data = ByteBuffer.allocateDirect(this.tmpPacket.size());
                data.put(this.tmpPacket.data().position(0L).limit((long)this.tmpPacket.size()).asByteBuffer());
                long packetTimebase = avutil.av_rescale_q((long)dts, (AVRational)this.videoTimebase, (AVRational)this.outStreamTimebase);
                this.sendVideoPacket(data, false, packetTimebase, frameRotation);
                this.absouteTotalLatencyUntilRTPPacketizingTimeMs += System.currentTimeMillis() - this.absoluteStartTimeMs - packetTimebase;
            }
            this.totalSendVideoPacketCallInterval += this.lastSendVideoPacketCallTime != 0L ? now - this.lastSendVideoPacketCallTime : 0L;
            ++this.videoPacketCount;
            this.totalVideoProcessingTime += System.currentTimeMillis() - now;
            this.lastSendVideoPacketCallTime = now;
        } else {
            logger.trace("frame type: {}", buffer.limit() > 4 ? Byte.valueOf(buffer.get(4)) : "");
            this.sendVideoPacket(buffer, isKeyFrame, dts, frameRotation);
            this.absouteTotalLatencyUntilRTPPacketizingTimeMs += System.currentTimeMillis() - this.absoluteStartTimeMs - dts;
        }
        this.bitrateMeasurement.add(buffer.limit(), now);
    }

    public boolean contains(IWebRTCClient webRTCClient) {
        return this.webRTCClientList.contains(webRTCClient);
    }

    public void setBitrate(int videoBitrate, int audioBitrate) {
        this.videoBitrate = videoBitrate;
        this.audioBitrate = audioBitrate;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public AVRational getVideoTimebase() {
        return this.videoTimebase;
    }

    public void setVideoTimebase(AVRational videoTimebase) {
        this.videoTimebase = videoTimebase;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public AVRational getAudioTimebase() {
        return this.audioTimebase;
    }

    public void setAudioTimebase(AVRational audioTimebase) {
        this.audioTimebase = audioTimebase;
    }

    public Queue<IWebRTCClient> getClientList() {
        return this.webRTCClientList;
    }

    public int getClientCount() {
        return this.clientCount.intValue();
    }

    public int getAudioPacketCount() {
        return this.audioPacketCount;
    }

    public long getVideoPacketCount() {
        return this.videoPacketCount;
    }

    public long getTotalVideoProcessingTime() {
        return this.totalVideoProcessingTime;
    }

    public VideoCodec getVideoCodec() {
        return this.codec;
    }

    public void setCodec(VideoCodec codec) {
        this.codec = codec;
    }

    public void setAbsoluteStartTimeMs(long absoluteStartTimeMs) {
        this.absoluteStartTimeMs = absoluteStartTimeMs;
    }

    public long getAbsoluteStartTimeMs() {
        return this.absoluteStartTimeMs;
    }

    public long getAbsouteTotalLatencyUntilRTPPacketizingTimeMs() {
        return this.absouteTotalLatencyUntilRTPPacketizingTimeMs;
    }

    public void setFrameIdAndCaptureTimeMs(long frameId, long captureTimeMs) {
        this.frameId = frameId;
        this.captureTimeMs = captureTimeMs;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public long getCaptureTimeMs() {
        return this.captureTimeMs;
    }

    public static class MovingTimeAverage {
        private Object lock = new Object();
        Queue<Pair<Double, Long>> values = new LinkedList<Pair<Double, Long>>();
        int windowSize;

        public MovingTimeAverage(int size) {
            this.windowSize = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(double value, long time) {
            Object object = this.lock;
            synchronized (object) {
                this.values.offer((Pair<Double, Long>)new ImmutablePair((Object)value, (Object)time));
                if (this.values.size() > this.windowSize) {
                    this.values.poll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getTimeAverage() {
            Object object = this.lock;
            synchronized (object) {
                if (this.values.isEmpty()) {
                    return 0.0;
                }
                if (this.values.size() == 1) {
                    return (Double)this.values.peek().getLeft();
                }
                double totalValue = 0.0;
                long t0 = (Long)this.values.peek().getRight();
                long t1 = t0 + 1L;
                for (Pair pair : this.values) {
                    totalValue += ((Double)pair.getLeft()).doubleValue();
                    t1 = (Long)pair.getRight();
                }
                return totalValue / (double)(t1 - t0);
            }
        }
    }
}

