/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.AppSettings;
import io.antmedia.cluster.IStreamInfo;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import io.antmedia.enterprise.adaptive.WebRTCEncoderAdaptor;
import io.antmedia.enterprise.webrtc.DataChannelRouter;
import io.antmedia.enterprise.webrtc.IDataChannelMessageSender;
import io.antmedia.enterprise.webrtc.SubtrackPoller;
import io.antmedia.enterprise.webrtc.WebRTCPlayStreamInfoListener;
import io.antmedia.enterprise.webrtc.WebRTCStreamInfoListener;
import io.antmedia.enterprise.webrtc.codec.VirtualVideoEncoderFactory;
import io.antmedia.statistic.type.WebRTCAudioSendStats;
import io.antmedia.statistic.type.WebRTCVideoSendStats;
import io.antmedia.webrtc.VideoCodec;
import io.antmedia.webrtc.api.IAudioRecordListener;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.CapturerObserver;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.NaluIndex;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RTCStats;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioRecord;

public class WebRTCClient
implements IWebRTCClient,
PeerConnection.Observer,
SdpObserver,
IDataChannelMessageSender {
    public static final String LOCAL_IPv4_127_0_0_1 = "127.0.0.1";
    public static final String LOCAL_IPv6_127_0_0_1 = "::1";
    private static final String FALSE = "false";
    private MediaConstraints audioConstraints;
    private MediaConstraints sdpMediaConstraints;
    private PeerConnectionFactory peerConnectionFactory;
    protected PeerConnection peerConnection;
    private ArrayList<VideoSource> videoSources = new ArrayList();
    private AudioSource audioSource;
    private IWebRTCAdaptor webRTCAdaptor;
    protected String streamId;
    private Map<String, IWebRTCMuxer> registeredWebRTCMuxers = new LinkedHashMap<String, IWebRTCMuxer>();
    protected static Logger logger = LoggerFactory.getLogger(WebRTCClient.class);
    protected VirtualVideoEncoderFactory encoderFactory;
    public static final int ADAPTIVE_RESET_COUNT = 90;
    public static final int ADAPTIVE_QUALITY_CHECK_TIME_MS = 5000;
    private volatile boolean isInitialized = false;
    private AtomicBoolean stopCalled = new AtomicBoolean(false);
    private volatile boolean isStreaming = false;
    private long adaptStreamScheduledFuture = -1L;
    private volatile boolean remoteDescriptionSet = false;
    private WebRTCPlayStreamInfoListener iWebRTCStreamInfoListener;
    private boolean debugIsFullyFinished = false;
    private long timeToCallStart = 0L;
    private long timeToCallStartStreaming = 0L;
    private long timeToCallStop = 0L;
    protected long fullyStoppedTime = 0L;
    protected long lastVideoPacketSentTime = 0L;
    public static final String VIDEO_TRACK_ID = "ARDAMSv";
    public static final String AUDIO_TRACK_ID = "ARDAMSa";
    private int streamHeight = 0;
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String OUTBOUND_RTP = "outbound-rtp";
    private static final String AUDIO = "audio";
    private static final String MEDIA_TYPE = "mediaType";
    private static final String PACKETS_SENT = "packetsSent";
    private static final String BYTES_SENT = "bytesSent";
    private static final String VIDEO = "video";
    private static final String NACK_COUNT = "nackCount";
    private static final String PLI_COUNT = "pliCount";
    private static final String FIR_COUNT = "firCount";
    private static final String FRAME_ENCODED = "framesEncoded";
    private AtomicInteger excessiveBandwidthCount = new AtomicInteger(0);
    private long lastSendVideoPacketCallTime;
    private long totalSendVideoPacketCallInterval;
    private long sendVideoPacketCallCount = 0L;
    private long sendAudioPacketCallCount = 0L;
    private long totalSendAudioPacketCallInterval;
    private long lastSendAudioPacketCallTime;
    protected Vertx vertx;
    private String stunServerUri = "stun:stun1.l.google.com:19302";
    private WebRtcAudioRecord audioRecord;
    private ArrayList<CapturerObserver> capturerObservers = new ArrayList();
    Semaphore sem = new Semaphore(1);
    Queue<IceCandidate> iceCandidateQueue = new ConcurrentLinkedQueue<IceCandidate>();
    private int webRTCPortRangeMin = 0;
    private int webRTCPortRangeMax = 0;
    private long startTime;
    private IAudioPacketSender audioSender;
    private long lastKnownAudioPacketsSent;
    private BigInteger lastKnownAudioBytesSent = BigInteger.ZERO;
    private long lastKnownVideoPacketsSent;
    private BigInteger lastKnownVideoBytesSent = BigInteger.ZERO;
    private long lastKnownFramesEncoded;
    private double lastKnownStatsTimeStampMs = 0.0;
    private WebRTCVideoSendStats videoStats;
    private WebRTCAudioSendStats audioStats;
    private JavaAudioDeviceModule adm;
    private int portAllocatorFlags = 0;
    private AtomicInteger tryCountBeforeSwitchback = new AtomicInteger(0);
    private int cachedPacketLoss;
    private int cachedRttMeasurement;
    private boolean replaceCandidateAddressWithServerAddress;
    private String serverAddress;
    private boolean disableIpv6 = true;
    private Map<String, Boolean> mapVideoTrackEnable;
    private Map<String, Boolean> mapAudioTrackEnable;
    private AppSettings appSettings;
    private IVideoPacketSender videoSender;
    protected DataChannel dataChannel;
    private DataChannelRouter dataChannelRouter;
    private VideoCodec codec;
    private List<IStreamInfo> streamInfoList;
    private boolean noVideo;
    private Vertx webRTCVertx;
    private Context signallingContext;
    private long nativeStatsTimer = -1L;
    private Logging.Severity webrtcLogLevel = Logging.Severity.LS_WARNING;
    private String clientInfo;
    private SubtrackPoller subtrackPoller;
    private SubtrackPoller.SubtrackPollerListener subtrackPollerListener;
    private WebRTCViewerInfo viewerInfo;
    private DataStore datastore;
    private String currentlyAddingTrackId = null;

    public int getForceStreamHeight() {
        return this.streamHeight;
    }

    public void forceStreamQuality(int streamHeight) {
        this.streamHeight = streamHeight;
        if (this.webRTCAdaptor != null && streamHeight != 0) {
            this.webRTCAdaptor.forceStreamingQuality(this.streamId, (IWebRTCClient)this, streamHeight);
        }
    }

    public WebRTCClient(String streamId, Vertx vertx, List<String> subTracks, Logging.Severity logLevel, DataStore dataStore) {
        this.streamId = streamId;
        this.vertx = vertx;
        this.mapVideoTrackEnable = new HashMap<String, Boolean>();
        this.mapVideoTrackEnable.put(streamId, subTracks.isEmpty());
        for (String trackId : subTracks) {
            this.mapVideoTrackEnable.put(trackId, false);
        }
        this.mapAudioTrackEnable = new HashMap<String, Boolean>();
        this.mapAudioTrackEnable.put(streamId, subTracks.isEmpty());
        for (String trackId : subTracks) {
            this.mapAudioTrackEnable.put(trackId, false);
        }
        logger.info("WebRTCClient created video = {} audio = {} streamId:{}", new Object[]{this.mapVideoTrackEnable.get(streamId), this.mapAudioTrackEnable.get(streamId), streamId});
        this.setAudioSender((t, p) -> logger.debug("Audio Sender is not set yet for {} and client {}", (Object)streamId, (Object)this.hashCode()));
        this.setVideoSender((encodedFrameBuffer, isKeyFrame, timestampNs, frameRotation, naluIndices, trackIndex) -> logger.debug("Video Sender is not set yet for {} and client {}", (Object)streamId, (Object)this.hashCode()));
        this.webrtcLogLevel = logLevel;
        this.datastore = dataStore;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public List<String> getSubTracks() {
        ArrayList<String> subTracks = new ArrayList<String>();
        subTracks.addAll(this.mapVideoTrackEnable.keySet());
        return subTracks;
    }

    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    public void sendVideoPacket(ByteBuffer data, boolean isKeyFrame, long timestampNs, int frameRotation, List<NaluIndex> naluIndices, String trackId) {
        logger.trace("Nalu indices size: {} streamId:{}  client hash:{}", new Object[]{naluIndices.size(), this.streamId, this.hashCode()});
        this.videoSender.sendVideo(data, isKeyFrame, timestampNs, frameRotation, naluIndices, trackId);
    }

    public void sendAudioPacket(ByteBuffer audioPacket, long timestamp, String trackId) {
        if (this.mapAudioTrackEnable.get(trackId).booleanValue()) {
            long now = System.currentTimeMillis();
            ++this.sendAudioPacketCallCount;
            this.totalSendAudioPacketCallInterval += this.lastSendAudioPacketCallTime != 0L ? now - this.lastSendAudioPacketCallTime : 0L;
            this.lastSendAudioPacketCallTime = now;
            this.audioSender.sendAudio(AUDIO_TRACK_ID + trackId, audioPacket);
        }
    }

    public void addTrackOnTheFly(String trackId) {
        logger.info("new track {} is added to {}", (Object)trackId, (Object)this.streamId);
        this.enableTrack(trackId, false);
        this.vertx.executeBlocking(ll -> {
            this.acquireOfferCreateSemaphore();
            if (this.isStreaming()) {
                this.encoderFactory.createNewEncoder(trackId);
                List<String> mediaStreamLabels = Collections.singletonList("ARDAMS");
                this.executeOnSignallingThread(() -> {
                    this.addTracks(mediaStreamLabels, trackId);
                    this.currentlyAddingTrackId = trackId;
                    this.peerConnection.createOffer((SdpObserver)this, this.sdpMediaConstraints);
                });
                if (this.getAppSettings().isDataChannelEnabled()) {
                    this.getDataChannelRouter().addPlayer(trackId, this);
                }
            }
        }, null);
    }

    public void removeTracksOnTheFly(String trackId) {
        this.vertx.executeBlocking(ll -> {
            this.acquireOfferCreateSemaphore();
            this.executeOnSignallingThread(() -> {
                ArrayList<RtpSender> removingSenders = new ArrayList<RtpSender>();
                List senders = this.peerConnection.getSenders();
                for (RtpSender sender : senders) {
                    if (!sender.id().contentEquals(VIDEO_TRACK_ID + trackId) && !sender.id().contentEquals(AUDIO_TRACK_ID + trackId)) continue;
                    removingSenders.add(sender);
                }
                for (RtpSender sender : removingSenders) {
                    logger.info("sender {} will be removed", (Object)sender.id());
                    this.peerConnection.removeTrack(sender);
                }
                this.peerConnection.createOffer((SdpObserver)this, this.sdpMediaConstraints);
            });
            this.mapVideoTrackEnable.remove(trackId);
            this.mapAudioTrackEnable.remove(trackId);
        }, null);
    }

    private void acquireOfferCreateSemaphore() {
        try {
            this.sem.acquire();
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
    }

    public int getTargetBitrate() {
        return this.encoderFactory.getEncoder(this.streamId).getAdjustedBitrate();
    }

    public int getPacketLoss() {
        return this.encoderFactory.getEncoder(this.streamId).getPacketLossAverage();
    }

    public int getRttMeasurement() {
        return this.encoderFactory.getEncoder(this.streamId).getRttMeasurementsAverage();
    }

    public PeerConnectionFactory createPeerConnectionFactory(List<VideoCodec> codecList) {
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder().setFieldTrials(null).createInitializationOptions());
        this.encoderFactory = new VirtualVideoEncoderFactory(this.streamId, this.getSubTracks(), codecList);
        SoftwareVideoDecoderFactory decoderFactory = new SoftwareVideoDecoderFactory();
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.disableNetworkMonitor = true;
        options.networkIgnoreMask = 16;
        this.adm = (JavaAudioDeviceModule)JavaAudioDeviceModule.builder(null).setUseHardwareAcousticEchoCanceler(false).setUseHardwareNoiseSuppressor(false).setAudioRecordErrorCallback(null).setAudioTrackErrorCallback(null).setAudioRecordListener(new IAudioRecordListener(){

            public void audioRecordStoppped() {
                WebRTCClient.this.stopAudioSender();
            }

            public void audioRecordStarted() {
                WebRTCClient.this.setAudioSender((t, p) -> WebRTCClient.this.audioRecord.notifyEncodedData(t, p));
            }
        }).createAudioDeviceModule();
        this.audioRecord = this.adm.getAudioRecord();
        return PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule((AudioDeviceModule)this.adm).setVideoEncoderFactory((VideoEncoderFactory)this.encoderFactory).setVideoDecoderFactory((VideoDecoderFactory)decoderFactory).createPeerConnectionFactory();
    }

    protected void stopAudioSender() {
        this.setAudioSender((t, p) -> logger.error("sendAudio was called while stopping for stream {} & client {}.", (Object)this.streamId, (Object)this.hashCode()));
    }

    public void setWebRTCVertx(Vertx webRTCVertx) {
        this.webRTCVertx = webRTCVertx;
        this.signallingContext = webRTCVertx.getOrCreateContext();
    }

    public void start() {
        if (this.stopCalled.get()) {
            logger.info("Stop called before start() for stream:{} client:{}", (Object)this.streamId, (Object)this.hashCode());
            return;
        }
        if (this.iWebRTCStreamInfoListener == null) {
            throw new IllegalArgumentException("iWebRTCStreamInfoListener should not be null");
        }
        this.timeToCallStart = System.currentTimeMillis();
        this.executeOnSignallingThread(this::startInternal);
        this.webRTCVertx.setTimer((long)this.appSettings.getWebRTCClientStartTimeoutMs(), l -> {
            try {
                if (!this.isStreaming) {
                    logger.warn("It's still not streaming so stop the webrtc client for stream: {} and client:{} ", (Object)this.streamId, (Object)this.hashCode());
                    this.stop();
                }
            }
            catch (Exception t) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)t));
            }
        });
    }

    protected void startInternal() {
        if (this.stopCalled.get()) {
            logger.info("Stop called before startInternal() for stream:{} client:{}", (Object)this.streamId, (Object)this.hashCode());
            return;
        }
        try {
            this.startTime = System.currentTimeMillis();
            logger.info("startInternal time: {} stream id:{} viewer hashcode:{}", new Object[]{this.startTime, this.streamId, this.hashCode()});
            this.streamInfoList = this.webRTCAdaptor.getStreamInfo(this.streamId);
            if (this.isMultitrackClient()) {
                for (String string : this.mapVideoTrackEnable.keySet()) {
                    this.streamInfoList = this.webRTCAdaptor.getStreamInfo(string);
                    if (this.streamInfoList == null || this.streamInfoList.isEmpty()) continue;
                    break;
                }
            }
            if (this.streamInfoList != null && !this.streamInfoList.isEmpty()) {
                ArrayList<VideoCodec> videoCodecList = new ArrayList<VideoCodec>();
                this.noVideo = false;
                for (IStreamInfo streamInfo : this.streamInfoList) {
                    if (!videoCodecList.contains(streamInfo.getVideoCodec())) {
                        videoCodecList.add(streamInfo.getVideoCodec());
                    }
                    if (streamInfo.getVideoCodec() != VideoCodec.NOVIDEO) continue;
                    this.noVideo = true;
                }
                this.createMediaConstraintsInternal();
                if (this.peerConnectionFactory == null) {
                    this.peerConnectionFactory = this.createPeerConnectionFactory(videoCodecList);
                }
                ArrayList<PeerConnection.IceServer> arrayList = new ArrayList<PeerConnection.IceServer>();
                arrayList.add(PeerConnection.IceServer.builder((String)this.stunServerUri).createIceServer());
                PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(arrayList);
                rtcConfig.enableDtlsSrtp = true;
                rtcConfig.minPort = this.webRTCPortRangeMin;
                rtcConfig.maxPort = this.webRTCPortRangeMax;
                rtcConfig.disableIpv6 = this.disableIpv6;
                rtcConfig.enableCpuOveruseDetection = false;
                rtcConfig.tcpCandidatePolicy = this.getAppSettings().isWebRTCTcpCandidatesEnabled() ? PeerConnection.TcpCandidatePolicy.ENABLED : PeerConnection.TcpCandidatePolicy.DISABLED;
                rtcConfig.portAllocatorFlags = this.portAllocatorFlags;
                rtcConfig.sdpSemantics = this.appSettings.getWebRTCSdpSemantics() != null && this.appSettings.getWebRTCSdpSemantics().equals("unifiedPlan") ? PeerConnection.SdpSemantics.UNIFIED_PLAN : PeerConnection.SdpSemantics.PLAN_B;
                this.peerConnection = this.peerConnectionFactory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this);
                Logging.enableLogToDebugOutput((Logging.Severity)this.webrtcLogLevel);
                List<String> mediaStreamLabels = Collections.singletonList("ARDAMS");
                this.setVideoSender(this::sendVideoInternal);
                this.acquireOfferCreateSemaphore();
                for (String id : this.mapVideoTrackEnable.keySet()) {
                    if (!this.mapVideoTrackEnable.get(id).booleanValue()) continue;
                    this.addTracks(mediaStreamLabels, id);
                }
                if (this.appSettings.isDataChannelEnabled()) {
                    this.createDataChannel();
                }
                this.peerConnection.createOffer((SdpObserver)this, this.sdpMediaConstraints);
                this.isInitialized = true;
                long startRunTime = System.currentTimeMillis() - this.startTime;
                logger.info("Timing:WebRTCClient({}) is initialized for {} takes {}ms", new Object[]{this.hashCode(), this.streamId, startRunTime});
            } else {
                logger.error("*******There is no stream info in webrtc adaptor for stream: {} so webrtc client will not start*****", (Object)this.streamId);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void createDataChannel() {
        this.dataChannel = this.peerConnection.createDataChannel(this.streamId, new DataChannel.Init());
        this.dataChannel.registerObserver(new DataChannel.Observer(){

            public void onStateChange() {
                logger.info("DataChannel State Change for stream Id {}", (Object)WebRTCClient.this.streamId);
            }

            public void onMessage(DataChannel.Buffer buffer) {
                logger.debug("DataChannel message received stream Id {}", (Object)WebRTCClient.this.streamId);
                byte[] data = new byte[buffer.data.capacity()];
                buffer.data.get(data);
                boolean binary = buffer.binary;
                WebRTCClient.this.executeOnSignallingThread(() -> {
                    try {
                        WebRTCClient.this.getDataChannelRouter().playerMessageReceived(WebRTCClient.this, WebRTCClient.this.streamId, data, binary);
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                });
            }

            public void onBufferedAmountChange(long previousAmount) {
                logger.trace("DataChannel Buffered Amount Changed from {} for streamId: {}", (Object)previousAmount, (Object)WebRTCClient.this.streamId);
            }
        });
        if (this.isMultitrackClient()) {
            for (String trackId : this.mapVideoTrackEnable.keySet()) {
                if (!this.getAppSettings().isDataChannelEnabled()) continue;
                this.getDataChannelRouter().addPlayer(trackId, this);
            }
        } else {
            this.getDataChannelRouter().addPlayer(this.streamId, this);
        }
    }

    public void sendVideoInternal(ByteBuffer data, boolean isKeyFrame, long timestampNs, int frameRotation, List<NaluIndex> naluIndices, String trackId) {
        if (this.mapVideoTrackEnable.get(trackId).booleanValue()) {
            long now = System.currentTimeMillis();
            ++this.sendVideoPacketCallCount;
            this.totalSendVideoPacketCallInterval += this.lastSendVideoPacketCallTime != 0L ? now - this.lastSendVideoPacketCallTime : 0L;
            this.lastSendVideoPacketCallTime = now;
            data.rewind();
            this.encoderFactory.getEncoder(trackId).setEncodedFrameBuffer(data, isKeyFrame, timestampNs, frameRotation, naluIndices, trackId);
        }
    }

    public void addTracks(List<String> mediaStreamLabels, String id) {
        if (!this.noVideo) {
            VideoSource videoSource = this.peerConnectionFactory.createVideoSource(false);
            CapturerObserver capturerObserver = videoSource.getCapturerObserver();
            this.capturerObservers.add(capturerObserver);
            VideoTrack videoTrack = this.peerConnectionFactory.createVideoTrack(VIDEO_TRACK_ID + id, videoSource);
            this.peerConnection.addTrack((MediaStreamTrack)videoTrack, mediaStreamLabels);
        }
        this.audioSource = this.peerConnectionFactory.createAudioSource(this.audioConstraints);
        AudioTrack audioTrack = this.peerConnectionFactory.createAudioTrack(AUDIO_TRACK_ID + id, this.audioSource);
        this.peerConnection.addTrack((MediaStreamTrack)audioTrack, mediaStreamLabels);
    }

    private void createMediaConstraintsInternal() {
        this.audioConstraints = new MediaConstraints();
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, FALSE));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, FALSE));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, FALSE));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, FALSE));
        this.sdpMediaConstraints = new MediaConstraints();
    }

    public void onSignalingChange(PeerConnection.SignalingState newState) {
        logger.info("onSignalingChange : {}", (Object)newState);
    }

    public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
        logger.info("IceConnectionState: {} instance: {}", (Object)newState, (Object)this.hashCode());
        if (newState == PeerConnection.IceConnectionState.CONNECTED) {
            long timeDiff = System.currentTimeMillis() - this.startTime;
            logger.info("Timing:OnIceConnection Connected state takes {}ms hash:{} remoteDescriptionSet:{}", new Object[]{timeDiff, this.hashCode(), this.remoteDescriptionSet});
            if (this.remoteDescriptionSet) {
                this.startStreaming();
            }
        } else if (newState == PeerConnection.IceConnectionState.FAILED || newState == PeerConnection.IceConnectionState.CLOSED) {
            this.stop();
        }
    }

    public void startStreaming() {
        if (this.isStreaming || this.stopCalled.get()) {
            logger.warn("StartStreaming is called in an unexpected case. It's streaming: {}(should be false) and it's stopped:{} (should be false)", (Object)this.isStreaming, (Object)this.stopCalled);
            return;
        }
        logger.info("Starting streaming for {}", (Object)this.streamId);
        this.isStreaming = true;
        this.timeToCallStartStreaming = System.currentTimeMillis();
        this.executeOnSignallingThread(() -> {
            if (this.stopCalled.get()) {
                logger.info("Stop called before startStreaming() for stream:{} client:{}", (Object)this.streamId, (Object)this.hashCode());
                return;
            }
            logger.info("registering webrtc client {} with codec {} to webrtc adaptor for streamId {}", new Object[]{this.hashCode(), this.codec, this.streamId});
            boolean registered = false;
            if (this.webRTCAdaptor != null) {
                for (String trackId : this.mapVideoTrackEnable.keySet()) {
                    registered |= this.webRTCAdaptor.registerWebRTCClient(trackId, (IWebRTCClient)this, this.codec);
                }
                if (registered) {
                    this.iWebRTCStreamInfoListener.streamingStarted(this.streamId);
                    this.adaptStreamScheduledFuture = this.vertx.setPeriodic(5000L, id -> {
                        if (this.getForceStreamHeight() == 0 || !this.isMultitrackClient()) {
                            this.webRTCAdaptor.adaptStreamingQuality(this.streamId, (IWebRTCClient)this, this.codec);
                        }
                        if (!this.isMultitrackClient()) {
                            this.vertx.executeBlocking(b -> {
                                this.iWebRTCStreamInfoListener.birateMeasurement(this.streamId, this.getTargetBitrate(), this.getWebRTCMuxer(this.streamId).getVideoBitrate(), this.getWebRTCMuxer(this.streamId).getAudioBitrate());
                                b.complete();
                            }, null);
                        }
                    });
                    this.nativeStatsTimer = this.scheduleAtFixedRateOnSignallingThread(this::getWebRTCNativeStats, 15000);
                    if (this.viewerInfo != null) {
                        this.datastore.saveViewerInfo(this.viewerInfo);
                    }
                } else {
                    logger.warn("Cannot register to WebRTC Adaptor for stream id {}", (Object)this.streamId);
                }
            } else {
                logger.warn("webrtc adaptor is null for streamId {}", (Object)this.streamId);
            }
        });
    }

    public void getWebRTCNativeStats() {
        if (this.stopCalled.get() || this.peerConnection == null) {
            logger.error("Get stats called after WebRTCClient is stopped for {} client:{} isStopped:{} isNull:{}", new Object[]{this.getStreamId(), this.hashCode(), this.stopCalled, this.peerConnection == null});
            return;
        }
        this.peerConnection.getStats(report -> {
            if (report == null) {
                return;
            }
            Map statsMap = report.getStatsMap();
            WebRTCAudioSendStats tmpAudioStats = new WebRTCAudioSendStats();
            WebRTCVideoSendStats tmpVideoStats = new WebRTCVideoSendStats();
            double timeMs = 0.0;
            for (Map.Entry entry : statsMap.entrySet()) {
                RTCStats value = (RTCStats)entry.getValue();
                if (!OUTBOUND_RTP.equals(value.getType())) continue;
                timeMs = value.getTimestampUs() / 1000.0;
                long timeDiffSeconds = (long)((timeMs - this.lastKnownStatsTimeStampMs) / 1000.0);
                if (timeDiffSeconds == 0L) {
                    logger.error("Time difference in stats collecting is 0  in seconds and time difference {} in ms", (Object)(timeMs - this.lastKnownStatsTimeStampMs));
                    return;
                }
                if (AUDIO.equals(value.getMembers().get(MEDIA_TYPE))) {
                    long packetsReceived = (Long)value.getMembers().get(PACKETS_SENT);
                    long packetsReceivedDiff = packetsReceived - this.lastKnownAudioPacketsSent;
                    tmpAudioStats.setAudioPacketsSent(packetsReceived);
                    tmpAudioStats.setAudioPacketsSentPerSecond(packetsReceivedDiff / timeDiffSeconds);
                    this.lastKnownAudioPacketsSent = packetsReceived;
                    BigInteger bytesSent = (BigInteger)value.getMembers().get(BYTES_SENT);
                    BigInteger bytesSentDiff = bytesSent.subtract(this.lastKnownAudioBytesSent);
                    tmpAudioStats.setAudioBytesSent(bytesSent);
                    tmpAudioStats.setAudioBytesSentPerSecond(bytesSentDiff.divide(BigInteger.valueOf(timeDiffSeconds)));
                    this.lastKnownAudioBytesSent = bytesSent;
                    tmpAudioStats.setTimeMs((long)timeMs);
                    continue;
                }
                if (!VIDEO.equals(value.getMembers().get(MEDIA_TYPE))) continue;
                long firCount = (Long)value.getMembers().get(FIR_COUNT);
                tmpVideoStats.setVideoFirCount(firCount);
                long pliCount = (Long)value.getMembers().get(PLI_COUNT);
                tmpVideoStats.setVideoPliCount(pliCount);
                long nackCount = (Long)value.getMembers().get(NACK_COUNT);
                tmpVideoStats.setVideoNackCount(nackCount);
                long packetsSent = (Long)value.getMembers().get(PACKETS_SENT);
                long packetsReceivedDiff = packetsSent - this.lastKnownVideoPacketsSent;
                tmpVideoStats.setVideoPacketsSent(packetsSent);
                tmpVideoStats.setVideoPacketsSentPerSecond(packetsReceivedDiff / timeDiffSeconds);
                this.lastKnownVideoPacketsSent = packetsSent;
                BigInteger bytesSent = (BigInteger)value.getMembers().get(BYTES_SENT);
                BigInteger bytesReceivedDiff = bytesSent.subtract(this.lastKnownVideoBytesSent);
                tmpVideoStats.setVideoBytesSent(bytesSent);
                tmpVideoStats.setVideoBytesSentPerSecond(bytesReceivedDiff.divide(BigInteger.valueOf(timeDiffSeconds)));
                this.lastKnownVideoBytesSent = bytesSent;
                long framesEncoded = (Long)value.getMembers().get(FRAME_ENCODED);
                long framesEncodedDiff = framesEncoded - this.lastKnownFramesEncoded;
                tmpVideoStats.setVideoFramesEncoded(framesEncoded);
                tmpVideoStats.setVideoFramesEncodedPerSecond(framesEncodedDiff / timeDiffSeconds);
                this.lastKnownFramesEncoded = framesEncoded;
                tmpVideoStats.setTimeMs((long)timeMs);
            }
            this.lastKnownStatsTimeStampMs = timeMs;
            this.videoStats = tmpVideoStats;
            this.audioStats = tmpAudioStats;
            this.iWebRTCStreamInfoListener.avgBitrateMeasurement(this.streamId, tmpVideoStats.getVideoBytesSentPerSecond(), tmpAudioStats.getAudioBytesSentPerSecond());
        });
    }

    public void onIceConnectionReceivingChange(boolean receiving) {
        logger.debug("onIceConnectionReceivingChange : {}", (Object)receiving);
    }

    public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
        logger.debug("onIceGatheringChange : {} ", (Object)newState);
    }

    public void onIceCandidate(IceCandidate candidate) {
        logger.debug("onIceCandidate {} ", (Object)candidate);
        this.executeOnSignallingThread(() -> this.iWebRTCStreamInfoListener.iceCandidateReceived(WebRTCEncoderAdaptor.getCandidate(candidate, this.replaceCandidateAddressWithServerAddress, this.serverAddress, logger), this.streamId));
    }

    public void setReplaceCandidateAddressWithServerAddress(boolean replaceCandidateAddressWithServerAddress) {
        this.replaceCandidateAddressWithServerAddress = replaceCandidateAddressWithServerAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
        logger.info("onIceCandidatesRemoved : {} for stream Id {}", (Object)candidates, (Object)this.streamId);
    }

    public void onAddStream(MediaStream stream) {
        logger.info("onAddStream : {} for stream Id {}", (Object)stream, (Object)this.streamId);
    }

    public void onRemoveStream(MediaStream stream) {
        logger.info("onRemoveStream : {}  for streamId {}", (Object)stream, (Object)this.streamId);
    }

    public void onDataChannel(DataChannel dataChannel) {
        logger.info("onDataChannel : {}", (Object)dataChannel);
    }

    public void onRenegotiationNeeded() {
        logger.info("onRenegotiationNeeded for {}", (Object)this.streamId);
    }

    public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        logger.info("onAddTrack : {}", (Object)receiver);
    }

    public void onCreateSuccess(SessionDescription sdp) {
        this.executeOnSignallingThread(() -> this.onCreateSuccesInternal(sdp));
    }

    private void onCreateSuccesInternal(SessionDescription sdp) {
        logger.info("setting local description for stream Id {} viewer hashcode:{}", (Object)this.streamId, (Object)this.hashCode());
        if (this.peerConnection == null) {
            logger.warn("PeerConnection is null. WebRTC Client can be stopped before this method stream id:{} viewer hashcode:{}", (Object)this.streamId, (Object)this.hashCode());
            return;
        }
        this.peerConnection.setLocalDescription((SdpObserver)new SdpObserverLogger(), sdp);
        String type = sdp.type == SessionDescription.Type.ANSWER ? "answer" : "offer";
        this.iWebRTCStreamInfoListener.localDescriptionSet(sdp.description, type, this.getStreamId());
        long timeDiff = System.currentTimeMillis() - this.startTime;
        logger.info("Timing:onCreateSuccess takes {}ms hash:{}", (Object)timeDiff, (Object)this.hashCode());
    }

    public void onSetSuccess() {
        this.sem.release();
        if (this.currentlyAddingTrackId != null) {
            logger.info("Ready to stream track:{}", (Object)this.currentlyAddingTrackId);
            this.enableTrack(this.currentlyAddingTrackId, true);
            this.currentlyAddingTrackId = null;
        }
        this.executeOnSignallingThread(() -> {
            this.remoteDescriptionSet = true;
            logger.info("onSetSuccess (remote) for stream Id {}", (Object)this.streamId);
            if (this.stopCalled.get()) {
                logger.warn("onSetSuccess is called after stream is stopped {}", (Object)this.streamId);
                return;
            }
            Iterator iterator = this.iceCandidateQueue.iterator();
            while (iterator.hasNext()) {
                IceCandidate iceCandidate = (IceCandidate)iterator.next();
                this.peerConnection.addIceCandidate(iceCandidate);
                iterator.remove();
            }
            switch (this.peerConnection.iceConnectionState()) {
                case CONNECTED: 
                case COMPLETED: {
                    this.startStreaming();
                    break;
                }
            }
        });
        long timeDiff = System.currentTimeMillis() - this.startTime;
        logger.info("Timing:onSetSuccess takes {}ms hash:{}", (Object)timeDiff, (Object)this.hashCode());
    }

    public void onCreateFailure(String error) {
        logger.info("onCreateFailure : {}", (Object)error);
    }

    public void onSetFailure(String error) {
        logger.error("onSetFailure : {}", (Object)error);
    }

    public void setRemoteDescription(SessionDescription sdp) {
        this.executeOnSignallingThread(() -> this.setRemoteDescriptionInternal(sdp));
    }

    void executeOnSignallingThread(Runnable command) {
        this.signallingContext.runOnContext(h -> {
            try {
                command.run();
            }
            catch (Exception t) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)t));
            }
        });
    }

    public long scheduleAtFixedRateOnSignallingThread(Runnable command, int period) {
        return this.webRTCVertx.setPeriodic((long)period, h -> this.signallingContext.runOnContext(l -> {
            try {
                command.run();
            }
            catch (Exception t) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)t));
            }
        }));
    }

    private void setRemoteDescriptionInternal(SessionDescription sdp) {
        this.codec = this.determineCodec(sdp.description);
        if (this.peerConnection != null) {
            logger.info("setting remote description for stream Id {} for {}", (Object)this.streamId, (Object)this.hashCode());
            this.peerConnection.setRemoteDescription((SdpObserver)this, sdp);
        } else {
            logger.warn("Peer connection is null. It cannot add ice candidate for stream Id {}", (Object)this.streamId);
        }
    }

    public VideoCodec determineCodec(String description) {
        VideoCodec selectedCodec = VideoCodec.NOVIDEO;
        if (!this.noVideo) {
            boolean sdpContainsVP8 = description.contains(VideoCodec.VP8.toString());
            boolean sdpContainsH264 = description.contains(VideoCodec.H264.toString());
            boolean sdpContainsH265 = description.contains(VideoCodec.H265.toString());
            boolean h264StreamExists = false;
            boolean vp8StreamExists = false;
            boolean h265StreamExists = false;
            for (IStreamInfo streamInfo : this.streamInfoList) {
                if (streamInfo.getVideoCodec() == VideoCodec.H264) {
                    h264StreamExists = true;
                    continue;
                }
                if (streamInfo.getVideoCodec() == VideoCodec.VP8) {
                    vp8StreamExists = true;
                    continue;
                }
                if (streamInfo.getVideoCodec() != VideoCodec.H265) continue;
                h265StreamExists = true;
            }
            if (h265StreamExists && sdpContainsH265) {
                selectedCodec = VideoCodec.H265;
            } else if (h264StreamExists && sdpContainsH264) {
                selectedCodec = VideoCodec.H264;
            } else if (vp8StreamExists && sdpContainsVP8) {
                selectedCodec = VideoCodec.VP8;
            }
        }
        return selectedCodec;
    }

    public void addIceCandidate(IceCandidate iceCandidate) {
        if (!iceCandidate.sdp.contains(LOCAL_IPv4_127_0_0_1) && !iceCandidate.sdp.contains(LOCAL_IPv6_127_0_0_1)) {
            logger.info("addIceCandidate : {}", (Object)iceCandidate);
            if (this.peerConnection != null && this.remoteDescriptionSet) {
                this.executeOnSignallingThread(() -> {
                    if (this.peerConnection != null && !this.peerConnection.addIceCandidate(iceCandidate)) {
                        logger.error("Cannot add ice candidate({}) for stream {}", (Object)iceCandidate, (Object)this.streamId);
                    }
                });
            } else {
                this.iceCandidateQueue.add(iceCandidate);
                if (this.peerConnection == null) {
                    logger.info("It cannot add ICE Candidate because peer connection null for stream {}. It will be added after remote description is set", (Object)this.streamId);
                } else {
                    logger.info("It cannot add ICE Candidate because remote description is not set for stream {}. It will be added after remote description is set", (Object)this.streamId);
                }
            }
        }
    }

    public void setVideoResolution(int width, int height) {
    }

    private void stopPartial() {
        if (this.adaptStreamScheduledFuture != -1L) {
            this.vertx.cancelTimer(this.adaptStreamScheduledFuture);
            this.adaptStreamScheduledFuture = -1L;
        }
        if (this.nativeStatsTimer != -1L) {
            logger.info("Clearing native stats timer for stream:{} and viewer hashcode:{}", (Object)this.streamId, (Object)this.hashCode());
            this.webRTCVertx.cancelTimer(this.nativeStatsTimer);
            this.nativeStatsTimer = -1L;
        }
    }

    public synchronized void stop() {
        if (this.stopCalled.get()) {
            logger.info("Stop is already called for {} viewer hashcode:{}", (Object)this.streamId, (Object)this.hashCode());
            return;
        }
        this.stopCalled.set(true);
        this.isInitialized = false;
        this.stopPartial();
        this.stopAudioSender();
        this.setVideoSender((encodedFrameBuffer, isKeyFrame, timestampNs, frameRotation, naluIndices, trackIndex) -> logger.error("sendVideoPacket was called while stopping for stream {} & client {}.", (Object)this.streamId, (Object)this.hashCode()));
        this.executeOnSignallingThread(() -> {
            try {
                logger.info("Stop is called for {} for {}", (Object)this.streamId, (Object)this.hashCode());
                this.timeToCallStop = System.currentTimeMillis();
                this.stopPartial();
                this.stopInternal();
                this.isStreaming = false;
            }
            catch (Exception t) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)t));
            }
        });
    }

    public void setStopCalled(boolean stopCalled) {
        this.stopCalled.set(stopCalled);
    }

    private void stopInternal() {
        if (this.subtrackPollerListener != null) {
            this.subtrackPoller.unRegister(this.streamId, this.subtrackPollerListener);
        }
        for (IWebRTCMuxer muxer : this.registeredWebRTCMuxers.values()) {
            if (muxer == null) continue;
            muxer.unRegisterWebRTCClient((IWebRTCClient)this);
        }
        if (this.audioSource != null) {
            logger.info("Disposing audio source for stream Id {} viewer hashcode:{}", (Object)this.streamId, (Object)this.hashCode());
            this.audioSource.dispose();
            this.audioSource = null;
        }
        for (VideoSource videoSource : this.videoSources) {
            if (videoSource == null) continue;
            logger.info("Disposing video source for stream Id {} viewer hashcode:{}", (Object)this.streamId, (Object)this.hashCode());
            videoSource.dispose();
        }
        if (this.dataChannel != null && this.getDataChannelRouter() != null) {
            if (this.isMultitrackClient()) {
                for (String trackId : this.mapVideoTrackEnable.keySet()) {
                    this.mapVideoTrackEnable.put(trackId, false);
                    if (!this.getAppSettings().isDataChannelEnabled()) continue;
                    this.getDataChannelRouter().removePlayer(trackId, this);
                }
            } else {
                this.getDataChannelRouter().removePlayer(this.streamId, this);
            }
        }
        if (this.dataChannel != null) {
            this.dataChannel.close();
            this.dataChannel.dispose();
            this.dataChannel = null;
        }
        if (this.peerConnection != null) {
            logger.info("Closing and disposing peer connection for stream Id {} for {}", (Object)this.streamId, (Object)this.hashCode());
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        if (this.peerConnectionFactory != null) {
            logger.info("Closing peer connection factory for {} viewer hashcode:{}", (Object)this.streamId, (Object)this.hashCode());
            this.peerConnectionFactory.dispose();
            this.peerConnectionFactory = null;
        }
        this.fullyStoppedTime = System.currentTimeMillis();
        this.logGeneralStats();
        if (this.adm != null) {
            this.adm.release();
        } else {
            logger.warn("ADM is null while stopping for stream: {}", (Object)this.streamId);
        }
        this.adm = null;
        this.audioRecord = null;
        this.iWebRTCStreamInfoListener.streamingStopped(this.streamId);
        if (this.viewerInfo != null) {
            this.datastore.deleteWebRTCViewerInfo(this.viewerInfo.getViewerId());
        }
        this.debugIsFullyFinished = true;
    }

    public void logGeneralStats() {
        logger.info("Stopping webrtc client number of send audio packet call: {} send video packet call: {} client id: {}", new Object[]{this.sendAudioPacketCallCount, this.sendVideoPacketCallCount, this.hashCode()});
        if (this.sendVideoPacketCallCount > 0L) {
            long averageSendVideoPacket = this.totalSendVideoPacketCallInterval / this.sendVideoPacketCallCount;
            logger.info("Average sendVideoPacket call interval {}ms client id:{}", (Object)averageSendVideoPacket, (Object)this.hashCode());
        }
        if (this.sendAudioPacketCallCount > 0L) {
            long averageSendAudioPacket = this.totalSendAudioPacketCallInterval / this.sendAudioPacketCallCount;
            logger.info("Average sendAudioPacket call interval {}ms client id:{}", (Object)averageSendAudioPacket, (Object)this.hashCode());
        }
    }

    public long getSendVideoPacketCallCount() {
        return this.sendVideoPacketCallCount;
    }

    public long getSendAudioPacketCallCount() {
        return this.sendAudioPacketCallCount;
    }

    public float getVideoFrameSentPeriod() {
        float period = 0.0f;
        if (this.sendVideoPacketCallCount > 0L) {
            period = (float)this.totalSendVideoPacketCallInterval / (float)this.sendVideoPacketCallCount;
        }
        return period;
    }

    public float getAudioFrameSentPeriod() {
        float period = 0.0f;
        if (this.sendAudioPacketCallCount > 0L) {
            period = (float)this.totalSendAudioPacketCallInterval / (float)this.sendAudioPacketCallCount;
        }
        return period;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public void setStreaming(boolean isStreaming) {
        this.isStreaming = isStreaming;
    }

    public void setStreamInfoListener(WebRTCPlayStreamInfoListener iWebRTCStreamInfoListener) {
        this.iWebRTCStreamInfoListener = iWebRTCStreamInfoListener;
    }

    public boolean isDebugIsFullyFinished() {
        return this.debugIsFullyFinished;
    }

    public void setDebugIsFullyFinished(boolean debugIsFullyFinished) {
        this.debugIsFullyFinished = debugIsFullyFinished;
    }

    public long getTimeToStartStreaming() {
        if (this.timeToCallStartStreaming != 0L && this.timeToCallStart != 0L) {
            return this.timeToCallStartStreaming - this.timeToCallStart;
        }
        return -1L;
    }

    public long getTimeToStop() {
        if (this.timeToCallStop != 0L && this.fullyStoppedTime != 0L) {
            return this.fullyStoppedTime - this.timeToCallStop;
        }
        return -1L;
    }

    public void debugSetRemoteDescriptionSet(boolean enable) {
        this.remoteDescriptionSet = enable;
    }

    public void setStunServerUri(String stunServerUri) {
        this.stunServerUri = stunServerUri;
    }

    public Queue<IceCandidate> getIceCandidateQueue() {
        return this.iceCandidateQueue;
    }

    public boolean isRemoteDescriptionSet() {
        return this.remoteDescriptionSet;
    }

    public void setPortRange(int webRTCPortRangeMin, int webRTCPortRangeMax) {
        this.webRTCPortRangeMin = webRTCPortRangeMin;
        this.webRTCPortRangeMax = webRTCPortRangeMax;
    }

    public IAudioPacketSender getAudioSender() {
        return this.audioSender;
    }

    public void setAudioSender(IAudioPacketSender audioSender) {
        this.audioSender = audioSender;
    }

    public void setPeerConnectionFactory(PeerConnectionFactory peerConnectionFactory) {
        this.peerConnectionFactory = peerConnectionFactory;
    }

    public WebRTCVideoSendStats getVideoStats() {
        return this.videoStats;
    }

    public WebRTCAudioSendStats getAudioStats() {
        return this.audioStats;
    }

    public WebRTCStreamInfoListener getStreamInfoListener() {
        return this.iWebRTCStreamInfoListener;
    }

    public void increaseExcessiveBandwidthCount() {
        this.excessiveBandwidthCount.incrementAndGet();
    }

    public void resetExcessiveBandwidthCount() {
        this.excessiveBandwidthCount.set(0);
    }

    public int getExcessiveBandwidthCount() {
        return this.excessiveBandwidthCount.intValue();
    }

    public void setPortAllocatorFlags(int portAllocatorFlags) {
        this.portAllocatorFlags = portAllocatorFlags;
    }

    public void setTryCountBeforeSwitchBack(int tryCountBeforeSwitchback) {
        if (tryCountBeforeSwitchback < 0) {
            tryCountBeforeSwitchback = 0;
        }
        this.tryCountBeforeSwitchback.set(tryCountBeforeSwitchback);
    }

    public int getTryCountBeforeSwitchBack() {
        return this.tryCountBeforeSwitchback.intValue();
    }

    public void cacheChannelParameters() {
        this.cachedPacketLoss = this.getPacketLoss();
        this.cachedRttMeasurement = this.getRttMeasurement();
    }

    public int getCachedPacketLoss() {
        return this.cachedPacketLoss;
    }

    public int getCachedRttMeasurement() {
        return this.cachedRttMeasurement;
    }

    public void debugSetAdm(JavaAudioDeviceModule adm) {
        this.adm = adm;
    }

    public boolean isDisableIpv6() {
        return this.disableIpv6;
    }

    public void setDisableIpv6(boolean disableIpv6) {
        this.disableIpv6 = disableIpv6;
    }

    public IVideoPacketSender getVideoSender() {
        return this.videoSender;
    }

    public void setVideoSender(IVideoPacketSender videoSender) {
        this.videoSender = videoSender;
    }

    public void setVideoTrack(String trackId, boolean enabled) {
        this.mapVideoTrackEnable.put(trackId, enabled);
    }

    public void setAudioTrack(String trackId, boolean enabled) {
        this.mapAudioTrackEnable.put(trackId, enabled);
    }

    public void enableTrack(String trackId, boolean enabled) {
        this.mapAudioTrackEnable.put(trackId, enabled);
        this.mapVideoTrackEnable.put(trackId, enabled);
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    @Override
    public void sendMessageViaDataChannel(DataChannel.Buffer buffer) {
        this.executeOnSignallingThread(() -> this.dataChannel.send(buffer));
    }

    public DataChannelRouter getDataChannelRouter() {
        return this.dataChannelRouter;
    }

    public void setDataChannelRouter(DataChannelRouter dataChannelRouter) {
        this.dataChannelRouter = dataChannelRouter;
    }

    public void setPeerConnectionForTest(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
    }

    public void setEncoderFactoryForTest(VirtualVideoEncoderFactory encoderFactory) {
        this.encoderFactory = encoderFactory;
    }

    public Map<String, Boolean> getMapTrackEnable() {
        return this.mapVideoTrackEnable;
    }

    public Map<String, Boolean> getMapAudioTrackEnableForTest() {
        return this.mapAudioTrackEnable;
    }

    public VideoCodec getCodec() {
        return this.codec;
    }

    public void setCodec(VideoCodec codec) {
        this.codec = codec;
    }

    public void setStreamInfoList(List<IStreamInfo> streamInfoList) {
        this.streamInfoList = streamInfoList;
    }

    public boolean isStopCalled() {
        return this.stopCalled.get();
    }

    public void setClientInfo(String clientInfo) {
        this.clientInfo = clientInfo;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public void addWebRTCMuxer(IWebRTCMuxer webRTCMuxer) {
        this.registeredWebRTCMuxers.put(webRTCMuxer.getStreamId(), webRTCMuxer);
    }

    public void removeWebRTCMuxer(IWebRTCMuxer webRTCMuxer) {
        this.registeredWebRTCMuxers.remove(webRTCMuxer.getStreamId());
        if (this.registeredWebRTCMuxers.isEmpty()) {
            this.stop();
        } else {
            this.removeTracksOnTheFly(webRTCMuxer.getStreamId());
        }
    }

    public IWebRTCMuxer getWebRTCMuxer(String trackId) {
        return this.registeredWebRTCMuxers.get(trackId);
    }

    public boolean isMultitrackClient() {
        return this.mapVideoTrackEnable.size() > 1 || this.mapAudioTrackEnable.size() > 1;
    }

    public SubtrackPoller.SubtrackPollerListener getSubtrackPollerListener() {
        return this.subtrackPollerListener;
    }

    public void setSubtrackPollerListener(SubtrackPoller.SubtrackPollerListener subtrackPollerListener) {
        this.subtrackPollerListener = subtrackPollerListener;
    }

    public SubtrackPoller getSubtrackPoller() {
        return this.subtrackPoller;
    }

    public void setSubtrackPoller(SubtrackPoller subtrackPoller) {
        this.subtrackPoller = subtrackPoller;
    }

    public void setViewerInfo(WebRTCViewerInfo info) {
        this.viewerInfo = info;
    }

    public WebRTCViewerInfo getViewerInfo() {
        return this.viewerInfo;
    }

    public String getCurrentlyAddingTrackId() {
        return this.currentlyAddingTrackId;
    }

    class SdpObserverLogger
    implements SdpObserver {
        SdpObserverLogger() {
        }

        public void onCreateSuccess(SessionDescription sdp) {
            logger.info("SdpObserverLogger - Oncreate Success: {}", (Object)sdp);
        }

        public void onSetSuccess() {
            logger.info("SdpObserverLogger - onSetSuccess (local) for stream Id {}", (Object)WebRTCClient.this.streamId);
        }

        public void onCreateFailure(String error) {
            logger.info("SdpObserverLogger - onCreateFailure for stream Id {} error is {}", (Object)WebRTCClient.this.streamId, (Object)error);
        }

        public void onSetFailure(String error) {
            logger.info("SdpObserverLogger - onSetFailure for stream Id {} error is {}", (Object)WebRTCClient.this.streamId, (Object)error);
        }
    }

    public static interface IVideoPacketSender {
        public void sendVideo(ByteBuffer var1, boolean var2, long var3, int var5, List<NaluIndex> var6, String var7);
    }

    static interface IAudioPacketSender {
        public void sendAudio(String var1, ByteBuffer var2);
    }

    public static class MediaPacket {
        private ByteBuffer data;
        private long timestamp;
        private boolean isKeyFrame;
        private int frameRotation;

        public MediaPacket(ByteBuffer data, long timestamp, boolean isKeyFrame, int frameRotation) {
            this.data = data;
            this.timestamp = timestamp;
            this.isKeyFrame = isKeyFrame;
            this.frameRotation = frameRotation;
        }
    }
}

