/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.enterprise.adaptive.EncoderAdaptor;
import io.antmedia.enterprise.adaptive.StreamAdaptor;
import io.antmedia.enterprise.adaptive.WebRTCEncoderAdaptor;
import io.antmedia.enterprise.cluster.TcpCluster;
import io.antmedia.enterprise.plugin.CustomBroadcast;
import io.antmedia.enterprise.webrtc.DataChannelRouter;
import io.antmedia.enterprise.webrtc.SubtrackPoller;
import io.antmedia.enterprise.webrtc.WebRTCAdaptor;
import io.antmedia.enterprise.webrtc.WebRTCClient;
import io.antmedia.plugin.api.IFrameListener;
import io.antmedia.plugin.api.IStreamListener;
import io.antmedia.plugin.api.StreamParametersInfo;
import io.antmedia.rest.model.Result;
import io.antmedia.statistic.type.RTMPToWebRTCStats;
import io.antmedia.statistic.type.WebRTCAudioReceiveStats;
import io.antmedia.statistic.type.WebRTCAudioSendStats;
import io.antmedia.statistic.type.WebRTCVideoReceiveStats;
import io.antmedia.statistic.type.WebRTCVideoSendStats;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.scope.IScope;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;

public class WebRTCApplication
extends AntMediaApplicationAdapter {
    private static final Logger logger = Red5LoggerFactory.getLogger(WebRTCApplication.class);
    private Map<String, List<Session>> signallingConnections = new ConcurrentHashMap<String, List<Session>>();
    private Map<String, WebRTCEncoderAdaptor> publisherAdaptorList = new ConcurrentHashMap<String, WebRTCEncoderAdaptor>();
    private Map<String, WebRTCEncoderAdaptor> publisherListToBeStopped = new ConcurrentHashMap<String, WebRTCEncoderAdaptor>();
    private Map<String, Queue<WebRTCClient>> webRTCClientsMap = new ConcurrentHashMap<String, Queue<WebRTCClient>>();
    private TcpCluster cluster;
    private static final int LOW_LEVEL_STATS_COLLECT_PERIOD = 15000;
    private long lowLevelStatsCalculatorTask = -1L;
    private Map<String, EncoderAdaptor> rtmpToWebRTCStreamsMap = new ConcurrentHashMap<String, EncoderAdaptor>();
    private DataChannelRouter dataChannelRouter;
    private Map<String, CustomBroadcast> customBroadcasts = new ConcurrentHashMap<String, CustomBroadcast>();
    private SubtrackPoller subtrackPoller;

    public boolean appStart(IScope app) {
        boolean appStarted = super.appStart(app);
        this.lowLevelStatsCalculatorTask = this.getVertx().setPeriodic(15000L, h -> this.calculateLowLevelStats());
        this.dataChannelRouter = new DataChannelRouter(this.getAppSettings());
        this.subtrackPoller = new SubtrackPoller(this.getVertx(), this.getDataStore());
        return appStarted;
    }

    public Map<String, List<Session>> getSignallingConnections() {
        return this.signallingConnections;
    }

    public void setSignallingConnections(Map<String, List<Session>> signallingConnections) {
        this.signallingConnections = signallingConnections;
    }

    public Map<String, WebRTCEncoderAdaptor> getPublisherAdaptorList() {
        return this.publisherAdaptorList;
    }

    public void setPublisherAdaptorList(Map<String, WebRTCEncoderAdaptor> publisherAdaptorList) {
        this.publisherAdaptorList = publisherAdaptorList;
    }

    public Map<String, Queue<WebRTCClient>> getWebRTCClientsMap() {
        return this.webRTCClientsMap;
    }

    public TcpCluster getCluster() {
        if (this.cluster == null) {
            if (this.getScope().getContext().hasBean("tomcat.cluster")) {
                this.cluster = (TcpCluster)this.getScope().getContext().getBean("tomcat.cluster");
                logger.debug("clusterNotifier in WebSocketListener ---> {}", (Object)this.cluster);
            } else {
                logger.debug("No clusternotified in app {}", (Object)this.getScope().getName());
            }
        }
        return this.cluster;
    }

    public void setCluster(TcpCluster cluster) {
        this.cluster = cluster;
    }

    public void serverShuttingdown() {
        this.serverShuttingDown = true;
        logger.info("{} is closing streams", (Object)this.getScope().getName());
        this.sendClosingMessageToPeers();
        this.closeStreamFetchers();
        this.closeRTMPStreams();
        this.deleteZombiRooms();
        this.shutdownWebRTCPublishers();
        this.closeCustomBroadcasts();
        this.waitUntilLiveStreamsStopped();
        this.waitUntilThreadsStop();
        this.getVertx().cancelTimer(this.lowLevelStatsCalculatorTask);
        this.createShutdownFile(this.getScope().getName());
        this.getDataStore().close();
    }

    public void deleteZombiRooms() {
        List rooms = this.getDataStore().getConferenceRoomList(0, 100, "", "", "");
        for (ConferenceRoom conferenceRoom : rooms) {
            if (!conferenceRoom.isZombi()) continue;
            this.getDataStore().deleteConferenceRoom(conferenceRoom.getRoomId());
        }
    }

    private boolean checkAndWait(int i, int numberOfLiveStreams) {
        boolean result = true;
        int waitPeriod = 1000;
        try {
            if (i > 3) {
                logger.warn("Operation not completed for app: {} for {} the value is {} and this should be decreased to zero", new Object[]{this.getScope().getName(), waitPeriod * i, numberOfLiveStreams});
            }
            if (i > 10) {
                logger.error("****************************************************************************************");
                logger.error("Operation not completed and givig up to finish the server");
                logger.error("****************************************************************************************");
                result = false;
            }
            Thread.sleep(waitPeriod);
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public boolean shutdownWebRTCPublishers() {
        boolean result = true;
        for (WebRTCEncoderAdaptor adaptor : this.publisherAdaptorList.values()) {
            if (adaptor == null) continue;
            adaptor.stop(true);
            logger.info("WebRTC Encoder adaptor stop stream Id {} before shutdown", (Object)adaptor.getStreamId());
        }
        IWebRTCAdaptor webRTCAdaptor = this.getWebRTCAdaptor();
        logger.info("Checking if total number of live stream({}) in WebRTC Adaptor is zero for app:{}", (Object)webRTCAdaptor.getNumberOfLiveStreams(), (Object)this.getScope().getName());
        int i = 0;
        int liveStreamsCount = webRTCAdaptor.getNumberOfLiveStreams();
        while (liveStreamsCount > 0 && result) {
            result = this.checkAndWait(i, liveStreamsCount);
            ++i;
            liveStreamsCount = webRTCAdaptor.getNumberOfLiveStreams();
        }
        i = 0;
        logger.info("Checking if total number of webrtc viewers({}) in WebRTC Adaptor is zero for app:{}", (Object)webRTCAdaptor.getNumberOfTotalViewers(), (Object)this.getScope().getName());
        int liveViewerCount = webRTCAdaptor.getNumberOfTotalViewers();
        while (liveViewerCount > 0 && result) {
            result = this.checkAndWait(i, liveViewerCount);
            ++i;
            liveViewerCount = webRTCAdaptor.getNumberOfTotalViewers();
        }
        return result;
    }

    public IWebRTCAdaptor getWebRTCAdaptor() {
        return (IWebRTCAdaptor)ScopeUtils.getScopeService((IScope)this.getScope(), IWebRTCAdaptor.class, WebRTCAdaptor.class);
    }

    public Result stopStreaming(Broadcast broadcast) {
        Optional<WebRTCEncoderAdaptor> adaptor;
        Result result = super.stopStreaming(broadcast);
        if (!result.isSuccess() && (adaptor = this.publisherAdaptorList.values().stream().filter(predicate -> predicate.getStreamId().contentEquals(broadcast.getStreamId())).findFirst()).isPresent()) {
            adaptor.get().stop(true);
            result.setSuccess(true);
        }
        return result;
    }

    public synchronized void calculateLowLevelStats() {
        WebRTCVideoReceiveStats tmpVideoReceiveStats = new WebRTCVideoReceiveStats();
        WebRTCAudioReceiveStats tmpAudioReceiveStats = new WebRTCAudioReceiveStats();
        Set<Map.Entry<String, WebRTCEncoderAdaptor>> entrySet = this.publisherAdaptorList.entrySet();
        for (Map.Entry<String, WebRTCEncoderAdaptor> entry : entrySet) {
            tmpVideoReceiveStats.addVideoStats(entry.getValue().getVideoReceivedStats());
            tmpAudioReceiveStats.addAudioStats(entry.getValue().getAudioReceivedStats());
        }
        this.webRTCVideoReceiveStats = tmpVideoReceiveStats;
        this.webRTCAudioReceiveStats = tmpAudioReceiveStats;
        WebRTCVideoSendStats tmpVideoSentStats = new WebRTCVideoSendStats();
        WebRTCAudioSendStats tmpAudioSentStats = new WebRTCAudioSendStats();
        for (Map.Entry<String, Queue<WebRTCClient>> entry : this.webRTCClientsMap.entrySet()) {
            for (WebRTCClient webRTCClient : entry.getValue()) {
                tmpVideoSentStats.addVideoStats(webRTCClient.getVideoStats());
                tmpAudioSentStats.addAudioStats(webRTCClient.getAudioStats());
            }
        }
        this.webRTCVideoSendStats = tmpVideoSentStats;
        this.webRTCAudioSendStats = tmpAudioSentStats;
    }

    private void sendClosingMessageToPeers() {
        for (WebRTCEncoderAdaptor webRTCEncoderAdaptor : this.publisherAdaptorList.values()) {
            webRTCEncoderAdaptor.getInfoListener().serverWillClose();
        }
        for (Queue queue : this.webRTCClientsMap.values()) {
            for (WebRTCClient webRTCClient : queue) {
                webRTCClient.getStreamInfoListener().serverWillClose();
            }
        }
    }

    public RTMPToWebRTCStats getRTMPToWebRTCStats(String streamId) {
        EncoderAdaptor encoderAdaptor = this.rtmpToWebRTCStreamsMap.get(streamId);
        if (encoderAdaptor != null) {
            return encoderAdaptor.getRtmpWebrtcStats();
        }
        return new RTMPToWebRTCStats(streamId);
    }

    public Map<String, EncoderAdaptor> getRtmpToWebRTCStreamsMap() {
        return this.rtmpToWebRTCStreamsMap;
    }

    public void setRtmpToWebRTCStreamsMap(Map<String, EncoderAdaptor> rtmpToWebRTCStreamsMap) {
        this.rtmpToWebRTCStreamsMap = rtmpToWebRTCStreamsMap;
    }

    public DataChannelRouter getDataChannelRouter() {
        return this.dataChannelRouter;
    }

    public void setDataChannelRouter(DataChannelRouter dataChannelRouter) {
        this.dataChannelRouter = dataChannelRouter;
    }

    public boolean isDataChannelMessagingSupported() {
        return true;
    }

    public boolean isDataChannelEnabled() {
        return this.getAppSettings().isDataChannelEnabled();
    }

    public synchronized boolean sendDataChannelMessage(String streamId, String message) {
        byte[] dataBytes = message.getBytes(Charset.defaultCharset());
        this.dataChannelRouter.playerMessageReceived(null, streamId, dataBytes, false);
        this.dataChannelRouter.publisherMessageReceived(streamId, dataBytes, false);
        return true;
    }

    public boolean doesWebRTCStreamExist(String streamId) {
        DataChannelRouter router = this.getDataChannelRouter();
        return router.doesPublisherForStreamExist(streamId);
    }

    public Map<String, WebRTCEncoderAdaptor> getPublisherListToBeStopped() {
        return this.publisherListToBeStopped;
    }

    public void addFrameListener(String streamId, IFrameListener listener) {
        StreamAdaptor streamAdaptor = null;
        EncoderAdaptor adaptorForTheStream = null;
        StreamParametersInfo videoStreamInfo = new StreamParametersInfo();
        StreamParametersInfo audioStreamInfo = new StreamParametersInfo();
        for (WebRTCEncoderAdaptor webRTCEncoderAdaptor : this.publisherAdaptorList.values()) {
            if (!webRTCEncoderAdaptor.getStreamId().equals(streamId)) continue;
            streamAdaptor = webRTCEncoderAdaptor.getStreamAdaptorList().get(0);
            adaptorForTheStream = webRTCEncoderAdaptor;
            break;
        }
        if (adaptorForTheStream == null) {
            adaptorForTheStream = this.rtmpToWebRTCStreamsMap.get(streamId);
        }
        if (adaptorForTheStream != null) {
            streamAdaptor = adaptorForTheStream.getStreamAdaptorList().get(0);
            videoStreamInfo.codecParameters = adaptorForTheStream.getVideoCodecParameters();
            videoStreamInfo.enabled = adaptorForTheStream.isEnableVideo();
            audioStreamInfo.codecParameters = adaptorForTheStream.getAudioCodecParameters();
            audioStreamInfo.enabled = adaptorForTheStream.isEnableAudio();
            videoStreamInfo.timeBase = adaptorForTheStream.getVideoTimeBase();
            audioStreamInfo.timeBase = adaptorForTheStream.getAudioTimeBase();
            listener.setVideoStreamInfo(streamId, videoStreamInfo);
            listener.setAudioStreamInfo(streamId, audioStreamInfo);
            streamAdaptor.addFrameListener(listener);
        }
    }

    public void removeFrameListener(String streamId, IFrameListener listener) {
        StreamAdaptor streamAdaptor = null;
        for (WebRTCEncoderAdaptor webRTCEncoderAdaptor : this.publisherAdaptorList.values()) {
            if (!webRTCEncoderAdaptor.getStreamId().equals(streamId)) continue;
            streamAdaptor = webRTCEncoderAdaptor.getStreamAdaptorList().get(0);
        }
        EncoderAdaptor adaptor = this.rtmpToWebRTCStreamsMap.get(streamId);
        if (adaptor != null) {
            streamAdaptor = adaptor.getStreamAdaptorList().get(0);
        }
        if (streamAdaptor != null) {
            streamAdaptor.removeFrameListener(listener);
        }
    }

    public IFrameListener createCustomBroadcast(String streamId) {
        CustomBroadcast cb = new CustomBroadcast(streamId, this);
        this.customBroadcasts.put(streamId, cb);
        return cb;
    }

    public void stopCustomBroadcast(String streamId) {
        if (this.customBroadcasts.containsKey(streamId)) {
            CustomBroadcast cb = this.customBroadcasts.remove(streamId);
            cb.stop();
        }
    }

    private void closeCustomBroadcasts() {
        for (String streamId : this.customBroadcasts.keySet()) {
            this.stopCustomBroadcast(streamId);
        }
    }

    public Map<String, CustomBroadcast> getCustomBroadcasts() {
        return this.customBroadcasts;
    }

    public void joinedTheRoom(String roomId, String streamId) {
        for (IStreamListener listener : this.streamListeners) {
            listener.joinedTheRoom(roomId, streamId);
        }
    }

    public void leftTheRoom(String roomId, String streamId) {
        for (IStreamListener listener : this.streamListeners) {
            listener.leftTheRoom(roomId, streamId);
        }
    }

    public SubtrackPoller getSubtrackPoller() {
        return this.subtrackPoller;
    }

    public void setSubtrackPoller(SubtrackPoller subtrackPoller) {
        this.subtrackPoller = subtrackPoller;
    }

    public boolean stopPlaying(String viewerId) {
        Collection<Queue<WebRTCClient>> webRTCClients = this.webRTCClientsMap.values();
        for (Queue<WebRTCClient> clientsQueue : webRTCClients) {
            for (WebRTCClient webRTCClient : clientsQueue) {
                if (!webRTCClient.getViewerInfo().getViewerId().equals(viewerId)) continue;
                webRTCClient.stop();
                return true;
            }
        }
        return false;
    }
}

