/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.cluster.IStreamInfo;
import io.antmedia.enterprise.cluster.webrtc.OriginServer;
import io.antmedia.rest.WebRTCClientStats;
import io.antmedia.webrtc.VideoCodec;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRTCAdaptor
implements IWebRTCAdaptor {
    Map<String, List<IWebRTCMuxer>> muxerMap = new ConcurrentHashMap<String, List<IWebRTCMuxer>>();
    private AtomicInteger numberOfLiveStreams = new AtomicInteger(0);
    protected static Logger logger = LoggerFactory.getLogger(WebRTCAdaptor.class);
    private int excessiveBandwidthValue = 300000;
    private int excessiveBandwidthCallThreshold = 3;
    private int packetLossDiffThresholdForSwitchback = 10;
    private int rttMeasurementDiffThresholdForSwitchback = 20;
    private int tryCountBeforeSwitchback = 5;
    private ICheckExcessiveBandwidth excessiveBandwidthChecker = this::logActiveStatus;

    private void logActiveStatus(String streamId, IWebRTCClient webRTCClient, IWebRTCMuxer currentlyRegisteredMuxer, IWebRTCMuxer adaptedMuxer, int targetBitrate, int currentBitrateDiff, IWebRTCMuxer excessiveMuxer) {
        logger.info("Client:{} for stream {} current video bitrate: {} audio bitrate: {} webrtc client target bitrate: {}", new Object[]{webRTCClient.hashCode(), streamId, currentlyRegisteredMuxer.getVideoBitrate(), currentlyRegisteredMuxer.getAudioBitrate(), targetBitrate});
    }

    public synchronized void registerMuxer(String streamId, IWebRTCMuxer webRTCMuxer) {
        logger.info("registering {} muxer with {}p and codec::{} to webrtc adaptor", new Object[]{streamId, webRTCMuxer.getVideoHeight(), webRTCMuxer.getVideoCodec()});
        List<Object> list = this.muxerMap.get(streamId);
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList());
            int number = this.numberOfLiveStreams.incrementAndGet();
            logger.info("Increasing number of live streams: {} and stream id:{}", (Object)number, (Object)streamId);
        }
        list.add(webRTCMuxer);
        this.muxerMap.put(streamId, list);
    }

    public synchronized void unRegisterMuxer(String streamId, IWebRTCMuxer webRTCMuxer) {
        logger.info("unregistering {} muxer with {}p and codec: {} from webrtc adaptor", new Object[]{streamId, webRTCMuxer.getVideoHeight(), webRTCMuxer.getVideoCodec()});
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list != null) {
            list.remove(webRTCMuxer);
        }
        if (list != null && list.isEmpty() && this.muxerMap.remove(streamId) != null) {
            int number = this.numberOfLiveStreams.decrementAndGet();
            logger.info("Decreasing number of live streams: {} and stream id:{}", (Object)number, (Object)streamId);
        }
    }

    public boolean registerWebRTCClient(String streamId, IWebRTCClient webRTCClient, VideoCodec codec) {
        boolean result = false;
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list != null && !list.isEmpty()) {
            IWebRTCMuxer highestBitrateMuxer = null;
            for (IWebRTCMuxer iWebRTCMuxer : list) {
                VideoCodec muxerCodec = iWebRTCMuxer.getVideoCodec();
                if (muxerCodec != codec) continue;
                int videoBitrate = iWebRTCMuxer.getVideoBitrate();
                if (highestBitrateMuxer != null && highestBitrateMuxer.getVideoBitrate() >= videoBitrate) continue;
                highestBitrateMuxer = iWebRTCMuxer;
            }
            if (highestBitrateMuxer != null) {
                highestBitrateMuxer.registerWebRTCClient(webRTCClient);
                result = true;
            } else {
                logger.warn("No appropriate webrtc muxer found for webrtc client whose codec:{} for stream: {}", (Object)codec, (Object)streamId);
            }
        } else {
            logger.warn("No webrtc muxer exist for stream:{} in webrtc adaptor ", (Object)streamId);
        }
        return result;
    }

    public boolean registerWebRTCClient(String streamId, IWebRTCClient webRTCClient, int resolutionHeight, VideoCodec videoCodec) {
        boolean result = false;
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list != null && !list.isEmpty()) {
            for (IWebRTCMuxer iWebRTCMuxer : list) {
                if (resolutionHeight != iWebRTCMuxer.getVideoHeight() || videoCodec != iWebRTCMuxer.getVideoCodec()) continue;
                iWebRTCMuxer.registerWebRTCClient(webRTCClient);
                result = true;
                break;
            }
            if (!result) {
                logger.error("WebRTCClient cannot register to webrtc muxer for codec:{} height:{} stream:{}", new Object[]{videoCodec, resolutionHeight, streamId});
            }
        }
        return result;
    }

    public boolean streamExists(String streamId) {
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        return list != null && !list.isEmpty();
    }

    public List<IStreamInfo> getStreamInfo(String streamId) {
        List<IWebRTCMuxer> streamList = this.muxerMap.get(streamId);
        return streamList;
    }

    public void forceStreamingQuality(String streamId, IWebRTCClient webRTCClient, int streamHeight) {
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list == null) {
            logger.info("There is no muxer for stream id {}", (Object)streamId);
            return;
        }
        IWebRTCMuxer fixedMuxer = null;
        IWebRTCMuxer currentlyRegisteredMuxer = webRTCClient.getWebRTCMuxer(streamId);
        if (streamHeight == currentlyRegisteredMuxer.getVideoHeight()) {
            logger.info("Current Muxer resolution and forced resolution are same: {}", (Object)streamHeight);
            return;
        }
        for (IWebRTCMuxer iWebRTCMuxer : list) {
            fixedMuxer = iWebRTCMuxer;
            if (fixedMuxer.getVideoHeight() != streamHeight) continue;
            logger.info("Forced Stream quality: {} for the stream id: {} from current stream quality:{} to muxer stream quality: {} video bitrate: {}, audio bitrate: {}", new Object[]{streamHeight, webRTCClient.hashCode(), streamId, currentlyRegisteredMuxer.getVideoHeight(), fixedMuxer.getVideoHeight(), fixedMuxer.getVideoBitrate(), fixedMuxer.getAudioBitrate()});
            currentlyRegisteredMuxer.unRegisterWebRTCClient(webRTCClient);
            fixedMuxer.registerWebRTCClient(webRTCClient);
            return;
        }
    }

    public void adaptStreamingQuality(String streamId, IWebRTCClient webRTCClient, VideoCodec codec) {
        if (webRTCClient instanceof OriginServer) {
            logger.info("No adaptive streaming for WebRTCClusterClient for stream Id {}", (Object)streamId);
            return;
        }
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list == null) {
            logger.info("There is no muxer for stream id {}", (Object)streamId);
            return;
        }
        IWebRTCMuxer currentlyRegisteredMuxer = webRTCClient.getWebRTCMuxer(streamId);
        IWebRTCMuxer adaptedMuxer = null;
        int targetBitrate = webRTCClient.getTargetBitrate();
        int currentBitrateDiff = targetBitrate - (currentlyRegisteredMuxer.getVideoBitrate() + currentlyRegisteredMuxer.getAudioBitrate());
        int excessiveBandwidthValueDiff = Integer.MIN_VALUE;
        IWebRTCMuxer excessiveMuxer = null;
        boolean protectedFromSwitchBack = false;
        for (IWebRTCMuxer iWebRTCMuxer : list) {
            if (iWebRTCMuxer.getVideoCodec() != codec) continue;
            int bitrateDiff = targetBitrate - (iWebRTCMuxer.getVideoBitrate() + iWebRTCMuxer.getAudioBitrate());
            if (bitrateDiff > 0 && (bitrateDiff < currentBitrateDiff || currentBitrateDiff < 0)) {
                if (currentBitrateDiff < 0) {
                    int packetLossDiff = webRTCClient.getPacketLoss() - webRTCClient.getCachedPacketLoss();
                    int rttMeasurementDiff = webRTCClient.getRttMeasurement() - webRTCClient.getCachedRttMeasurement();
                    if (webRTCClient.getTryCountBeforeSwitchBack() <= 0 || packetLossDiff > this.packetLossDiffThresholdForSwitchback || rttMeasurementDiff > this.rttMeasurementDiffThresholdForSwitchback) {
                        webRTCClient.setTryCountBeforeSwitchBack(0);
                        currentBitrateDiff = bitrateDiff;
                        adaptedMuxer = iWebRTCMuxer;
                        continue;
                    }
                    logger.info("Protected from switch back tryCount left:{} , \tpacketLossDiff:{}, rttMeasurement Diff:{}", new Object[]{webRTCClient.getTryCountBeforeSwitchBack(), packetLossDiff, rttMeasurementDiff});
                    protectedFromSwitchBack = true;
                    continue;
                }
                currentBitrateDiff = bitrateDiff;
                adaptedMuxer = iWebRTCMuxer;
                continue;
            }
            if (bitrateDiff < 0 && currentBitrateDiff < 0 && bitrateDiff > currentBitrateDiff) {
                currentBitrateDiff = bitrateDiff;
                adaptedMuxer = iWebRTCMuxer;
                continue;
            }
            if (bitrateDiff >= 0 || currentBitrateDiff <= 0 || bitrateDiff <= excessiveBandwidthValueDiff) continue;
            excessiveBandwidthValueDiff = bitrateDiff;
            excessiveMuxer = iWebRTCMuxer;
        }
        if (protectedFromSwitchBack) {
            int tryCount = webRTCClient.getTryCountBeforeSwitchBack() - 1;
            webRTCClient.setTryCountBeforeSwitchBack(tryCount);
        }
        if (adaptedMuxer != null && !currentlyRegisteredMuxer.equals(adaptedMuxer)) {
            logger.info("switching bitrate for client: {} for the stream id: {} from video bitrate:{} audio bitrate:{} to muxer video bitrate: {} audio bitrate: {} webrtc client target bitrate: {}", new Object[]{webRTCClient.hashCode(), streamId, currentlyRegisteredMuxer.getVideoBitrate(), currentlyRegisteredMuxer.getAudioBitrate(), adaptedMuxer.getVideoBitrate(), adaptedMuxer.getAudioBitrate(), targetBitrate});
            currentlyRegisteredMuxer.unRegisterWebRTCClient(webRTCClient);
            adaptedMuxer.registerWebRTCClient(webRTCClient);
            webRTCClient.resetExcessiveBandwidthCount();
            webRTCClient.setTryCountBeforeSwitchBack(0);
        } else {
            this.excessiveBandwidthChecker.checkExcessiveBandwidth(streamId, webRTCClient, currentlyRegisteredMuxer, adaptedMuxer, targetBitrate, currentBitrateDiff, excessiveMuxer);
        }
    }

    public void checkExcessiveBandwidthImpl(String streamId, IWebRTCClient webRTCClient, IWebRTCMuxer currentlyRegisteredMuxer, IWebRTCMuxer adaptedMuxer, int targetBitrate, int currentBitrateDiff, IWebRTCMuxer excessiveMuxer) {
        if (currentBitrateDiff > this.excessiveBandwidthValue) {
            webRTCClient.increaseExcessiveBandwidthCount();
        } else {
            webRTCClient.resetExcessiveBandwidthCount();
        }
        if (webRTCClient.getExcessiveBandwidthCount() >= this.excessiveBandwidthCallThreshold) {
            if (excessiveMuxer != null && !excessiveMuxer.equals(currentlyRegisteredMuxer)) {
                webRTCClient.setTryCountBeforeSwitchBack(this.tryCountBeforeSwitchback);
                webRTCClient.resetExcessiveBandwidthCount();
                webRTCClient.cacheChannelParameters();
                currentlyRegisteredMuxer.unRegisterWebRTCClient(webRTCClient);
                excessiveMuxer.registerWebRTCClient(webRTCClient);
                logger.info("Trying excessive bitrate for Client:{} for stream {} current video/audio bitrate: {}/{} webrtc client target bitrate: {} excessive video/audio bitrate:{}/{}", new Object[]{webRTCClient, streamId, currentlyRegisteredMuxer.getVideoBitrate(), currentlyRegisteredMuxer.getAudioBitrate(), targetBitrate, excessiveMuxer.getVideoBitrate(), excessiveMuxer.getAudioBitrate()});
            } else {
                webRTCClient.setTryCountBeforeSwitchBack(0);
                webRTCClient.resetExcessiveBandwidthCount();
                logger.warn("Cannot try excessive bitrate because excessiveMuxer is: {} or currentlyRegisteredMuxer is equals to excessiveMuxer {}current video/audio bitrate:{}/{} target bitrate:{} ", new Object[]{excessiveMuxer, currentlyRegisteredMuxer.equals(excessiveMuxer), currentlyRegisteredMuxer.getVideoBitrate(), currentlyRegisteredMuxer.getAudioBitrate(), targetBitrate});
            }
        } else {
            this.logActiveStatus(streamId, webRTCClient, currentlyRegisteredMuxer, adaptedMuxer, targetBitrate, currentBitrateDiff, excessiveMuxer);
        }
    }

    public int getNumberOfLiveStreams() {
        return this.numberOfLiveStreams.get();
    }

    public int getNumberOfTotalViewers() {
        int totalViewer = 0;
        for (List<IWebRTCMuxer> webRTCMuxerList : this.muxerMap.values()) {
            for (IWebRTCMuxer iWebRTCMuxer : webRTCMuxerList) {
                totalViewer += iWebRTCMuxer.getClientCount();
            }
        }
        logger.debug("total number of viewers: {}", (Object)totalViewer);
        return totalViewer;
    }

    public int getNumberOfViewers(String streamId) {
        int numberOfViewer = -1;
        if (this.muxerMap.containsKey(streamId)) {
            numberOfViewer = 0;
            List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
            for (IWebRTCMuxer iWebRTCMuxer : list) {
                numberOfViewer += iWebRTCMuxer.getClientCount();
            }
        }
        logger.info("get number of viewers for stream id {} is {}", (Object)streamId, (Object)numberOfViewer);
        return numberOfViewer;
    }

    public List<IWebRTCMuxer> getWebRTCMuxers(String streamId) {
        return this.muxerMap.get(streamId);
    }

    public Set<String> getStreams() {
        return this.muxerMap.keySet();
    }

    public List<WebRTCClientStats> getWebRTCClientStats(String streamId) {
        ArrayList<WebRTCClientStats> clientStatsList = new ArrayList<WebRTCClientStats>();
        if (this.muxerMap.containsKey(streamId)) {
            List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
            for (IWebRTCMuxer iWebRTCMuxer : list) {
                Queue clientList = iWebRTCMuxer.getClientList();
                int sendBitrate = iWebRTCMuxer.getAudioBitrate() + iWebRTCMuxer.getVideoBitrate();
                for (IWebRTCClient iWebRTCClient : clientList) {
                    WebRTCClientStats webRTCClientStats = new WebRTCClientStats(iWebRTCClient.getTargetBitrate(), sendBitrate, (double)iWebRTCClient.getVideoFrameSentPeriod(), (double)iWebRTCClient.getAudioFrameSentPeriod(), iWebRTCClient.getSendVideoPacketCallCount(), iWebRTCClient.getSendAudioPacketCallCount(), iWebRTCClient.hashCode(), iWebRTCClient.getClientInfo());
                    webRTCClientStats.setVideoSentStats(iWebRTCClient.getVideoStats());
                    webRTCClientStats.setAudioSentStats(iWebRTCClient.getAudioStats());
                    clientStatsList.add(webRTCClientStats);
                }
            }
        }
        return clientStatsList;
    }

    public void setExcessiveBandwidthCallThreshold(int excessiveBandwidthCallThreshold) {
        this.excessiveBandwidthCallThreshold = excessiveBandwidthCallThreshold;
    }

    public void setExcessiveBandwidthValue(int excessiveBandwidthValue) {
        this.excessiveBandwidthValue = excessiveBandwidthValue;
    }

    public void setExcessiveBandwidthAlgorithmEnabled(boolean excessiveBandwidthAlgorithmEnabled) {
        logger.info("setting excessive bandwidth algorithm enabled:{} ", (Object)excessiveBandwidthAlgorithmEnabled);
        this.excessiveBandwidthChecker = excessiveBandwidthAlgorithmEnabled ? this::checkExcessiveBandwidthImpl : this::logActiveStatus;
    }

    public void setPacketLossDiffThresholdForSwitchback(int packetLossDiffThresholdForSwitchback) {
        this.packetLossDiffThresholdForSwitchback = packetLossDiffThresholdForSwitchback;
    }

    public void setRttMeasurementDiffThresholdForSwitchback(int rttMeasurementDiffThresholdForSwitchback) {
        this.rttMeasurementDiffThresholdForSwitchback = rttMeasurementDiffThresholdForSwitchback;
    }

    public void setTryCountBeforeSwitchback(int tryCountBeforeSwitchback) {
        this.tryCountBeforeSwitchback = tryCountBeforeSwitchback;
    }

    public int getTryCountBeforeSwitchback() {
        return this.tryCountBeforeSwitchback;
    }

    public int getPacketLossDiffThresholdForSwitchback() {
        return this.packetLossDiffThresholdForSwitchback;
    }

    public int getRttMeasurementDiffThresholdForSwitchback() {
        return this.rttMeasurementDiffThresholdForSwitchback;
    }

    private static interface ICheckExcessiveBandwidth {
        public void checkExcessiveBandwidth(String var1, IWebRTCClient var2, IWebRTCMuxer var3, IWebRTCMuxer var4, int var5, int var6, IWebRTCMuxer var7);
    }
}

