/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SubtrackPoller {
    public static final long POLL_PERIOD = 5000L;
    private HashMap<String, List<SubtrackPollerListener>> mapTrackListeners = new HashMap();
    private Vertx vertx;
    private DataStore dataStore;

    public SubtrackPoller(Vertx vertx, DataStore dataStore) {
        this.vertx = vertx;
        this.dataStore = dataStore;
        this.init();
    }

    public void register(String streamId, SubtrackPollerListener listener) {
        List<SubtrackPollerListener> listeners = this.mapTrackListeners.get(streamId);
        if (listeners == null) {
            listeners = new ArrayList<SubtrackPollerListener>();
            this.mapTrackListeners.put(streamId, listeners);
        }
        listeners.add(listener);
    }

    private void init() {
        this.vertx.setPeriodic(5000L, l -> {
            for (String streamId : this.mapTrackListeners.keySet()) {
                Broadcast mainBroadcast = this.dataStore.get(streamId);
                if (mainBroadcast == null) continue;
                for (SubtrackPollerListener listener : this.mapTrackListeners.get(streamId)) {
                    listener.onSubTracks(mainBroadcast.getSubTrackStreamIds());
                }
            }
        });
    }

    public void unRegister(String streamId, SubtrackPollerListener subtrackPollerListener) {
        List<SubtrackPollerListener> listeners = this.mapTrackListeners.get(streamId);
        listeners.remove(subtrackPollerListener);
        if (listeners.isEmpty()) {
            this.mapTrackListeners.remove(streamId);
        }
    }

    public static interface SubtrackPollerListener {
        public void onSubTracks(List<String> var1);
    }
}

