/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.webrtc;

import io.antmedia.AppSettings;
import io.antmedia.enterprise.webrtc.IDataChannelMessagePublisher;
import io.antmedia.enterprise.webrtc.IDataChannelMessageSender;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.DataChannel;

public class DataChannelRouter {
    private static Logger logger = LoggerFactory.getLogger(DataChannelRouter.class);
    private Map<String, IDataChannelMessagePublisher> mapPublishers = new ConcurrentHashMap<String, IDataChannelMessagePublisher>();
    private Map<String, List<IDataChannelMessageSender>> mapPlayers = new ConcurrentHashMap<String, List<IDataChannelMessageSender>>();
    private AppSettings appSettings;
    private Object lock = new Object();

    public DataChannelRouter(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publisherMessageReceived(String streamId, byte[] data, boolean binary) {
        List<IDataChannelMessageSender> players = this.mapPlayers.get(streamId);
        if (players != null) {
            IDataChannelMessagePublisher publisher = this.mapPublishers.get(streamId);
            publisher.sendMessageToDataChannelWebHook(new DataChannel.Buffer(ByteBuffer.wrap((byte[])data.clone()), binary));
            Object object = this.lock;
            synchronized (object) {
                for (IDataChannelMessageSender player : players) {
                    player.sendMessageViaDataChannel(new DataChannel.Buffer(ByteBuffer.wrap((byte[])data.clone()), binary));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerMessageReceived(IDataChannelMessageSender source, String streamId, byte[] data, boolean binary) {
        IDataChannelMessageSender publisher = this.mapPublishers.get(streamId);
        if (publisher != null) {
            String dist = this.appSettings.getDataChannelPlayerDistribution();
            if (!dist.equals("none")) {
                List<IDataChannelMessageSender> players;
                publisher.sendMessageViaDataChannel(new DataChannel.Buffer(ByteBuffer.wrap((byte[])data.clone()), binary));
                if (dist.equals("all") && (players = this.mapPlayers.get(streamId)) != null) {
                    Object object = this.lock;
                    synchronized (object) {
                        for (IDataChannelMessageSender player : players) {
                            if (player == source) continue;
                            player.sendMessageViaDataChannel(new DataChannel.Buffer(ByteBuffer.wrap((byte[])data.clone()), binary));
                        }
                    }
                }
            }
        } else {
            logger.error("Data is not delivered because publisher is removed from data channel for stream {}", (Object)streamId);
        }
    }

    public void addPublisher(String streamId, IDataChannelMessagePublisher publisher) {
        this.mapPublishers.put(streamId, publisher);
    }

    public void addPlayer(String streamId, IDataChannelMessageSender player) {
        logger.info("add data channel player for stream:{} and player:{}", (Object)streamId, (Object)player.hashCode());
        List<IDataChannelMessageSender> players = this.mapPlayers.get(streamId);
        if (players == null) {
            players = new LinkedList<IDataChannelMessageSender>();
        }
        players.add(player);
        this.mapPlayers.put(streamId, players);
    }

    public void removePublisher(String streamId, IDataChannelMessageSender publisher) {
        this.mapPublishers.remove(streamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(String streamId, IDataChannelMessageSender player) {
        logger.info("remove data channel player for stream:{} and player:{}", (Object)streamId, (Object)player.hashCode());
        List<IDataChannelMessageSender> players = this.mapPlayers.get(streamId);
        Object object = this.lock;
        synchronized (object) {
            players.remove(player);
        }
        if (players.isEmpty()) {
            this.mapPlayers.remove(streamId);
        }
    }

    public boolean doesPublisherForStreamExist(String streamId) {
        return this.mapPublishers.containsKey(streamId);
    }
}

