/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.tensorflow.recognition;

import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.enterprise.tensorflow.IDeepLearningProcessor;
import io.antmedia.enterprise.tensorflow.recognition.GraphBuilder;
import io.antmedia.muxer.Muxer;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.tensorflow.Graph;
import org.tensorflow.Output;
import org.tensorflow.Session;
import org.tensorflow.Tensor;

public class TensorFlowRecognizer
extends Muxer
implements IDeepLearningProcessor {
    private String modelDir;
    private byte[] graphDef;
    private List<String> labels;
    private TensorFlowObject latestRecognizedObject;

    public TensorFlowRecognizer(Vertx vertx, String modelDir) {
        super(vertx);
        this.modelDir = modelDir;
        this.init();
    }

    public void init() {
        this.graphDef = this.readAllBytesOrExit(Paths.get(this.modelDir, "tensorflow_inception_graph.pb"));
        this.labels = this.readAllLinesOrExit(Paths.get(this.modelDir, "imagenet_comp_graph_label_strings.txt"));
    }

    public boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        return false;
    }

    public boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        return false;
    }

    public boolean prepareIO() {
        return false;
    }

    public void writeTrailer() {
    }

    public void writePacket(AVPacket avpacket, AVStream inStream) {
    }

    public void writePacket(AVPacket pkt, AVCodecContext codecContex) {
        byte[] data = new byte[pkt.size()];
        pkt.data().get(data);
        this.process(data);
    }

    @Override
    public void process(byte[] data) {
        try (Tensor<Float> image = this.constructAndExecuteGraphToNormalizeImage(data);){
            float[] labelProbabilities = this.executeInceptionGraph(this.graphDef, image);
            int bestLabelIdx = this.maxIndex(labelProbabilities);
            this.latestRecognizedObject = new TensorFlowObject(this.labels.get(bestLabelIdx), labelProbabilities[bestLabelIdx] * 100.0f, "id");
        }
    }

    @Override
    public TensorFlowObject getLatestRecognizedObject() {
        return this.latestRecognizedObject;
    }

    private byte[] readAllBytesOrExit(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            System.err.println("Failed to read [" + path + "]: " + e.getMessage());
            System.exit(1);
            return null;
        }
    }

    private List<String> readAllLinesOrExit(Path path) {
        try {
            return Files.readAllLines(path, Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            System.err.println("Failed to read [" + path + "]: " + e.getMessage());
            System.exit(0);
            return null;
        }
    }

    private Tensor<Float> constructAndExecuteGraphToNormalizeImage(byte[] imageBytes) {
        try (Graph g = new Graph();){
            Tensor tensor;
            GraphBuilder b = new GraphBuilder(g);
            int H = 224;
            int W = 224;
            float mean = 117.0f;
            float scale = 1.0f;
            Output<String> input = b.constant("input", imageBytes);
            Output<Float> output = b.div(b.sub(b.resizeBilinear(b.expandDims(b.cast(b.decodeJpeg(input, 3L), Float.class), b.constant("make_batch", 0)), b.constant("size", new int[]{224, 224})), b.constant("mean", 117.0f)), b.constant("scale", 1.0f));
            try (Session s = new Session(g);){
                tensor = ((Tensor)s.runner().fetch(output.op().name()).run().get(0)).expect(Float.class);
            }
            return tensor;
        }
    }

    /*
     * Exception decompiling
     */
    private float[] executeInceptionGraph(byte[] graphDef, Tensor<Float> image) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int maxIndex(float[] probabilities) {
        int best = 0;
        for (int i = 1; i < probabilities.length; ++i) {
            if (!(probabilities[i] > probabilities[best])) continue;
            best = i;
        }
        return best;
    }

    @Override
    public List<TensorFlowObject> getObjects() {
        return null;
    }
}

