/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.tensorflow.recognition;

import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.types.UInt8;

public class GraphBuilder {
    private Graph g;

    GraphBuilder(Graph g) {
        this.g = g;
    }

    Output<Float> div(Output<Float> x, Output<Float> y) {
        return this.binaryOp("Div", x, y);
    }

    <T> Output<T> sub(Output<T> x, Output<T> y) {
        return this.binaryOp("Sub", x, y);
    }

    <T> Output<Float> resizeBilinear(Output<T> images, Output<Integer> size) {
        return this.binaryOp3("ResizeBilinear", images, size);
    }

    <T> Output<T> expandDims(Output<T> input, Output<Integer> dim) {
        return this.binaryOp3("ExpandDims", input, dim);
    }

    <T, U> Output<U> cast(Output<T> value, Class<U> type) {
        DataType dtype = DataType.fromClass(type);
        return this.g.opBuilder("Cast", "Cast").addInput(value).setAttr("DstT", dtype).build().output(0);
    }

    Output<UInt8> decodeJpeg(Output<String> contents, long channels) {
        return this.g.opBuilder("DecodeJpeg", "DecodeJpeg").addInput(contents).setAttr("channels", channels).build().output(0);
    }

    <T> Output<T> constant(String name, Object value, Class<T> type) {
        try (Tensor t = Tensor.create((Object)value, type);){
            Output output = this.g.opBuilder("Const", name).setAttr("dtype", DataType.fromClass(type)).setAttr("value", t).build().output(0);
            return output;
        }
    }

    Output<String> constant(String name, byte[] value) {
        return this.constant(name, value, String.class);
    }

    Output<Integer> constant(String name, int value) {
        return this.constant(name, value, Integer.class);
    }

    Output<Integer> constant(String name, int[] value) {
        return this.constant(name, value, Integer.class);
    }

    Output<Float> constant(String name, float value) {
        return this.constant(name, Float.valueOf(value), Float.class);
    }

    private <T> Output<T> binaryOp(String type, Output<T> in1, Output<T> in2) {
        return this.g.opBuilder(type, type).addInput(in1).addInput(in2).build().output(0);
    }

    private <T, U, V> Output<T> binaryOp3(String type, Output<U> in1, Output<V> in2) {
        return this.g.opBuilder(type, type).addInput(in1).addInput(in2).build().output(0);
    }
}

