/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.tensorflow.detection;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.enterprise.tensorflow.IDeepLearningProcessor;
import io.antmedia.enterprise.tensorflow.detection.Classifier;
import io.antmedia.enterprise.tensorflow.detection.TFObjectDetector;
import io.antmedia.muxer.Muxer;
import io.vertx.core.Vertx;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorFlowDetector
extends Muxer
implements IDeepLearningProcessor {
    private String modelDir;
    private Classifier classifier;
    List<TensorFlowObject> tensorFlowObjects;
    private String streamId;
    private long captureCount = 0L;
    private DataStore dataStore;
    private static Logger logger = LoggerFactory.getLogger(TensorFlowDetector.class);

    public TensorFlowDetector(Vertx vertx, DataStore dataStore, String modelDir) throws IOException {
        super(vertx);
        this.modelDir = modelDir;
        this.classifier = TFObjectDetector.create(modelDir);
        this.tensorFlowObjects = new ArrayList<TensorFlowObject>();
        this.dataStore = dataStore;
    }

    public void init(IScope scope, String name, int resolution, String subFolder, int bitrate) {
        super.init(scope, name, resolution, subFolder, bitrate);
        this.streamId = name;
    }

    public File getResourceFile(IScope scope, String name, String extension, String subFolder) {
        return TensorFlowDetector.getPreviewFile((IScope)scope, (String)name, (String)extension);
    }

    @Override
    public void process(byte[] data) throws IOException {
        this.vertx.executeBlocking(b -> {
            this.processInternal(data);
            b.complete();
        }, null);
    }

    public void processInternal(byte[] data) {
        try {
            long startTime = System.currentTimeMillis();
            ArrayList<TensorFlowObject> newDetectedObjects = new ArrayList<TensorFlowObject>();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedImage image = ImageIO.read(bais);
            List<Classifier.Recognition> recognitionList = this.classifier.recognizeImage(image);
            String recordId = this.streamId + "_" + this.captureCount;
            for (Classifier.Recognition recognition : recognitionList) {
                TensorFlowObject tfObject = new TensorFlowObject(recognition.getTitle(), recognition.getConfidence().floatValue(), recordId);
                tfObject.setMinX(recognition.getLocation().getMinX());
                tfObject.setMinY(recognition.getLocation().getMinY());
                tfObject.setMaxX(recognition.getLocation().getMaxX());
                tfObject.setMaxY(recognition.getLocation().getMaxY());
                newDetectedObjects.add(tfObject);
                logger.info("Recognized object -> ID: {} - Title: {} - Score: {}", new Object[]{recognition.getId(), recognition.getTitle(), recognition.getConfidence()});
            }
            logger.info("Processing time: {} ms. Number of found objects {}", (Object)(System.currentTimeMillis() - startTime), (Object)newDetectedObjects.size());
            if (recognitionList.size() > 0) {
                boolean detectedDifferentObjects = false;
                if (newDetectedObjects.size() != this.tensorFlowObjects.size()) {
                    detectedDifferentObjects = true;
                } else {
                    for (int i = 0; i < newDetectedObjects.size(); ++i) {
                        boolean foundMatch = false;
                        for (int j = 0; j < this.tensorFlowObjects.size(); ++j) {
                            logger.info("current object: {} previous object: {}", (Object)((TensorFlowObject)newDetectedObjects.get((int)i)).objectName, (Object)this.tensorFlowObjects.get((int)j).objectName);
                            if (!((TensorFlowObject)newDetectedObjects.get((int)i)).objectName.equals(this.tensorFlowObjects.get((int)j).objectName)) continue;
                            foundMatch = true;
                            break;
                        }
                        if (foundMatch) continue;
                        detectedDifferentObjects = true;
                        break;
                    }
                }
                if (detectedDifferentObjects) {
                    this.tensorFlowObjects = newDetectedObjects;
                    File outputFile = TensorFlowDetector.getPreviewFile((IScope)this.scope, (String)recordId, (String)".jpeg");
                    logger.info("outputting to {}", (Object)outputFile.getAbsolutePath());
                    this.saveAnnotatedImage(image, recognitionList, outputFile);
                    if (this.dataStore != null) {
                        this.dataStore.saveDetection(recordId, System.currentTimeMillis(), this.tensorFlowObjects);
                    }
                    ++this.captureCount;
                } else {
                    logger.info("detection is the same as previous one");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveAnnotatedImage(BufferedImage image, List<Classifier.Recognition> recognitions, File outputImageFile) throws IOException {
        Graphics2D g2D = image.createGraphics();
        g2D.setColor(Color.RED);
        g2D.setStroke(new BasicStroke(image.getWidth() * 5 / 1000));
        for (Classifier.Recognition recognition : recognitions) {
            Rectangle rectangle = new Rectangle((int)recognition.getLocation().getMinX(), (int)recognition.getLocation().getMinY(), (int)(recognition.getLocation().getWidth() + 0.5), (int)(recognition.getLocation().getHeight() + 0.5));
            g2D.draw(rectangle);
        }
        ImageIO.write((RenderedImage)image, "jpeg", outputImageFile);
    }

    @Override
    public TensorFlowObject getLatestRecognizedObject() {
        if (!this.tensorFlowObjects.isEmpty()) {
            return this.tensorFlowObjects.get(0);
        }
        return null;
    }

    @Override
    public List<TensorFlowObject> getObjects() {
        return this.tensorFlowObjects;
    }

    public boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        return false;
    }

    public boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        return false;
    }

    public boolean prepareIO() {
        return false;
    }

    public void writeTrailer() {
    }

    public void writePacket(AVPacket avpacket, AVStream inStream) {
    }

    public void writePacket(AVPacket pkt, AVCodecContext codecContex) {
    }
}

