/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.tensorflow.detection;

import java.awt.image.BufferedImage;
import java.util.List;
import javafx.geometry.Rectangle2D;

public interface Classifier {
    public List<Recognition> recognizeImage(BufferedImage var1);

    public static class Recognition {
        private final String id;
        private final String title;
        private final Float confidence;
        private Rectangle2D location;

        public Recognition(String id, String title, Float confidence, Rectangle2D location) {
            this.id = id;
            this.title = title;
            this.confidence = confidence;
            this.location = location;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public Float getConfidence() {
            return this.confidence;
        }

        public Rectangle2D getLocation() {
            return this.location;
        }

        public void setLocation(Rectangle2D location) {
            this.location = location;
        }

        public String toString() {
            Object resultString = "";
            if (this.id != null) {
                resultString = (String)resultString + "[" + this.id + "] ";
            }
            if (this.title != null) {
                resultString = (String)resultString + this.title + " ";
            }
            if (this.confidence != null) {
                resultString = (String)resultString + String.format("(%.1f%%) ", Float.valueOf(this.confidence.floatValue() * 100.0f));
            }
            if (this.location != null) {
                resultString = (String)resultString + this.location + " ";
            }
            return ((String)resultString).trim();
        }
    }
}

