/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.social.endpoint;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Clock;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.api.services.youtube.YouTube;
import com.google.api.services.youtube.model.CdnSettings;
import com.google.api.services.youtube.model.Channel;
import com.google.api.services.youtube.model.ChannelListResponse;
import com.google.api.services.youtube.model.ChannelSnippet;
import com.google.api.services.youtube.model.IngestionInfo;
import com.google.api.services.youtube.model.LiveBroadcast;
import com.google.api.services.youtube.model.LiveBroadcastContentDetails;
import com.google.api.services.youtube.model.LiveBroadcastListResponse;
import com.google.api.services.youtube.model.LiveBroadcastSnippet;
import com.google.api.services.youtube.model.LiveBroadcastStatus;
import com.google.api.services.youtube.model.LiveChatMessage;
import com.google.api.services.youtube.model.LiveChatMessageAuthorDetails;
import com.google.api.services.youtube.model.LiveChatMessageListResponse;
import com.google.api.services.youtube.model.LiveChatMessageSnippet;
import com.google.api.services.youtube.model.LiveStream;
import com.google.api.services.youtube.model.LiveStreamListResponse;
import com.google.api.services.youtube.model.LiveStreamSnippet;
import com.google.api.services.youtube.model.LiveStreamStatus;
import com.google.api.services.youtube.model.MonitorStreamInfo;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoListResponse;
import com.google.api.services.youtube.model.VideoStatistics;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.rest.model.Interaction;
import io.antmedia.rest.model.User;
import io.antmedia.rest.model.UserType;
import io.antmedia.social.LiveComment;
import io.antmedia.social.ResourceOrigin;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeEndpoint
extends VideoServiceEndpoint {
    protected static final String STATUS = "status";
    protected static final String SNIPPET = "snippet";
    protected static final String AUTHOR_DETAILS = "authorDetails";
    protected static final String STATISTICS = "statistics";
    private static final String FIRST_AUTHENTICATED_THE_SERVER = "First authenticated the server";
    private Map<String, List<LiveComment>> commentMapList = new ConcurrentHashMap<String, List<LiveComment>>();
    protected Map<String, Integer> viewerCountMap = new HashMap<String, Integer>();
    private Map<String, Interaction> interactionMap = new HashMap<String, Interaction>();
    private static Logger logger = LoggerFactory.getLogger(YoutubeEndpoint.class);
    private List<String> activeStreamList = new ArrayList<String>();
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    public static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private YouTube mYoutube;
    private String device_code;
    private String accessToken;

    public YoutubeEndpoint(String clientId, String clientSecret, DataStore dataStore, SocialEndpointCredentials credentials, Vertx vertx) {
        super(clientId, clientSecret, dataStore, credentials, vertx);
    }

    public void init(String accountName, String accessToken, String refreshToken, long expireTimeSeconds, String tokenType, long authTime) {
        this.accessToken = accessToken;
        Credential credential = this.newCredential();
        credential.setAccessToken(accessToken);
        credential.setRefreshToken(refreshToken);
        credential.setExpiresInSeconds(Long.valueOf(expireTimeSeconds));
        this.mYoutube = new YouTube.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName("Ant Media Server").build();
    }

    private Credential newCredential() {
        Credential.Builder builder = new Credential.Builder(BearerToken.authorizationHeaderAccessMethod()).setTransport(HTTP_TRANSPORT).setJsonFactory(JSON_FACTORY).setTokenServerEncodedUrl("https://accounts.google.com/o/oauth2/token").setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.getClientId(), this.getClientSecret())).setRequestInitializer(null).setClock(Clock.SYSTEM);
        builder.addRefreshListener(new CredentialRefreshListener(){

            public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
                try {
                    YoutubeEndpoint.this.saveCredentials(YoutubeEndpoint.this.getCredentials().getAccountName(), credential.getAccessToken(), credential.getRefreshToken(), String.valueOf(credential.getExpiresInSeconds()), YoutubeEndpoint.this.getCredentials().getTokenType(), YoutubeEndpoint.this.getCredentials().getAccountId());
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }

            public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
                logger.error("onTokenErrorResponse in account tname {}", (Object)YoutubeEndpoint.this.getCredentials().getAccountName());
            }
        });
        return builder.build();
    }

    public LiveStreamStatus getLiveStreamStatus(String streamId) {
        try {
            YouTube.LiveStreams.List liveStream = this.mYoutube.liveStreams().list(STATUS);
            liveStream.setId(streamId);
            LiveStreamListResponse streamListResponse = (LiveStreamListResponse)liveStream.execute();
            LiveStream stream = (LiveStream)streamListResponse.getItems().get(0);
            return stream.getStatus();
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public boolean startEvent(String broadcastId) throws IOException {
        YouTube.LiveBroadcasts.Transition transitionRequest = this.mYoutube.liveBroadcasts().transition("live", broadcastId, STATUS);
        transitionRequest.execute();
        return transitionRequest.getBroadcastStatus().equals("live");
    }

    public LiveBroadcastStatus endEvent(String broadcastId) throws IOException {
        YouTube.LiveBroadcasts.Transition transitionRequest = this.mYoutube.liveBroadcasts().transition("complete", broadcastId, STATUS);
        LiveBroadcast liveBroadcast = (LiveBroadcast)transitionRequest.execute();
        return liveBroadcast.getStatus();
    }

    public boolean bindEventAndStream(LiveBroadcast liveBroadcast, LiveStream liveStream) {
        YouTube.LiveBroadcasts.Bind liveBroadcastBind = null;
        try {
            liveBroadcastBind = this.mYoutube.liveBroadcasts().bind(liveBroadcast.getId(), "id,contentDetails");
            liveBroadcastBind.setStreamId(liveStream.getId());
            liveBroadcastBind.execute();
            return true;
        }
        catch (GoogleJsonResponseException e) {
            logger.error("GoogleJsonResponseException code: {} : {}", (Object)e.getDetails().getCode(), (Object)e.getDetails().getMessage());
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return false;
    }

    private LiveBroadcast createEvent(String name, String description, boolean is360, boolean isPublic) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long futureDateMillis = System.currentTimeMillis() + 600000L;
        Date futureDate = new Date();
        futureDate.setTime(futureDateMillis);
        LiveBroadcastSnippet broadcastSnippet = new LiveBroadcastSnippet();
        broadcastSnippet.setTitle(name);
        if (description != null) {
            broadcastSnippet.setDescription(description);
        }
        broadcastSnippet.setScheduledStartTime(new DateTime(futureDate));
        LiveBroadcastContentDetails contentDetails = new LiveBroadcastContentDetails();
        MonitorStreamInfo monitorStream = new MonitorStreamInfo();
        monitorStream.setEnableMonitorStream(Boolean.valueOf(false));
        contentDetails.setMonitorStream(monitorStream);
        contentDetails.setEnableDvr(Boolean.valueOf(true));
        contentDetails.setEnableLowLatency(Boolean.valueOf(false));
        if (is360) {
            contentDetails.setProjection("360");
        }
        LiveBroadcastStatus status = new LiveBroadcastStatus();
        if (!isPublic) {
            status.setPrivacyStatus("private");
        } else {
            status.setPrivacyStatus("public");
        }
        LiveBroadcast broadcast = new LiveBroadcast();
        broadcast.setKind("youtube#liveBroadcast");
        broadcast.setSnippet(broadcastSnippet);
        broadcast.setStatus(status);
        broadcast.setContentDetails(contentDetails);
        YouTube.LiveBroadcasts.Insert liveBroadcastInsert = null;
        liveBroadcastInsert = this.mYoutube.liveBroadcasts().insert("snippet,status,contentDetails", broadcast);
        return (LiveBroadcast)liveBroadcastInsert.execute();
    }

    private LiveStream createStream(int height) throws IOException {
        LiveStreamSnippet streamSnippet = new LiveStreamSnippet();
        streamSnippet.setTitle("Ant-Media-Server-Stream" + height);
        CdnSettings cdn = new CdnSettings();
        cdn.setFrameRate("30fps");
        cdn.setResolution(height + "p");
        cdn.setIngestionType("rtmp");
        LiveStream stream = new LiveStream();
        stream.setKind("youtube#liveStream");
        stream.setSnippet(streamSnippet);
        stream.setCdn(cdn);
        YouTube.LiveStreams.Insert liveStreamInsert = this.mYoutube.liveStreams().insert("snippet,cdn", stream);
        return (LiveStream)liveStreamInsert.execute();
    }

    public VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters() throws Exception {
        GenericUrl genericUrl = new GenericUrl("https://accounts.google.com/o/oauth2/device/code");
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("client_id", this.getClientId());
        mapData.put("scope", "https://www.googleapis.com/auth/youtube");
        UrlEncodedContent content = new UrlEncodedContent(mapData);
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));
        HttpRequest postRequest = requestFactory.buildPostRequest(genericUrl, (HttpContent)content);
        Device device = (Device)postRequest.execute().parseAs(Device.class);
        if (device == null) {
            throw new NullPointerException("Device object is null, request is not successful");
        }
        this.authParameters = new VideoServiceEndpoint.DeviceAuthParameters();
        this.authParameters.device_code = device.device_code;
        this.device_code = device.device_code;
        this.authParameters.user_code = device.user_code;
        this.authParameters.expires_in = device.expires_in;
        this.authParameters.interval = device.interval;
        this.authParameters.verification_url = device.verification_url;
        return this.authParameters;
    }

    public boolean askIfDeviceAuthenticated() throws Exception {
        if (this.device_code == null) {
            throw new NullPointerException("First call askDeviceAuthParameters");
        }
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("client_id", this.getClientId());
        mapData.put("client_secret", this.getClientSecret());
        mapData.put("code", this.device_code);
        mapData.put("grant_type", "http://oauth.net/grant_type/device/1.0");
        UrlEncodedContent content = new UrlEncodedContent(mapData);
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));
        boolean result = false;
        HttpRequest postRequest = requestFactory.buildPostRequest(new GenericUrl("https://accounts.google.com/o/oauth2/token"), (HttpContent)content);
        DeviceToken deviceToken = (DeviceToken)postRequest.execute().parseAs(DeviceToken.class);
        if (deviceToken != null && deviceToken.access_token != null) {
            String accountName = "";
            String accountId = "";
            this.init(accountName, deviceToken.access_token, deviceToken.refresh_token, deviceToken.expires_in, deviceToken.token_type, System.currentTimeMillis());
            Channel channel = this.getYoutubeChannel();
            if (channel != null) {
                ChannelSnippet snippet = channel.getSnippet();
                accountName = snippet.getTitle();
                accountId = channel.getId();
            }
            try {
                LiveBroadcast createEvent = this.createEvent("test_stream", "Private test_stream to check your account is enabled for live streaming. You can delete this stream", false, false);
                this.saveCredentials(accountName, deviceToken.access_token, deviceToken.refresh_token, String.valueOf(deviceToken.expires_in), deviceToken.token_type, accountId);
                this.mYoutube.liveBroadcasts().delete(createEvent.getId()).execute();
                result = true;
            }
            catch (Exception e) {
                this.setError("LIVE_STREAMING_NOT_ENABLED");
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    public Channel getYoutubeChannel() {
        try {
            YouTube.Channels.List channelsListMineRequest = this.mYoutube.channels().list(SNIPPET);
            channelsListMineRequest.setMine(Boolean.valueOf(true));
            ChannelListResponse response = (ChannelListResponse)channelsListMineRequest.execute();
            return (Channel)response.getItems().get(0);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public String getName() {
        return "youtube";
    }

    public boolean isAuthenticated() {
        return this.mYoutube != null && this.accessToken != null && this.accessToken.length() > 0;
    }

    public void resetCredentials() {
        super.resetCredentials();
        this.accessToken = null;
    }

    public Endpoint createBroadcast(String name, String description, String serverStreamId, boolean is360, boolean isPublic, int videoHeight, boolean isLowLatency) throws IOException {
        boolean binded;
        LiveStream stream;
        LiveBroadcast liveBroadcast;
        if (this.mYoutube == null) {
            throw new NullPointerException(FIRST_AUTHENTICATED_THE_SERVER);
        }
        if (name == null) {
            name = "no_title";
        }
        if ((liveBroadcast = this.createEvent(name, description, is360, isPublic)) != null && (stream = this.createStream(videoHeight)) != null && (binded = this.bindEventAndStream(liveBroadcast, stream))) {
            IngestionInfo ingestionInfo = stream.getCdn().getIngestionInfo();
            String rtmpUrl = ingestionInfo.getIngestionAddress() + "/" + ingestionInfo.getStreamName();
            return new Endpoint(liveBroadcast.getId(), stream.getId(), name, rtmpUrl, this.getName(), this.getCredentials().getId(), serverStreamId);
        }
        return null;
    }

    public void publishBroadcast(Endpoint endpoint) throws Exception {
        if (this.mYoutube == null) {
            throw new NullPointerException(FIRST_AUTHENTICATED_THE_SERVER);
        }
        if (endpoint.getBroadcastId() == null) {
            throw new NullPointerException("No broadcast is available, call createBroadcast function before calling publish broadcast");
        }
        this.vertx.executeBlocking(future -> {
            LiveStreamStatus streamStatus = null;
            try {
                do {
                    streamStatus = this.getLiveStreamStatus(endpoint.getStreamId());
                    logger.info("youtube stream status: {}", (Object)streamStatus);
                } while (!streamStatus.getStreamStatus().equals("active"));
                this.startEvent(endpoint.getBroadcastId());
                this.activeStreamList.add(endpoint.getServerStreamId());
                if (this.collectInteractivity) {
                    this.startCollectingInteractivity(endpoint);
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            future.complete((Object)true);
        }, resultHandler -> logger.info("result execute blocking: {}", resultHandler.result()));
    }

    protected void startCollectingInteractivity(Endpoint endpoint) {
        try {
            YouTube.LiveBroadcasts.List list = this.mYoutube.liveBroadcasts().list(SNIPPET);
            list.setId(endpoint.getBroadcastId());
            LiveBroadcastListResponse streamListResponse = (LiveBroadcastListResponse)list.execute();
            LiveBroadcast stream = (LiveBroadcast)streamListResponse.getItems().get(0);
            String liveChatId = stream.getSnippet().getLiveChatId();
            logger.info("live chat id: {}", (Object)liveChatId);
            this.fetchLiveChatMessages(liveChatId, endpoint, null);
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void fetchLiveChatMessages(String liveChatId, Endpoint endpoint, String pageToken) {
        try {
            YouTube.LiveChatMessages.List chatMessageList = this.mYoutube.liveChatMessages().list(liveChatId, "snippet,authorDetails");
            if (pageToken != null) {
                chatMessageList.setPageToken(pageToken);
            }
            LiveChatMessageListResponse chatMessageListResponse = (LiveChatMessageListResponse)chatMessageList.execute();
            Long pollingIntervalMillis = chatMessageListResponse.getPollingIntervalMillis();
            logger.trace("Polling interval {}ms for stream {}", (Object)pollingIntervalMillis, (Object)endpoint.getStreamId());
            String nextPageToken = chatMessageListResponse.getNextPageToken();
            List items = chatMessageListResponse.getItems();
            ArrayList<LiveComment> commentList = new ArrayList<LiveComment>();
            for (LiveChatMessage liveChatMessage : items) {
                LiveChatMessageAuthorDetails authorDetails = liveChatMessage.getAuthorDetails();
                User from = new User(authorDetails.getChannelId(), authorDetails.getDisplayName(), authorDetails.getProfileImageUrl(), UserType.YOUTUBE_USER);
                LiveChatMessageSnippet messageSnippet = liveChatMessage.getSnippet();
                commentList.add(new LiveComment(liveChatMessage.getId(), messageSnippet.getTextMessageDetails().getMessageText(), from, ResourceOrigin.YOUTUBE, messageSnippet.getPublishedAt().getValue()));
                logger.info("live comment {} from {} for stream Id: {}", new Object[]{messageSnippet.getTextMessageDetails().getMessageText(), from.getFullName(), endpoint.getStreamId()});
            }
            this.putCommentMap(endpoint.getServerStreamId(), commentList);
            YouTube.Videos.List videoList = this.mYoutube.videos().list(STATISTICS);
            videoList.setId(endpoint.getBroadcastId());
            VideoListResponse videoListResponse = (VideoListResponse)videoList.execute();
            VideoStatistics videoStatistics = ((Video)videoListResponse.getItems().get(0)).getStatistics();
            this.putInteractionMap(endpoint.getServerStreamId(), videoStatistics.getLikeCount().intValue());
            this.putViewerMap(endpoint.getServerStreamId(), videoStatistics.getViewCount().intValue());
            logger.info("like count {} viewer count {} for streamId {}", new Object[]{videoStatistics.getLikeCount(), videoStatistics.getViewCount(), endpoint.getStreamId()});
            if (this.activeStreamList.contains(endpoint.getServerStreamId())) {
                this.vertx.setTimer(pollingIntervalMillis.longValue(), handler -> this.fetchLiveChatMessages(liveChatId, endpoint, nextPageToken));
            } else {
                logger.debug("Stream does not exist in active stream list so it is stopping to fetch chat and like counts for stream Id {}", (Object)endpoint.getStreamId());
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void putViewerMap(String serverStreamId, int viewCount) {
        this.viewerCountMap.put(serverStreamId, viewCount);
    }

    public void putInteractionMap(String serverStreamId, int likeCount) {
        Interaction interaction = this.interactionMap.getOrDefault(serverStreamId, new Interaction());
        interaction.setLikeCount(likeCount);
        interaction.setOrigin(ResourceOrigin.YOUTUBE);
        this.interactionMap.put(serverStreamId, interaction);
    }

    public void putCommentMap(String serverStreamId, List<LiveComment> list) {
        if (list != null && !list.isEmpty()) {
            List<LiveComment> commentList = this.commentMapList.get(serverStreamId);
            if (commentList == null) {
                commentList = new ArrayList<LiveComment>();
            }
            commentList.addAll(list);
            this.commentMapList.put(serverStreamId, commentList);
        }
    }

    public void stopBroadcast(Endpoint endpoint) throws Exception {
        if (this.mYoutube == null) {
            throw new NullPointerException(FIRST_AUTHENTICATED_THE_SERVER);
        }
        if (endpoint.getBroadcastId() == null) {
            throw new NullPointerException("No broadcast is avaiable, you can only stop published broadcasts");
        }
        try {
            this.endEvent(endpoint.getBroadcastId());
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        this.activeStreamList.remove(endpoint.getServerStreamId());
        this.viewerCountMap.remove(endpoint.getServerStreamId());
        this.commentMapList.remove(endpoint.getServerStreamId());
        this.interactionMap.remove(endpoint.getServerStreamId());
    }

    public String getBroadcast(Endpoint endpoint) throws Exception {
        YouTube.LiveBroadcasts.List list = this.mYoutube.liveBroadcasts().list(STATUS);
        list.setId(endpoint.getBroadcastId());
        LiveBroadcastListResponse streamListResponse = (LiveBroadcastListResponse)list.execute();
        LiveBroadcast stream = (LiveBroadcast)streamListResponse.getItems().get(0);
        String liveStreamStatus = stream.getStatus().getLifeCycleStatus();
        String status = "UNPUBLISHED";
        if (liveStreamStatus.equals("live") || liveStreamStatus.equals("liveStarting")) {
            status = "LIVE";
        } else if (liveStreamStatus.equals("created")) {
            status = "UNPUBLISHED";
        } else if (liveStreamStatus.equals("complete")) {
            status = "LIVE_STOPPED";
        }
        return status;
    }

    public List<LiveComment> getComments(String streamId, int offset, int batch) {
        int size;
        List<LiveComment> comments = this.commentMapList.get(streamId);
        List<LiveComment> resultList = null;
        if (comments != null && offset < (size = comments.size())) {
            int toIndex = offset + batch;
            if (toIndex > size) {
                toIndex = size;
            }
            resultList = comments.subList(offset, toIndex);
        }
        return resultList;
    }

    public Interaction getInteraction(String streamId) {
        return this.interactionMap.getOrDefault(streamId, null);
    }

    public int getTotalCommentsCount(String streamId) {
        List<LiveComment> comments = this.commentMapList.get(streamId);
        if (comments != null) {
            return comments.size();
        }
        return 0;
    }

    public long getLiveViews(String streamId) {
        return this.viewerCountMap.getOrDefault(streamId, 0).intValue();
    }

    public List<String> getActiveStreamList() {
        return this.activeStreamList;
    }

    public void setActiveStreamList(List<String> activeStreamList) {
        this.activeStreamList = activeStreamList;
    }

    public static class DeviceToken {
        @Key
        public String access_token;
        @Key
        public String token_type;
        @Key
        public String refresh_token;
        @Key
        public int expires_in;
    }

    public static class Device {
        @Key
        public String device_code;
        @Key
        public String user_code;
        @Key
        public String verification_url;
        @Key
        public int expires_in;
        @Key
        public int interval;
    }
}

