/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.social.endpoint;

import com.restfb.Connection;
import com.restfb.DefaultFacebookClient;
import com.restfb.FacebookClient;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.exception.devicetoken.FacebookDeviceTokenCodeExpiredException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenDeclinedException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenPendingException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenSlowdownException;
import com.restfb.json.Json;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import com.restfb.scope.FacebookPermissions;
import com.restfb.scope.ScopeBuilder;
import com.restfb.types.Account;
import com.restfb.types.DeviceCode;
import com.restfb.types.LiveVideo;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointChannel;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.rest.model.Interaction;
import io.antmedia.rest.model.User;
import io.antmedia.rest.model.UserType;
import io.antmedia.social.LiveComment;
import io.antmedia.social.ResourceOrigin;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.glassfish.jersey.media.sse.EventSource;
import org.glassfish.jersey.media.sse.SseFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookEndpoint
extends VideoServiceEndpoint {
    private static final String FIELDS = "fields";
    private Map<String, List<LiveComment>> commentMapList = new HashMap<String, List<LiveComment>>();
    private Map<String, Interaction> interactionMap = new HashMap<String, Interaction>();
    protected Map<String, Integer> viewerCountMap = new HashMap<String, Integer>();
    private static final String BASE_SSE_URL = "https://streaming-graph.facebook.com/";
    private static Logger logger = LoggerFactory.getLogger(FacebookEndpoint.class);
    DefaultFacebookClient fbClient;
    private DefaultFacebookClient deviceTokenClient;
    private String deviceCode;
    private String accessToken;
    private List<Account> accountsList = new ArrayList<Account>();
    private Map<String, EventSource> eventSource4CommentsMap = new HashMap<String, EventSource>();
    private Map<String, EventSource> eventSource4ReactionsMap = new HashMap<String, EventSource>();
    private Map<String, Long> liveViewTimerMap = new HashMap<String, Long>();

    public FacebookEndpoint(String clientId, String clientSecret, DataStore dataStore, SocialEndpointCredentials credentials, Vertx vertx) {
        super(clientId, clientSecret, dataStore, credentials, vertx);
    }

    public void init(String accountName, String accessToken, String refreshToken, long expireTime, String tokenType, long authTime) {
        this.accessToken = accessToken;
        this.fbClient = new DefaultFacebookClient(this.accessToken, Version.LATEST);
    }

    public String getName() {
        return "facebook";
    }

    public VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters() throws Exception {
        String specialAccessToken = this.getClientId() + "|" + this.getClientSecret();
        this.deviceTokenClient = new DefaultFacebookClient(specialAccessToken, Version.LATEST);
        ScopeBuilder scope = new ScopeBuilder();
        scope.addPermission(FacebookPermissions.PUBLISH_PAGES);
        scope.addPermission(FacebookPermissions.MANAGE_PAGES);
        scope.addPermission(FacebookPermissions.USER_VIDEOS);
        scope.addPermission(FacebookPermissions.PUBLISH_VIDEO);
        DeviceCode deviceCodeTmp = this.deviceTokenClient.fetchDeviceCode(scope);
        if (deviceCodeTmp != null) {
            this.authParameters = new VideoServiceEndpoint.DeviceAuthParameters();
            this.authParameters.device_code = deviceCodeTmp.getCode();
            this.deviceCode = deviceCodeTmp.getCode();
            this.authParameters.user_code = deviceCodeTmp.getUserCode();
            this.authParameters.interval = deviceCodeTmp.getInterval();
            this.authParameters.expires_in = deviceCodeTmp.getExpiresIn();
            this.authParameters.verification_url = deviceCodeTmp.getVerificationUri();
        }
        return this.authParameters;
    }

    public boolean askIfDeviceAuthenticated() throws Exception {
        if (this.deviceTokenClient == null) {
            throw new NullPointerException("Call askDeviceAuthParameters first");
        }
        boolean result = false;
        try {
            FacebookClient.AccessToken accessTokenTmp = this.deviceTokenClient.obtainDeviceAccessToken(this.deviceCode);
            String accountName = "";
            this.init(accountName, accessTokenTmp.getAccessToken(), null, accessTokenTmp.getExpires().getTime(), accessTokenTmp.getTokenType(), System.currentTimeMillis());
            com.restfb.types.User userObject = (com.restfb.types.User)this.fbClient.fetchObject("me", com.restfb.types.User.class, new Parameter[]{Parameter.with((String)FIELDS, (Object)"name,id")});
            this.saveCredentials(userObject.getName(), accessTokenTmp.getAccessToken(), null, String.valueOf(accessTokenTmp.getExpires().getTime()), accessTokenTmp.getTokenType(), userObject.getId());
            result = true;
        }
        catch (FacebookDeviceTokenCodeExpiredException | FacebookDeviceTokenDeclinedException | FacebookDeviceTokenSlowdownException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (FacebookDeviceTokenPendingException facebookDeviceTokenPendingException) {
            // empty catch block
        }
        return result;
    }

    public boolean isAuthenticated() {
        return this.fbClient != null && this.accessToken != null && this.accessToken.length() > 0;
    }

    public SocialEndpointChannel getChannel() {
        SocialEndpointCredentials credentials = this.getCredentials();
        if (credentials != null) {
            return new SocialEndpointChannel(credentials.getAccountId(), credentials.getAccountName(), credentials.getAccountType());
        }
        return new SocialEndpointChannel();
    }

    public List<SocialEndpointChannel> getChannelList() {
        Connection accountConnection = this.fbClient.fetchConnection("me/accounts", Account.class, new Parameter[0]);
        ArrayList<SocialEndpointChannel> endpointChannelList = new ArrayList<SocialEndpointChannel>();
        SocialEndpointCredentials credentials = this.getCredentials();
        endpointChannelList.add(new SocialEndpointChannel(this.getCredentials().getId(), credentials.getAccountName(), "profile"));
        this.accountsList.clear();
        for (List accountPage : accountConnection) {
            for (Account account : accountPage) {
                this.accountsList.add(account);
                endpointChannelList.add(new SocialEndpointChannel(account.getId(), account.getName(), "page"));
            }
        }
        return endpointChannelList;
    }

    public boolean setActiveChannel(String type, String id) {
        SocialEndpointCredentials addSocialEndpointCredentials;
        boolean result = false;
        SocialEndpointCredentials credentials = this.getCredentials();
        String credentialDBId = null;
        if (credentials != null) {
            if (credentials.getAccountId().equals(id)) {
                result = true;
                return result;
            }
            credentialDBId = credentials.getId();
        }
        credentials = new SocialEndpointCredentials();
        credentials.setAccountType(type);
        credentials.setAccountId(id);
        credentials.setServiceName(this.getName());
        credentials.setId(credentialDBId);
        for (Account account : this.accountsList) {
            if (!account.getId().equals(id)) continue;
            credentials.setAccessToken(account.getAccessToken());
            credentials.setAccountName(account.getName());
            result = true;
            break;
        }
        if (result && (addSocialEndpointCredentials = this.dataStore.addSocialEndpointCredentials(credentials)) != null) {
            this.setCredentials(addSocialEndpointCredentials);
            long expireTime = 0L;
            long authTime = 0L;
            if (addSocialEndpointCredentials.getExpireTimeInSeconds() != null) {
                expireTime = Long.valueOf(addSocialEndpointCredentials.getExpireTimeInSeconds());
            }
            if (addSocialEndpointCredentials.getAuthTimeInMilliseconds() != null) {
                authTime = Long.valueOf(addSocialEndpointCredentials.getAuthTimeInMilliseconds());
            }
            this.init(addSocialEndpointCredentials.getAccountName(), addSocialEndpointCredentials.getAccessToken(), addSocialEndpointCredentials.getRefreshToken(), expireTime, addSocialEndpointCredentials.getTokenType(), authTime);
        }
        return result;
    }

    public void resetCredentials() {
        this.fbClient = null;
        this.accessToken = null;
        super.resetCredentials();
    }

    public Endpoint createBroadcast(String name, String description, String serverStreamId, boolean is360, boolean isPublic, int videoHeight, boolean isLowLatency) throws IOException {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        parameterList.add(Parameter.with((String)"status", (Object)"UNPUBLISHED"));
        parameterList.add(Parameter.with((String)"is_spherical", (Object)is360));
        parameterList.add(Parameter.with((String)"privacy", (Object)new JsonObject().add("value", "EVERYONE")));
        if (name != null && name.length() > 0) {
            parameterList.add(Parameter.with((String)"title", (Object)name));
        }
        if (description != null && description.length() > 0) {
            parameterList.add(Parameter.with((String)"description", (Object)description));
        }
        LiveVideo liveVideo = (LiveVideo)this.fbClient.publish(this.getCredentials().getAccountId() + "/live_videos", LiveVideo.class, parameterList.toArray(new Parameter[parameterList.size()]));
        return new Endpoint(liveVideo.getId(), null, name, liveVideo.getStreamUrl(), this.getName(), this.getCredentials().getId(), serverStreamId);
    }

    public void setAccountsList(List<Account> accountsList) {
        this.accountsList = accountsList;
    }

    public void publishBroadcast(Endpoint endpoint) throws Exception {
        this.fbClient.publish(endpoint.getBroadcastId(), LiveVideo.class, new Parameter[]{Parameter.with((String)"status", (Object)"LIVE_NOW")});
        if (this.collectInteractivity) {
            this.subscribe2Comments(endpoint);
            this.subscribe2Reactions(endpoint);
            long timerId = this.vertx.setPeriodic(5000L, id -> {
                LiveVideo fetchObject = (LiveVideo)this.fbClient.fetchObject(endpoint.getBroadcastId(), LiveVideo.class, new Parameter[]{Parameter.with((String)FIELDS, (Object)"live_views")});
                logger.debug("broadcast id {} live views count {}", (Object)endpoint.getBroadcastId(), (Object)fetchObject.getLiveViews().intValue());
                this.putViewerMap(endpoint.getServerStreamId(), fetchObject.getLiveViews().intValue());
            });
            this.liveViewTimerMap.put(endpoint.getServerStreamId(), timerId);
        }
    }

    public void stopBroadcast(Endpoint endpoint) {
        EventSource eventSource4Reactions;
        try {
            this.fbClient.publish(endpoint.getBroadcastId(), LiveVideo.class, new Parameter[]{Parameter.with((String)"end_live_video", (Object)true)});
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        EventSource eventSource4Comments = this.eventSource4CommentsMap.remove(endpoint.getServerStreamId());
        if (eventSource4Comments != null) {
            eventSource4Comments.close();
        }
        if ((eventSource4Reactions = this.eventSource4ReactionsMap.remove(endpoint.getServerStreamId())) != null) {
            eventSource4Reactions.close();
        }
        this.commentMapList.remove(endpoint.getServerStreamId());
        this.interactionMap.remove(endpoint.getServerStreamId());
        Long timerId = this.liveViewTimerMap.remove(endpoint.getServerStreamId());
        if (timerId != null) {
            this.vertx.cancelTimer(timerId.longValue());
        }
        this.viewerCountMap.remove(endpoint.getServerStreamId());
    }

    public List<LiveComment> getComments(String streamId, int offset, int batch) {
        int size;
        List<LiveComment> facebookComments = this.commentMapList.get(streamId);
        List<LiveComment> resultList = null;
        if (facebookComments != null && offset < (size = facebookComments.size())) {
            int toIndex = offset + batch;
            if (toIndex > size) {
                toIndex = size;
            }
            resultList = facebookComments.subList(offset, toIndex);
        }
        return resultList;
    }

    public long getLiveViews(String streamId) {
        return this.viewerCountMap.getOrDefault(streamId, 0).intValue();
    }

    public int getTotalCommentsCount(String streamId) {
        List<LiveComment> facebookComments = this.commentMapList.get(streamId);
        if (facebookComments != null) {
            return facebookComments.size();
        }
        return 0;
    }

    public Interaction getInteraction(String streamId) {
        return this.interactionMap.get(streamId);
    }

    public void putViewerMap(String serverStreamId, int viewCount) {
        this.viewerCountMap.put(serverStreamId, viewCount);
    }

    public String getBroadcast(Endpoint endpoint) throws Exception {
        LiveVideo fetchObject = (LiveVideo)this.fbClient.fetchObject(endpoint.getBroadcastId(), LiveVideo.class, new Parameter[]{Parameter.with((String)FIELDS, (Object)"status,title,description,id")});
        return fetchObject.getStatus();
    }

    public void subscribe2Comments(Endpoint endpoint) {
        try {
            Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
            String targetURL = BASE_SSE_URL + endpoint.getBroadcastId() + "/live_comments?access_token=" + this.accessToken + "&comment_rate=one_per_two_seconds&fields=" + URLEncoder.encode("from{name,id,picture},message,id,created_time", "UTF-8");
            WebTarget target = client.target(targetURL);
            EventSource eventSource4Comments = EventSource.target((WebTarget)target).build();
            eventSource4Comments.register(inboundEvent -> {
                String data;
                if (inboundEvent != null && (data = (String)inboundEvent.readData(String.class)) != null && !data.isEmpty()) {
                    this.putCommentMap(endpoint.getServerStreamId(), this.parseComment(data));
                    logger.debug("Comment received: {}", (Object)data);
                }
            });
            eventSource4Comments.open();
            this.eventSource4CommentsMap.put(endpoint.getStreamId(), eventSource4Comments);
        }
        catch (UnsupportedEncodingException e) {
            logger.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void putCommentMap(String serverStreamId, LiveComment comment) {
        ArrayList<LiveComment> list = this.commentMapList.getOrDefault(serverStreamId, new ArrayList());
        if (list == null) {
            list = new ArrayList<LiveComment>();
        }
        list.add(comment);
        this.commentMapList.put(serverStreamId, list);
    }

    public void subscribe2Reactions(Endpoint endpoint) {
        Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
        String targetURL = BASE_SSE_URL + endpoint.getBroadcastId() + "/live_reactions?access_token=" + this.accessToken + "&fields=reaction_stream";
        WebTarget target = client.target(targetURL);
        EventSource eventSource4Reactions = EventSource.target((WebTarget)target).build();
        eventSource4Reactions.register(inboundEvent -> {
            String data;
            if (inboundEvent != null && (data = (String)inboundEvent.readData(String.class)) != null && !data.isEmpty()) {
                this.putInteractionMap(endpoint.getServerStreamId(), this.parseInteraction(data));
                logger.debug("Interaction received: {}", (Object)data);
            }
        });
        eventSource4Reactions.open();
        this.eventSource4ReactionsMap.put(endpoint.getStreamId(), eventSource4Reactions);
    }

    public void putInteractionMap(String serverStreamId, Interaction interaction) {
        this.interactionMap.put(serverStreamId, interaction);
    }

    public LiveComment parseComment(String jsonComment) {
        LiveComment comment = null;
        try {
            JsonObject jsonObject = Json.parse((String)jsonComment).asObject();
            String message = jsonObject.get("message").asString();
            String id = jsonObject.get("id").asString();
            String createTime = jsonObject.get("created_time").asString();
            long timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(createTime).getTime();
            JsonObject userObject = jsonObject.get("from").asObject();
            String userId = userObject.get("id").asString();
            String userName = userObject.get("name").asString();
            String pictureURL = userObject.get("picture").asObject().get("data").asObject().get("url").asString();
            User from = new User(userId, userName, pictureURL, UserType.FACEBOOK_USER);
            comment = new LiveComment(id, message, from, ResourceOrigin.FACEBOOK, timestamp);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return comment;
    }

    public Interaction parseInteraction(String jsonInteraction) {
        Interaction interaction = new Interaction();
        interaction.setOrigin(ResourceOrigin.FACEBOOK);
        JsonArray jsonArray = Json.parse((String)jsonInteraction).asObject().get("reaction_stream").asArray();
        int length = jsonArray.size();
        block16: for (int i = 0; i < length; ++i) {
            String key;
            JsonObject jsObject = (JsonObject)jsonArray.get(i);
            int value = jsObject.get("value").asInt();
            switch (key = jsObject.get("key").asString()) {
                case "LIKE": {
                    interaction.setLikeCount(value);
                    continue block16;
                }
                case "LOVE": {
                    interaction.setLoveCount(value);
                    continue block16;
                }
                case "HAHA": {
                    interaction.setHahaCount(value);
                    continue block16;
                }
                case "WOW": {
                    interaction.setWowCount(value);
                    continue block16;
                }
                case "ANGRY": {
                    interaction.setAngryCount(value);
                    continue block16;
                }
                case "SAD": {
                    interaction.setSadCount(value);
                    continue block16;
                }
                default: {
                    logger.warn("Undefined interaction: {}", (Object)key);
                }
            }
        }
        return interaction;
    }
}

