/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.security;

import com.amazonaws.util.Base32;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.google.common.hash.Hashing;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.security.ITokenService;
import io.antmedia.security.TOTPGenerator;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TokenService
implements ApplicationContextAware,
IStreamPublishSecurity,
ITokenService {
    public static final String BEAN_NAME = "token.service";
    protected static Logger logger = LoggerFactory.getLogger(TokenService.class);
    private AppSettings settings;
    private DataStore dataStore;
    Map<String, String> authenticatedMap = new ConcurrentHashMap<String, String>();
    Map<String, String> subscriberAuthenticatedMap = new ConcurrentHashMap<String, String>();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext.containsBean("app.settings")) {
            this.settings = (AppSettings)applicationContext.getBean("app.settings");
        }
    }

    public boolean checkToken(String tokenId, String streamId, String sessionId, String type) {
        boolean result = false;
        if (streamId != null && sessionId != null) {
            Token token = new Token();
            token.setTokenId(tokenId);
            token.setStreamId(streamId);
            token.setType(type);
            if (this.getDataStore().validateToken(token) != null) {
                result = true;
                if (type.equals("play")) {
                    this.authenticatedMap.put(sessionId, streamId);
                }
            } else if (this.authenticatedMap.containsKey(sessionId) && this.authenticatedMap.get(sessionId).equals(streamId)) {
                result = true;
            }
        }
        return result;
    }

    public boolean checkJwtToken(String jwtTokenId, String streamId, String type) {
        boolean result = false;
        if (streamId != null && jwtTokenId != null) {
            Token token = new Token();
            token.setTokenId(jwtTokenId);
            token.setStreamId(streamId);
            token.setType(type);
            if (this.settings.getJwtStreamSecretKey() != null && this.settings.getJwtStreamSecretKey().length() <= 32) {
                Algorithm algorithm = Algorithm.HMAC256((String)this.settings.getJwtStreamSecretKey());
                try {
                    JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("streamId", streamId).withClaim("type", type).build();
                    verifier.verify(jwtTokenId);
                    result = true;
                }
                catch (JWTVerificationException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean checkHash(String hash, String streamId, String sessionId, String type) {
        boolean result = false;
        if (!this.settings.getTokenHashSecret().isEmpty()) {
            String hashSecret = this.settings.getTokenHashSecret();
            String hashCombine = streamId + type + hashSecret;
            logger.info("hashCombine is {}", (Object)hashCombine);
            String sha256hex = Hashing.sha256().hashString((CharSequence)hashCombine, StandardCharsets.UTF_8).toString();
            logger.info("computed hash  is {}", (Object)sha256hex);
            if (sha256hex.equals(hash)) {
                if (type.equals("play")) {
                    this.authenticatedMap.put(sessionId, streamId);
                }
                result = true;
                logger.info("Valid Hash Value for the stream {}", (Object)streamId);
            } else if (this.authenticatedMap.containsKey(sessionId) && this.authenticatedMap.get(sessionId).equals(streamId)) {
                result = true;
            } else {
                logger.info("Invalid Hash Value for the stream {}", (Object)streamId);
            }
        }
        return result;
    }

    public boolean checkTimeBasedSubscriber(String subscriberId, String streamId, String sessionId, String subscriberCodeText, boolean forPublish) {
        boolean result = false;
        if (streamId != null && sessionId != null) {
            int subscriberCode = this.parseSubscriberCode(subscriberCodeText);
            if (subscriberCode != -1 && subscriberId != null) {
                DataStore tmpDataStore = this.getDataStore();
                Subscriber subscriber = tmpDataStore.getSubscriber(streamId, subscriberId);
                if (subscriber != null) {
                    if (forPublish) {
                        if ("publish".equals(subscriber.getType())) {
                            result = this.checkCode(subscriber.getB32Secret(), subscriberCode);
                        }
                    } else if ("play".equals(subscriber.getType()) && !subscriber.isConnected()) {
                        result = this.checkCode(subscriber.getB32Secret(), subscriberCode);
                        if (result) {
                            this.subscriberAuthenticatedMap.put(sessionId, streamId);
                        }
                    } else {
                        result = this.isSubscriberAlreadyAuthenticated(sessionId, streamId);
                    }
                } else {
                    result = this.isSubscriberAlreadyAuthenticated(sessionId, streamId);
                }
            } else {
                result = this.isSubscriberAlreadyAuthenticated(sessionId, streamId);
            }
        }
        return result;
    }

    private boolean isSubscriberAlreadyAuthenticated(String sessionId, String streamId) {
        boolean result = false;
        if (this.subscriberAuthenticatedMap.containsKey(sessionId) && this.subscriberAuthenticatedMap.get(sessionId).equals(streamId)) {
            result = true;
        }
        return result;
    }

    private boolean checkCode(String b32Secret, int subscriberCode) {
        boolean result = false;
        byte[] secretBytes = Base32.decode((String)b32Secret);
        String code = TOTPGenerator.generateTOTP((byte[])secretBytes, (int)this.settings.getTimeTokenPeriod(), (int)6, (String)"HmacSHA1");
        int intCode = Integer.parseInt(code);
        if (intCode == subscriberCode) {
            result = true;
        }
        return result;
    }

    public int parseSubscriberCode(String subscriberCodeText) {
        int subscriberCode = -1;
        try {
            subscriberCode = Integer.parseInt(subscriberCodeText);
            if (subscriberCode > 999999) {
                logger.warn("subscriberCode {} should be 6 digits", (Object)subscriberCodeText);
                subscriberCode = -1;
            }
        }
        catch (NumberFormatException e) {
            logger.warn("subscriberCode {} is not an integer", (Object)subscriberCodeText);
        }
        return subscriberCode;
    }

    public boolean isPublishAllowed(IScope scope, String name, String mode, Map<String, String> queryParams) {
        boolean result = true;
        String MOCK_SESSION_ID = "sessionId";
        if (this.settings.isTimeTokenSubscriberOnly() || this.settings.isEnableTimeTokenForPublish()) {
            String subscriberCodeText;
            if (queryParams == null || !queryParams.containsKey("subscriberId") || !queryParams.containsKey("subscriberCode")) {
                this.closeConnection();
                logger.info("Time based token subscriber request does not have subscriberId or subscriberCode query params for stream:{}", (Object)name);
                return false;
            }
            String subscriberId = queryParams.get("subscriberId");
            if (!this.checkTimeBasedSubscriber(subscriberId, name, "sessionId", subscriberCodeText = queryParams.get("subscriberCode"), true)) {
                logger.info("Time based token subscriber request with id {} and with code {} is not valid for publishing ", (Object)subscriberId, (Object)subscriberCodeText);
                this.closeConnection();
                return false;
            }
        }
        if (this.settings.isPublishTokenControlEnabled()) {
            result = false;
            if (queryParams == null || !queryParams.containsKey("token")) {
                this.closeConnection();
                return false;
            }
            String token = queryParams.get("token");
            if (this.checkToken(token, name, "sessionId", "publish")) {
                result = true;
            } else {
                logger.info("Token {} is not valid for publishing ", (Object)token);
                this.closeConnection();
            }
        }
        if (this.settings.isPublishJwtControlEnabled()) {
            result = false;
            if (queryParams == null || !queryParams.containsKey("token")) {
                this.closeConnection();
                return false;
            }
            String jwtTokenId = queryParams.get("token");
            if (this.checkJwtToken(jwtTokenId, name, "publish")) {
                result = true;
            } else {
                logger.info("JWT Token {} is not valid for publishing ", (Object)jwtTokenId);
                this.closeConnection();
            }
        }
        if (this.settings.isHashControlPublishEnabled()) {
            result = false;
            if (queryParams == null || !queryParams.containsKey("token")) {
                logger.info("No token parameter so not accepting the publish for stream:{}", (Object)name);
                this.closeConnection();
                return false;
            }
            String hash = queryParams.get("token");
            if (this.checkHash(hash, name, "sessionId", "publish")) {
                result = true;
            } else {
                logger.info("Hash {} is not valid for publishing ", (Object)hash);
                this.closeConnection();
            }
        }
        return result;
    }

    public void closeConnection() {
        IConnection connectionLocal = Red5.getConnectionLocal();
        if (connectionLocal != null) {
            connectionLocal.close();
        } else {
            logger.warn("Rtmp connection local is null.");
        }
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = ((DataStoreFactory)this.applicationContext.getBean("dataStoreFactory")).getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public Map<String, String> getAuthenticatedMap() {
        return this.authenticatedMap;
    }

    public void setAuthenticatedMap(Map<String, String> authenticatedMap) {
        this.authenticatedMap = authenticatedMap;
    }

    public Map<String, String> getSubscriberAuthenticatedMap() {
        return this.subscriberAuthenticatedMap;
    }

    public void setSubscriberAuthenticatedMap(Map<String, String> subscriberAuthenticatedMap) {
        this.subscriberAuthenticatedMap = subscriberAuthenticatedMap;
    }

    public Token createToken(String streamId, long expireDate, String type, String roomName) {
        Token token = null;
        if (streamId != null) {
            token = new Token();
            token.setStreamId(streamId);
            token.setExpireDate(expireDate);
            token.setType(type);
            token.setRoomId(roomName);
            try {
                String tokenId = RandomStringUtils.randomNumeric((int)24);
                token.setTokenId(tokenId);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return token;
    }

    public Token createJwtToken(String streamId, long expireDate, String type, String roomName) {
        Token token = null;
        if (streamId != null && this.settings.getJwtStreamSecretKey() != null && this.settings.getJwtStreamSecretKey().length() >= 32) {
            String jwtTokenId = null;
            token = new Token();
            token.setStreamId(streamId);
            token.setExpireDate(expireDate);
            token.setType(type);
            token.setRoomId(roomName);
            Date expireDateType = new Date(expireDate *= 1000L);
            try {
                Algorithm algorithm = Algorithm.HMAC256((String)this.settings.getJwtStreamSecretKey());
                jwtTokenId = JWT.create().withClaim("streamId", streamId).withClaim("type", type).withExpiresAt(expireDateType).sign(algorithm);
                token.setTokenId(jwtTokenId);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return token;
    }
}

