/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.security;

import io.antmedia.AppSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.catalina.util.NetMask;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PublishIPFilter
implements ApplicationContextAware,
IStreamPublishSecurity {
    public static final String BEAN_NAME = "publishIPFilter";
    protected static Logger logger = LoggerFactory.getLogger(PublishIPFilter.class);
    private AppSettings settings;
    private ArrayList<NetMask> allowedIps = null;

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext.containsBean("app.settings")) {
            this.settings = (AppSettings)applicationContext.getBean("app.settings");
        }
    }

    public boolean isPublishAllowed(IScope scope, String name, String mode, Map<String, String> queryParams) {
        boolean result = false;
        List allowedPublisherCIDRList = this.settings.getAllowedPublisherCIDRList();
        if (allowedPublisherCIDRList.isEmpty()) {
            result = true;
        } else if (this.isIpAllowed(allowedPublisherCIDRList)) {
            result = true;
        } else {
            Red5.getConnectionLocal().close();
            result = false;
        }
        return result;
    }

    private boolean isIpAllowed(List<NetMask> allowedPublisherCIDRList) {
        String host = Red5.getConnectionLocal().getRemoteAddress();
        try {
            InetAddress addr = InetAddress.getByName(host);
            for (NetMask nm : allowedPublisherCIDRList) {
                if (!nm.matches(addr)) continue;
                logger.info("Publishing is allowed for this ip:{}", (Object)host);
                return true;
            }
        }
        catch (UnknownHostException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        logger.info("Publishing is not allowed for this ip:{}", (Object)host);
        return false;
    }
}

