/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.preview;

import com.google.common.io.Files;
import io.antmedia.enterprise.tensorflow.IDeepLearningProcessor;
import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PngMuxer
extends Muxer {
    private StorageClient storageClient;
    private File tmpFile;
    private String s3PreviewsFolderPath = null;
    private boolean overwrite = false;
    private IDeepLearningProcessor deepLearningProcessor;
    private boolean uploadPNGToS3 = true;
    private int S3_CONSTANT = 4;
    private static Logger logger = LoggerFactory.getLogger(PngMuxer.class);

    public PngMuxer(Vertx vertx, StorageClient storageClient, int uploadExtensionsToS3) {
        super(vertx);
        this.format = "image2";
        if ((uploadExtensionsToS3 & this.S3_CONSTANT) == 0) {
            this.uploadPNGToS3 = false;
        }
        this.extension = ".png";
        this.storageClient = storageClient;
    }

    public void init(IScope scope, String name, int resolutionHeight, String subFolder, int bitrate) {
        this.init(scope, name, resolutionHeight, this.overwrite, subFolder, bitrate);
        this.tmpFile = PngMuxer.getPreviewFile((IScope)scope, (String)name, (String)this.extension);
    }

    public boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        return this.addStream((AVCodecParameters)null, null, streamIndex);
    }

    public boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        this.registeredStreamIndexList.add(streamIndex);
        return true;
    }

    public File getResourceFile(IScope scope, String name, String extension, String subFolder) {
        return PngMuxer.getPreviewFile((IScope)scope, (String)name, (String)extension);
    }

    public boolean prepareIO() {
        return true;
    }

    public synchronized void writeTrailer() {
        try {
            if (this.tmpFile.exists() && !this.tmpFile.getAbsolutePath().equals(this.file.getAbsolutePath())) {
                Files.move((File)this.tmpFile, (File)this.file);
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        logger.info("vertx= " + this.vertx + " stor= " + this.storageClient);
        if (this.vertx != null && this.storageClient != null && this.uploadPNGToS3) {
            this.vertx.setTimer(100L, l -> {
                logger.warn("writer uploading png {}", (Object)this.file.getName());
                this.storageClient.save(this.getS3Path(this.file.getName()), this.file);
            });
        }
    }

    public String getS3Path(String fileName) {
        return this.s3PreviewsFolderPath + File.separator + fileName;
    }

    public synchronized void writePacket(AVPacket pkt, AVStream stream) {
        if (!this.registeredStreamIndexList.contains(pkt.stream_index())) {
            return;
        }
        this.writePacket(pkt, null, null);
    }

    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContext) {
        if (!this.registeredStreamIndexList.contains(pkt.stream_index())) {
            return;
        }
        this.writePacket(pkt, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase) {
        if (!this.registeredStreamIndexList.contains(pkt.stream_index())) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.tmpFile);
            byte[] data = new byte[pkt.size()];
            pkt.data().get(data);
            fos.write(data, 0, data.length);
            fos.close();
            if (this.deepLearningProcessor != null) {
                this.deepLearningProcessor.process(data);
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public void setOverwrite(boolean previewOverwrite) {
        this.overwrite = previewOverwrite;
    }

    public IDeepLearningProcessor getDeepLearningProcessor() {
        return this.deepLearningProcessor;
    }

    public void setDeepLearningProcessor(IDeepLearningProcessor deepLearningProcessor) {
        this.deepLearningProcessor = deepLearningProcessor;
    }

    public void setS3PreviewsFolderPath(String s3PreviewsFolderPath) {
        this.s3PreviewsFolderPath = s3PreviewsFolderPath;
    }

    public boolean isUploadingToS3() {
        return this.uploadPNGToS3;
    }
}

