/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.preview;

import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.VideoCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;

public class PngEncoder
extends VideoEncoder {
    private long previewCreatePeriod = 5000L;
    private long lastPreviewCreateTime = 0L;
    private int width = 0;
    private int height = 0;
    private double ratio = 0.0;

    public PngEncoder(int resolutionHeight, int bitrate, long previewCreatePeriod, String streamId) {
        super(resolutionHeight, bitrate, streamId);
        this.previewCreatePeriod = previewCreatePeriod;
    }

    protected void openVideoEncoder(int width, int height, AVRational videoCodecTimebase) {
        this.width = width;
        this.height = height;
        this.ratio = (double)height / (double)width;
        this.logger.info("PNG incoming widthxheight:{}x{} initial aspect ratio: {}", new Object[]{width, height, this.ratio});
        this.codec = avcodec.avcodec_find_encoder((int)61);
        if (this.codec == null) {
            throw new NullPointerException("Could not find encoder AV_CODEC_ID_PNG for stream");
        }
        this.codecName = this.codec.name().getString();
        this.videoCodecContext = avcodec.avcodec_alloc_context3((AVCodec)this.codec);
        if (this.videoCodecContext == null) {
            throw new NullPointerException("Could not allocate video codec context");
        }
        int resolutionWidth = width * this.resolutionHeight / height;
        if (resolutionWidth % 2 == 1) {
            ++resolutionWidth;
        }
        this.videoCodecContext.width(resolutionWidth);
        this.videoCodecContext.height(this.resolutionHeight);
        this.videoCodecTimebase = new AVRational();
        this.videoCodecTimebase.num(videoCodecTimebase.num());
        this.videoCodecTimebase.den(videoCodecTimebase.den());
        this.logger.info("preparing codec for stream: {} source wxh:{}x{} target wxh:{}x{} aspect ratio: {}", new Object[]{this.streamId, width, height, resolutionWidth, this.resolutionHeight, this.ratio});
        this.videoCodecContext.time_base(this.videoCodecTimebase);
        this.videoCodecContext.pix_fmt(2);
        int ret = avcodec.avcodec_open2((AVCodecContext)this.videoCodecContext, (AVCodec)this.codec, (AVDictionary)null);
        if (ret < 0) {
            this.logger.error("Codec cannot be opened for stream: {}", (Object)this.streamId);
            avcodec.avcodec_free_context((AVCodecContext)this.videoCodecContext);
            this.videoCodecContext = null;
            throw new IllegalArgumentException("Codec could not be opened for stream: " + this.streamId);
        }
        this.prepareFrame();
        this.avpacket = new AVPacket();
    }

    @Override
    protected void prepareCodecLocal(int width, int height, AVRational videoCodecTimebase, AVRational sampleAspectRatio, int gopSize, int streamIndex, boolean isAVC, AVCodecParameters codecpar) throws Exception {
        this.openVideoEncoder(width, height, videoCodecTimebase);
        for (Muxer muxer : this.muxerList) {
            muxer.addStream(this.codec, this.videoCodecContext, streamIndex);
        }
        this.running.set(true);
        this.logger.info("leaving prepare codec for stream: {}", (Object)this.streamId);
    }

    public void reinitializeContext() throws Exception {
        this.running.set(false);
        this.logger.info("Reinitializing encoder context with new width = {}, height = {}", (Object)this.width, (Object)this.height);
        this.freeEncoderRelatedResources();
        this.openVideoEncoder(this.width, this.height, this.videoCodecTimebase);
        this.running.set(true);
    }

    @Override
    public boolean writeFrameInternal(AVFrame frame, int streamIndex, long captureTimeMS) throws Exception {
        if (frame == null || frame.key_frame() == 0) {
            return false;
        }
        long entranceTime = System.nanoTime();
        if (!this.running.get()) {
            this.logger.warn("video codec context is not initialized on png encoder: {} for stream: {}", (Object)this.hashCode(), (Object)this.streamId);
            return false;
        }
        if (this.lastPreviewCreateTime != 0L && this.lastPreviewCreateTime + this.previewCreatePeriod > System.currentTimeMillis()) {
            return false;
        }
        if (this.ratio != (double)frame.height() / (double)frame.width()) {
            this.height = frame.height();
            this.width = frame.width();
            this.ratio = (double)frame.height() / (double)frame.width();
            this.reinitializeContext();
        }
        this.logger.debug("write frame internal incoming frame widthxheight:{}x{} target frame widthxheight:{}x{} incoming frame format: {} target format:{} incoming frame linesize: {} target linesize:{}", new Object[]{frame.width(), frame.height(), this.videoCodecContext.width(), this.videoCodecContext.height(), frame.format(), this.videoCodecContext.pix_fmt(), frame.linesize().get(), this.picture.linesize().get()});
        AVFrame tmpFrame = this.scaleVideoIfRequrired(frame);
        this.initPacket();
        boolean result = false;
        int ret = this.sendPacket2Encoder(streamIndex, tmpFrame);
        if (ret >= 0) {
            result = this.receiveAndWritePacket(streamIndex);
        }
        avcodec.av_packet_unref((AVPacket)this.avpacket);
        this.totalProcessingTime += System.nanoTime() - entranceTime;
        ++this.encodedPacketCount;
        this.lastPreviewCreateTime = System.currentTimeMillis();
        return result;
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public VideoCodec getCodec() {
        return VideoCodec.PNG;
    }
}

