/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.plugin;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.enterprise.adaptive.DecodedStreamsEncoderAdaptor;
import io.antmedia.enterprise.adaptive.EncoderAdaptor;
import io.antmedia.enterprise.adaptive.StreamAdaptor;
import io.antmedia.plugin.api.IFrameListener;
import io.antmedia.plugin.api.StreamParametersInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomBroadcast
implements IFrameListener {
    protected static Logger logger = LoggerFactory.getLogger(CustomBroadcast.class);
    private EncoderAdaptor encAdaptor;
    private String streamId;
    private IScope scope;
    private DataStore datastore;
    private int streamIndex = 0;
    private int videoIndex;
    private int audioIndex;
    private AVCodecParameters videoCodecParams;
    private AVCodecParameters audioCodecParams;

    public CustomBroadcast(String streamId, AntMediaApplicationAdapter appAdapter) {
        this.streamId = streamId;
        this.scope = appAdapter.getScope();
        this.datastore = appAdapter.getDataStore();
        Broadcast broadcast = this.datastore.get(streamId);
        if (broadcast == null) {
            AntMediaApplicationAdapter.saveUndefinedBroadcast((String)streamId, null, (AntMediaApplicationAdapter)appAdapter, (String)"broadcasting", (long)0L, (String)"WebRTC");
        }
        this.encAdaptor = new DecodedStreamsEncoderAdaptor(null){

            @Override
            public boolean prepare() throws Exception {
                this.prepareInternal();
                return true;
            }
        };
    }

    public AVFrame onAudioFrame(String streamId, AVFrame audioFrame) {
        this.encAdaptor.addFrame2StreamAdaptors(System.currentTimeMillis(), audioFrame, this.audioIndex, StreamAdaptor.PacketType.AUDIO_FRAME);
        return null;
    }

    public AVFrame onVideoFrame(String streamId, AVFrame frame) {
        this.encAdaptor.addFrame2StreamAdaptors(System.currentTimeMillis(), frame, this.videoIndex, StreamAdaptor.PacketType.VIDEO_FRAME);
        return null;
    }

    public void writeTrailer(String streamId) {
        this.encAdaptor.writeTrailer();
    }

    public void start() {
        if (this.audioCodecParams != null) {
            this.encAdaptor.setEnableAudio(true);
            this.audioIndex = this.streamIndex++;
            this.encAdaptor.setAudioStreamIndex(this.audioIndex);
            this.encAdaptor.setAudioCodecParameter(this.audioCodecParams);
        }
        if (this.videoCodecParams != null) {
            this.encAdaptor.setEnableVideo(true);
            this.videoIndex = this.streamIndex++;
            this.encAdaptor.setVideoStreamIndex(this.videoIndex);
            this.encAdaptor.setVideoCodecParameter(this.videoCodecParams);
        }
        this.encAdaptor.init(this.scope, this.streamId, false);
        if (this.encAdaptor.getEncoderSettingsList() != null && this.encAdaptor.getEncoderSettingsList().isEmpty()) {
            this.encAdaptor.getEncoderSettingsList().addAll(AppSettings.encodersStr2List((String)"720,1500000,64000"));
        }
        try {
            this.encAdaptor.prepare();
            this.encAdaptor.setIsRecording(true);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void stop() {
        this.writeTrailer(this.streamId);
        this.encAdaptor.setIsRecording(false);
        this.datastore.delete(this.streamId);
    }

    public void setVideoStreamInfo(String streamId, StreamParametersInfo videoStreamInfo) {
        this.videoCodecParams = videoStreamInfo.codecParameters;
    }

    public void setAudioStreamInfo(String streamId, StreamParametersInfo audioStreamInfo) {
        this.audioCodecParams = audioStreamInfo.codecParameters;
    }

    public void setEncAdaptor(EncoderAdaptor encAdaptor) {
        this.encAdaptor = encAdaptor;
    }
}

