/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.muxer;

import com.google.common.io.Files;
import io.antmedia.muxer.IAntMediaStreamHandler;
import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tika.utils.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MatroskaMuxer
extends Muxer {
    protected static Logger logger = LoggerFactory.getLogger(MatroskaMuxer.class);
    private List<Integer> registeredStreamIndexList = new ArrayList<Integer>();
    private int totalSize = 0;
    private StorageClient storageClient = null;
    private File fileTmp;
    private String streamId;
    private int resolution;
    private String s3StreamsFolderPath = "streams";
    private static String TEMP_EXTENSION = ".tmp";

    public MatroskaMuxer(StorageClient storageClient, Vertx vertx, String s3StreamsFolderPath) {
        super(vertx);
        this.extension = ".mkv";
        this.format = "matroska";
        this.storageClient = storageClient;
        this.vertx = vertx;
        this.s3StreamsFolderPath = s3StreamsFolderPath;
    }

    public void init(IScope scope, String name, int resolutionHeight, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            this.streamId = name;
            this.isInitialized = true;
            this.resolution = resolutionHeight;
            if (resolutionHeight != 0) {
                name = (String)name + "_" + resolutionHeight + "p";
            }
            Object tmpName = name;
            int i = 1;
            do {
                this.file = MatroskaMuxer.getRecordFile((IScope)scope, (String)tmpName, (String)this.extension, (String)subFolder);
                tmpName = (String)name + "_" + i;
                ++i;
            } while (this.file.exists());
            File parentFile = this.file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.scope = scope;
        }
    }

    private boolean isCodecSupported(AVCodecParameters avCodecParameters) {
        return this.isCodecSupported(avCodecParameters.codec_id());
    }

    private boolean isCodecSupported(int codecId) {
        return true;
    }

    public synchronized boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext == null) {
            return false;
        }
        this.registeredStreamIndexList.add(streamIndex);
        AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
        outStream.time_base(timebase);
        outStream.codec().time_base(timebase);
        int ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)codecParameters);
        if (ret < 0) {
            System.out.println("codec context cannot be copied");
        }
        outStream.codec().codec_tag(0);
        if ((outputContext.oformat().flags() & 0x40) != 0) {
            outStream.codec().flags(outStream.codec().flags() | 0x400000);
        }
        return true;
    }

    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVCodecParameters codecParameter = new AVCodecParameters();
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)codecParameter, (AVCodecContext)codecContext);
        if (ret < 0) {
            logger.error("Cannot get codec parameters for {}", (Object)this.streamId);
        }
        return this.addStream(codecParameter, codecContext.time_base(), streamIndex);
    }

    private AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new AVFormatContext(null);
            this.fileTmp = new File(this.file.getAbsolutePath() + TEMP_EXTENSION);
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, (String)this.fileTmp.getAbsolutePath());
            if (ret < 0) {
                logger.info("Could not create output context for {}", (Object)this.fileTmp.getName());
                return null;
            }
        }
        return this.outputFormatContext;
    }

    public synchronized boolean prepareIO() {
        AVFormatContext context = this.getOutputFormatContext();
        if (context == null) {
            return false;
        }
        if (context.pb() != null) {
            return false;
        }
        AVIOContext pb = new AVIOContext(null);
        int ret = avformat.avio_open((AVIOContext)pb, (String)this.fileTmp.getAbsolutePath(), (int)2);
        if (ret < 0) {
            logger.warn("Could not open output file for {}", (Object)this.fileTmp.getName());
            return false;
        }
        context.pb(pb);
        AVDictionary optionsDictionary = null;
        if (!this.options.isEmpty()) {
            optionsDictionary = new AVDictionary();
            Set keySet = this.options.keySet();
            for (String key : keySet) {
                avutil.av_dict_set((AVDictionary)optionsDictionary, (String)key, (String)((String)this.options.get(key)), (int)0);
            }
        }
        if ((ret = avformat.avformat_write_header((AVFormatContext)context, optionsDictionary)) < 0) {
            logger.warn("could not write header to {}", (Object)this.fileTmp.getName());
            this.clearResource();
            return false;
        }
        if (optionsDictionary != null) {
            avutil.av_dict_free((AVDictionary)optionsDictionary);
        }
        this.isRunning.set(true);
        return true;
    }

    public synchronized void writeTrailer() {
        if (!this.isRunning.get() || this.outputFormatContext == null || this.outputFormatContext.pb() == null) {
            logger.error("OutputFormatContext is not initialized correctly or alread closed {}", (Object)this.fileTmp.getName());
            return;
        }
        this.isRunning.set(false);
        avformat.av_write_trailer((AVFormatContext)this.outputFormatContext);
        this.clearResource();
        this.isRecording = false;
        String absolutePath = this.fileTmp.getAbsolutePath();
        String origFileName = absolutePath.replace(TEMP_EXTENSION, "");
        File f = new File(origFileName);
        try {
            Files.move((File)this.fileTmp, (File)f);
            IContext context = this.scope.getContext();
            ApplicationContext appCtx = context.getApplicationContext();
            Object bean = appCtx.getBean("web.handler");
            if (bean instanceof IAntMediaStreamHandler) {
                ((IAntMediaStreamHandler)bean).muxingFinished(this.streamId, f, this.getDuration(f), this.resolution);
            }
            if (this.storageClient != null) {
                this.vertx.setTimer(1000L, l -> this.storageClient.save(this.s3StreamsFolderPath + File.separator + f.getName(), f));
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public long getDuration(File f) {
        AVFormatContext inputFormatContext = avformat.avformat_alloc_context();
        if (avformat.avformat_open_input((AVFormatContext)inputFormatContext, (String)f.getAbsolutePath(), null, (AVDictionary)null) < 0) {
            logger.error("cannot open input context of {}", (Object)f.getName());
            avformat.avformat_close_input((AVFormatContext)inputFormatContext);
            return -1L;
        }
        int ret = avformat.avformat_find_stream_info((AVFormatContext)inputFormatContext, (AVDictionary)null);
        if (ret < 0) {
            logger.error("Could not find stream information in {}", (Object)f.getName());
            avformat.avformat_close_input((AVFormatContext)inputFormatContext);
            return -1L;
        }
        long durationInMS = -1L;
        if (inputFormatContext.duration() != avutil.AV_NOPTS_VALUE) {
            durationInMS = inputFormatContext.duration() / 1000L;
        }
        return durationInMS;
    }

    private void clearResource() {
        if ((this.outputFormatContext.flags() & 1) == 0) {
            avformat.avio_closep((AVIOContext)this.outputFormatContext.pb());
        }
        avformat.avformat_free_context((AVFormatContext)this.outputFormatContext);
        this.outputFormatContext = null;
    }

    public synchronized void writePacket(AVPacket pkt, AVStream stream) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(pkt.stream_index());
        this.writePacket(pkt, stream.time_base(), outStream.time_base());
    }

    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContext) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(pkt.stream_index());
        this.writePacket(pkt, outStream.codec().time_base(), outStream.time_base());
    }

    private void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase) {
        if (this.outputFormatContext == null || this.outputFormatContext.pb() == null) {
            logger.error("OutputFormatContext is not initialized correctly for {}", (Object)this.fileTmp.getName());
            return;
        }
        this.totalSize += pkt.size();
        int packetIndex = pkt.stream_index();
        if (!this.registeredStreamIndexList.contains(packetIndex)) {
            return;
        }
        long pts = pkt.pts();
        long dts = pkt.dts();
        long duration = pkt.duration();
        long pos = pkt.pos();
        pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inputTimebase, (AVRational)outputTimebase));
        pkt.pos(-1L);
        int ret = avformat.av_write_frame((AVFormatContext)this.outputFormatContext, (AVPacket)pkt);
        if (ret < 0) {
            logger.warn("cannot write frame to muxer for {}", (Object)this.fileTmp.getName());
        }
        pkt.pts(pts);
        pkt.dts(dts);
        pkt.duration(duration);
        pkt.pos(pos);
    }
}

