/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.muxer;

import io.antmedia.muxer.Muxer;
import io.vertx.core.Vertx;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVBitStreamFilter;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVOutputFormat;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DASHMuxer
extends Muxer {
    private long lastDTS = -1L;
    private Map<AVCodecContext, Integer> streamMap = new ConcurrentHashMap<AVCodecContext, Integer>();
    protected static Logger logger = LoggerFactory.getLogger(DASHMuxer.class);
    private String fragmentDuration = "0.5";
    private String segDuration = "4";
    private static AVRational avRationalTimeBase = new AVRational();
    private AVPacket tmpPacket;
    private boolean deleteFileOnExit = true;
    private int audioIndex;
    private int videoIndex;
    private String targetLatency = "3.5";
    private String windowSize = "5";
    private Map<Integer, AVRational> codecTimeBaseMap = new HashMap<Integer, AVRational>();
    private AVPacket videoPkt;
    private boolean multibitrate = false;
    private String extraWindowSize;
    private String streamId;
    private volatile boolean firstPrepareIOCalled = false;
    private boolean llHlsEnabled = false;
    private boolean llDashEnabled = true;
    private boolean hlsEnabled = false;
    private boolean useTimeline = false;
    private boolean httpStreaming = true;
    private String outputPath;
    private AVBSFContext bsfExtractdataContext;
    private boolean headerWritten = false;
    private BytePointer allocatedExtraDataPointer;
    private String dashHttpEndpoint;
    private int serverDefaultHttpPort;

    public DASHMuxer(Vertx vertx, String fragmentTime, String segmetationTime, String targetLatency, boolean deleteDASHFilesOnExit, boolean multibitrate, String windowSize, String extraWindowSize, boolean llDashEnabled, boolean llHLSEnabled, boolean hlsEnabled, boolean useTimeline, boolean httpStreaming, String dashHttpEndpoint, int defaultHttpPort) {
        super(vertx);
        this.extension = ".mpd";
        this.format = "dash";
        this.serverDefaultHttpPort = defaultHttpPort;
        this.fragmentDuration = fragmentTime;
        this.segDuration = segmetationTime;
        this.targetLatency = targetLatency;
        this.deleteFileOnExit = deleteDASHFilesOnExit;
        this.multibitrate = multibitrate;
        this.windowSize = windowSize;
        this.extraWindowSize = extraWindowSize;
        this.llDashEnabled = llDashEnabled;
        this.llHlsEnabled = llHLSEnabled;
        this.hlsEnabled = this.llHlsEnabled || hlsEnabled;
        this.useTimeline = useTimeline;
        this.httpStreaming = httpStreaming;
        this.dashHttpEndpoint = dashHttpEndpoint;
    }

    public void init(IScope scope, String streamId, int resolutionHeight, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            super.init(scope, streamId, 0, subFolder, bitrate);
            this.streamId = streamId;
            this.options.put("frag_duration", this.fragmentDuration);
            this.options.put("seg_duration", this.segDuration);
            logger.info("DASH Segment Duration: {}, Fragment Duration: {}", (Object)this.segDuration, (Object)this.fragmentDuration);
            if (this.targetLatency != null && !this.targetLatency.isEmpty()) {
                this.options.put("target_latency", this.targetLatency);
            }
            if (this.deleteFileOnExit) {
                this.options.put("remove_at_exit", "1");
            } else {
                this.options.put("remove_at_exit", "0");
            }
            String initSegName = streamId + "_$RepresentationID$.$ext$";
            String mediaSegName = streamId + "_$RepresentationID$segment$Number%05d$.$ext$";
            this.options.put("init_seg_name", initSegName);
            this.options.put("media_seg_name", mediaSegName);
            this.options.put("use_timeline", this.useTimeline ? "1" : "0");
            this.options.put("utc_timing_url", "https://time.akamai.com/?iso");
            this.options.put("adaptation_sets", "id=0,streams=v id=1,streams=a");
            this.options.put("export_side_data", "1");
            this.options.put("write_prft", "0");
            this.options.put("format_options", "movflags=cmaf");
            this.options.put("frag_type", "duration");
            this.options.put("strict", "experimental");
            this.options.put("window_size", this.windowSize);
            this.options.put("extra_window_size", this.extraWindowSize);
            this.options.put("ldash", this.llDashEnabled ? "1" : "0");
            this.options.put("lhls", this.llHlsEnabled ? "1" : "0");
            this.options.put("hls_playlist", this.hlsEnabled ? "1" : "0");
            this.options.put("streaming", "1");
            this.tmpPacket = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.tmpPacket);
            this.videoPkt = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.videoPkt);
            this.isInitialized = true;
        }
    }

    public AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new AVFormatContext(null);
            this.outputPath = null;
            this.outputPath = this.httpStreaming ? (this.dashHttpEndpoint == null ? "http://localhost:" + this.serverDefaultHttpPort + File.separator + this.scope.getName() + "/chunked/" + this.streamId + File.separator + this.streamId + ".mpd" : this.dashHttpEndpoint + File.separator + this.streamId + ".mpd") : this.file.getAbsolutePath();
            int ret = this.initOutputContext(this.outputFormatContext, null, this.format, this.outputPath);
            if (ret < 0) {
                logger.info("Could not create output context for {}", (Object)this.file.getName());
                return null;
            }
        }
        return this.outputFormatContext;
    }

    public int initOutputContext(AVFormatContext outputFormatContext, AVOutputFormat oformat, String format, String filename) {
        return avformat.avformat_alloc_output_context2((AVFormatContext)outputFormatContext, (AVOutputFormat)oformat, (String)format, (String)filename);
    }

    public synchronized boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecParameters.codec_id()) && (codecParameters.codec_type() == 1 || codecParameters.codec_type() == 0)) {
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)codecParameters);
            outStream.time_base(timebase);
            this.codecTimeBaseMap.put(outStream.index(), timebase);
            this.registeredStreamIndexList.add(streamIndex);
            outStream.codecpar().codec_tag(0);
            if (codecParameters.codec_type() == 1) {
                this.audioIndex = outStream.index();
            } else {
                this.videoIndex = outStream.index();
            }
            logger.info("addStream with parameters and stream index:{} ", (Object)outStream.index());
            result = true;
        }
        return result;
    }

    private boolean isCodecSupported(int codecId) {
        return codecId == 27 || codecId == 86018;
    }

    private synchronized void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        if (this.outputFormatContext == null || !this.isRunning.get()) {
            logger.error("OutputFormatContext is not initialized correctly for {}", (Object)this.file.getName());
            return;
        }
        long pts = pkt.pts();
        long dts = pkt.dts();
        long duration = pkt.duration();
        long pos = pkt.pos();
        pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inputTimebase, (AVRational)outputTimebase));
        pkt.pos(-1L);
        try {
            if (codecType == 0) {
                int ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt);
                this.checkResult(ret, "Cannot copy packet for " + this.streamId);
                if (this.bsfExtractdataContext != null) {
                    ret = avcodec.av_bsf_send_packet((AVBSFContext)this.bsfExtractdataContext, (AVPacket)this.tmpPacket);
                    this.checkResult(ret, "cannot send packet to the filter for " + this.streamId);
                    while (avcodec.av_bsf_receive_packet((AVBSFContext)this.bsfExtractdataContext, (AVPacket)this.tmpPacket) == 0) {
                        if (!this.headerWritten) {
                            IntPointer size = new IntPointer(1L);
                            BytePointer extradataBytePointer = avcodec.av_packet_get_side_data((AVPacket)this.tmpPacket, (int)1, (IntPointer)size);
                            if (size.get() != 0) {
                                this.allocatedExtraDataPointer = new BytePointer(avutil.av_malloc((long)((long)size.get() + 64L))).capacity((long)size.get() + 64L);
                                byte[] extraDataArray = new byte[size.get()];
                                extradataBytePointer.get(extraDataArray, 0, extraDataArray.length);
                                this.allocatedExtraDataPointer.put(extraDataArray, 0, extraDataArray.length);
                                logger.info("extradata size:{} extradata: {} allocated pointer: {}", new Object[]{size.get(), extradataBytePointer, this.allocatedExtraDataPointer});
                                this.outputFormatContext.streams(pkt.stream_index()).codecpar().extradata(this.allocatedExtraDataPointer);
                                this.outputFormatContext.streams(pkt.stream_index()).codecpar().extradata_size(size.get());
                                this.writeHeader();
                            }
                        }
                        if (this.headerWritten) {
                            ret = avformat.av_write_frame((AVFormatContext)this.outputFormatContext, (AVPacket)this.tmpPacket);
                            this.checkResult(ret, "cannot write video frame to muxer for stream: " + this.streamId);
                            continue;
                        }
                        logger.info("Header is not written yet for writing video packet for stream: {}", (Object)this.streamId);
                    }
                } else {
                    ret = avformat.av_write_frame((AVFormatContext)this.outputFormatContext, (AVPacket)this.tmpPacket);
                    this.checkResult(ret, "cannot write video frame to muxe for stream: " + this.streamId);
                }
                avcodec.av_packet_unref((AVPacket)this.tmpPacket);
            } else {
                int ret = avformat.av_write_frame((AVFormatContext)this.outputFormatContext, (AVPacket)pkt);
                this.checkResult(ret, "cannot write frame(not video) to muxer stream: " + this.streamId);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        pkt.pts(pts);
        pkt.dts(dts);
        pkt.duration(duration);
        pkt.pos(pos);
    }

    public synchronized void writeTrailer() {
        if (!this.isRunning.get() || this.outputFormatContext == null) {
            logger.warn("DASHMuxer trailer is returning because it's not correct state. Isrunning: {}, outputformatContext: {}", (Object)this.isRunning.get(), (Object)this.outputFormatContext);
            return;
        }
        this.isRunning.set(false);
        avformat.av_write_trailer((AVFormatContext)this.outputFormatContext);
        if (this.tmpPacket != null) {
            avcodec.av_packet_free((AVPacket)this.tmpPacket);
            this.tmpPacket = null;
        }
        if (this.videoPkt != null) {
            avcodec.av_packet_free((AVPacket)this.videoPkt);
            this.videoPkt = null;
        }
        if (this.audioPkt != null) {
            avcodec.av_packet_free((AVPacket)this.audioPkt);
            this.videoPkt = null;
        }
        if (this.bsfExtractdataContext != null) {
            avcodec.av_bsf_free((AVBSFContext)this.bsfExtractdataContext);
            this.bsfExtractdataContext = null;
        }
        avformat.avformat_free_context((AVFormatContext)this.outputFormatContext);
        this.outputFormatContext.close();
        this.outputFormatContext = null;
        this.isRecording = false;
    }

    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContext) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            logger.trace("not registered stream index {}", (Object)this.file.getName());
            return;
        }
        int streamIndex = pkt.stream_index();
        if (codecContext != null) {
            streamIndex = this.streamMap.get(codecContext);
        }
        AVStream outStream = this.outputFormatContext.streams(streamIndex);
        int index = pkt.stream_index();
        pkt.stream_index(streamIndex);
        AVRational codecTimebase = this.codecTimeBaseMap.get(streamIndex);
        this.writePacket(pkt, codecTimebase, outStream.time_base(), outStream.codecpar().codec_type());
        pkt.stream_index(index);
    }

    public void closePointers(Pointer ... pointers) {
        for (Pointer pointer : pointers) {
            pointer.close();
        }
    }

    public void checkResult(int ret, String message) throws IllegalArgumentException {
        if (ret < 0) {
            throw new IllegalArgumentException(message + " error is " + this.getErrorDefinition(ret));
        }
    }

    public boolean addVideoStream(int width, int height, AVRational videoTimebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecId)) {
            this.registeredStreamIndexList.add(streamIndex);
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            this.videoIndex = outStream.index();
            outStream.codecpar().width(width);
            outStream.codecpar().height(height);
            outStream.codecpar().codec_id(codecId);
            outStream.codecpar().codec_type(0);
            outStream.codecpar().format(0);
            outStream.codecpar().codec_tag(0);
            AVRational timeBase = new AVRational();
            timeBase.num(1).den(1000);
            AVBitStreamFilter bsfc = avcodec.av_bsf_get_by_name((String)"extract_extradata");
            try {
                this.bsfExtractdataContext = new AVBSFContext(null);
                int ret = avcodec.av_bsf_alloc((AVBitStreamFilter)bsfc, (AVBSFContext)this.bsfExtractdataContext);
                this.checkResult(ret, "cannot allocate bsf context for " + this.streamId);
                ret = avcodec.avcodec_parameters_copy((AVCodecParameters)this.bsfExtractdataContext.par_in(), (AVCodecParameters)outStream.codecpar());
                this.checkResult(ret, "cannot copy input codec parameters for " + this.streamId);
                this.bsfExtractdataContext.time_base_in(timeBase);
                ret = avcodec.av_bsf_init((AVBSFContext)this.bsfExtractdataContext);
                this.checkResult(ret, "cannot init bit stream filter context for " + this.streamId);
                ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)this.bsfExtractdataContext.par_out());
                this.checkResult(ret, "cannot copy codec parameters to output for " + this.streamId);
                outStream.time_base(this.bsfExtractdataContext.time_base_out());
                this.codecTimeBaseMap.put(this.videoIndex, timeBase);
                result = true;
            }
            catch (IllegalArgumentException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                this.closePointers(new Pointer[]{outStream, timeBase, bsfc});
            }
        }
        return result;
    }

    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVFormatContext context = this.getOutputFormatContext();
        if (context == null) {
            return false;
        }
        if (this.isCodecSupported(codecContext.codec_id())) {
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)context, (AVCodec)codec);
            this.registeredStreamIndexList.add(outStream.index());
            this.streamMap.put(codecContext, outStream.index());
            if (codecContext.codec_type() == 0) {
                avcodec.avcodec_parameters_from_context((AVCodecParameters)outStream.codecpar(), (AVCodecContext)codecContext);
                outStream.time_base(codecContext.time_base());
                this.codecTimeBaseMap.put(outStream.index(), codecContext.time_base());
            } else {
                int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)outStream.codecpar(), (AVCodecContext)codecContext);
                logger.info("copy codec parameter from context {} stream index: {}", (Object)ret, (Object)streamIndex);
                if (codecContext.codec_type() != 1) {
                    logger.warn("This should be audio codec for {}", (Object)this.file.getName());
                }
                outStream.time_base(codecContext.time_base());
                this.codecTimeBaseMap.put(outStream.index(), codecContext.time_base());
            }
            outStream.codecpar().codec_tag(0);
            logger.info("addStream with stream index:{} out streamIndex:{}", (Object)streamIndex, (Object)outStream.index());
            if ((context.oformat().flags() & 0x40) != 0) {
                codecContext.flags(codecContext.flags() | 0x400000);
            }
        }
        return true;
    }

    public synchronized boolean prepareIO() {
        if (this.multibitrate && !this.firstPrepareIOCalled) {
            this.firstPrepareIOCalled = true;
            return true;
        }
        AVFormatContext context = this.getOutputFormatContext();
        if (context == null || this.isRunning.get()) {
            logger.warn("Returning prepareIO. It may be due to context is null or it's already running. Context value is {} and isRunning: {}", (Object)context, (Object)this.isRunning.get());
            return false;
        }
        if (this.bsfExtractdataContext == null) {
            return this.writeHeader();
        }
        this.isRunning.set(true);
        logger.info("leaving prepare io for stream:{}", (Object)this.streamId);
        return true;
    }

    public String getErrorDefinition(int errorCode) {
        byte[] data = new byte[128];
        avutil.av_strerror((int)errorCode, (byte[])data, (long)data.length);
        return new String(data, 0, data.length);
    }

    public boolean writeHeader() {
        int ret;
        AVDictionary optionsDictionary = null;
        if (!this.options.isEmpty()) {
            optionsDictionary = new AVDictionary();
            Set keySet = this.options.keySet();
            for (String key : keySet) {
                avutil.av_dict_set((AVDictionary)optionsDictionary, (String)key, (String)((String)this.options.get(key)), (int)0);
            }
        }
        if ((ret = avformat.avformat_write_header((AVFormatContext)this.getOutputFormatContext(), (AVDictionary)optionsDictionary)) < 0 && logger.isWarnEnabled()) {
            logger.error("Could not write header. Make sure that you set 'settings.forceAspectRationInTranscoding=true' in app settings. File: {} Error: {}", (Object)this.outputPath, (Object)this.getErrorDefinition(ret));
            return false;
        }
        if (optionsDictionary != null) {
            avutil.av_dict_free((AVDictionary)optionsDictionary);
        }
        this.headerWritten = true;
        this.isRunning.set(true);
        return true;
    }

    public synchronized void writePacket(AVPacket avpacket, AVStream inStream) {
        int streamIndex;
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(avpacket.stream_index()) || this.outputFormatContext == null) {
            logger.warn("Returning in writePacket. IsRunning: {}, stream index {} context: {}", new Object[]{this.isRunning.get(), avpacket.stream_index(), this.outputFormatContext});
            return;
        }
        if (inStream.codecpar().codec_type() == 0) {
            streamIndex = this.videoIndex;
        } else if (inStream.codecpar().codec_type() == 1) {
            streamIndex = this.audioIndex;
        } else {
            logger.error("Undefined codec type for {}", (Object)this.file.getName());
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(streamIndex);
        int index = avpacket.stream_index();
        avpacket.stream_index(streamIndex);
        this.writePacket(avpacket, inStream.time_base(), outStream.time_base(), outStream.codecpar().codec_type());
        avpacket.stream_index(index);
    }

    public void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        if (!this.isRunning.get()) {
            logger.warn("Not writing to VideoBuffer for {} because Is running:{}", (Object)this.file.getName(), (Object)this.isRunning.get());
            return;
        }
        this.videoPkt.stream_index(this.videoIndex);
        this.videoPkt.pts(pts);
        this.videoPkt.dts(dts);
        this.videoPkt.duration(0L);
        encodedVideoFrame.rewind();
        if (isKeyFrame) {
            this.videoPkt.flags(this.videoPkt.flags() | 1);
        }
        BytePointer bytePointer = new BytePointer(encodedVideoFrame);
        this.videoPkt.data(bytePointer);
        this.videoPkt.size(encodedVideoFrame.limit());
        this.videoPkt.position(0L);
        this.writePacket(this.videoPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.videoPkt);
    }

    public void writeAudioBuffer(ByteBuffer audioFrame, int streamIndex, long timestamp) {
        if (!this.isRunning.get()) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing AudioBuffer for {} because Is running:{}", (Object)this.streamId, (Object)this.isRunning.get());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        this.audioPkt.stream_index(streamIndex);
        this.audioPkt.pts(timestamp);
        this.audioPkt.dts(timestamp);
        audioFrame.rewind();
        this.audioPkt.flags(this.audioPkt.flags() | 1);
        this.audioPkt.data(new BytePointer(audioFrame));
        this.audioPkt.size(audioFrame.limit());
        this.audioPkt.position(0L);
        this.writePacket(this.audioPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.audioPkt);
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    static {
        avRationalTimeBase.num(1);
        avRationalTimeBase.den(1);
    }
}

