/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.licence;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.antmedia.datastore.db.types.Licence;
import io.antmedia.licence.ILicenceService;
import io.antmedia.settings.ServerSettings;
import io.vertx.core.Vertx;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.red5.server.Launcher;
import org.red5.spring.Red5ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;

public class LicenceService
implements ILicenceService,
ApplicationContextAware {
    private Vertx vertx;
    private ServerSettings serverSettings;
    private Licence activeLicence = new Licence();
    private Gson gson = new Gson();
    protected static Logger logger = LoggerFactory.getLogger(LicenceService.class);
    public static final String BASE_URL = "https://us-central1-ant-media-server-license.cloudfunctions.net/";
    private static String checkLicenseStatusUrl = "https://us-central1-ant-media-server-license.cloudfunctions.net/check/licenseStatus";
    public static final String SERVER_REQUEST_ERROR = "serverRequestError";
    public static final String INVALID_KEY_ERROR = "INVALID_KEY";
    public static final String VALID = "valid";
    private static final int LICENSE_CHECK_PERIOD = 300000;
    private static final long THREE_DAYS_IN_MILLISECONDS = 259200000L;
    public static final String SUSPENDED_FILE_PATH = System.getProperty("java.io.tmpdir") + File.separator + ".amsinstance_s";

    private void asyncCheckLicense() {
        this.vertx.executeBlocking(b -> {
            this.checkLicence(this.serverSettings.getLicenceKey());
            b.complete();
        }, null);
    }

    public void start() {
        if (!this.serverSettings.isBuildForMarket()) {
            this.asyncCheckLicense();
            long l = this.vertx.setPeriodic(300000L, id -> this.asyncCheckLicense());
        } else {
            logger.info("this is market build instance id: {}", (Object)Launcher.getInstanceId());
        }
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
    }

    public String getInstanceId() {
        Object instanceId = Launcher.getInstanceId();
        if (instanceId == null) {
            instanceId = UUID.randomUUID().toString() + "no_instance_id_file";
            logger.error("no instance ID file ");
        }
        return instanceId;
    }

    public Licence checkLicence(String key) {
        Licence tmpLicence = new Licence();
        if (!this.serverSettings.isBuildForMarket()) {
            File suspendedFile;
            if (this.isKeyValid(key)) {
                try {
                    String instanceId = Launcher.getInstanceId();
                    String version = Launcher.getVersion();
                    String type = Launcher.getVersionType();
                    JsonObject requestParam = new JsonObject();
                    requestParam.addProperty("instanceId", instanceId);
                    requestParam.addProperty("key", key);
                    requestParam.addProperty("ip", ServerSettings.getLocalHostAddress());
                    requestParam.addProperty("instanceType", type);
                    requestParam.addProperty("instanceVersion", version);
                    try (CloseableHttpClient client = this.getHttpClient();){
                        HttpRequestBase post = (HttpRequestBase)RequestBuilder.post().setUri(checkLicenseStatusUrl).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(requestParam.toString())).build();
                        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(5000).build();
                        post.setConfig(requestConfig);
                        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                            StringBuilder result = LicenceService.readResponse((HttpResponse)response);
                            if (response.getStatusLine().getStatusCode() == 200) {
                                tmpLicence = (Licence)this.gson.fromJson(result.toString(), Licence.class);
                                if (tmpLicence.getLicenceId() != null) {
                                    logger.debug("valid licence key : {}", (Object)key);
                                    tmpLicence.setStatus(VALID);
                                    Files.deleteIfExists(new File(Launcher.INSTANCE_STARTED_FILE).toPath());
                                    Files.deleteIfExists(new File(SUSPENDED_FILE_PATH).toPath());
                                } else {
                                    File f;
                                    InvalidLicenseResult res = (InvalidLicenseResult)this.gson.fromJson(result.toString(), InvalidLicenseResult.class);
                                    tmpLicence.setStatus(res.getResult());
                                    if (res.isLicenceBlocked() && !(f = new File(SUSPENDED_FILE_PATH)).exists() && !f.createNewFile()) {
                                        throw new IOException("license file cannot be created");
                                    }
                                }
                            } else {
                                tmpLicence.setStatus(SERVER_REQUEST_ERROR);
                            }
                            if (this.isTrialEnded()) {
                                tmpLicence.setStatus("TRIAL_PERIOD_ENDED");
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            } else {
                tmpLicence.setStatus(INVALID_KEY_ERROR);
                logger.debug("this is market build or no key provided for instance id {}", (Object)Launcher.getInstanceId());
            }
            if (this.isTrialEnded()) {
                tmpLicence.setStatus("TRIAL_PERIOD_ENDED");
            }
            if ((suspendedFile = new File(SUSPENDED_FILE_PATH)).exists()) {
                tmpLicence.setStatus("LICENSE_BLOCKED");
            }
        }
        this.activeLicence = tmpLicence;
        return this.activeLicence;
    }

    public boolean isTrialEnded() {
        boolean trialEnded = false;
        try {
            File f = new File(Launcher.INSTANCE_STARTED_FILE);
            if (f.exists()) {
                Path path = f.toPath();
                BasicFileAttributes fatr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                trialEnded = System.currentTimeMillis() > fatr.creationTime().toMillis() + 259200000L;
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return trialEnded;
    }

    public Licence getLastLicenseStatus() {
        return this.activeLicence;
    }

    public boolean isKeyValid(String key) {
        return key != null && key.length() >= 8;
    }

    public static StringBuilder readResponse(HttpResponse response) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder result = new StringBuilder();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public void setActiveLicence(Licence licence) {
        this.activeLicence = licence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext.containsBean("red5.common")) {
            Red5ApplicationContext red5Common = (Red5ApplicationContext)applicationContext.getBean("red5.common");
            if (!red5Common.containsBean("vertxCore")) throw new ApplicationContextException("No Vertx bean in application context");
            this.vertx = (Vertx)red5Common.getBean("vertxCore");
            return;
        } else {
            logger.warn("No server in application context");
        }
    }

    public static void setLicenseUrl(String licenseUrl) {
        checkLicenseStatusUrl = licenseUrl;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public boolean isLicenceSuspended() {
        return this.activeLicence != null && ("LICENSE_BLOCKED".equals(this.activeLicence.getStatus()) || "TRIAL_PERIOD_ENDED".equals(this.activeLicence.getStatus()));
    }

    public static class InvalidLicenseResult {
        public static final String NO_LICENSE_RESULT = "NO_LICENSE_FOUND";
        public static final String LICENSE_BLOCKED = "LICENSE_BLOCKED";
        public static final String LICENSE_EXPIRED = "LICENSE_EXPIRED";
        public static final String NO_LICENSE_DEFINED = "NO_LICENSE_DEFINED";
        public static final String ALL_LICENSES_ARE_USED = "ALL_LICENSES_ARE_USED";
        public static final String TRIAL_PERIOD_ENDED = "TRIAL_PERIOD_ENDED";
        String result = null;

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public boolean isNoLicenseFound() {
            return NO_LICENSE_RESULT.equals(this.result);
        }

        public boolean isLicenceBlocked() {
            return LICENSE_BLOCKED.equals(this.result);
        }
    }
}

