/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster.webrtc;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.enterprise.cluster.webrtc.IOriginServerStatusListener;
import io.antmedia.enterprise.cluster.webrtc.OriginServer;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginServerStatusListener
implements IOriginServerStatusListener {
    private IWebRTCAdaptor webRTCAdaptor;
    private DataStore dataStore;
    private StreamInfo streamInfo;
    private OriginServer originServer;
    private AtomicBoolean portsReady = new AtomicBoolean(false);
    private static Logger logger = LoggerFactory.getLogger(OriginServerStatusListener.class);

    public OriginServerStatusListener(IWebRTCAdaptor webRTCAdaptor, DataStore dataStore, StreamInfo streamInfo, OriginServer originServer) {
        this.webRTCAdaptor = webRTCAdaptor;
        this.dataStore = dataStore;
        this.streamInfo = streamInfo;
        this.originServer = originServer;
    }

    public synchronized void saveAndRegister() {
        if (this.portsReady.get()) {
            return;
        }
        if (!(this.streamInfo.isVideoEnabled() && this.streamInfo.getVideoPort() <= 0 || this.streamInfo.isAudioEnabled() && this.streamInfo.getAudioPort() <= 0 || this.streamInfo.isDataChannelEnabled() && this.streamInfo.getDataChannelPort() <= 0)) {
            this.portsReady.set(true);
            logger.info("OriginServer ready now. Video enabled/port:{}/{} Audio enabled/port:{}/{} Data Channel enabled/port:{}/{} for stream {} with height: {} codec:{}", new Object[]{this.streamInfo.isVideoEnabled(), this.streamInfo.getVideoPort(), this.streamInfo.isAudioEnabled(), this.streamInfo.getAudioPort(), this.streamInfo.isDataChannelEnabled(), this.streamInfo.getDataChannelPort(), this.streamInfo.getStreamId(), this.streamInfo.getVideoHeight(), this.streamInfo.getVideoCodec()});
            this.webRTCAdaptor.registerWebRTCClient(this.streamInfo.getStreamId(), (IWebRTCClient)this.originServer, this.streamInfo.getVideoHeight(), this.streamInfo.getVideoCodec());
            this.dataStore.saveStreamInfo(this.streamInfo);
        } else {
            logger.warn("OriginServer not ready. Current video:{} audio:{} data:{} for stream: {} - codec:{}", new Object[]{this.streamInfo.getVideoPort(), this.streamInfo.getAudioPort(), this.streamInfo.getDataChannelPort(), this.streamInfo.getStreamId(), this.streamInfo.getVideoCodec()});
        }
    }

    @Override
    public void videoPortReady(int videoPort) {
        logger.info("video port({}) for origin stream {}", (Object)videoPort, (Object)this.streamInfo.getStreamId());
        this.streamInfo.setVideoPort(videoPort);
        this.saveAndRegister();
    }

    @Override
    public void audioPortReady(int audioPort) {
        logger.info("audio port({}) for origin stream {}", (Object)audioPort, (Object)this.streamInfo.getStreamId());
        this.streamInfo.setAudioPort(audioPort);
        this.saveAndRegister();
    }

    @Override
    public void dataChannelPortReady(int dataChannelPort) {
        logger.info("data channel port({}) for origin stream {}", (Object)dataChannelPort, (Object)this.streamInfo.getStreamId());
        this.streamInfo.setDataChannelPort(dataChannelPort);
        this.saveAndRegister();
    }
}

