/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster.webrtc;

import io.antmedia.enterprise.cluster.webrtc.ClusterPacketHandler;
import io.antmedia.enterprise.cluster.webrtc.DataChannelPacket;
import io.antmedia.enterprise.cluster.webrtc.DataPacket;
import io.antmedia.enterprise.cluster.webrtc.IOriginServerStatusListener;
import io.antmedia.enterprise.webrtc.DataChannelRouter;
import io.antmedia.enterprise.webrtc.IDataChannelMessageSender;
import io.antmedia.statistic.type.WebRTCAudioSendStats;
import io.antmedia.statistic.type.WebRTCVideoSendStats;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.NaluIndex;
import org.webrtc.SessionDescription;

public class OriginServer
implements IWebRTCClient,
IDataChannelMessageSender {
    private static Logger logger = LoggerFactory.getLogger(OriginServer.class);
    private Vertx vertx;
    NetServer videoServer;
    NetServer audioServer;
    NetServer dataChannelServer;
    private Queue<NetSocket> videoConnections = new ConcurrentLinkedQueue<NetSocket>();
    private Queue<NetSocket> audioConnections = new ConcurrentLinkedQueue<NetSocket>();
    private Queue<NetSocket> dataChannelConnections = new ConcurrentLinkedQueue<NetSocket>();
    private int debugMaxVideoLength = 0;
    private int debugMaxAudioLength = 0;
    private IWebRTCMuxer webRTCMuxer;
    private int height;
    private int width;
    private long lastVideoPacketSentTime = 0L;
    private long totalVideoFrameInterval;
    private int numberOfVideoPacketSent = 0;
    private int numberOfAudioPacketSent = 0;
    private long lastAudioPacketSentTime = 0L;
    private long totalAudioFrameInterval = 0L;
    private String streamId;
    private byte[] videoConfigData;
    private IOriginServerStatusListener statusListener;
    private final boolean videoEnabled;
    private final boolean audioEnabled;
    private DataChannelRouter dataChannelRouter;
    private boolean dataChannelEnabled;

    public OriginServer(String streamId, Vertx vertx, boolean videoEnabled, boolean audioEnabled) {
        this.streamId = streamId;
        this.vertx = vertx;
        this.videoEnabled = videoEnabled;
        this.audioEnabled = audioEnabled;
    }

    public void setStatusListener(IOriginServerStatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
    }

    public void sendVideoPacket(ByteBuffer videoPacket, boolean isKeyFrame, long timestamp, int frameRotation, List<NaluIndex> naluIndice, String trackId) {
        long now = System.currentTimeMillis();
        long diff = now - this.lastVideoPacketSentTime;
        this.totalVideoFrameInterval += this.lastVideoPacketSentTime != 0L ? diff : 0L;
        ++this.numberOfVideoPacketSent;
        this.lastVideoPacketSentTime = now;
        videoPacket.rewind();
        byte[] data = new byte[videoPacket.limit()];
        videoPacket.get(data);
        DataPacket packet = new DataPacket(data, 0, isKeyFrame, timestamp, null, videoPacket.limit(), frameRotation, trackId);
        byte[] rawData = SerializationUtils.serialize((Serializable)packet);
        if (logger.isDebugEnabled() && rawData.length > this.debugMaxVideoLength) {
            this.debugMaxVideoLength = rawData.length;
            logger.debug("latest max video packet size {}", (Object)this.debugMaxVideoLength);
        }
        for (NetSocket s : this.videoConnections) {
            ClusterPacketHandler.sendPacket(rawData, s);
        }
    }

    public void sendAudioPacket(ByteBuffer audioPacket, long timestamp, String trackId) {
        long now = System.currentTimeMillis();
        ++this.numberOfAudioPacketSent;
        long diff = now - this.lastAudioPacketSentTime;
        this.totalAudioFrameInterval += this.lastAudioPacketSentTime != 0L ? diff : 0L;
        this.lastAudioPacketSentTime = now;
        audioPacket.rewind();
        byte[] data = new byte[audioPacket.limit()];
        audioPacket.get(data);
        DataPacket packet = new DataPacket(data, 1, false, timestamp, null, audioPacket.limit(), 0, trackId);
        byte[] rawData = SerializationUtils.serialize((Serializable)packet);
        if (logger.isDebugEnabled() && rawData.length > this.debugMaxAudioLength) {
            this.debugMaxAudioLength = rawData.length;
            logger.debug("latest max audio packet size {}", (Object)this.debugMaxAudioLength);
        }
        for (NetSocket s : this.audioConnections) {
            ClusterPacketHandler.sendPacket(rawData, s);
        }
    }

    public int getTargetBitrate() {
        return 0;
    }

    public void start() {
        logger.info("Origin Server is starting video enabled:{} audio enabled: {} for stream:{}", new Object[]{this.videoEnabled, this.audioEnabled, this.streamId});
        if (this.videoEnabled) {
            NetServerOptions videoOptions = new NetServerOptions().setTcpNoDelay(true).setReceiveBufferSize(300000);
            this.videoServer = this.vertx.createNetServer(videoOptions);
            this.videoServer.connectHandler(socket -> {
                if (this.videoConfigData != null) {
                    ClusterPacketHandler.sendPacket(this.videoConfigData, socket);
                }
                this.videoConnections.add((NetSocket)socket);
                socket.closeHandler(v -> this.videoConnections.remove(socket));
                socket.exceptionHandler(throwable -> logger.error("Socket exception for stream:{}, trace:{}", (Object)this.streamId, (Object)ExceptionUtils.getStackTrace((Throwable)throwable)));
            });
            this.videoServer.listen(0, res -> {
                if (res.succeeded()) {
                    logger.info("Setting stream cluster origin video port {} for stream {}", (Object)this.videoServer.actualPort(), (Object)this.streamId);
                    this.statusListener.videoPortReady(this.videoServer.actualPort());
                } else {
                    logger.error("Video port is not set. Stream probably will not started on edge for stream {}", (Object)this.streamId);
                    this.statusListener.videoPortReady(0);
                }
            });
        }
        if (this.audioEnabled) {
            NetServerOptions audioOptions = new NetServerOptions().setTcpNoDelay(true).setReceiveBufferSize(100000);
            this.audioServer = this.vertx.createNetServer(audioOptions);
            this.audioServer.connectHandler(socket -> {
                this.audioConnections.add((NetSocket)socket);
                socket.closeHandler(v -> this.audioConnections.remove(socket));
                socket.exceptionHandler(throwable -> logger.error("Socket exception for stream:{}, trace:{}", (Object)this.streamId, (Object)ExceptionUtils.getStackTrace((Throwable)throwable)));
            });
            this.audioServer.listen(0, res -> {
                if (res.succeeded()) {
                    logger.info("Setting stream cluster origin audio port {} for stream {}", (Object)this.audioServer.actualPort(), (Object)this.streamId);
                    this.statusListener.audioPortReady(this.audioServer.actualPort());
                } else {
                    logger.error("Audio port is not set. Stream probably will not started on edge for stream {}", (Object)this.streamId);
                    this.statusListener.audioPortReady(0);
                }
            });
        }
        if (this.isDataChannelEnabled()) {
            NetServerOptions dataChannelOptions = new NetServerOptions().setTcpNoDelay(true).setReceiveBufferSize(100000);
            this.dataChannelServer = this.vertx.createNetServer(dataChannelOptions);
            this.dataChannelServer.connectHandler(socket -> {
                this.dataChannelConnections.add((NetSocket)socket);
                socket.handler((Handler)new ClusterPacketHandler(packet -> {
                    DataChannelPacket dataPacket = (DataChannelPacket)SerializationUtils.deserialize((byte[])packet);
                    this.getDataChannelRouter().playerMessageReceived(null, this.streamId, dataPacket.data, dataPacket.binary);
                }));
                socket.closeHandler(v -> this.dataChannelConnections.remove(socket));
                socket.exceptionHandler(throwable -> logger.error("Socket exception for stream:{}, trace:{}", (Object)this.streamId, (Object)ExceptionUtils.getStackTrace((Throwable)throwable)));
            });
            this.dataChannelServer.listen(0, res -> {
                if (res.succeeded()) {
                    logger.info("Setting stream cluster origin dc port {} for stream {}", (Object)this.dataChannelServer.actualPort(), (Object)this.streamId);
                    this.statusListener.dataChannelPortReady(this.dataChannelServer.actualPort());
                } else {
                    logger.error("dc port is not set. Stream probably will not started on edge for stream {}", (Object)this.streamId);
                    this.statusListener.dataChannelPortReady(0);
                }
            });
            this.getDataChannelRouter().addPlayer(this.streamId, this);
        }
    }

    public void setRemoteDescription(SessionDescription sdp) {
    }

    public void addIceCandidate(IceCandidate iceCandidate) {
    }

    public void setVideoResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public IWebRTCMuxer getWebRTCMuxer(String trackId) {
        return this.webRTCMuxer;
    }

    public void stop() {
        logger.info("Stoping Origin Server for stream Id {} resolution is {}", (Object)this.streamId, (Object)this.height);
        for (NetSocket netSocket : this.videoConnections) {
            netSocket.close();
        }
        for (NetSocket netSocket : this.audioConnections) {
            netSocket.close();
        }
        for (NetSocket netSocket : this.dataChannelConnections) {
            netSocket.close();
        }
        if (this.webRTCMuxer != null) {
            this.webRTCMuxer.unRegisterWebRTCClient((IWebRTCClient)this);
        }
        if (this.videoServer != null) {
            this.videoServer.close();
            this.videoServer = null;
        }
        if (this.audioServer != null) {
            this.audioServer.close();
            this.audioServer = null;
        }
        if (this.dataChannelServer != null) {
            this.dataChannelServer.close();
            this.dataChannelServer = null;
        }
        if (this.isDataChannelEnabled() && this.getDataChannelRouter() != null) {
            this.getDataChannelRouter().removePlayer(this.streamId, this);
        }
        logger.info("Origin server is stopped for stream id: {} and height:{}", (Object)this.streamId, (Object)this.height);
    }

    public long getTimeToStartStreaming() {
        return 0L;
    }

    public long getTimeToStop() {
        return 0L;
    }

    public float getVideoFrameSentPeriod() {
        float period = 0.0f;
        if (this.numberOfVideoPacketSent > 0) {
            period = (float)this.totalVideoFrameInterval / (float)this.numberOfVideoPacketSent;
        }
        return period;
    }

    public float getAudioFrameSentPeriod() {
        float period = 0.0f;
        if (this.numberOfAudioPacketSent > 0) {
            period = (float)this.totalAudioFrameInterval / (float)this.numberOfAudioPacketSent;
        }
        return period;
    }

    public Queue<NetSocket> getVideoConnections() {
        return this.videoConnections;
    }

    public Queue<NetSocket> getAudioConnections() {
        return this.audioConnections;
    }

    public NetServer getVideoServer() {
        return this.videoServer;
    }

    public void setVideoServer(NetServer videoServer) {
        this.videoServer = videoServer;
    }

    public NetServer getAudioServer() {
        return this.audioServer;
    }

    public void setAudioServer(NetServer audioServer) {
        this.audioServer = audioServer;
    }

    public long getSendVideoPacketCallCount() {
        return this.numberOfVideoPacketSent;
    }

    public long getSendAudioPacketCallCount() {
        return this.numberOfAudioPacketSent;
    }

    public WebRTCVideoSendStats getVideoStats() {
        return null;
    }

    public WebRTCAudioSendStats getAudioStats() {
        return null;
    }

    public int getExcessiveBandwidthCount() {
        return 0;
    }

    public void increaseExcessiveBandwidthCount() {
    }

    public void resetExcessiveBandwidthCount() {
    }

    public void cacheChannelParameters() {
    }

    public int getCachedPacketLoss() {
        return 0;
    }

    public int getRttMeasurement() {
        return 0;
    }

    public int getPacketLoss() {
        return 0;
    }

    public void setTryCountBeforeSwitchBack(int tryCountBeforeSwitchback) {
    }

    public int getTryCountBeforeSwitchBack() {
        return 0;
    }

    public int getCachedRttMeasurement() {
        return 0;
    }

    @Override
    public void sendMessageViaDataChannel(DataChannel.Buffer buffer) {
        byte[] data = new byte[buffer.data.capacity()];
        buffer.data.get(data);
        byte[] rawData = SerializationUtils.serialize((Serializable)new DataChannelPacket(data, buffer.binary));
        for (NetSocket netSocket : this.dataChannelConnections) {
            ClusterPacketHandler.sendPacket(rawData, netSocket);
        }
    }

    public DataChannelRouter getDataChannelRouter() {
        return this.dataChannelRouter;
    }

    public void setDataChannelRouter(DataChannelRouter dataChannelRouter) {
        this.dataChannelRouter = dataChannelRouter;
    }

    public boolean isDataChannelEnabled() {
        return this.dataChannelEnabled;
    }

    public void setDataChannelEnabled(boolean dataChannelEnabled) {
        this.dataChannelEnabled = dataChannelEnabled;
    }

    public Queue<NetSocket> getDataChannelConnections() {
        return this.dataChannelConnections;
    }

    public int getForceStreamHeight() {
        return 0;
    }

    public void forceStreamQuality(int streamHeight) {
    }

    public String getClientInfo() {
        return "";
    }

    public void removeTracksOnTheFly(String trackId) {
    }

    public void addWebRTCMuxer(IWebRTCMuxer webRTCMuxer) {
        this.webRTCMuxer = webRTCMuxer;
    }

    public void removeWebRTCMuxer(IWebRTCMuxer webRTCMuxer) {
        this.stop();
    }
}

