/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster.webrtc;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.enterprise.IOperationListener;
import io.antmedia.enterprise.cluster.webrtc.ClusterPacketHandler;
import io.antmedia.enterprise.cluster.webrtc.DataChannelPacket;
import io.antmedia.enterprise.cluster.webrtc.DataPacket;
import io.antmedia.enterprise.webrtc.DataChannelRouter;
import io.antmedia.enterprise.webrtc.IDataChannelMessagePublisher;
import io.antmedia.enterprise.webrtc.WebRTCMuxer;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.DataChannel;

public class EdgeClient
implements IDataChannelMessagePublisher {
    private StreamInfo streamInfo;
    private Vertx vertx;
    private IWebRTCAdaptor webRTCAdaptor;
    private static Logger logger = LoggerFactory.getLogger(EdgeClient.class);
    private IOperationListener connectionListener;
    private NetClient videoClient;
    private NetClient audioClient;
    private NetClient dataChannelClient;
    private NetSocket socketVideo;
    private NetSocket socketAudio;
    private NetSocket socketDataChannel;
    private WebRTCMuxer muxer;
    public static final int VIDEO_BUFFER_SIZE = 300000;
    public static final int AUDIO_BUFFER_SIZE = 100000;
    private boolean intentionalClose = false;
    private DataStore dataStore;
    private PacketHandler audioHandler;
    private PacketHandler videoHandler;
    private DataChannelRouter dataChannelRouter;
    private boolean initialized = false;
    private boolean connectingVideo = false;
    private boolean connectingAudio = false;
    private boolean connectingDataChannel = false;
    private Vertx webRTCVertx;

    public EdgeClient(StreamInfo streamInfo, Vertx vertx, Vertx webRTCVertx, DataStore dataStore) {
        this.streamInfo = streamInfo;
        this.vertx = vertx;
        this.dataStore = dataStore;
        this.webRTCVertx = webRTCVertx;
    }

    public void start(@Nonnull IOperationListener listener) {
        this.connectionListener = listener;
        if (this.streamInfo.isVideoEnabled()) {
            NetClientOptions options = new NetClientOptions().setTcpNoDelay(true).setSendBufferSize(300000).setIdleTimeout(1).setReconnectAttempts(10).setReconnectInterval(2000L);
            this.videoClient = this.vertx.createNetClient(options);
            this.connectVideo();
        }
        if (this.streamInfo.isAudioEnabled()) {
            NetClientOptions audioOptions = new NetClientOptions().setTcpNoDelay(true).setSendBufferSize(100000).setIdleTimeout(1).setReconnectAttempts(10).setReconnectInterval(2000L);
            this.audioClient = this.vertx.createNetClient(audioOptions);
            this.connectAudio();
        }
        if (this.streamInfo.isDataChannelEnabled()) {
            this.dataChannelClient = this.vertx.createNetClient(new NetClientOptions());
            this.connectDataChannel();
        }
        this.vertx.setPeriodic(5000L, l -> {
            if (this.webRTCAdaptor.getNumberOfViewers(this.streamInfo.getStreamId()) <= 0) {
                logger.info("Edge client-{} for stream {} is closed  because no active player.", (Object)this.streamInfo.getVideoHeight(), (Object)this.streamInfo.getStreamId());
                this.stop();
                this.vertx.cancelTimer(l.longValue());
            }
        });
    }

    public void connectVideo() {
        logger.info("Edge client-{} for stream {} connect video on port {}.", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.streamInfo.getVideoPort()});
        this.socketVideo = null;
        this.connectingVideo = true;
        this.videoClient.connect(this.streamInfo.getVideoPort(), this.streamInfo.getHost(), res -> {
            this.connectingVideo = false;
            if (res.succeeded()) {
                logger.info("Edge client-{} for stream {} is connected video on port {} to host:{}", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.streamInfo.getVideoPort(), this.streamInfo.getHost()});
                this.socketVideo = (NetSocket)res.result();
                this.videoHandler = new PacketHandler(this.muxer, this.streamInfo.getStreamId());
                this.socketVideo.handler((Handler)new ClusterPacketHandler(this.videoHandler));
                this.socketVideo.closeHandler(v -> this.videoSocketClosed());
                this.socketVideo.exceptionHandler(throwable -> logger.error("Socket exception for stream:{}, trace:{}", (Object)this.streamInfo.getStreamId(), (Object)ExceptionUtils.getStackTrace((Throwable)throwable)));
                this.checkAndNotifyConnection();
            } else {
                this.stopVideo();
                logger.error("Cannot connect to origin server({}) video port({}) for stream: {} height: {}cause is: {}", new Object[]{this.streamInfo.getHost(), this.streamInfo.getVideoPort(), this.streamInfo.getStreamId(), this.streamInfo.getVideoHeight(), res.cause().getMessage()});
            }
        });
    }

    public void connectAudio() {
        logger.info("Edge client-{} for stream {} connect audio on port {} to host:{}", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.streamInfo.getAudioPort(), this.streamInfo.getHost()});
        this.socketAudio = null;
        this.connectingAudio = true;
        this.audioClient.connect(this.streamInfo.getAudioPort(), this.streamInfo.getHost(), res -> {
            this.connectingAudio = false;
            if (res.succeeded()) {
                logger.info("Edge client-{} for stream {} is connected audio on port {} to host: {}", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.streamInfo.getAudioPort(), this.streamInfo.getHost()});
                this.socketAudio = (NetSocket)res.result();
                this.audioHandler = new PacketHandler(this.muxer, this.streamInfo.getStreamId());
                this.socketAudio.handler((Handler)new ClusterPacketHandler(this.audioHandler));
                this.socketAudio.closeHandler(v -> this.audioSocketClosed());
                this.socketAudio.exceptionHandler(throwable -> logger.error("Socket exception for stream:{}, trace:{}", (Object)this.streamInfo.getStreamId(), (Object)ExceptionUtils.getStackTrace((Throwable)throwable)));
                this.checkAndNotifyConnection();
            } else {
                this.stopAudio();
                logger.error("Cannot connect to origin server({}) audio port({}) for stream: {} height: {}", new Object[]{this.streamInfo.getHost(), this.streamInfo.getAudioPort(), this.streamInfo.getStreamId(), this.streamInfo.getVideoHeight()});
            }
        });
    }

    private void connectDataChannel() {
        logger.info("Edge client-{} for stream {} connect dc on port {} to host:{}", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.streamInfo.getDataChannelPort(), this.streamInfo.getHost()});
        if (this.streamInfo.isDataChannelEnabled()) {
            this.socketDataChannel = null;
            this.connectingDataChannel = true;
            this.dataChannelClient.connect(this.streamInfo.getDataChannelPort(), this.streamInfo.getHost(), res -> {
                this.connectingDataChannel = false;
                if (res.succeeded()) {
                    logger.info("Edge client-{} for stream {} is connected dc on port {} to host: {}", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.streamInfo.getDataChannelPort(), this.streamInfo.getHost()});
                    this.socketDataChannel = (NetSocket)res.result();
                    this.socketDataChannel.handler((Handler)new ClusterPacketHandler(packet -> {
                        DataChannelPacket dataPacket = (DataChannelPacket)SerializationUtils.deserialize((byte[])packet);
                        this.getDataChannelRouter().publisherMessageReceived(this.streamInfo.getStreamId(), dataPacket.data, dataPacket.binary);
                    }));
                    this.socketDataChannel.closeHandler(v -> this.dataChannelSocketClosed());
                    this.socketDataChannel.exceptionHandler(throwable -> logger.error("Socket exception for stream:{}, trace:{}", (Object)this.streamInfo.getStreamId(), (Object)ExceptionUtils.getStackTrace((Throwable)throwable)));
                    this.checkAndNotifyConnection();
                    this.getDataChannelRouter().addPublisher(this.streamInfo.getStreamId(), this);
                } else {
                    this.stopDataChannel();
                    logger.error("Cannot connect to origin server({}) dc port({}) for stream: {} height: {}", new Object[]{this.streamInfo.getHost(), this.streamInfo.getAudioPort(), this.streamInfo.getStreamId(), this.streamInfo.getVideoHeight()});
                }
            });
        }
    }

    public synchronized boolean isStreamStopped() {
        return this.dataStore.getStreamInfoList(this.streamInfo.getStreamId()).isEmpty();
    }

    public void videoSocketClosed() {
        logger.info("Edge client-{} for stream {} video socket closed with intention: {}.", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.intentionalClose});
        if (this.videoHandler != null) {
            this.videoHandler.logVideoStats();
        }
        boolean streamStopped = this.isStreamStopped();
        if (!this.intentionalClose && !streamStopped) {
            this.connectVideo();
        } else if (streamStopped) {
            this.stopVideo();
        }
    }

    public void audioSocketClosed() {
        logger.info("Edge client-{} for stream {} audio socket closed with intention: {}.", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.intentionalClose});
        if (this.audioHandler != null) {
            this.audioHandler.logAudioStats();
        }
        boolean streamStopped = this.isStreamStopped();
        if (!this.intentionalClose && !streamStopped) {
            this.connectAudio();
        } else if (streamStopped) {
            this.stopAudio();
        }
    }

    private void dataChannelSocketClosed() {
        logger.info("Edge client-{} for stream {} dc socket closed with intention: {}.", new Object[]{this.streamInfo.getVideoHeight(), this.streamInfo.getStreamId(), this.intentionalClose});
        boolean streamStopped = this.isStreamStopped();
        if (!this.intentionalClose && !streamStopped) {
            this.connectDataChannel();
        } else if (streamStopped) {
            this.stopDataChannel();
        }
    }

    private synchronized void checkAndNotifyConnection() {
        if (this.initialized) {
            logger.info("It's already initialized for stream:{}", (Object)this.streamInfo.getStreamId());
            return;
        }
        boolean status = true;
        if (this.streamInfo.isVideoEnabled()) {
            status &= this.socketVideo != null;
        }
        if (this.streamInfo.isAudioEnabled()) {
            status &= this.socketAudio != null;
        }
        if (this.streamInfo.isDataChannelEnabled()) {
            status &= this.socketDataChannel != null;
        }
        if (status) {
            this.initialized = true;
            this.connectionListener.operationCompleted(status, "");
        }
    }

    public WebRTCMuxer createMuxer() {
        this.muxer = new WebRTCMuxer(this.webRTCAdaptor);
        this.muxer.init(null, this.streamInfo.getStreamId(), this.streamInfo.getVideoHeight(), null, this.streamInfo.getVideoBitrate());
        this.muxer.setCodec(this.streamInfo.getVideoCodec());
        this.muxer.setWidth(this.streamInfo.getVideoWidth());
        this.muxer.setHeight(this.streamInfo.getVideoHeight());
        this.muxer.setVideoBitrate(this.streamInfo.getVideoBitrate());
        try (AVRational videoTimebase = new AVRational();){
            videoTimebase.num(1).den(this.streamInfo.getVideoRTimebase());
            this.muxer.setVideoTimebase(videoTimebase);
        }
        try (AVRational audioTimebase = new AVRational();){
            audioTimebase.num(1).den(this.streamInfo.getAudioRTimebase());
            this.muxer.setAudioTimebase(audioTimebase);
        }
        this.muxer.setAudioBitrate(this.streamInfo.getAudioBitrate());
        this.muxer.prepareIO();
        return this.muxer;
    }

    public void stop() {
        this.intentionalClose = true;
        if (this.streamInfo.isVideoEnabled()) {
            this.stopVideo();
        }
        if (this.streamInfo.isAudioEnabled()) {
            this.stopAudio();
        }
        if (this.streamInfo.isDataChannelEnabled()) {
            this.stopDataChannel();
        }
    }

    private void stopVideo() {
        logger.info("Video connection to origin ({}) is closed for stream:{}", (Object)this.streamInfo.getHost(), (Object)this.streamInfo.getStreamId());
        this.muxer.writeTrailer();
        this.videoClient.close();
        this.socketVideo = null;
        this.connectingVideo = false;
    }

    private void stopAudio() {
        logger.info("Audio connection to origin ({}) is closed for stream:{}", (Object)this.streamInfo.getHost(), (Object)this.streamInfo.getStreamId());
        this.muxer.writeTrailer();
        this.audioClient.close();
        this.socketAudio = null;
        this.connectingAudio = false;
    }

    private void stopDataChannel() {
        logger.info("dc connection to origin ({}) is closed for stream:{}", (Object)this.streamInfo.getHost(), (Object)this.streamInfo.getStreamId());
        this.dataChannelClient.close();
        this.socketDataChannel = null;
        this.connectingDataChannel = false;
        this.getDataChannelRouter().removePublisher(this.streamInfo.getStreamId(), this);
    }

    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    public IWebRTCAdaptor getWebRTCAdaptor() {
        return this.webRTCAdaptor;
    }

    public boolean isThereAnyConnectedClient() {
        return this.muxer.getClientCount() > 0;
    }

    public NetSocket getSocketVideo() {
        return this.socketVideo;
    }

    public NetSocket getSocketAudio() {
        return this.socketAudio;
    }

    public NetSocket getSocketDataChannel() {
        return this.socketDataChannel;
    }

    @Override
    public void sendMessageViaDataChannel(DataChannel.Buffer buffer) {
        byte[] data = new byte[buffer.data.capacity()];
        buffer.data.get(data);
        byte[] rawData = SerializationUtils.serialize((Serializable)new DataChannelPacket(data, buffer.binary));
        ClusterPacketHandler.sendPacket(rawData, this.socketDataChannel);
    }

    public DataChannelRouter getDataChannelRouter() {
        return this.dataChannelRouter;
    }

    public void setDataChannelRouter(DataChannelRouter dataChannelRouter) {
        this.dataChannelRouter = dataChannelRouter;
    }

    @Override
    public void sendMessageToDataChannelWebHook(DataChannel.Buffer buffer) {
    }

    public boolean isIntentionalClose() {
        return this.intentionalClose;
    }

    public boolean isConnectingAudio() {
        return this.connectingAudio;
    }

    public boolean isConnectingVideo() {
        return this.connectingVideo;
    }

    public boolean isConnectingDataChannel() {
        return this.connectingDataChannel;
    }

    public void setConnectingAudio(boolean connectingAudio) {
        this.connectingAudio = connectingAudio;
    }

    public void setConnectingVideo(boolean connectingVideo) {
        this.connectingVideo = connectingVideo;
    }

    public void setConnectingDataChannel(boolean connectingDataChannel) {
        this.connectingDataChannel = connectingDataChannel;
    }

    public static final class PacketHandler
    implements ClusterPacketHandler.IPacketReceiveListener {
        private final WebRTCMuxer muxer;
        private long lastSendVideoPacketCallTime;
        private long totalSendVideoPacketCallInterval;
        private long videoPacketCount;
        private long totalSendAudioPacketCallInterval;
        private long lastSendAudioPacketCallTime;
        private long audioPacketCount;
        private long totalAudioProcessingTime;
        private long totalVideoProcessingTime;
        private String streamId;

        public PacketHandler(WebRTCMuxer muxer, String streamId) {
            this.muxer = muxer;
            this.streamId = streamId;
        }

        public void logAudioStats() {
            if (this.videoPacketCount > 0L) {
                logger.info("Average write packet call interval for video {}ms average video packet processing time {}ms video packet count: {} for stream:{}", new Object[]{this.totalSendVideoPacketCallInterval / this.videoPacketCount, this.totalVideoProcessingTime / this.videoPacketCount, this.videoPacketCount, this.streamId});
            }
        }

        public void logVideoStats() {
            if (this.audioPacketCount > 0L) {
                logger.info("Average write packet call interval: {}ms average audio processing time: {}ms  audio packet count: {} for stream:{}", new Object[]{this.totalSendAudioPacketCallInterval / this.audioPacketCount, this.totalAudioProcessingTime / this.audioPacketCount, this.audioPacketCount, this.streamId});
            }
        }

        @Override
        public void packetReceived(byte[] packet) {
            DataPacket dataPacket = (DataPacket)SerializationUtils.deserialize((byte[])packet);
            this.sendPacket(this.muxer, dataPacket);
        }

        public void sendPacket(WebRTCMuxer muxer, DataPacket dataPacket) {
            long now = System.currentTimeMillis();
            if (dataPacket.type == 0) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(dataPacket.data.length);
                buffer.put(dataPacket.data);
                muxer.sendVideoPacketInternal(buffer, dataPacket.keyframe, dataPacket.timestamp / 1000000L, dataPacket.frameRotation, dataPacket.trackId);
                this.totalSendVideoPacketCallInterval += this.lastSendVideoPacketCallTime != 0L ? now - this.lastSendVideoPacketCallTime : 0L;
                ++this.videoPacketCount;
                this.totalVideoProcessingTime += System.currentTimeMillis() - now;
                this.lastSendVideoPacketCallTime = now;
            } else if (dataPacket.type == 1) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(dataPacket.data.length);
                buffer.put(dataPacket.data);
                muxer.sendTrackAudioPacket(buffer, dataPacket.timestamp, dataPacket.trackId);
                this.totalSendAudioPacketCallInterval += this.lastSendAudioPacketCallTime != 0L ? now - this.lastSendAudioPacketCallTime : 0L;
                ++this.audioPacketCount;
                this.totalAudioProcessingTime += System.currentTimeMillis() - now;
                this.lastSendAudioPacketCallTime = now;
            }
        }
    }
}

